/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.uml.architecture;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.emf.ui.providers.labelproviders.DelegatingToEMFLabelProvider;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.EditorNameInitializer;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentStructureTemplatePackage;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplatePrototype;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.representation.PapyrusDocumentPrototype;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.internal.command.ICreateDocumentTemplateEditorCommand;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.internal.viewpoint.PapyrusDocumentTemplateViewPrototype;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.modelresource.DocumentTemplateModel;
import org.eclipse.papyrus.model2doc.integration.uml.architecture.internal.messages.AbstractCreateDocumentTemplateEditorCommand;
import org.eclipse.papyrus.model2doc.integration.uml.architecture.internal.messages.Activator;
import org.eclipse.papyrus.model2doc.integration.uml.architecture.internal.messages.Messages;

public final class CreatePapyrusDocumentTemplateEditorCommand
extends AbstractCreateDocumentTemplateEditorCommand
implements ICreateDocumentTemplateEditorCommand {
    private String askName(ViewPrototype prototype, EObject semanticContext) {
        String defaultName = this.getDefaultName(prototype, semanticContext);
        return this.askDocumentName(Messages.CreatePapyrusDocumentTemplateEditorCommand_CreateDocumentTemplateDialogTitle, defaultName);
    }

    private String getDefaultName(ViewPrototype prototype, EObject semanticContext) {
        StringBuilder nameBuilder = new StringBuilder("New");
        nameBuilder.append(prototype.getLabel().replaceAll(" ", ""));
        String nameWithIncrement = EditorNameInitializer.getNameWithIncrement((EClass)DocumentStructureTemplatePackage.eINSTANCE.getTextDocumentTemplate(), (EStructuralFeature)DocumentStructureTemplatePackage.eINSTANCE.getDocumentTemplate_Name(), (String)nameBuilder.toString(), (EObject)semanticContext);
        return nameWithIncrement;
    }

    public boolean execute(PapyrusDocumentTemplateViewPrototype prototype, EObject semanticContext, String name) {
        String documentName;
        PapyrusRepresentationKind representation = prototype.getRepresentationKind();
        Assert.isTrue((boolean)(representation instanceof PapyrusDocumentPrototype), (String)"The representation associated to the PapyrusDocumentTemplateViewPrototype must be an instanceof PapyrusDocumentPrototype.");
        PapyrusDocumentPrototype docProto = (PapyrusDocumentPrototype)representation;
        DocumentTemplatePrototype docTemplateProto = docProto.getDocumentTemplatePrototype();
        String string = documentName = name == null || name.isEmpty() ? this.askName((ViewPrototype)prototype, semanticContext) : name;
        if (documentName == null) {
            return true;
        }
        return super.execute(docTemplateProto, semanticContext, documentName);
    }

    @Override
    protected final void attachToResource(EObject modelElement, DocumentTemplate docTemplate) {
        ServicesRegistry sReg = this.getServiceRegistry(modelElement);
        if (sReg == null) {
            return;
        }
        ModelSet modelSet = this.getModelSet(sReg);
        if (modelSet == null) {
            return;
        }
        DocumentTemplateModel model = null;
        try {
            model = (DocumentTemplateModel)modelSet.getModelChecked("org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.DocumentTemplate");
        }
        catch (NotFoundException e) {
            Activator.log.error("DocumentTemplateModel not found", (Throwable)e);
            return;
        }
        model.addDocument(docTemplate, modelElement);
    }

    @Override
    protected final String getDocumentMainTitle(EObject semanticContext) {
        return DelegatingToEMFLabelProvider.INSTANCE.getText((Object)semanticContext);
    }

    private ServicesRegistry getServiceRegistry(EObject modelElement) {
        try {
            return ServiceUtilsForEObject.getInstance().getServiceRegistry(modelElement);
        }
        catch (ServiceException e) {
            Activator.log.error("ServicesRegistry not found", (Throwable)e);
            return null;
        }
    }

    @Override
    protected final TransactionalEditingDomain getEditingDomain(EObject modelElement) {
        ServicesRegistry servicesRegistry = this.getServiceRegistry(modelElement);
        if (servicesRegistry == null) {
            return null;
        }
        try {
            return ServiceUtils.getInstance().getTransactionalEditingDomain((Object)servicesRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error("EditingDomain not found", (Throwable)e);
            return null;
        }
    }

    private ModelSet getModelSet(ServicesRegistry servicesRegistry) {
        try {
            return ServiceUtils.getInstance().getModelSet((Object)servicesRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error("ModelSet not found", (Throwable)e);
            return null;
        }
    }

    private IPageManager getPageManager(ServicesRegistry servicesRegistry) {
        try {
            return (IPageManager)ServiceUtils.getInstance().getService(IPageManager.class, (Object)servicesRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error("IPageManager not found", (Throwable)e);
            return null;
        }
    }

    @Override
    protected final void openEditor(DocumentTemplate template) {
        ServicesRegistry sReg = this.getServiceRegistry(template.getSemanticContext());
        if (sReg == null) {
            return;
        }
        IPageManager pageManager = this.getPageManager(sReg);
        if (pageManager == null) {
            return;
        }
        pageManager.openPage((Object)template);
    }
}

