/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.ucm.core.utils;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.ucm.core.utils.TemplateUtils;
import org.eclipse.papyrus.designer.ucm.profile.UCMProfile.ucm_components.PortTypeSpec;
import org.eclipse.papyrus.designer.ucm.profile.UCMProfile.ucm_interactions.IPortType;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.Type;

public class BindingUtils {
    private static final boolean USE_TB = true;

    public static EList<Type> getAbstractTypes(IPortType portType) {
        Class portTypeBase;
        TemplateSignature signature;
        BasicEList types = new BasicEList();
        if (portType != null && (signature = TemplateUtils.getSignature((TemplateableElement)(portTypeBase = portType.getBase_Class()).getNearestPackage())) != null) {
            for (TemplateParameter parameter : signature.getParameters()) {
                ParameterableElement formal = parameter.getParameteredElement();
                if (!(formal instanceof Type)) continue;
                types.add((Object)((Type)formal));
            }
        }
        return types;
    }

    public static Type getActual(PortTypeSpec portTypeSpec, Type formal) {
        EList bindings = portTypeSpec.getBase_Class().getTemplateBindings();
        if (bindings.size() > 0) {
            TemplateBinding binding = (TemplateBinding)bindings.get(0);
            for (TemplateParameterSubstitution sub : binding.getParameterSubstitutions()) {
                if (sub.getFormal() != formal.getOwningTemplateParameter()) continue;
                return (Type)sub.getActual();
            }
        }
        return null;
    }

    public static void setActual(PortTypeSpec portTypeSpec, Type formal, Type actual) {
        EList bindings = portTypeSpec.getBase_Class().getTemplateBindings();
        if (bindings.size() == 0) {
            TemplateSignature signature = TemplateUtils.getSignature((TemplateableElement)portTypeSpec.getType().getBase_Class().getNearestPackage());
            portTypeSpec.getBase_Class().createTemplateBinding(signature);
        }
        TemplateBinding binding = (TemplateBinding)bindings.get(0);
        for (TemplateParameterSubstitution sub : binding.getParameterSubstitutions()) {
            if (sub.getFormal() != formal) continue;
            sub.setActual((ParameterableElement)actual);
            return;
        }
        TemplateParameterSubstitution newSub = binding.createParameterSubstitution();
        newSub.setFormal(formal.getOwningTemplateParameter());
        newSub.setActual((ParameterableElement)actual);
    }

    public static void resetActual(PortTypeSpec portTypeSpec, Type formal) {
        EList bindings = portTypeSpec.getBase_Class().getTemplateBindings();
        if (bindings.size() > 0) {
            TemplateBinding binding = (TemplateBinding)bindings.get(0);
            for (TemplateParameterSubstitution sub : binding.getParameterSubstitutions()) {
                if (sub.getFormal() != formal.getOwningTemplateParameter()) continue;
                sub.destroy();
                break;
            }
        }
    }
}

