/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.ucm.types.profile.UCMTypes.Types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PrimitiveIntegerKind implements Enumerator
{
    SHORT(0, "SHORT", "SHORT"),
    LONG(1, "LONG", "LONG"),
    LONGLONG(2, "LONGLONG", "LONGLONG"),
    USHORT(3, "USHORT", "USHORT"),
    ULONG(4, "ULONG", "ULONG"),
    ULONGLONG(5, "ULONGLONG", "ULONGLONG");

    public static final int SHORT_VALUE = 0;
    public static final int LONG_VALUE = 1;
    public static final int LONGLONG_VALUE = 2;
    public static final int USHORT_VALUE = 3;
    public static final int ULONG_VALUE = 4;
    public static final int ULONGLONG_VALUE = 5;
    private static final PrimitiveIntegerKind[] VALUES_ARRAY;
    public static final List<PrimitiveIntegerKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PrimitiveIntegerKind[]{SHORT, LONG, LONGLONG, USHORT, ULONG, ULONGLONG};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PrimitiveIntegerKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveIntegerKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveIntegerKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveIntegerKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveIntegerKind get(int value) {
        switch (value) {
            case 0: {
                return SHORT;
            }
            case 1: {
                return LONG;
            }
            case 2: {
                return LONGLONG;
            }
            case 3: {
                return USHORT;
            }
            case 4: {
                return ULONG;
            }
            case 5: {
                return ULONGLONG;
            }
        }
        return null;
    }

    private PrimitiveIntegerKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

