/**
 * Copyright (c) 2014 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.cpp.codegen.xtend;

import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.CppGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppDocumentation;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Typedef;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * @author Önder GÜRCAN (onder.gurcan@cea.fr)
 */
@SuppressWarnings("all")
public class CppPrimitiveTypes {
  /**
   * Support two different kinds of primitive types
   * (1) those that are native types of the programming language such as long
   *     For these, no additional definition has to be done and they should be referenced
   *     with their name only
   * (2) those that correspond to a typedef (e.g. typedef long ErrorType). These require
   *     a typedef definition within the package and need to be referenced with their
   *     fully qualified name (e.g. MyPackage::ErrorType)
   * (3) Sometimes the name of the type defined by a typedef does not appear at the end, e.g.
   *     when defining functionPointers such as "typedef int (*HandlerFct) (void*);"
   * 	   (a function with a void* argument returning int)
   *     Support this case via a specific 'typeName' constant that gets replaced by the name of the
   *     type
   */
  public static CharSequence CppPrimitiveTypeDefinition(final PrimitiveType primitiveType) {
    CharSequence _xblockexpression = null;
    {
      final CharSequence typeDef = CppPrimitiveTypes.CppPrimitiveTypeDefinitionWoDoc(primitiveType);
      CharSequence _xifexpression = null;
      int _length = typeDef.length();
      boolean _greaterThan = (_length > 0);
      if (_greaterThan) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        CharSequence _CppElementDoc = CppDocumentation.CppElementDoc(primitiveType);
        _builder.append(_CppElementDoc);
        _builder.newLineIfNotEmpty();
        _builder.append(typeDef);
        _builder.newLineIfNotEmpty();
        _xifexpression = _builder;
      } else {
        _xifexpression = "";
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  public static CharSequence CppPrimitiveTypeDefinitionWoDoc(final PrimitiveType primitiveType) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasStereotype = GenUtils.hasStereotype(primitiveType, Typedef.class);
      if (_hasStereotype) {
        _builder.append("typedef ");
        String _replaceAll = UMLUtil.<Typedef>getStereotypeApplication(primitiveType, Typedef.class).getDefinition().replaceAll("typeName", primitiveType.getName());
        _builder.append(_replaceAll);
        _builder.newLineIfNotEmpty();
        {
          boolean _contains = UMLUtil.<Typedef>getStereotypeApplication(primitiveType, Typedef.class).getDefinition().contains("typeName");
          boolean _not = (!_contains);
          if (_not) {
            String _name = primitiveType.getName();
            _builder.append(_name);
          }
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      } else {
        String _stdtypes = CppGenUtils.getStdtypes(primitiveType);
        _builder.append(_stdtypes);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
}
