/**
 * Copyright (c) 2014 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.cpp.codegen.xtend;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.preferences.CppCodeGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.ExternLibrary;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.External;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Template;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.util.UMLUtil;

/**
 * @author Önder GÜRCAN (onder.gurcan@cea.fr)
 */
@SuppressWarnings("all")
public class CppClassIncludeDeclaration {
  public static List<String> cppClassIncludes(final NamedElement ne) {
    List<String> result = new ArrayList<String>();
    boolean _hasStereotypeTree = GenUtils.hasStereotypeTree(ne, ExternLibrary.class);
    if (_hasStereotypeTree) {
      result.addAll(GenUtils.<ExternLibrary>getApplicationTree(ne, ExternLibrary.class).getIncludes());
      boolean _hasStereotype = GenUtils.hasStereotype(ne, External.class);
      if (_hasStereotype) {
        final String incPath = CppClassIncludeDeclaration.includeName(ne);
        if ((incPath != null)) {
          result.add(incPath);
        }
      }
    } else {
      result.add(CppClassIncludeDeclaration.includeName(ne));
    }
    return result;
  }
  
  public static String includeName(final NamedElement ne) {
    boolean _hasStereotypeTree = GenUtils.hasStereotypeTree(ne, Template.class);
    if (_hasStereotypeTree) {
      return UMLUtil.<Template>getStereotypeApplication(ne, Template.class).getDeclaration();
    } else {
      boolean _hasStereotype = GenUtils.hasStereotype(ne, External.class);
      if (_hasStereotype) {
        return UMLUtil.<External>getStereotypeApplication(ne, External.class).getIncPath();
      } else {
        String _fullPath = GenUtils.getFullPath(ne.getNearestPackage());
        String _plus = (_fullPath + "/");
        String _name = ne.getName();
        String _plus_1 = (_plus + _name);
        String _plus_2 = (_plus_1 + ".");
        String _headerSuffix = CppCodeGenUtils.getHeaderSuffix();
        return (_plus_2 + _headerSuffix);
      }
    }
  }
}
