/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.common.base.file;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.eclipse.core.runtime.IPath;
import org.eclipse.papyrus.designer.languages.common.base.Activator;

public class ProtSection {
    private static final String START_OF_USER_CODE = "Start of user code ";
    private static final String END_OF_USER_CODE = "End of user code";

    public static String protSection(String header) {
        return String.format("Start of user code %s", header);
    }

    public static String mergeProtectedSections(IPath location, String content) {
        int idx = 0;
        boolean inProtSection = false;
        String protSection = "";
        try {
            FileInputStream input = new FileInputStream(location.toFile());
            CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
            decoder.onMalformedInput(CodingErrorAction.IGNORE);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)input, decoder);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.contains(START_OF_USER_CODE)) {
                    int newIdx = content.indexOf(line.trim(), idx);
                    if (newIdx == -1) {
                        idx = 0;
                        continue;
                    }
                    inProtSection = true;
                    protSection = "";
                    idx = newIdx + line.trim().length() + 1;
                    continue;
                }
                if (!inProtSection) continue;
                if (line.contains(END_OF_USER_CODE) && inProtSection) {
                    inProtSection = false;
                    int endIdx = content.indexOf(END_OF_USER_CODE, idx);
                    while (endIdx >= 0 && content.charAt(endIdx) != '\n') {
                        --endIdx;
                    }
                    content = String.valueOf(content.substring(0, idx)) + protSection + content.substring(endIdx + 1);
                    idx += protSection.length();
                    continue;
                }
                protSection = String.valueOf(protSection) + line + '\n';
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException e) {
            Activator.log.error((Throwable)e);
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        return content;
    }

    public static String protSection() {
        return END_OF_USER_CODE;
    }
}

