/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.editor.search.query;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.search.SearchMatch;
import org.eclipse.xtend.shared.ui.editor.search.query.OawSearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OawSearchQuery
implements ISearchQuery {
    private final String identifier;
    private final IXtendXpandProject project;
    private OawSearchResult result;

    public OawSearchQuery(IXtendXpandProject project, String identifier) {
        this.project = project;
        this.identifier = identifier;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return false;
    }

    public String getLabel() {
        return "openArchitectureWare Search";
    }

    public String getResultLabel(int matchCount) {
        String result = null;
        String searchText = this.identifier;
        String scope = "project";
        result = matchCount == 1 ? MessageFormat.format("''{0}'' - 1 match in {1}", searchText, scope) : (matchCount >= 2 ? MessageFormat.format("''{0}'' - {1} matches in {2}", searchText, matchCount, scope) : MessageFormat.format("''{0}'' - no match found in {1}", searchText, scope));
        return result;
    }

    public ISearchResult getSearchResult() {
        if (this.result == null) {
            this.result = new OawSearchResult(this);
        }
        return this.result;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        ISearchResult searchResult = this.getSearchResult();
        if (searchResult instanceof AbstractTextSearchResult) {
            AbstractTextSearchResult result = (AbstractTextSearchResult)searchResult;
            result.removeAll();
        }
        List<SearchMatch> matches = this.performSearch();
        for (SearchMatch searchMatch : matches) {
            this.result.addMatch(new Match((Object)searchMatch.getFile(), searchMatch.getOffSet() - 1, searchMatch.getLength()));
        }
        return Status.OK_STATUS;
    }

    protected abstract List<SearchMatch> performSearch();

    public String getIdentifier() {
        return this.identifier;
    }

    public IXtendXpandProject getProject() {
        return this.project;
    }
}

