/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Template;
import org.eclipse.jet.JET2TemplateLoader;
import org.eclipse.jet.JET2TemplateLoaderExtension;
import org.eclipse.jet.JET2Writer;
import org.osgi.framework.Bundle;

public class JET2TemplateLoaderImpl
implements JET2TemplateLoader,
JET2TemplateLoaderExtension {
    private final Map map;
    private final Bundle bundle;
    private JET2TemplateLoader delegate;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public JET2TemplateLoaderImpl(Bundle bundle, URL templateMap) throws IOException {
        this.bundle = bundle;
        this.map = this.getTemplateMap(bundle, templateMap);
    }

    private Map getTemplateMap(Bundle bundle, URL mapURL) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = mapURL.openStream();
            Properties map = new Properties();
            map.load(inputStream);
            Properties properties = map;
            Object var5_6 = null;
            this.ensureClosed(inputStream);
            return properties;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.ensureClosed(inputStream);
            throw throwable;
        }
    }

    private void ensureClosed(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public JET2Template getTemplate(String templatePath) {
        String className = (String)this.map.get(templatePath);
        if (className != null) {
            try {
                Class templateClass = this.bundle.loadClass(className);
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.jet.JET2Template");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(templateClass)) {
                    return (JET2Template)templateClass.newInstance();
                }
                return new JET1TemplateWrapper(templateClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return this.delegate != null ? this.delegate.getTemplate(templatePath) : null;
    }

    public JET2TemplateLoader getDelegateLoader() {
        return this.delegate;
    }

    public void setDelegateLoader(JET2TemplateLoader loader) {
        this.delegate = loader;
    }

    private static final class JET1TemplateWrapper
    implements JET2Template {
        private static final String JET1_ARGUMENT_CONTEXT_VAR = "argument";
        private final Object template;
        private final Method generateMethod;

        public JET1TemplateWrapper(Class templateClass) throws SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException {
            this.template = templateClass.newInstance();
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            this.generateMethod = templateClass.getMethod("generate", classArray);
        }

        public void generate(JET2Context context, JET2Writer out) {
            Object arg = context.hasVariable(JET1_ARGUMENT_CONTEXT_VAR) ? context.getVariable(JET1_ARGUMENT_CONTEXT_VAR) : null;
            try {
                Object result = this.generateMethod.invoke(this.template, arg);
                out.write(result != null ? result.toString() : "");
            }
            catch (IllegalArgumentException e) {
                context.logError(e.getCause());
            }
            catch (IllegalAccessException e) {
                context.logError(e.getCause());
            }
            catch (InvocationTargetException e) {
                context.logError(e.getCause());
            }
        }
    }
}

