/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.compiler;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jet.JET2Platform;
import org.eclipse.jet.compiler.CompileOptionsManager;
import org.eclipse.jet.core.compiler.JETCompilerOptions;
import org.eclipse.jet.core.parser.ITagLibraryResolver;
import org.eclipse.jet.core.parser.ITemplateResolver;
import org.eclipse.jet.core.parser.ast.JETASTParser;
import org.eclipse.jet.core.parser.ast.JETCompilationUnit;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.compiler.TemplateRunner;
import org.eclipse.jet.internal.parser.resources.WorkspaceTemplateResolverBuilder;
import org.eclipse.jet.internal.runtime.model.XMLDOMLoader;
import org.eclipse.jet.taglib.TagLibrary;
import org.eclipse.jet.taglib.TagLibraryManager;
import org.eclipse.jet.taglib.TagLibraryReference;
import org.eclipse.jet.transform.IJETBundleDescriptor;
import org.eclipse.jet.xpath.XPath;
import org.eclipse.jet.xpath.XPathException;
import org.eclipse.jet.xpath.XPathFactory;

public class CompilationHelper {
    private static final String EMF_CODEGEN_JETPROPERTIES = ".jetproperties";
    private static final String EMF_CODEGEN_JET_NATURE_ID = "org.eclipse.emf.codegen.jet.IJETNature";
    private static final ITagLibraryResolver TAG_LIBRARY_RESOLVER = new ITagLibraryResolver(){

        public TagLibrary getLibrary(String tagLibraryID) {
            return TagLibraryManager.getInstance().getTagLibrary(tagLibraryID);
        }
    };
    private final IProject project;
    private IJETBundleDescriptor projectDescription;
    private Map options;
    private Map predefinedTagLibraryMap;
    private JETASTParser astParser;

    public CompilationHelper(IProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        if (!project.exists() || !project.isOpen()) {
            throw new IllegalArgumentException();
        }
        this.project = project;
    }

    public JETASTParser getASTParser() {
        if (this.astParser == null) {
            Map options = this.getOptions();
            int jetSpec = JETCompilerOptions.getIntOption((Map)options, (String)"org.eclipse.jet.jetSpecificationVersion");
            JETASTParser.Builder builder = new JETASTParser.Builder(jetSpec);
            builder.tagLibraryResolver(TAG_LIBRARY_RESOLVER);
            builder.templateResolver(this.buildTemplateResolver());
            builder.predefinedTagLibraries(this.getPredefinedTagLibraryMap());
            IJETBundleDescriptor descriptor = this.getDescriptor();
            builder.enableEmbeddedExpressions(descriptor != null ? descriptor.isEnableEmbeddedExpressions() : false);
            this.astParser = builder.build();
        }
        return this.astParser;
    }

    public JETCompilationUnit getAST(String templatePath) {
        return (JETCompilationUnit)this.getASTParser().parse(templatePath);
    }

    public JETCompilationUnit getASTFromSource(String source) {
        return this.getASTFromSource(source, null);
    }

    public JETCompilationUnit getASTFromSource(String source, String templatePath) {
        return (JETCompilationUnit)this.getASTParser().parse(source.toCharArray(), templatePath);
    }

    public String getJavaCode(JETCompilationUnit ast) {
        this.ensurePackageAndClassSet(ast);
        TemplateRunner templateRunner = new TemplateRunner();
        String cgTemplatePath = this.getJetVersion() == 1 ? "templates/v1/jet2java.jet" : "templates/v2/jet2java.jet";
        String code = templateRunner.generate(cgTemplatePath, Collections.singletonMap("cu", ast));
        return code;
    }

    private void ensurePackageAndClassSet(JETCompilationUnit ast) {
        if (ast.getOutputJavaPackage() == null) {
            ast.setOutputJavaPackage(JETCompilerOptions.getStringOption((Map)this.getOptions(), (String)"org.eclipse.jet.compiledTemplatePackage"));
        }
        if (ast.getOutputJavaClassName() == null) {
            ast.setOutputJavaClassName("_jet_Unkonwn_");
        }
    }

    public String getJavaCode(JETCompilationUnit ast, Map javaElementPositionMap) {
        HashMap<String, Object> arguments = new HashMap<String, Object>(2);
        arguments.put("cu", ast);
        arguments.put("positionMap", javaElementPositionMap);
        TemplateRunner templateRunner = new TemplateRunner();
        String cgTemplatePath = this.getJetVersion() == 1 ? "templates/v1/jet2java.jet" : "templates/v2/jet2java.jet";
        String code = templateRunner.generate(cgTemplatePath, arguments);
        return code;
    }

    public int getJetVersion() {
        return JETCompilerOptions.getIntOption((Map)this.getOptions(), (String)"org.eclipse.jet.jetSpecificationVersion");
    }

    public Map getOptions() {
        if (this.options == null) {
            this.options = this.isLegacyJET1Project(this.project) ? this.getLegacyJETOptions(this.project) : CompileOptionsManager.getOptions(this.project);
        }
        return this.options;
    }

    private Map getLegacyJETOptions(IProject project) {
        IFile jetProperties = project.getFile(EMF_CODEGEN_JETPROPERTIES);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("org.eclipse.jet.jetSpecificationVersion", new Integer(1));
        options.put("org.eclipse.jet.v1BaseTransformationID", "");
        options.put("org.eclipse.jet.v1CompileBaseTemplates", JETCompilerOptions.DEFAULT_V1_COMPILE_BASE_TEMPLATES);
        if (jetProperties.exists()) {
            this.loadLegacyJetProperties(jetProperties, options);
        } else {
            options.put("org.eclipse.jet.v1TemplatesDir", "templates");
            options.put("org.eclipse.jet.javaOutputFolder", "src");
        }
        return options;
    }

    private void loadLegacyJetProperties(IFile jetProperties, Map options) {
        try {
            Object doc = new XMLDOMLoader().load(jetProperties.getLocationURI().toURL());
            XPath xpath = XPathFactory.newInstance().newXPath(null);
            String templatePath = xpath.compile("/jet-settings/template-container").evaluateAsString(doc);
            String outputPath = xpath.compile("/jet-settings/source-container").evaluateAsString(doc);
            options.put("org.eclipse.jet.v1TemplatesDir", templatePath);
            options.put("org.eclipse.jet.javaOutputFolder", outputPath);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XPathException e) {
            e.printStackTrace();
        }
    }

    private boolean isLegacyJET1Project(IProject project2) {
        try {
            return this.project.hasNature(EMF_CODEGEN_JET_NATURE_ID) || !this.project.hasNature("org.eclipse.jet.jet2Nature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public Map getPredefinedTagLibraryMap() {
        if (this.predefinedTagLibraryMap == null) {
            IJETBundleDescriptor descriptor = this.getDescriptor();
            if (descriptor != null) {
                TagLibraryReference[] tagLibraryReferences = descriptor.getTagLibraryReferences();
                this.predefinedTagLibraryMap = new HashMap(tagLibraryReferences.length);
                int i = 0;
                while (i < tagLibraryReferences.length) {
                    if (tagLibraryReferences[i].isAutoImport()) {
                        this.predefinedTagLibraryMap.put(tagLibraryReferences[i].getPrefix(), tagLibraryReferences[i].getTagLibraryId());
                    }
                    ++i;
                }
            } else {
                this.predefinedTagLibraryMap = Collections.EMPTY_MAP;
            }
        }
        return this.predefinedTagLibraryMap;
    }

    private IJETBundleDescriptor getDescriptor() {
        if (this.projectDescription == null) {
            this.projectDescription = JET2Platform.getProjectDescription(this.project.getName());
        }
        return this.projectDescription;
    }

    private ITemplateResolver buildTemplateResolver() {
        Map options = this.getOptions();
        WorkspaceTemplateResolverBuilder templateResolverWorkspaceTemplateResolverBuilder = new WorkspaceTemplateResolverBuilder(this.project);
        URI[] altBaseLocations = this.getAltBaseLocations(options);
        if (altBaseLocations.length > 0) {
            templateResolverWorkspaceTemplateResolverBuilder.addAltBaseLocations(altBaseLocations);
        }
        ITemplateResolver templateResolver = templateResolverWorkspaceTemplateResolverBuilder.build();
        return templateResolver;
    }

    private URI[] getAltBaseLocations(Map options) {
        String value = JETCompilerOptions.getStringOption((Map)options, (String)"org.eclipse.jet.v1BaseTransformationID");
        if (value == null || value.trim().length() == 0) {
            return new URI[0];
        }
        String[] uriStrings = value.split(",");
        ArrayList<URI> altLocations = new ArrayList<URI>(uriStrings.length);
        int i = 0;
        while (i < uriStrings.length) {
            String uriString = uriStrings[i].endsWith("/") ? uriStrings[i] : String.valueOf(uriStrings[i]) + "/";
            try {
                URI uri = new URI(uriString);
                altLocations.add(uri);
            }
            catch (URISyntaxException e) {
                InternalJET2Platform.logError(null, e);
            }
            ++i;
        }
        return altLocations.toArray(new URI[altLocations.size()]);
    }
}

