/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename;

import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameModuleRefactoring;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameModuleUtils;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class AcceleoRenameModuleParticipant
extends RenameParticipant {
    private IFile file;
    private IProject project;
    private Module module;
    private AcceleoRenameModuleRefactoring refactoring;

    protected boolean initialize(Object element) {
        if (element instanceof IFile && "mtl".equals(((IFile)element).getFileExtension()) && ((IFile)element).exists()) {
            boolean result;
            block6: {
                result = true;
                String newName = this.getArguments().getNewName();
                if (newName.length() > 0 && newName.endsWith(".mtl") && this.getArguments().getUpdateReferences()) {
                    this.file = (IFile)element;
                    this.project = this.file.getProject();
                    this.module = AcceleoRenameModuleUtils.getModuleFromFile(this.file);
                    try {
                        IMarker[] markers = this.file.findMarkers("org.eclipse.acceleo.ide.ui.problem", true, 2);
                        if (markers.length > 0) {
                            result = false;
                            break block6;
                        }
                        this.refactoring = new AcceleoRenameModuleRefactoring(false);
                    }
                    catch (CoreException coreException) {
                        result = false;
                    }
                } else {
                    result = false;
                }
            }
            return result;
        }
        return false;
    }

    public String getName() {
        return AcceleoUIMessages.getString("AcceleoEditorRenameModuleRefactoring.RenameModuleParticipant");
    }

    public RefactoringStatus checkConditions(IProgressMonitor monitor, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        this.refactoring.setFile(this.file);
        this.refactoring.setProject(this.project);
        this.refactoring.setModule(this.module);
        try {
            status.merge(this.refactoring.checkInitialConditions(monitor));
            String newNameWithoutExtension = this.getArguments().getNewName();
            newNameWithoutExtension = newNameWithoutExtension.substring(0, newNameWithoutExtension.lastIndexOf("."));
            this.refactoring.setNewModuleName(newNameWithoutExtension);
            status.merge(this.refactoring.checkFinalConditions(monitor));
        }
        catch (CoreException coreException) {}
        return status;
    }

    public Change createPreChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        return this.refactoring.createChange(monitor);
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        return null;
    }
}

