/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.migration;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.internal.xpand.migration.AbstractImportsManager;
import org.eclipse.gmf.internal.xpand.migration.OclKeywordManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModeltypeImports
extends AbstractImportsManager {
    private static final String DELIMITER = "_";
    private static final String DEFAULT_ALIAS = "metaModelRef";
    private boolean injectUnusedImports;
    private Set<String> modeltypeAliases = new HashSet<String>();
    private Map<String, String> nsURI2Aliases = new LinkedHashMap<String, String>();
    private Set<String> usedNsURIs = new HashSet<String>();
    private OclKeywordManager keywordManager;

    ModeltypeImports(StringBuilder stringBuilder, boolean injectUnusedImports, OclKeywordManager oclKeywordManager) {
        super(stringBuilder);
        this.injectUnusedImports = injectUnusedImports;
        this.keywordManager = oclKeywordManager;
    }

    void setInjectUnusedImports(boolean injectUnusedImports) {
        this.injectUnusedImports = injectUnusedImports;
    }

    Map<String, String> getModelTypes() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : this.nsURI2Aliases.entrySet()) {
            if (!this.injectUnusedImports && !this.usedNsURIs.contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    void registerModeltype(String nsURI) {
        assert (nsURI.length() > 0);
        String modeltypeAlias = this.getUniqueModeltypeAlias(nsURI);
        this.nsURI2Aliases.put(nsURI, modeltypeAlias);
    }

    String getModeltypeAlias(EPackage ePackage) {
        String nsURI = ePackage.getNsURI();
        if (!this.nsURI2Aliases.containsKey(nsURI)) {
            this.registerModeltype(nsURI);
        }
        this.usedNsURIs.add(nsURI);
        return this.nsURI2Aliases.get(nsURI);
    }

    private String getUniqueModeltypeAlias(String nsURI) {
        String aliasProposal;
        char[] charArray = nsURI.toCharArray();
        int i = charArray.length - 1;
        while (i > -1 && Character.isJavaIdentifierPart(charArray[i])) {
            --i;
        }
        if (i < charArray.length - 1) {
            char[] alias = new char[charArray.length - 1 - i];
            System.arraycopy(charArray, i + 1, alias, 0, charArray.length - 1 - i);
            alias[0] = Character.toLowerCase(alias[0]);
            aliasProposal = new String(alias);
            if (!Character.isJavaIdentifierStart(alias[0])) {
                aliasProposal = DELIMITER + aliasProposal;
            }
        } else {
            aliasProposal = DEFAULT_ALIAS;
        }
        String actualAlias = aliasProposal = this.keywordManager.getValidIdentifierValue(aliasProposal);
        int suffix = 1;
        while (this.modeltypeAliases.contains(actualAlias)) {
            actualAlias = String.valueOf(aliasProposal) + DELIMITER + suffix;
            ++suffix;
        }
        this.modeltypeAliases.add(actualAlias);
        return actualAlias;
    }
}

