/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.ui.contribution.base;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.importer.ImporterPlugin;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.ui.contribution.IModelImporterWizard;
import org.eclipse.emf.importer.ui.contribution.base.ModelImporterPage;
import org.eclipse.emf.importer.util.ImporterUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public abstract class ModelImporterWizard
extends Wizard
implements IModelImporterWizard {
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected PageHelper pageHelper;
    protected ModelImporter modelImporter;
    protected IFile originalGenModelFile;
    protected IFile modelFile;
    protected String fileName;
    protected IPath genModelContainerPath;
    protected IPath projectLocation;
    protected IPath projectPath;

    public ModelImporterWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void dispose() {
        this.selection = null;
        this.workbench = null;
        if (this.modelImporter != null) {
            this.modelImporter.dispose();
            this.modelImporter = null;
        }
        if (this.pageHelper != null) {
            if (this.getContainer() instanceof WizardDialog) {
                ((WizardDialog)this.getContainer()).removePageChangedListener((IPageChangedListener)this.pageHelper);
            }
            this.pageHelper.dispose();
            this.pageHelper = null;
        }
        super.dispose();
    }

    protected abstract ModelImporter createModelImporter();

    public ModelImporter getModelImporter() {
        if (this.modelImporter == null) {
            this.modelImporter = this.createModelImporter();
        }
        return this.modelImporter;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public List getFileExtensions() {
        return this.getModelImporter().getFileExtensions();
    }

    public void setContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
        if (wizardContainer instanceof WizardDialog) {
            this.pageHelper = new PageHelper();
            ((WizardDialog)wizardContainer).addPageChangedListener((IPageChangedListener)this.pageHelper);
        }
    }

    public void setOriginalGenModelFile(IFile originalGenModelFile) {
        this.originalGenModelFile = originalGenModelFile;
        if (originalGenModelFile != null) {
            this.setWindowTitle(ImporterPlugin.INSTANCE.getString("_UI_ReloadWizard_title"));
            this.getModelImporter().defineOriginalGenModelPath(originalGenModelFile.getFullPath());
        }
    }

    public IFile getOriginalGenModelFile() {
        return this.originalGenModelFile;
    }

    public void setModelFile(IFile modelFile) {
        this.modelFile = modelFile;
        this.getModelImporter().setModelFile(modelFile);
    }

    public IFile getModelFile() {
        return this.modelFile;
    }

    public void setGenModelFileName(String fileName) {
        this.fileName = fileName;
        this.getModelImporter().setGenModelFileName(fileName);
    }

    public String getGenModelFileName() {
        return this.fileName;
    }

    public void setGenModelContainerPath(IPath genModelContainerPath) {
        this.genModelContainerPath = genModelContainerPath;
        this.getModelImporter().setGenModelContainerPath(genModelContainerPath);
    }

    public IPath getGenModelContainerPath() {
        return this.genModelContainerPath;
    }

    public void setGenModelProjectLocation(IPath projectLocation) {
        this.projectLocation = projectLocation;
        this.getModelImporter().setGenModelProjectLocation(projectLocation);
    }

    public IPath getGenModelProjectLocation() {
        return this.projectLocation;
    }

    public void setGenModelProjectPath(IPath projectPath) {
        this.projectPath = projectPath;
        this.getModelImporter().setGenModelContainerPath(this.getModelImporter().computeGenModelContainerPath(projectPath));
    }

    public IPath getGenModelProjectPath() {
        return this.projectPath;
    }

    public boolean performCancel() {
        this.pageHelper.firePageDeactivated(4);
        return true;
    }

    public boolean performFinish() {
        this.pageHelper.firePageDeactivated(3);
        try {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected void execute(IProgressMonitor progressMonitor) throws CoreException {
                    try {
                        try {
                            ModelImporterWizard.this.getModelImporter().prepareGenModelAndEPackages(progressMonitor);
                            ModelImporterWizard.this.getModelImporter().saveGenModelAndEPackages(progressMonitor);
                        }
                        catch (Exception exception) {
                            throw new CoreException(ImporterUtil.createErrorStatus(exception, true));
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        progressMonitor.done();
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                    }
                    progressMonitor.done();
                }
            };
            try {
                this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            }
            catch (Exception exception) {
                ImporterPlugin.INSTANCE.log(exception);
                ErrorDialog.openError((Shell)this.getShell(), (String)ImporterPlugin.INSTANCE.getString("_UI_SaveError_title"), null, (IStatus)ImporterUtil.createErrorStatus(exception, true));
                return false;
            }
            IFile genModelFile = this.getFile(this.getModelImporter().getGenModelPath());
            if (this.getModelImporter().getOriginalGenModelPath() == null) {
                this.selectFile(genModelFile);
            }
            try {
                this.openEditor(genModelFile);
            }
            catch (PartInitException partInitException) {
                MessageDialog.openError((Shell)this.getShell(), (String)ImporterPlugin.INSTANCE.getString("_UI_OpenEditor_title"), (String)partInitException.getMessage());
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            ImporterPlugin.INSTANCE.log(exception);
            return false;
        }
    }

    protected IFile getFile(IPath path) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    protected void selectFile(IFile file) {
        IWorkbenchPage page = this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        final IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof ISetSelectionTarget) {
            StructuredSelection targetSelection = new StructuredSelection((Object)file);
            this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                private final /* synthetic */ ISelection val$targetSelection;
                {
                    this.val$targetSelection = iSelection;
                }

                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                }
            });
        }
    }

    protected void openEditor(IFile file) throws PartInitException {
        IWorkbenchPage page = this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        page.openEditor((IEditorInput)new FileEditorInput(file), this.getWorkbench().getEditorRegistry().getDefaultEditor(file.getFullPath().toString()).getId());
    }

    public static class PageHelper
    implements IPageChangedListener,
    IDisposable {
        protected Object oldPage;
        protected IPageChangeProvider pageChangeProvider;

        public void dispose() {
            this.oldPage = null;
            this.pageChangeProvider = null;
        }

        public void pageChanged(PageChangedEvent event) {
            this.pageChangeProvider = event.getPageChangeProvider();
            this.pageChanged(event.getSelectedPage());
        }

        protected void pageChanged(Object currentPage) {
            if (this.oldPage != currentPage) {
                ModelImporterPage page;
                int cause = 0;
                if (this.oldPage instanceof ModelImporterPage) {
                    page = (ModelImporterPage)((Object)this.oldPage);
                    cause = page.forwardDirection ? 2 : 1;
                    page.pageDeactivated(cause);
                }
                this.oldPage = currentPage;
                if (currentPage instanceof ModelImporterPage) {
                    page = (ModelImporterPage)((Object)currentPage);
                    page.pageActivated(page.neverVisible, cause);
                    page.neverVisible = false;
                }
            }
        }

        public void firePageDeactivated(int cause) {
            if (this.pageChangeProvider != null && this.pageChangeProvider.getSelectedPage() instanceof ModelImporterPage) {
                ((ModelImporterPage)((Object)this.pageChangeProvider.getSelectedPage())).pageDeactivated(cause);
            }
        }
    }
}

