/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOReadIndication;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.IAudit;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class UnsubscribeRemoteSessionsIndication
extends CDOReadIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, UnsubscribeRemoteSessionsIndication.class);
    private List<CDORevision> revisions;

    public UnsubscribeRemoteSessionsIndication(CDOServerProtocol protocol) {
        super(protocol, (short)23);
    }

    protected void indicating(CDODataInput in) throws IOException {
        int viewID = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Read viewID: {0}", new Object[]{viewID});
        }
        long timeStamp = in.readLong();
        if (TRACER.isEnabled()) {
            TRACER.format("Read timeStamp: {0,date} {0,time}", new Object[]{timeStamp});
        }
        int size = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Reading {0} IDs", new Object[]{size});
        }
        ArrayList<CDOID> invalidObjects = new ArrayList<CDOID>(size);
        int i = 0;
        while (i < size) {
            CDOID id = in.readCDOID();
            invalidObjects.add(id);
            if (TRACER.isEnabled()) {
                TRACER.format("Read ID: {0}", new Object[]{id});
            }
            ++i;
        }
        IView view = this.getSession().getView(viewID);
        if (view instanceof IAudit) {
            IAudit audit = (IAudit)view;
            this.revisions = audit.setTimeStamp(timeStamp, invalidObjects);
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} existanceFlags", new Object[]{this.revisions.size()});
        }
        out.writeInt(this.revisions.size());
        for (CDORevision revision : this.revisions) {
            boolean existanceFlag;
            boolean bl = existanceFlag = revision != null;
            if (TRACER.isEnabled()) {
                TRACER.format("Writing existanceFlag: {0}", new Object[]{existanceFlag});
            }
            out.writeBoolean(existanceFlag);
        }
    }
}

