/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDMeta;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.spi.server.StoreAccessor;
import org.eclipse.emf.cdo.spi.server.StoreAccessorPool;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.ProgressDistributor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Store
extends Lifecycle
implements IStore {
    protected static final long CRASHED = -1L;
    @ReflectUtil.ExcludeFromDump
    private final transient String type;
    @ReflectUtil.ExcludeFromDump
    private final transient Set<IStore.ChangeFormat> supportedChangeFormats;
    @ReflectUtil.ExcludeFromDump
    private final transient Set<IStore.RevisionTemporality> supportedRevisionTemporalities;
    @ReflectUtil.ExcludeFromDump
    private final transient Set<IStore.RevisionParallelism> supportedRevisionParallelisms;
    private IStore.RevisionTemporality revisionTemporality = IStore.RevisionTemporality.NONE;
    private IStore.RevisionParallelism revisionParallelism = IStore.RevisionParallelism.NONE;
    private IRepository repository;
    @ReflectUtil.ExcludeFromDump
    private transient long lastMetaID;
    @ReflectUtil.ExcludeFromDump
    private transient Object lastMetaIDLock = new Object();
    @ReflectUtil.ExcludeFromDump
    private transient ProgressDistributor indicatingCommitDistributor = new ProgressDistributor.Geometric(){

        public String toString() {
            String result = "indicatingCommitDistributor";
            if (Store.this.repository != null) {
                result = String.valueOf(result) + ": " + Store.this.repository.getName();
            }
            return result;
        }
    };

    public Store(String type, Set<IStore.ChangeFormat> supportedChangeFormats, Set<IStore.RevisionTemporality> supportedRevisionTemporalities, Set<IStore.RevisionParallelism> supportedRevisionParallelisms) {
        this.checkArg(!StringUtil.isEmpty((String)type), "Empty type");
        this.type = type;
        this.checkArg(supportedChangeFormats != null && !supportedChangeFormats.isEmpty(), "Empty supportedChangeFormats");
        this.supportedChangeFormats = supportedChangeFormats;
        this.checkArg(supportedRevisionTemporalities != null && !supportedRevisionTemporalities.isEmpty(), "Empty supportedRevisionTemporalities");
        this.supportedRevisionTemporalities = supportedRevisionTemporalities;
        this.checkArg(supportedRevisionParallelisms != null && !supportedRevisionParallelisms.isEmpty(), "Empty supportedRevisionParallelisms");
        this.supportedRevisionParallelisms = supportedRevisionParallelisms;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public IRepository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(IRepository repository) {
        this.repository = repository;
    }

    @Override
    public Set<IStore.ChangeFormat> getSupportedChangeFormats() {
        return this.supportedChangeFormats;
    }

    @Override
    public Set<IStore.RevisionTemporality> getSupportedRevisionTemporalities() {
        return this.supportedRevisionTemporalities;
    }

    @Override
    public Set<IStore.RevisionParallelism> getSupportedRevisionParallelisms() {
        return this.supportedRevisionParallelisms;
    }

    @Override
    public IStore.RevisionTemporality getRevisionTemporality() {
        return this.revisionTemporality;
    }

    @Override
    public void setRevisionTemporality(IStore.RevisionTemporality revisionTemporality) {
        this.checkInactive();
        this.checkState(this.supportedRevisionTemporalities.contains((Object)revisionTemporality), "Revision temporality not supported: " + (Object)((Object)revisionTemporality));
        this.revisionTemporality = revisionTemporality;
    }

    @Override
    public IStore.RevisionParallelism getRevisionParallelism() {
        return this.revisionParallelism;
    }

    @Override
    public void setRevisionParallelism(IStore.RevisionParallelism revisionParallelism) {
        this.checkInactive();
        this.checkState(this.supportedRevisionParallelisms.contains((Object)revisionParallelism), "Revision parallelism not supported: " + (Object)((Object)revisionParallelism));
        this.revisionParallelism = revisionParallelism;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastMetaID() {
        Object object = this.lastMetaIDLock;
        synchronized (object) {
            return this.lastMetaID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastMetaID(long lastMetaID) {
        Object object = this.lastMetaIDLock;
        synchronized (object) {
            this.lastMetaID = lastMetaID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOIDMetaRange getNextMetaIDRange(int count) {
        Object object = this.lastMetaIDLock;
        synchronized (object) {
            CDOIDMeta lowerBound = CDOIDUtil.createMeta((long)(this.lastMetaID + 1L));
            this.lastMetaID += (long)count;
            return CDOIDUtil.createMetaRange((CDOID)lowerBound, (int)count);
        }
    }

    @Override
    public IStoreAccessor getReader(ISession session) {
        IStoreAccessor reader = null;
        StoreAccessorPool pool = this.getReaderPool(session, false);
        if (pool != null) {
            reader = pool.removeStoreAccessor();
        }
        if (reader == null && session != null) {
            CDOCommonView[] views;
            CDOCommonView[] cDOCommonViewArray = views = session.getViews();
            int n = views.length;
            int n2 = 0;
            while (n2 < n) {
                CDOCommonView view = cDOCommonViewArray[n2];
                pool = this.getWriterPool((IView)view, false);
                if (pool != null && (reader = pool.removeStoreAccessor()) != null) break;
                ++n2;
            }
        }
        if (reader == null) {
            reader = this.createReader(session);
            LifecycleUtil.activate((Object)reader);
        }
        return reader;
    }

    @Override
    public IStoreAccessor getWriter(ITransaction transaction) {
        IStoreAccessor writer = null;
        StoreAccessorPool pool = this.getWriterPool(transaction, false);
        if (pool != null) {
            writer = pool.removeStoreAccessor();
        }
        if (writer == null) {
            writer = this.createWriter(transaction);
            LifecycleUtil.activate((Object)writer);
        }
        return writer;
    }

    @Override
    public ProgressDistributor getIndicatingCommitDistributor() {
        return this.indicatingCommitDistributor;
    }

    protected void releaseAccessor(StoreAccessor accessor) {
        StoreAccessorPool pool = null;
        pool = accessor.isReader() ? this.getReaderPool(accessor.getSession(), true) : this.getWriterPool(accessor.getTransaction(), true);
        if (pool != null) {
            pool.addStoreAccessor(accessor);
        } else {
            accessor.deactivate();
        }
    }

    protected abstract StoreAccessorPool getReaderPool(ISession var1, boolean var2);

    protected abstract StoreAccessorPool getWriterPool(IView var1, boolean var2);

    protected abstract IStoreAccessor createReader(ISession var1);

    protected abstract IStoreAccessor createWriter(ITransaction var1);

    public static IStoreAccessor.QueryResourcesContext.ExactMatch createExactMatchContext(final CDOID folderID, final String name, final long timeStamp) {
        return new IStoreAccessor.QueryResourcesContext.ExactMatch(){
            private CDOID resourceID;

            public CDOID getResourceID() {
                return this.resourceID;
            }

            public long getTimeStamp() {
                return timeStamp;
            }

            public CDOID getFolderID() {
                return folderID;
            }

            public String getName() {
                return name;
            }

            public boolean exactMatch() {
                return true;
            }

            public int getMaxResults() {
                return 1;
            }

            public boolean addResource(CDOID resourceID) {
                this.resourceID = resourceID;
                return false;
            }
        };
    }

    protected static <T> Set<T> set(T ... elements) {
        return Collections.unmodifiableSet(new HashSet<T>(Arrays.asList(elements)));
    }
}

