/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.io.Closeable;
import java.io.InputStream;
import org.eclipse.emf.cdo.common.id.CDOIDLibraryDescriptor;
import org.eclipse.emf.cdo.common.id.CDOIDLibraryProvider;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.internal.server.Store;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.hibernate.IHibernateMappingProvider;
import org.eclipse.emf.cdo.server.hibernate.IHibernateStore;
import org.eclipse.emf.cdo.server.hibernate.internal.id.CDOIDHibernateFactoryImpl;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernatePackageHandler;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStoreReader;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStoreWriter;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.cdo.server.internal.hibernate.bundle.OM;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOInterceptor;
import org.eclipse.emf.cdo.spi.common.CDOIDLibraryProviderImpl;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;

public class HibernateStore
extends Store
implements IHibernateStore {
    public static final String TYPE = "hibernate";
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HibernateStore.class);
    private static final CDOIDObjectFactory CDOID_OBJECT_FACTORY = new CDOIDHibernateFactoryImpl();
    private static final IDLibraryProvider CDOID_LIBRARY_PROVIDER = new IDLibraryProvider();
    private static final CDOIDLibraryDescriptor CDOID_LIBRARY_DESCRIPTOR = CDOID_LIBRARY_PROVIDER.createDescriptor(CDOIDHibernateFactoryImpl.class.getName());
    private static ThreadLocal<HibernateStore> currentHibernateStore = new ThreadLocal();
    private Configuration hibernateConfiguration;
    private SessionFactory hibernateSessionFactory;
    private HibernatePackageHandler packageHandler;
    private IHibernateMappingProvider mappingProvider;
    private boolean doDropSchema = false;

    public HibernateStore(IHibernateMappingProvider mappingProvider) {
        super(TYPE);
        this.mappingProvider = mappingProvider;
        this.packageHandler = new HibernatePackageHandler(this);
        if (TRACER.isEnabled() && mappingProvider != null) {
            TRACER.trace("HibernateStore with mappingProvider " + mappingProvider.getClass().getName());
        }
    }

    public Configuration getHibernateConfiguration() {
        return this.hibernateConfiguration;
    }

    public synchronized SessionFactory getHibernateSessionFactory() {
        if (this.hibernateSessionFactory == null) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Initializing SessionFactory for HibernateStore");
            }
            currentHibernateStore.set(this);
            try {
                this.initConfiguration();
                this.hibernateSessionFactory = this.hibernateConfiguration.buildSessionFactory();
            }
            finally {
                currentHibernateStore.set(null);
            }
        }
        return this.hibernateSessionFactory;
    }

    public boolean hasAuditingSupport() {
        return false;
    }

    public boolean hasBranchingSupport() {
        return false;
    }

    public boolean hasWriteDeltaSupport() {
        return false;
    }

    public CDOIDObjectFactory getCDOIDObjectFactory() {
        return CDOID_OBJECT_FACTORY;
    }

    public CDOIDLibraryDescriptor getCDOIDLibraryDescriptor() {
        return CDOID_LIBRARY_DESCRIPTOR;
    }

    public CDOIDLibraryProvider getCDOIDLibraryProvider() {
        return CDOID_LIBRARY_PROVIDER;
    }

    public HibernateStoreReader getReader(ISession session) {
        return (HibernateStoreReader)super.getReader(session);
    }

    public HibernateStoreReader createReader(ISession session) {
        return new HibernateStoreReader(this, session);
    }

    public HibernateStoreWriter createWriter(IView view) {
        return new HibernateStoreWriter(this, view);
    }

    public HibernateStoreWriter getWriter(IView view) {
        return (HibernateStoreWriter)super.getWriter(view);
    }

    public synchronized int getNextPackageID() {
        return this.packageHandler.getNextPackageID();
    }

    public synchronized int getNextClassID() {
        return this.packageHandler.getNextClassID();
    }

    public synchronized int getNextFeatureID() {
        return this.packageHandler.getNextFeatureID();
    }

    public boolean wasCrashed() {
        return false;
    }

    public void repairAfterCrash() {
        throw new UnsupportedOperationException();
    }

    public HibernatePackageHandler getPackageHandler() {
        return this.packageHandler;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.packageHandler.activate();
    }

    protected void doDeactivate() throws Exception {
        if (this.hibernateSessionFactory != null) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Closing SessionFactory");
            }
            this.hibernateSessionFactory.close();
            this.hibernateSessionFactory = null;
        }
        if (this.doDropSchema) {
            Configuration conf = this.getHibernateConfiguration();
            SchemaExport se = new SchemaExport(conf);
            se.drop(false, true);
        }
        this.packageHandler.deactivate();
        if (this.doDropSchema) {
            this.packageHandler.doDropSchema();
        }
        super.doDeactivate();
    }

    protected void reInitialize() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Re-Initializing HibernateStore");
        }
        if (this.hibernateSessionFactory != null) {
            if (!this.hibernateSessionFactory.isClosed()) {
                if (TRACER.isEnabled()) {
                    TRACER.trace("Closing SessionFactory");
                }
                this.hibernateSessionFactory.close();
            }
            this.hibernateSessionFactory = null;
        }
    }

    protected void initConfiguration() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Initializing Configuration");
        }
        InputStream in = null;
        try {
            try {
                this.hibernateConfiguration = new Configuration();
                if (this.mappingProvider != null) {
                    this.mappingProvider.setHibernateStore(this);
                    this.mappingProvider.addMapping(this.hibernateConfiguration);
                }
                if (TRACER.isEnabled()) {
                    TRACER.trace("Adding resource.hbm.xml to configuration");
                }
                in = OM.BUNDLE.getInputStream("mappings/resource.hbm.xml");
                this.hibernateConfiguration.addInputStream(in);
                this.hibernateConfiguration.setInterceptor((Interceptor)new CDOInterceptor());
                this.hibernateConfiguration.setProperties(HibernateUtil.getInstance().getPropertiesFromStore(this));
                if (this.hibernateConfiguration.getProperty("hibernate.hbm2ddl.auto") != null && this.hibernateConfiguration.getProperty("hibernate.hbm2ddl.auto").startsWith("create")) {
                    this.doDropSchema = true;
                    this.hibernateConfiguration.setProperty("hibernate.hbm2ddl.auto", "update");
                } else {
                    this.doDropSchema = false;
                }
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close((Closeable)in);
    }

    public static HibernateStore getCurrentHibernateStore() {
        return currentHibernateStore.get();
    }

    private static final class IDLibraryProvider
    extends CDOIDLibraryProviderImpl {
        public IDLibraryProvider() {
            this.addLibrary("hibernate-id-v2.jar", org.eclipse.emf.cdo.server.hibernate.internal.id.bundle.OM.BUNDLE);
        }
    }
}

