/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.unixsocket.server;

import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.Executor;
import jnr.enxio.channels.NativeSelectorProvider;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.unixsocket.common.UnixSocketEndPoint;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="Connector using UNIX Socket")
public class UnixSocketConnector
extends AbstractConnector {
    public static final int MAX_UNIX_SOCKET_PATH_LENGTH = 107;
    private static final Logger LOG = LoggerFactory.getLogger(UnixSocketConnector.class);
    private final SelectorManager _manager;
    private String _unixSocket = "/tmp/jetty.sock";
    private volatile UnixServerSocketChannel _acceptChannel;
    private volatile int _acceptQueueSize = 0;
    private volatile boolean _reuseAddress = true;

    public UnixSocketConnector(@Name(value="server") Server server) {
        this(server, -1);
    }

    public UnixSocketConnector(@Name(value="server") Server server, @Name(value="selectors") int selectors) {
        this(server, selectors, new ConnectionFactory[]{new HttpConnectionFactory()});
    }

    public UnixSocketConnector(@Name(value="server") Server server, ConnectionFactory ... factories) {
        this(server, -1, factories);
    }

    public UnixSocketConnector(@Name(value="server") Server server, @Name(value="selectors") int selectors, ConnectionFactory ... factories) {
        this(server, null, null, null, selectors, factories);
    }

    public UnixSocketConnector(@Name(value="server") Server server, @Name(value="sslContextFactory") SslContextFactory.Server sslContextFactory) {
        this(server, -1, sslContextFactory);
    }

    public UnixSocketConnector(@Name(value="server") Server server, @Name(value="selectors") int selectors, @Name(value="sslContextFactory") SslContextFactory.Server sslContextFactory) {
        this(server, null, null, null, selectors, AbstractConnectionFactory.getFactories((SslContextFactory.Server)sslContextFactory, (ConnectionFactory[])new ConnectionFactory[]{new HttpConnectionFactory()}));
    }

    public UnixSocketConnector(@Name(value="server") Server server, @Name(value="sslContextFactory") SslContextFactory.Server sslContextFactory, ConnectionFactory ... factories) {
        this(server, null, null, null, -1, AbstractConnectionFactory.getFactories((SslContextFactory.Server)sslContextFactory, (ConnectionFactory[])factories));
    }

    public UnixSocketConnector(@Name(value="server") Server server, @Name(value="executor") Executor executor, @Name(value="scheduler") Scheduler scheduler, @Name(value="bufferPool") ByteBufferPool bufferPool, @Name(value="selectors") int selectors, ConnectionFactory ... factories) {
        super(server, executor, scheduler, bufferPool, 0, factories);
        this._manager = this.newSelectorManager(this.getExecutor(), this.getScheduler(), selectors > 0 ? selectors : 1);
        this.addBean(this._manager, true);
    }

    @ManagedAttribute(value="The UNIX socket file name")
    public String getUnixSocket() {
        return this._unixSocket;
    }

    public void setUnixSocket(String filename) {
        if (filename.length() > 107) {
            throw new IllegalArgumentException("Unix socket path too long");
        }
        this._unixSocket = filename;
    }

    protected SelectorManager newSelectorManager(Executor executor, Scheduler scheduler, int selectors) {
        return new UnixSocketConnectorManager(executor, scheduler, selectors);
    }

    protected void doStart() throws Exception {
        this.open();
        super.doStart();
        if (this.getAcceptors() == 0) {
            this._manager.acceptor((SelectableChannel)this._acceptChannel);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.close();
    }

    public void open() throws IOException {
        if (this._acceptChannel == null) {
            File file = new File(this._unixSocket);
            file.deleteOnExit();
            UnixSocketAddress bindAddress = new UnixSocketAddress(file);
            UnixServerSocketChannel serverChannel = UnixServerSocketChannel.open();
            serverChannel.configureBlocking(this.getAcceptors() > 0);
            try {
                serverChannel.socket().bind((SocketAddress)bindAddress, this.getAcceptQueueSize());
            }
            catch (IOException e) {
                LOG.warn("cannot bind {} exists={} writable={}", new Object[]{file, file.exists(), file.canWrite()});
                throw e;
            }
            this.addBean(serverChannel);
            if (LOG.isDebugEnabled()) {
                LOG.debug("opened {}", (Object)serverChannel);
            }
            this._acceptChannel = serverChannel;
        }
    }

    public void close() {
        UnixServerSocketChannel serverChannel = this._acceptChannel;
        this._acceptChannel = null;
        if (serverChannel != null) {
            this.removeBean(serverChannel);
            if (serverChannel.isOpen()) {
                try {
                    serverChannel.close();
                }
                catch (IOException e) {
                    LOG.warn("Unable to close serverChannel: {}", (Object)serverChannel, (Object)e);
                }
            }
            try {
                Files.deleteIfExists(Paths.get(this._unixSocket, new String[0]));
            }
            catch (IOException e) {
                LOG.warn("Unable to delete UnixSocket at {}", (Object)this._unixSocket, (Object)e);
            }
        }
    }

    public void accept(int acceptorID) throws IOException {
        LOG.debug("Blocking UnixSocket accept used.  Might not be able to be interrupted!");
        UnixServerSocketChannel serverChannel = this._acceptChannel;
        if (serverChannel != null && serverChannel.isOpen()) {
            LOG.debug("accept {}", (Object)serverChannel);
            UnixSocketChannel channel = serverChannel.accept();
            LOG.debug("accepted {}", (Object)channel);
            this.accepted(channel);
        }
    }

    protected void accepted(UnixSocketChannel channel) throws IOException {
        channel.configureBlocking(false);
        this._manager.accept((SelectableChannel)channel);
    }

    public SelectorManager getSelectorManager() {
        return this._manager;
    }

    public Object getTransport() {
        return this._acceptChannel;
    }

    protected UnixSocketEndPoint newEndPoint(SelectableChannel channel, ManagedSelector selector, SelectionKey key) {
        return new UnixSocketEndPoint((UnixSocketChannel)channel, selector, key, this.getScheduler());
    }

    @ManagedAttribute(value="Accept Queue size")
    public int getAcceptQueueSize() {
        return this._acceptQueueSize;
    }

    public void setAcceptQueueSize(int acceptQueueSize) {
        this._acceptQueueSize = acceptQueueSize;
    }

    @ManagedAttribute(value="Whether the server socket reuses addresses")
    public boolean getReuseAddress() {
        return this._reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this._reuseAddress = reuseAddress;
    }

    public String toString() {
        return String.format("%s{%s}", super.toString(), this._unixSocket);
    }

    protected class UnixSocketConnectorManager
    extends SelectorManager {
        public UnixSocketConnectorManager(Executor executor, Scheduler scheduler, int selectors) {
            super(executor, scheduler, selectors);
        }

        protected void accepted(SelectableChannel channel) throws IOException {
            UnixSocketConnector.this.accepted((UnixSocketChannel)channel);
        }

        protected Selector newSelector() throws IOException {
            return NativeSelectorProvider.getInstance().openSelector();
        }

        protected EndPoint newEndPoint(SelectableChannel channel, ManagedSelector selector, SelectionKey selectionKey) {
            UnixSocketEndPoint endPoint = UnixSocketConnector.this.newEndPoint(channel, selector, selectionKey);
            endPoint.setIdleTimeout(UnixSocketConnector.this.getIdleTimeout());
            return endPoint;
        }

        public Connection newConnection(SelectableChannel channel, EndPoint endpoint, Object attachment) {
            return UnixSocketConnector.this.getDefaultConnectionFactory().newConnection((Connector)UnixSocketConnector.this, endpoint);
        }

        protected void endPointOpened(EndPoint endpoint) {
            super.endPointOpened(endpoint);
            UnixSocketConnector.this.onEndPointOpened(endpoint);
        }

        protected void endPointClosed(EndPoint endpoint) {
            UnixSocketConnector.this.onEndPointClosed(endpoint);
            super.endPointClosed(endpoint);
        }

        protected boolean doFinishConnect(SelectableChannel channel) throws IOException {
            return ((UnixSocketChannel)channel).finishConnect();
        }

        protected boolean isConnectionPending(SelectableChannel channel) {
            return ((UnixSocketChannel)channel).isConnectionPending();
        }

        protected SelectableChannel doAccept(SelectableChannel server) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("doAccept async {}", (Object)server);
            }
            UnixSocketChannel channel = ((UnixServerSocketChannel)server).accept();
            if (LOG.isDebugEnabled()) {
                LOG.debug("accepted async {}", (Object)channel);
            }
            return channel;
        }
    }
}

