/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

public class WorkspaceUtils {
    private WorkspaceUtils() {
    }

    public static IFile getIFile(String fileUnderWorkspace) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Path location = new Path(fileUnderWorkspace);
        IFile ifile = workspace.getRoot().getFileForLocation((IPath)location);
        return ifile;
    }

    public static IFile getWorkspaceFile(String name) {
        try {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(name));
            return file;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IFile getWorkspaceFile(URI uri) {
        String uriPath = uri.isFile() ? uri.toFileString() : (uri.isPlatform() ? uri.toPlatformString(true) : uri.toString());
        return WorkspaceUtils.getWorkspaceFile(uriPath);
    }

    public static IContainer getIContainer(String folderUnderWorkspace) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Path location = new Path(folderUnderWorkspace);
        IContainer cont = workspace.getRoot().getContainerForLocation((IPath)location);
        return cont;
    }

    public static IFolder getWorkspaceFolder(String name) {
        try {
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(name));
            return folder;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IProject getWorkspaceProject(String name) {
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            return project;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IContainer getWorkspaceContainer(String name) {
        Path path = new Path(name);
        if (path.segmentCount() > 1) {
            return WorkspaceUtils.getWorkspaceFolder(name);
        }
        return WorkspaceUtils.getWorkspaceProject(name);
    }

    public static String getPathString(IResource resource) {
        String path = resource.getFullPath().toString();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }
}

