package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link DockerCredentialHelperAuth}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDockerCredentialHelperAuth.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableDockerCredentialHelperAuth
    implements DockerCredentialHelperAuth {
  private final String username;
  private final String secret;
  private final @Nullable String serverUrl;
  private transient final RegistryAuth toRegistryAuth;

  private ImmutableDockerCredentialHelperAuth(
      String username,
      String secret,
      @Nullable String serverUrl) {
    this.username = username;
    this.secret = secret;
    this.serverUrl = serverUrl;
    this.toRegistryAuth = Objects.requireNonNull(DockerCredentialHelperAuth.super.toRegistryAuth(), "toRegistryAuth");
  }

  /**
   * @return The value of the {@code username} attribute
   */
  @JsonProperty("Username")
  @Override
  public String username() {
    return username;
  }

  /**
   * @return The value of the {@code secret} attribute
   */
  @JsonProperty("Secret")
  @Override
  public String secret() {
    return secret;
  }

  /**
   * @return The value of the {@code serverUrl} attribute
   */
  @JsonProperty("ServerURL")
  @Override
  public @Nullable String serverUrl() {
    return serverUrl;
  }

  /**
   * @return The computed-at-construction value of the {@code toRegistryAuth} attribute
   */
  @JsonProperty("toRegistryAuth")
  @JsonIgnore
  @Override
  public RegistryAuth toRegistryAuth() {
    return toRegistryAuth;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerCredentialHelperAuth#username() username} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for username
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerCredentialHelperAuth withUsername(String value) {
    String newValue = Objects.requireNonNull(value, "username");
    if (this.username.equals(newValue)) return this;
    return new ImmutableDockerCredentialHelperAuth(newValue, this.secret, this.serverUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerCredentialHelperAuth#secret() secret} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for secret
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerCredentialHelperAuth withSecret(String value) {
    String newValue = Objects.requireNonNull(value, "secret");
    if (this.secret.equals(newValue)) return this;
    return new ImmutableDockerCredentialHelperAuth(this.username, newValue, this.serverUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerCredentialHelperAuth#serverUrl() serverUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for serverUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDockerCredentialHelperAuth withServerUrl(@Nullable String value) {
    if (Objects.equals(this.serverUrl, value)) return this;
    return new ImmutableDockerCredentialHelperAuth(this.username, this.secret, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDockerCredentialHelperAuth} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDockerCredentialHelperAuth
        && equalTo(0, (ImmutableDockerCredentialHelperAuth) another);
  }

  private boolean equalTo(int synthetic, ImmutableDockerCredentialHelperAuth another) {
    return username.equals(another.username)
        && secret.equals(another.secret)
        && Objects.equals(serverUrl, another.serverUrl)
        && toRegistryAuth.equals(another.toRegistryAuth);
  }

  /**
   * Computes a hash code from attributes: {@code username}, {@code secret}, {@code serverUrl}, {@code toRegistryAuth}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + username.hashCode();
    h += (h << 5) + secret.hashCode();
    h += (h << 5) + Objects.hashCode(serverUrl);
    h += (h << 5) + toRegistryAuth.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DockerCredentialHelperAuth} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DockerCredentialHelperAuth{"
        + "username=" + username
        + ", secret=" + secret
        + ", serverUrl=" + serverUrl
        + ", toRegistryAuth=" + toRegistryAuth
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DockerCredentialHelperAuth} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DockerCredentialHelperAuth instance
   */
  public static ImmutableDockerCredentialHelperAuth copyOf(DockerCredentialHelperAuth instance) {
    if (instance instanceof ImmutableDockerCredentialHelperAuth) {
      return (ImmutableDockerCredentialHelperAuth) instance;
    }
    return ImmutableDockerCredentialHelperAuth.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDockerCredentialHelperAuth ImmutableDockerCredentialHelperAuth}.
   * <pre>
   * ImmutableDockerCredentialHelperAuth.builder()
   *    .username(String) // required {@link DockerCredentialHelperAuth#username() username}
   *    .secret(String) // required {@link DockerCredentialHelperAuth#secret() secret}
   *    .serverUrl(String | null) // nullable {@link DockerCredentialHelperAuth#serverUrl() serverUrl}
   *    .build();
   * </pre>
   * @return A new ImmutableDockerCredentialHelperAuth builder
   */
  public static ImmutableDockerCredentialHelperAuth.Builder builder() {
    return new ImmutableDockerCredentialHelperAuth.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDockerCredentialHelperAuth ImmutableDockerCredentialHelperAuth}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements DockerCredentialHelperAuth.Builder {
    private static final long INIT_BIT_USERNAME = 0x1L;
    private static final long INIT_BIT_SECRET = 0x2L;
    private long initBits = 0x3L;

    private String username;
    private String secret;
    private String serverUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DockerCredentialHelperAuth} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DockerCredentialHelperAuth instance) {
      Objects.requireNonNull(instance, "instance");
      this.username(instance.username());
      this.secret(instance.secret());
      @Nullable String serverUrlValue = instance.serverUrl();
      if (serverUrlValue != null) {
        serverUrl(serverUrlValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DockerCredentialHelperAuth#username() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Username")
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Initializes the value for the {@link DockerCredentialHelperAuth#secret() secret} attribute.
     * @param secret The value for secret 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Secret")
    public final Builder secret(String secret) {
      this.secret = Objects.requireNonNull(secret, "secret");
      initBits &= ~INIT_BIT_SECRET;
      return this;
    }

    /**
     * Initializes the value for the {@link DockerCredentialHelperAuth#serverUrl() serverUrl} attribute.
     * @param serverUrl The value for serverUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ServerURL")
    public final Builder serverUrl(@Nullable String serverUrl) {
      this.serverUrl = serverUrl;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDockerCredentialHelperAuth ImmutableDockerCredentialHelperAuth}.
     * @return An immutable instance of DockerCredentialHelperAuth
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDockerCredentialHelperAuth build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDockerCredentialHelperAuth(username, secret, serverUrl);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      if ((initBits & INIT_BIT_SECRET) != 0) attributes.add("secret");
      return "Cannot build DockerCredentialHelperAuth, some of required attributes are not set " + attributes;
    }
  }
}
