/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.Config;
import org.mandas.docker.client.messages.swarm.ConfigSpec;
import org.mandas.docker.client.messages.swarm.Version;

final class ImmutableConfig
implements Config {
    private final String id;
    private final Version version;
    private final Date createdAt;
    private final Date updatedAt;
    private final ConfigSpec configSpec;

    private ImmutableConfig(String id, Version version, Date createdAt, Date updatedAt, ConfigSpec configSpec) {
        this.id = id;
        this.version = version;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.configSpec = configSpec;
    }

    @Override
    @JsonProperty(value="ID")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Version")
    public Version version() {
        return this.version;
    }

    @Override
    @JsonProperty(value="CreatedAt")
    public Date createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="UpdatedAt")
    public Date updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="Spec")
    public ConfigSpec configSpec() {
        return this.configSpec;
    }

    public final ImmutableConfig withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableConfig(newValue, this.version, this.createdAt, this.updatedAt, this.configSpec);
    }

    public final ImmutableConfig withVersion(Version value) {
        if (this.version == value) {
            return this;
        }
        Version newValue = Objects.requireNonNull(value, "version");
        return new ImmutableConfig(this.id, newValue, this.createdAt, this.updatedAt, this.configSpec);
    }

    public final ImmutableConfig withCreatedAt(Date value) {
        if (this.createdAt == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "createdAt");
        return new ImmutableConfig(this.id, this.version, newValue, this.updatedAt, this.configSpec);
    }

    public final ImmutableConfig withUpdatedAt(Date value) {
        if (this.updatedAt == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "updatedAt");
        return new ImmutableConfig(this.id, this.version, this.createdAt, newValue, this.configSpec);
    }

    public final ImmutableConfig withConfigSpec(ConfigSpec value) {
        if (this.configSpec == value) {
            return this;
        }
        ConfigSpec newValue = Objects.requireNonNull(value, "configSpec");
        return new ImmutableConfig(this.id, this.version, this.createdAt, this.updatedAt, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConfig && this.equalTo(0, (ImmutableConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableConfig another) {
        return this.id.equals(another.id) && this.version.equals(another.version) && this.createdAt.equals(another.createdAt) && this.updatedAt.equals(another.updatedAt) && this.configSpec.equals(another.configSpec);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.updatedAt.hashCode();
        h += (h << 5) + this.configSpec.hashCode();
        return h;
    }

    public String toString() {
        return "Config{id=" + this.id + ", version=" + String.valueOf(this.version) + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", configSpec=" + String.valueOf(this.configSpec) + "}";
    }

    public static ImmutableConfig copyOf(Config instance) {
        if (instance instanceof ImmutableConfig) {
            return (ImmutableConfig)instance;
        }
        return ImmutableConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_VERSION = 2L;
        private static final long INIT_BIT_CREATED_AT = 4L;
        private static final long INIT_BIT_UPDATED_AT = 8L;
        private static final long INIT_BIT_CONFIG_SPEC = 16L;
        private long initBits = 31L;
        private String id;
        private Version version;
        private Date createdAt;
        private Date updatedAt;
        private ConfigSpec configSpec;

        private Builder() {
        }

        public final Builder from(Config instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.version(instance.version());
            this.createdAt(instance.createdAt());
            this.updatedAt(instance.updatedAt());
            this.configSpec(instance.configSpec());
            return this;
        }

        @JsonProperty(value="ID")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Version")
        public final Builder version(Version version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="CreatedAt")
        public final Builder createdAt(Date createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="UpdatedAt")
        public final Builder updatedAt(Date updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="Spec")
        public final Builder configSpec(ConfigSpec configSpec) {
            this.configSpec = Objects.requireNonNull(configSpec, "configSpec");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConfig(this.id, this.version, this.createdAt, this.updatedAt, this.configSpec);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("updatedAt");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("configSpec");
            }
            return "Cannot build Config, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    static final class Criteria
    implements Config.Criteria {
        @Nullable
        private final String configId;
        @Nullable
        private final String label;
        @Nullable
        private final String name;

        private Criteria(@Nullable String configId, @Nullable String label, @Nullable String name) {
            this.configId = configId;
            this.label = label;
            this.name = name;
        }

        @Override
        @Nullable
        public String configId() {
            return this.configId;
        }

        @Override
        @Nullable
        public String label() {
            return this.label;
        }

        @Override
        @Nullable
        public String name() {
            return this.name;
        }

        public final Criteria withConfigId(@Nullable String value) {
            if (Objects.equals(this.configId, value)) {
                return this;
            }
            return new Criteria(value, this.label, this.name);
        }

        public final Criteria withLabel(@Nullable String value) {
            if (Objects.equals(this.label, value)) {
                return this;
            }
            return new Criteria(this.configId, value, this.name);
        }

        public final Criteria withName(@Nullable String value) {
            if (Objects.equals(this.name, value)) {
                return this;
            }
            return new Criteria(this.configId, this.label, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Criteria && this.equalTo(0, (Criteria)another);
        }

        private boolean equalTo(int synthetic, Criteria another) {
            return Objects.equals(this.configId, another.configId) && Objects.equals(this.label, another.label) && Objects.equals(this.name, another.name);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.configId);
            h += (h << 5) + Objects.hashCode(this.label);
            h += (h << 5) + Objects.hashCode(this.name);
            return h;
        }

        public String toString() {
            return "Criteria{configId=" + this.configId + ", label=" + this.label + ", name=" + this.name + "}";
        }

        public static Criteria copyOf(Config.Criteria instance) {
            if (instance instanceof Criteria) {
                return (Criteria)instance;
            }
            return Criteria.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder
        implements Config.Criteria.Builder {
            private String configId;
            private String label;
            private String name;

            private Builder() {
            }

            public final Builder from(Config.Criteria instance) {
                String nameValue;
                String labelValue;
                Objects.requireNonNull(instance, "instance");
                String configIdValue = instance.configId();
                if (configIdValue != null) {
                    this.configId(configIdValue);
                }
                if ((labelValue = instance.label()) != null) {
                    this.label(labelValue);
                }
                if ((nameValue = instance.name()) != null) {
                    this.name(nameValue);
                }
                return this;
            }

            @Override
            public final Builder configId(@Nullable String configId) {
                this.configId = configId;
                return this;
            }

            @Override
            public final Builder label(@Nullable String label) {
                this.label = label;
                return this;
            }

            @Override
            public final Builder name(@Nullable String name) {
                this.name = name;
                return this;
            }

            @Override
            public Criteria build() {
                return new Criteria(this.configId, this.label, this.name);
            }
        }
    }
}

