/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.client.messages.EndpointConfig;
import org.mandas.docker.client.messages.NetworkingConfig;

final class ImmutableNetworkingConfig
implements NetworkingConfig {
    private final Map<String, EndpointConfig> endpointsConfig;

    private ImmutableNetworkingConfig(Map<String, EndpointConfig> endpointsConfig) {
        this.endpointsConfig = endpointsConfig;
    }

    @Override
    @JsonProperty(value="EndpointsConfig")
    public Map<String, EndpointConfig> endpointsConfig() {
        return this.endpointsConfig;
    }

    public final ImmutableNetworkingConfig withEndpointsConfig(Map<String, ? extends EndpointConfig> entries) {
        if (this.endpointsConfig == entries) {
            return this;
        }
        Map<String, EndpointConfig> newValue = ImmutableNetworkingConfig.createUnmodifiableMap(true, false, entries);
        return new ImmutableNetworkingConfig(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNetworkingConfig && this.equalTo(0, (ImmutableNetworkingConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableNetworkingConfig another) {
        return this.endpointsConfig.equals(another.endpointsConfig);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.endpointsConfig.hashCode();
        return h;
    }

    public String toString() {
        return "NetworkingConfig{endpointsConfig=" + String.valueOf(this.endpointsConfig) + "}";
    }

    public static ImmutableNetworkingConfig copyOf(NetworkingConfig instance) {
        if (instance instanceof ImmutableNetworkingConfig) {
            return (ImmutableNetworkingConfig)instance;
        }
        return ImmutableNetworkingConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder
    implements NetworkingConfig.Builder {
        private Map<String, EndpointConfig> endpointsConfig = new LinkedHashMap<String, EndpointConfig>();

        private Builder() {
        }

        public final Builder from(NetworkingConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllEndpointsConfig(instance.endpointsConfig());
            return this;
        }

        public final Builder addEndpointsConfig(String key, EndpointConfig value) {
            this.endpointsConfig.put(Objects.requireNonNull(key, "endpointsConfig key"), Objects.requireNonNull(value, value == null ? "endpointsConfig value for key: " + key : null));
            return this;
        }

        public final Builder addEndpointsConfig(Map.Entry<String, ? extends EndpointConfig> entry) {
            EndpointConfig v;
            String k = entry.getKey();
            this.endpointsConfig.put(Objects.requireNonNull(k, "endpointsConfig key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "endpointsConfig value for key: " + k : null));
            return this;
        }

        @Override
        @JsonProperty(value="EndpointsConfig")
        public final Builder endpointsConfig(Map<String, ? extends EndpointConfig> entries) {
            this.endpointsConfig.clear();
            return this.putAllEndpointsConfig(entries);
        }

        public final Builder putAllEndpointsConfig(Map<String, ? extends EndpointConfig> entries) {
            for (Map.Entry<String, ? extends EndpointConfig> e : entries.entrySet()) {
                EndpointConfig v;
                String k = e.getKey();
                this.endpointsConfig.put(Objects.requireNonNull(k, "endpointsConfig key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "endpointsConfig value for key: " + k : null));
            }
            return this;
        }

        @Override
        public ImmutableNetworkingConfig build() {
            return new ImmutableNetworkingConfig(ImmutableNetworkingConfig.createUnmodifiableMap(false, false, this.endpointsConfig));
        }
    }
}

