/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.eclipse.gemini.web.core.spi.ServletContainerException;
import org.osgi.framework.Bundle;

public class WebappConfigLocator {
    static final String DEFAULT_CONFIG_DIRECTORY = "config";
    private static final String DEFAULT_CONTEXT_XML = "context.xml";
    private static final String DEFAULT_WEB_XML = "web.xml";
    static final String CONTEXT_XML = "META-INF/context.xml";
    private static final String XML_EXTENSION = ".xml";
    private static final String ROOT_PATH = "/";
    private static final String ROOT_CONTEXT_FILE = "ROOT";
    private static final char SLASH_SEPARATOR = '/';
    private static final char HASH_SEPARATOR = '#';
    static final String JAR_SCHEMA = "jar:";
    static final String JAR_TO_ENTRY_SEPARATOR = "!/";
    static final String EMPTY_STRING = "";

    public static String resolveDefaultContextXml(File configLocation) {
        if (configLocation == null) {
            return null;
        }
        File defaultContextXml = new File(configLocation, DEFAULT_CONTEXT_XML);
        if (defaultContextXml.exists()) {
            return defaultContextXml.getAbsolutePath();
        }
        return null;
    }

    public static String resolveDefaultWebXml(File configLocation) {
        if (configLocation == null) {
            return null;
        }
        File defaultWebXml = new File(configLocation, DEFAULT_WEB_XML);
        if (defaultWebXml.exists()) {
            return defaultWebXml.getAbsolutePath();
        }
        return null;
    }

    public static URL resolveWebappContextXml(String path, String docBase, File configLocation, Bundle bundle) throws MalformedURLException {
        File contextXml = new File(configLocation, String.valueOf(path = WebappConfigLocator.formatContextPath(path)) + XML_EXTENSION);
        if (contextXml.exists()) {
            return contextXml.toURI().toURL();
        }
        if (EMPTY_STRING.equals(docBase)) {
            if (bundle != null) {
                return WebappConfigLocator.resolveWebappContextXmlFromJarURLConnection(bundle);
            }
            return null;
        }
        File docBaseFile = new File(docBase);
        if (docBaseFile.isDirectory()) {
            contextXml = new File(docBaseFile, CONTEXT_XML);
            if (contextXml.exists()) {
                return contextXml.toURI().toURL();
            }
        } else {
            JarFile jar;
            try {
                jar = new JarFile(docBaseFile);
            }
            catch (IOException e) {
                throw new ServletContainerException("Cannot open for reading " + docBaseFile.getAbsolutePath(), (Throwable)e);
            }
            ZipEntry contextXmlEntry = jar.getEntry(CONTEXT_XML);
            if (contextXmlEntry != null) {
                return new URL(JAR_SCHEMA + docBaseFile.toURI().toString() + JAR_TO_ENTRY_SEPARATOR + CONTEXT_XML);
            }
        }
        return null;
    }

    public static File resolveWebappConfigDir(File mainConfigDir, Host host) {
        File configLocation = mainConfigDir = mainConfigDir != null ? mainConfigDir : new File(DEFAULT_CONFIG_DIRECTORY);
        Container parent = host.getParent();
        if (parent != null && parent instanceof Engine) {
            configLocation = new File(configLocation, parent.getName());
        }
        return new File(configLocation, host.getName());
    }

    private static String formatContextPath(String contextPath) {
        if (contextPath.equals(ROOT_PATH)) {
            contextPath = ROOT_CONTEXT_FILE;
        } else if ('/' == contextPath.charAt(0)) {
            contextPath = contextPath.substring(1);
        }
        return contextPath.replace('/', '#');
    }

    /*
     * Loose catch block
     */
    private static URL resolveWebappContextXmlFromJarURLConnection(Bundle bundle) {
        ZipFile jarFile;
        block16: {
            URL uRL;
            block17: {
                URL bundleUrl;
                try {
                    bundleUrl = new URL(JAR_SCHEMA + bundle.getLocation() + JAR_TO_ENTRY_SEPARATOR + CONTEXT_XML);
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
                jarFile = null;
                URLConnection connection = bundleUrl.openConnection();
                if (!(connection instanceof JarURLConnection)) break block16;
                JarURLConnection jarURLConnection = (JarURLConnection)connection;
                jarURLConnection.setUseCaches(false);
                jarFile = jarURLConnection.getJarFile();
                String entryName = jarURLConnection.getEntryName();
                if (entryName == null || jarFile == null || ((JarFile)jarFile).getEntry(entryName) == null) break block16;
                uRL = bundleUrl;
                if (jarFile == null) break block17;
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
            return uRL;
            catch (IOException iOException) {
                block18: {
                    try {
                        if (jarFile == null) break block18;
                    }
                    catch (Throwable throwable) {
                        if (jarFile != null) {
                            try {
                                jarFile.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        throw throwable;
                    }
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException3) {}
                }
                return null;
            }
        }
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }
}

