/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Hexagon;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondWIP;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.style.ISkinParam;

public class FtileDiamond
extends FtileDiamondWIP {
    public FtileDiamond(ISkinParam skinParam, HColor backColor, HColor borderColor, Swimlane swimlane) {
        this(skinParam, backColor, borderColor, swimlane, TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0));
    }

    public FtileDiamond withNorth(TextBlock north) {
        return new FtileDiamond(this.skinParam(), this.backColor, this.borderColor, this.swimlane, north, this.south, this.east, this.west);
    }

    public FtileDiamond withWest(TextBlock west1) {
        if (west1 == null) {
            return this;
        }
        return new FtileDiamond(this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.north, this.south, this.east, west1);
    }

    public FtileDiamond withEast(TextBlock east1) {
        if (east1 == null) {
            return this;
        }
        return new FtileDiamond(this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.north, this.south, east1, this.west);
    }

    public FtileDiamond withSouth(TextBlock south) {
        return new FtileDiamond(this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.north, south, this.east, this.west);
    }

    private FtileDiamond(ISkinParam skinParam, HColor backColor, HColor borderColor, Swimlane swimlane, TextBlock north, TextBlock south, TextBlock east, TextBlock west) {
        super(null, skinParam, backColor, borderColor, swimlane, north, south, east, west);
    }

    @Override
    public void drawU(UGraphic ug) {
        double suppY1 = this.north.calculateDimension(ug.getStringBounder()).getHeight();
        ug = ug.apply(UTranslate.dy(suppY1));
        ug.apply(this.borderColor).apply(this.getThickness(this.getStyle())).apply(this.backColor.bg()).draw(Hexagon.asPolygon(this.shadowing));
        this.north.drawU(ug.apply(new UTranslate(18.0, -suppY1)));
        this.south.drawU(ug.apply(new UTranslate(18.0, 24.0)));
        XDimension2D dimWeat1 = this.west.calculateDimension(ug.getStringBounder());
        this.west.drawU(ug.apply(new UTranslate(-dimWeat1.getWidth(), -dimWeat1.getHeight() + 12.0)));
        XDimension2D dimEast1 = this.east.calculateDimension(ug.getStringBounder());
        this.east.drawU(ug.apply(new UTranslate(24.0, -dimEast1.getHeight() + 12.0)));
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        double suppY1 = this.north.calculateDimension(stringBounder).getHeight();
        XDimension2D dim = new XDimension2D(24.0, 24.0 + suppY1);
        return new FtileGeometry(dim, dim.getWidth() / 2.0, suppY1, dim.getHeight());
    }

    public Ftile withWestAndEast(TextBlock tb1, TextBlock tb2) {
        return this.withWest(tb1).withEast(tb2);
    }

    public double getWestEastLabelHeight(StringBounder stringBounder) {
        XDimension2D dimEast = this.east.calculateDimension(stringBounder);
        XDimension2D dimWest = this.west.calculateDimension(stringBounder);
        return Math.max(dimEast.getHeight(), dimWest.getHeight());
    }

    public double getEastLabelWidth(StringBounder stringBounder) {
        XDimension2D dimEast = this.east.calculateDimension(stringBounder);
        return dimEast.getWidth();
    }

    public double getSouthLabelHeight(StringBounder stringBounder) {
        XDimension2D dimSouth = this.south.calculateDimension(stringBounder);
        return dimSouth.getHeight();
    }
}

