/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.rrobot.impl.generators;

import com.google.common.base.Objects;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fx.ide.rrobot.model.bundle.Attribute;
import org.eclipse.fx.ide.rrobot.model.bundle.Element;
import org.eclipse.fx.ide.rrobot.model.bundle.Extension;
import org.eclipse.fx.ide.rrobot.model.bundle.PluginXMLFile;
import org.eclipse.fx.ide.rrobot.model.task.BooleanExpression;
import org.eclipse.fx.ide.rrobot.model.task.ExcludeableElementMixin;
import org.eclipse.fx.ide.rrobot.model.task.Generator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class PluginXMLGenerator
implements Generator<PluginXMLFile> {
    public InputStream generate(PluginXMLFile file, Map<String, Object> data) {
        CharSequence _generateContent = this.generateContent(file, data);
        String _string = _generateContent.toString();
        byte[] _bytes = _string.getBytes();
        ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_bytes);
        return _byteArrayInputStream;
    }

    public CharSequence generateContent(PluginXMLFile file, final Map<String, Object> data) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append((Object)"<?eclipse version=\"3.0\"?>");
        _builder.newLine();
        _builder.append((Object)"<plugin>");
        _builder.newLine();
        EList _extensions = file.getExtensions();
        Functions.Function1<Extension, Boolean> _function = new Functions.Function1<Extension, Boolean>(){

            public Boolean apply(Extension e) {
                boolean _excludeExpression = PluginXMLGenerator.this.excludeExpression((ExcludeableElementMixin)e, data);
                return _excludeExpression;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_extensions, (Functions.Function1)_function);
        for (Extension ext : _filter) {
            boolean _notEquals;
            _builder.append((Object)"<extension ");
            String _id = ext.getId();
            boolean bl = _notEquals = !Objects.equal((Object)_id, null);
            if (_notEquals) {
                _builder.append((Object)"id=\"");
                String _id_1 = ext.getId();
                _builder.append((Object)_id_1, "");
                _builder.append((Object)"\"");
            }
            _builder.append((Object)" point=\"");
            String _point = ext.getPoint();
            _builder.append((Object)_point, "");
            _builder.append((Object)"\">");
            _builder.newLineIfNotEmpty();
            EList _elements = ext.getElements();
            for (Element el : _elements) {
                _builder.append((Object)"\t");
                CharSequence _elementBuilder = this.elementBuilder(el);
                _builder.append((Object)_elementBuilder, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"</extension>");
            _builder.newLine();
        }
        _builder.append((Object)"</plugin>");
        _builder.newLine();
        return _builder;
    }

    public boolean excludeExpression(ExcludeableElementMixin mixin, Map<String, Object> data) {
        boolean _notEquals;
        BooleanExpression _excludeExpression = mixin.getExcludeExpression();
        boolean bl = _notEquals = !Objects.equal((Object)_excludeExpression, null);
        if (_notEquals) {
            BooleanExpression _excludeExpression_1 = mixin.getExcludeExpression();
            boolean _execute = _excludeExpression_1.execute(data);
            return !_execute;
        }
        return true;
    }

    public CharSequence elementBuilder(Element el) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<");
        String _name = el.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" ");
        EList _attributes = el.getAttributes();
        Functions.Function1<Attribute, String> _function = new Functions.Function1<Attribute, String>(){

            public String apply(Attribute a) {
                String _name = a.getName();
                String _plus = String.valueOf(_name) + "=\"";
                String _value = a.getValue();
                String _plus_1 = String.valueOf(_plus) + _value;
                String _plus_2 = String.valueOf(_plus_1) + "\"";
                return _plus_2;
            }
        };
        List _map = ListExtensions.map((List)_attributes, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)" ");
        _builder.append((Object)_join, "");
        _builder.append((Object)" ");
        EList _children = el.getChildren();
        boolean _isEmpty = _children.isEmpty();
        if (_isEmpty) {
            _builder.append((Object)"/");
        }
        _builder.append((Object)">");
        _builder.newLineIfNotEmpty();
        EList _children_1 = el.getChildren();
        boolean _isEmpty_1 = _children_1.isEmpty();
        boolean bl = _not = !_isEmpty_1;
        if (_not) {
            EList _children_2 = el.getChildren();
            for (Element c : _children_2) {
                _builder.append((Object)"\t");
                CharSequence _elementBuilder = this.elementBuilder(c);
                _builder.append((Object)_elementBuilder, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"</");
            String _name_1 = el.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)">");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        return _builder;
    }
}

