/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.utils.installer;

import java.io.File;
import java.io.IOException;

class Node {
    String m_rootPath;
    String m_rootDirName;
    String m_fileAbsolutePath;
    String m_fileCanonicalPath;
    static final String m_fs = System.getProperty("file.separator");

    private Node() {
    }

    public Node(String string, File file) throws IOException, IllegalArgumentException {
        this.m_rootPath = string;
        this.m_rootDirName = new File(string).getName();
        this.m_fileAbsolutePath = file.getAbsolutePath();
        this.m_fileCanonicalPath = file.getCanonicalPath();
        if (!this.m_rootPath.endsWith(m_fs)) {
            this.m_rootPath = this.m_rootPath + m_fs;
        }
        if (!new File(this.m_rootPath).isDirectory()) {
            throw new IllegalArgumentException("The root path value is not a directory");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException(file.getCanonicalPath() + " is not a file.");
        }
        if (file.getAbsolutePath().indexOf(this.m_rootPath) != 0) {
            throw new IllegalStateException(this.m_fileAbsolutePath + " does not appear to be a child of " + this.m_rootPath);
        }
    }

    public String getRootPath() {
        return this.m_rootPath;
    }

    public File getFile() {
        return new File(this.m_fileAbsolutePath);
    }

    public String getAbsolutePath() {
        return this.m_fileAbsolutePath;
    }

    public String getCanonicalPath() throws IOException {
        return this.m_fileCanonicalPath;
    }

    public boolean equals(Node node) throws IOException {
        return this.m_fileCanonicalPath.equals(node.getCanonicalPath());
    }

    public String getRelativePath() throws IllegalStateException {
        return this.m_rootDirName + m_fs + this.m_fileAbsolutePath.substring(this.m_rootPath.length());
    }
}

