/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.beanvalidation.tck.tests.validation.ExecutiveProducer;
import org.hibernate.beanvalidation.tck.tests.validation.Location;

public class MovieProduction {
    private Map<@NotBlank String, @Valid @NotNull Location> locationsByScene = new HashMap<String, Location>();
    private List<@Valid ExecutiveProducer> executiveProducers = new ArrayList<ExecutiveProducer>();

    private MovieProduction() {
    }

    public Map<String, Location> getLocationsByScene() {
        return this.locationsByScene;
    }

    public static MovieProduction invalidMapKey() {
        MovieProduction production = new MovieProduction();
        production.locationsByScene.put("", new Location("Parc de la T\u00eate d'Or", "Lyon", "69006"));
        return production;
    }

    public static MovieProduction invalidCascading() {
        MovieProduction production = new MovieProduction();
        production.locationsByScene.put("Scene 1", new Location("Parc de la T\u00eate d'Or", "Lyon", null));
        return production;
    }

    public static MovieProduction invalidExecutiveProducer() {
        MovieProduction production = new MovieProduction();
        production.executiveProducers.add(new ExecutiveProducer("", ""));
        return production;
    }
}

