/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.parameter;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.datatools.sqltools.routineeditor.launching.LaunchHelper;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;

public class LaunchConfigurationParamsHistoryListener
implements ILaunchConfigurationListener {
    private static LaunchConfigurationParamsHistoryListener instance = null;
    private String _configDir = EditorCorePlugin.getDefault().getStateLocation().append("params_config").toOSString();
    private ILaunchConfiguration _moveFrom;

    private LaunchConfigurationParamsHistoryListener() {
        File dir = new File(this._configDir);
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    public static synchronized LaunchConfigurationParamsHistoryListener getInstance() {
        if (instance == null) {
            instance = new LaunchConfigurationParamsHistoryListener();
        }
        return instance;
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        try {
            if (configuration.getType() == LaunchHelper.getLaunchConfigType() && this._moveFrom != null) {
                File configDir = new File(String.valueOf(this._configDir) + File.separator + this._moveFrom.getName());
                File configDirNew = new File(String.valueOf(this._configDir) + File.separator + configuration.getName());
                configDir.renameTo(configDirNew);
                this._moveFrom = null;
            }
        }
        catch (CoreException ce) {
            RoutineEditorActivator.getDefault().log(ce);
        }
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        if (DebugPlugin.getDefault().getLaunchManager().getMovedTo(configuration) == null) {
            File configDir = new File(String.valueOf(this._configDir) + File.separator + configuration.getName());
            if (configDir.exists() && configDir.isDirectory()) {
                File[] fileArray = configDir.listFiles();
                int i = 0;
                while (i < fileArray.length) {
                    fileArray[i].delete();
                    ++i;
                }
                configDir.delete();
            }
        } else {
            this._moveFrom = configuration;
        }
    }

    private ArrayList readExistingConfigurations(ILaunchConfiguration configuration) {
        ArrayList<String> configs = new ArrayList<String>();
        try {
            int configNum = configuration.getAttribute("org.eclipse.datatools.sqltools.debug.launching.configuration.number", -1);
            if (configNum == -1) {
                return configs;
            }
            int i = 1;
            while (i < configNum + 1) {
                String configName = configuration.getAttribute("org.eclipse.datatools.sqltools.debug.launching.configuration" + i, null);
                if (configName != null) {
                    configs.add(configName);
                }
                ++i;
            }
        }
        catch (CoreException ce) {
            RoutineEditorActivator.getDefault().log(ce);
        }
        return configs;
    }
}

