"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
class Message {
    constructor(type) {
        this.seq = 0;
        this.type = type;
    }
}
exports.Message = Message;
class Response extends Message {
    constructor(request, message) {
        super('response');
        this.request_seq = request.seq;
        this.command = request.command;
        if (message) {
            this.success = false;
            this.message = message;
        }
        else {
            this.success = true;
        }
    }
}
exports.Response = Response;
class Event extends Message {
    constructor(event, body) {
        super('event');
        this.event = event;
        if (body) {
            this.body = body;
        }
    }
}
exports.Event = Event;
//# sourceMappingURL=data:application/json;base64,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