/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dartboard.pub;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.dartboard.Messages;
import org.eclipse.dartboard.util.PubUtil;
import org.eclipse.dartboard.util.StatusUtil;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.component.annotations.Component;

@Component(service={PubService.class})
public class PubService {
    private static final ILog LOG = Platform.getLog(PubService.class);
    private Map<IProject, Job> pubGetJobs = new HashMap<IProject, Job>();

    public void get(final IProject project, boolean offline) {
        Job active = this.pubGetJobs.get(project);
        if (active != null) {
            active.cancel();
            this.pubGetJobs.remove(project);
        }
        Job pubSync = Job.create((String)NLS.bind((String)Messages.PubSync_Job_Name, (Object)project.getName()), monitor -> {
            IPath location = project.getLocation();
            if (location == null) {
                return StatusUtil.createError(NLS.bind((String)Messages.PubSync_CouldNotDeterminePath, (Object)project.getName()));
            }
            ProcessBuilder builder = PubUtil.getPubProcessBuilder("get", offline ? "--offline" : "--no-offline").directory(location.makeAbsolute().toFile());
            Process process = null;
            try {
                process = builder.start();
            }
            catch (IOException exception) {
                return StatusUtil.createError(Messages.PubSync_CouldNotStartProcess, exception);
            }
            try {
                Throwable exception = null;
                Object var7_10 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String taskName;
                    SubMonitor mo = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    while ((taskName = reader.readLine()) != null) {
                        if (!taskName.equalsIgnoreCase(Messages.PubSync_Task_ResolvingDependencies) && !taskName.equalsIgnoreCase(Messages.PubSync_Task_PrecompilingExecutables)) continue;
                        mo.split(50);
                        mo.setTaskName(taskName);
                    }
                }
                catch (Throwable throwable) {
                    if (exception == null) {
                        exception = throwable;
                    } else if (exception != throwable) {
                        exception.addSuppressed(throwable);
                    }
                    throw exception;
                }
            }
            catch (IOException exception) {
                return StatusUtil.createError(Messages.PubSync_CouldNotStartProcess, exception);
            }
            return Status.OK_STATUS;
        });
        pubSync.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                PubService.this.pubGetJobs.remove(project);
                IStatus result = event.getResult();
                if (result.isOK() || result.getCode() == 8) {
                    try {
                        project.refreshLocal(2, null);
                    }
                    catch (CoreException exception) {
                        LOG.log(StatusUtil.createError(NLS.bind((String)Messages.Error_CouldNotRefreshResource, (Object)project.getName()), exception));
                    }
                }
            }
        });
        pubSync.setPriority(30);
        pubSync.setUser(true);
        pubSync.schedule(1000L);
        this.pubGetJobs.put(project, pubSync);
    }
}

