/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"@(#)mlib_v_ImageBlendTable.c	9.3	07/11/05 SMI"

/*
 * Tables mlib_c_blend_Q8 and mlib_c_blend_u8_sat
 *
 * DESCRIPTION
 *   mlib_v_blend_ARGB
 *   mlib_v_blend_RGBA
 *   mlib_v_blend_alpha
 *   mlib_v_blend_alpha_f32
 *
 *  COMMENTS
 *    These tables are used by VIS version of the blend functions.
 */

#include <mlib_types.h>
#include <mlib_v_ImageBlendTable.h>

/* *********************************************************** */

#pragma align 8(mlib_table_blend_alpha_s32)

const mlib_s32 mlib_table_blend_alpha_s32[] = {
	0x00000000, 0x00000000, 0x00100010, 0x00100010,
	0x00200020, 0x00200020, 0x00300030, 0x00300030,
	0x00400040, 0x00400040, 0x00500050, 0x00500050,
	0x00600060, 0x00600060, 0x00700070, 0x00700070,
	0x00800080, 0x00800080, 0x00900090, 0x00900090,
	0x00a000a0, 0x00a000a0, 0x00b000b0, 0x00b000b0,
	0x00c000c0, 0x00c000c0, 0x00d000d0, 0x00d000d0,
	0x00e000e0, 0x00e000e0, 0x00f000f0, 0x00f000f0,
	0x01000100, 0x01000100, 0x01100110, 0x01100110,
	0x01200120, 0x01200120, 0x01300130, 0x01300130,
	0x01400140, 0x01400140, 0x01500150, 0x01500150,
	0x01600160, 0x01600160, 0x01700170, 0x01700170,
	0x01800180, 0x01800180, 0x01900190, 0x01900190,
	0x01a001a0, 0x01a001a0, 0x01b001b0, 0x01b001b0,
	0x01c001c0, 0x01c001c0, 0x01d001d0, 0x01d001d0,
	0x01e001e0, 0x01e001e0, 0x01f001f0, 0x01f001f0,
	0x02000200, 0x02000200, 0x02100210, 0x02100210,
	0x02200220, 0x02200220, 0x02300230, 0x02300230,
	0x02400240, 0x02400240, 0x02500250, 0x02500250,
	0x02600260, 0x02600260, 0x02700270, 0x02700270,
	0x02800280, 0x02800280, 0x02900290, 0x02900290,
	0x02a002a0, 0x02a002a0, 0x02b002b0, 0x02b002b0,
	0x02c002c0, 0x02c002c0, 0x02d002d0, 0x02d002d0,
	0x02e002e0, 0x02e002e0, 0x02f002f0, 0x02f002f0,
	0x03000300, 0x03000300, 0x03100310, 0x03100310,
	0x03200320, 0x03200320, 0x03300330, 0x03300330,
	0x03400340, 0x03400340, 0x03500350, 0x03500350,
	0x03600360, 0x03600360, 0x03700370, 0x03700370,
	0x03800380, 0x03800380, 0x03900390, 0x03900390,
	0x03a003a0, 0x03a003a0, 0x03b003b0, 0x03b003b0,
	0x03c003c0, 0x03c003c0, 0x03d003d0, 0x03d003d0,
	0x03e003e0, 0x03e003e0, 0x03f003f0, 0x03f003f0,
	0x04000400, 0x04000400, 0x04100410, 0x04100410,
	0x04200420, 0x04200420, 0x04300430, 0x04300430,
	0x04400440, 0x04400440, 0x04500450, 0x04500450,
	0x04600460, 0x04600460, 0x04700470, 0x04700470,
	0x04800480, 0x04800480, 0x04900490, 0x04900490,
	0x04a004a0, 0x04a004a0, 0x04b004b0, 0x04b004b0,
	0x04c004c0, 0x04c004c0, 0x04d004d0, 0x04d004d0,
	0x04e004e0, 0x04e004e0, 0x04f004f0, 0x04f004f0,
	0x05000500, 0x05000500, 0x05100510, 0x05100510,
	0x05200520, 0x05200520, 0x05300530, 0x05300530,
	0x05400540, 0x05400540, 0x05500550, 0x05500550,
	0x05600560, 0x05600560, 0x05700570, 0x05700570,
	0x05800580, 0x05800580, 0x05900590, 0x05900590,
	0x05a005a0, 0x05a005a0, 0x05b005b0, 0x05b005b0,
	0x05c005c0, 0x05c005c0, 0x05d005d0, 0x05d005d0,
	0x05e005e0, 0x05e005e0, 0x05f005f0, 0x05f005f0,
	0x06000600, 0x06000600, 0x06100610, 0x06100610,
	0x06200620, 0x06200620, 0x06300630, 0x06300630,
	0x06400640, 0x06400640, 0x06500650, 0x06500650,
	0x06600660, 0x06600660, 0x06700670, 0x06700670,
	0x06800680, 0x06800680, 0x06900690, 0x06900690,
	0x06a006a0, 0x06a006a0, 0x06b006b0, 0x06b006b0,
	0x06c006c0, 0x06c006c0, 0x06d006d0, 0x06d006d0,
	0x06e006e0, 0x06e006e0, 0x06f006f0, 0x06f006f0,
	0x07000700, 0x07000700, 0x07100710, 0x07100710,
	0x07200720, 0x07200720, 0x07300730, 0x07300730,
	0x07400740, 0x07400740, 0x07500750, 0x07500750,
	0x07600760, 0x07600760, 0x07700770, 0x07700770,
	0x07800780, 0x07800780, 0x07900790, 0x07900790,
	0x07a007a0, 0x07a007a0, 0x07b007b0, 0x07b007b0,
	0x07c007c0, 0x07c007c0, 0x07d007d0, 0x07d007d0,
	0x07e007e0, 0x07e007e0, 0x07f007f0, 0x07f007f0,
	0x08000800, 0x08000800, 0x08100810, 0x08100810,
	0x08200820, 0x08200820, 0x08300830, 0x08300830,
	0x08400840, 0x08400840, 0x08500850, 0x08500850,
	0x08600860, 0x08600860, 0x08700870, 0x08700870,
	0x08800880, 0x08800880, 0x08900890, 0x08900890,
	0x08a008a0, 0x08a008a0, 0x08b008b0, 0x08b008b0,
	0x08c008c0, 0x08c008c0, 0x08d008d0, 0x08d008d0,
	0x08e008e0, 0x08e008e0, 0x08f008f0, 0x08f008f0,
	0x09000900, 0x09000900, 0x09100910, 0x09100910,
	0x09200920, 0x09200920, 0x09300930, 0x09300930,
	0x09400940, 0x09400940, 0x09500950, 0x09500950,
	0x09600960, 0x09600960, 0x09700970, 0x09700970,
	0x09800980, 0x09800980, 0x09900990, 0x09900990,
	0x09a009a0, 0x09a009a0, 0x09b009b0, 0x09b009b0,
	0x09c009c0, 0x09c009c0, 0x09d009d0, 0x09d009d0,
	0x09e009e0, 0x09e009e0, 0x09f009f0, 0x09f009f0,
	0x0a000a00, 0x0a000a00, 0x0a100a10, 0x0a100a10,
	0x0a200a20, 0x0a200a20, 0x0a300a30, 0x0a300a30,
	0x0a400a40, 0x0a400a40, 0x0a500a50, 0x0a500a50,
	0x0a600a60, 0x0a600a60, 0x0a700a70, 0x0a700a70,
	0x0a800a80, 0x0a800a80, 0x0a900a90, 0x0a900a90,
	0x0aa00aa0, 0x0aa00aa0, 0x0ab00ab0, 0x0ab00ab0,
	0x0ac00ac0, 0x0ac00ac0, 0x0ad00ad0, 0x0ad00ad0,
	0x0ae00ae0, 0x0ae00ae0, 0x0af00af0, 0x0af00af0,
	0x0b000b00, 0x0b000b00, 0x0b100b10, 0x0b100b10,
	0x0b200b20, 0x0b200b20, 0x0b300b30, 0x0b300b30,
	0x0b400b40, 0x0b400b40, 0x0b500b50, 0x0b500b50,
	0x0b600b60, 0x0b600b60, 0x0b700b70, 0x0b700b70,
	0x0b800b80, 0x0b800b80, 0x0b900b90, 0x0b900b90,
	0x0ba00ba0, 0x0ba00ba0, 0x0bb00bb0, 0x0bb00bb0,
	0x0bc00bc0, 0x0bc00bc0, 0x0bd00bd0, 0x0bd00bd0,
	0x0be00be0, 0x0be00be0, 0x0bf00bf0, 0x0bf00bf0,
	0x0c000c00, 0x0c000c00, 0x0c100c10, 0x0c100c10,
	0x0c200c20, 0x0c200c20, 0x0c300c30, 0x0c300c30,
	0x0c400c40, 0x0c400c40, 0x0c500c50, 0x0c500c50,
	0x0c600c60, 0x0c600c60, 0x0c700c70, 0x0c700c70,
	0x0c800c80, 0x0c800c80, 0x0c900c90, 0x0c900c90,
	0x0ca00ca0, 0x0ca00ca0, 0x0cb00cb0, 0x0cb00cb0,
	0x0cc00cc0, 0x0cc00cc0, 0x0cd00cd0, 0x0cd00cd0,
	0x0ce00ce0, 0x0ce00ce0, 0x0cf00cf0, 0x0cf00cf0,
	0x0d000d00, 0x0d000d00, 0x0d100d10, 0x0d100d10,
	0x0d200d20, 0x0d200d20, 0x0d300d30, 0x0d300d30,
	0x0d400d40, 0x0d400d40, 0x0d500d50, 0x0d500d50,
	0x0d600d60, 0x0d600d60, 0x0d700d70, 0x0d700d70,
	0x0d800d80, 0x0d800d80, 0x0d900d90, 0x0d900d90,
	0x0da00da0, 0x0da00da0, 0x0db00db0, 0x0db00db0,
	0x0dc00dc0, 0x0dc00dc0, 0x0dd00dd0, 0x0dd00dd0,
	0x0de00de0, 0x0de00de0, 0x0df00df0, 0x0df00df0,
	0x0e000e00, 0x0e000e00, 0x0e100e10, 0x0e100e10,
	0x0e200e20, 0x0e200e20, 0x0e300e30, 0x0e300e30,
	0x0e400e40, 0x0e400e40, 0x0e500e50, 0x0e500e50,
	0x0e600e60, 0x0e600e60, 0x0e700e70, 0x0e700e70,
	0x0e800e80, 0x0e800e80, 0x0e900e90, 0x0e900e90,
	0x0ea00ea0, 0x0ea00ea0, 0x0eb00eb0, 0x0eb00eb0,
	0x0ec00ec0, 0x0ec00ec0, 0x0ed00ed0, 0x0ed00ed0,
	0x0ee00ee0, 0x0ee00ee0, 0x0ef00ef0, 0x0ef00ef0,
	0x0f000f00, 0x0f000f00, 0x0f100f10, 0x0f100f10,
	0x0f200f20, 0x0f200f20, 0x0f300f30, 0x0f300f30,
	0x0f400f40, 0x0f400f40, 0x0f500f50, 0x0f500f50,
	0x0f600f60, 0x0f600f60, 0x0f700f70, 0x0f700f70,
	0x0f800f80, 0x0f800f80, 0x0f900f90, 0x0f900f90,
	0x0fa00fa0, 0x0fa00fa0, 0x0fb00fb0, 0x0fb00fb0,
	0x0fc00fc0, 0x0fc00fc0, 0x0fd00fd0, 0x0fd00fd0,
	0x0fe00fe0, 0x0fe00fe0, 0x0ff00ff0, 0x0ff00ff0,
	0x10001000, 0x10001000
};

/* *********************************************************** */

#pragma align 8(mlib_table_blend_RGBA_s32)
const mlib_s32 mlib_table_blend_RGBA_s32[] = {
	0x00000000, 0x00001000, 0x00100010, 0x00101000,
	0x00200020, 0x00201000, 0x00300030, 0x00301000,
	0x00400040, 0x00401000, 0x00500050, 0x00501000,
	0x00600060, 0x00601000, 0x00700070, 0x00701000,
	0x00800080, 0x00801000, 0x00900090, 0x00901000,
	0x00a000a0, 0x00a01000, 0x00b000b0, 0x00b01000,
	0x00c000c0, 0x00c01000, 0x00d000d0, 0x00d01000,
	0x00e000e0, 0x00e01000, 0x00f000f0, 0x00f01000,
	0x01000100, 0x01001000, 0x01100110, 0x01101000,
	0x01200120, 0x01201000, 0x01300130, 0x01301000,
	0x01400140, 0x01401000, 0x01500150, 0x01501000,
	0x01600160, 0x01601000, 0x01700170, 0x01701000,
	0x01800180, 0x01801000, 0x01900190, 0x01901000,
	0x01a001a0, 0x01a01000, 0x01b001b0, 0x01b01000,
	0x01c001c0, 0x01c01000, 0x01d001d0, 0x01d01000,
	0x01e001e0, 0x01e01000, 0x01f001f0, 0x01f01000,
	0x02000200, 0x02001000, 0x02100210, 0x02101000,
	0x02200220, 0x02201000, 0x02300230, 0x02301000,
	0x02400240, 0x02401000, 0x02500250, 0x02501000,
	0x02600260, 0x02601000, 0x02700270, 0x02701000,
	0x02800280, 0x02801000, 0x02900290, 0x02901000,
	0x02a002a0, 0x02a01000, 0x02b002b0, 0x02b01000,
	0x02c002c0, 0x02c01000, 0x02d002d0, 0x02d01000,
	0x02e002e0, 0x02e01000, 0x02f002f0, 0x02f01000,
	0x03000300, 0x03001000, 0x03100310, 0x03101000,
	0x03200320, 0x03201000, 0x03300330, 0x03301000,
	0x03400340, 0x03401000, 0x03500350, 0x03501000,
	0x03600360, 0x03601000, 0x03700370, 0x03701000,
	0x03800380, 0x03801000, 0x03900390, 0x03901000,
	0x03a003a0, 0x03a01000, 0x03b003b0, 0x03b01000,
	0x03c003c0, 0x03c01000, 0x03d003d0, 0x03d01000,
	0x03e003e0, 0x03e01000, 0x03f003f0, 0x03f01000,
	0x04000400, 0x04001000, 0x04100410, 0x04101000,
	0x04200420, 0x04201000, 0x04300430, 0x04301000,
	0x04400440, 0x04401000, 0x04500450, 0x04501000,
	0x04600460, 0x04601000, 0x04700470, 0x04701000,
	0x04800480, 0x04801000, 0x04900490, 0x04901000,
	0x04a004a0, 0x04a01000, 0x04b004b0, 0x04b01000,
	0x04c004c0, 0x04c01000, 0x04d004d0, 0x04d01000,
	0x04e004e0, 0x04e01000, 0x04f004f0, 0x04f01000,
	0x05000500, 0x05001000, 0x05100510, 0x05101000,
	0x05200520, 0x05201000, 0x05300530, 0x05301000,
	0x05400540, 0x05401000, 0x05500550, 0x05501000,
	0x05600560, 0x05601000, 0x05700570, 0x05701000,
	0x05800580, 0x05801000, 0x05900590, 0x05901000,
	0x05a005a0, 0x05a01000, 0x05b005b0, 0x05b01000,
	0x05c005c0, 0x05c01000, 0x05d005d0, 0x05d01000,
	0x05e005e0, 0x05e01000, 0x05f005f0, 0x05f01000,
	0x06000600, 0x06001000, 0x06100610, 0x06101000,
	0x06200620, 0x06201000, 0x06300630, 0x06301000,
	0x06400640, 0x06401000, 0x06500650, 0x06501000,
	0x06600660, 0x06601000, 0x06700670, 0x06701000,
	0x06800680, 0x06801000, 0x06900690, 0x06901000,
	0x06a006a0, 0x06a01000, 0x06b006b0, 0x06b01000,
	0x06c006c0, 0x06c01000, 0x06d006d0, 0x06d01000,
	0x06e006e0, 0x06e01000, 0x06f006f0, 0x06f01000,
	0x07000700, 0x07001000, 0x07100710, 0x07101000,
	0x07200720, 0x07201000, 0x07300730, 0x07301000,
	0x07400740, 0x07401000, 0x07500750, 0x07501000,
	0x07600760, 0x07601000, 0x07700770, 0x07701000,
	0x07800780, 0x07801000, 0x07900790, 0x07901000,
	0x07a007a0, 0x07a01000, 0x07b007b0, 0x07b01000,
	0x07c007c0, 0x07c01000, 0x07d007d0, 0x07d01000,
	0x07e007e0, 0x07e01000, 0x07f007f0, 0x07f01000,
	0x08000800, 0x08001000, 0x08100810, 0x08101000,
	0x08200820, 0x08201000, 0x08300830, 0x08301000,
	0x08400840, 0x08401000, 0x08500850, 0x08501000,
	0x08600860, 0x08601000, 0x08700870, 0x08701000,
	0x08800880, 0x08801000, 0x08900890, 0x08901000,
	0x08a008a0, 0x08a01000, 0x08b008b0, 0x08b01000,
	0x08c008c0, 0x08c01000, 0x08d008d0, 0x08d01000,
	0x08e008e0, 0x08e01000, 0x08f008f0, 0x08f01000,
	0x09000900, 0x09001000, 0x09100910, 0x09101000,
	0x09200920, 0x09201000, 0x09300930, 0x09301000,
	0x09400940, 0x09401000, 0x09500950, 0x09501000,
	0x09600960, 0x09601000, 0x09700970, 0x09701000,
	0x09800980, 0x09801000, 0x09900990, 0x09901000,
	0x09a009a0, 0x09a01000, 0x09b009b0, 0x09b01000,
	0x09c009c0, 0x09c01000, 0x09d009d0, 0x09d01000,
	0x09e009e0, 0x09e01000, 0x09f009f0, 0x09f01000,
	0x0a000a00, 0x0a001000, 0x0a100a10, 0x0a101000,
	0x0a200a20, 0x0a201000, 0x0a300a30, 0x0a301000,
	0x0a400a40, 0x0a401000, 0x0a500a50, 0x0a501000,
	0x0a600a60, 0x0a601000, 0x0a700a70, 0x0a701000,
	0x0a800a80, 0x0a801000, 0x0a900a90, 0x0a901000,
	0x0aa00aa0, 0x0aa01000, 0x0ab00ab0, 0x0ab01000,
	0x0ac00ac0, 0x0ac01000, 0x0ad00ad0, 0x0ad01000,
	0x0ae00ae0, 0x0ae01000, 0x0af00af0, 0x0af01000,
	0x0b000b00, 0x0b001000, 0x0b100b10, 0x0b101000,
	0x0b200b20, 0x0b201000, 0x0b300b30, 0x0b301000,
	0x0b400b40, 0x0b401000, 0x0b500b50, 0x0b501000,
	0x0b600b60, 0x0b601000, 0x0b700b70, 0x0b701000,
	0x0b800b80, 0x0b801000, 0x0b900b90, 0x0b901000,
	0x0ba00ba0, 0x0ba01000, 0x0bb00bb0, 0x0bb01000,
	0x0bc00bc0, 0x0bc01000, 0x0bd00bd0, 0x0bd01000,
	0x0be00be0, 0x0be01000, 0x0bf00bf0, 0x0bf01000,
	0x0c000c00, 0x0c001000, 0x0c100c10, 0x0c101000,
	0x0c200c20, 0x0c201000, 0x0c300c30, 0x0c301000,
	0x0c400c40, 0x0c401000, 0x0c500c50, 0x0c501000,
	0x0c600c60, 0x0c601000, 0x0c700c70, 0x0c701000,
	0x0c800c80, 0x0c801000, 0x0c900c90, 0x0c901000,
	0x0ca00ca0, 0x0ca01000, 0x0cb00cb0, 0x0cb01000,
	0x0cc00cc0, 0x0cc01000, 0x0cd00cd0, 0x0cd01000,
	0x0ce00ce0, 0x0ce01000, 0x0cf00cf0, 0x0cf01000,
	0x0d000d00, 0x0d001000, 0x0d100d10, 0x0d101000,
	0x0d200d20, 0x0d201000, 0x0d300d30, 0x0d301000,
	0x0d400d40, 0x0d401000, 0x0d500d50, 0x0d501000,
	0x0d600d60, 0x0d601000, 0x0d700d70, 0x0d701000,
	0x0d800d80, 0x0d801000, 0x0d900d90, 0x0d901000,
	0x0da00da0, 0x0da01000, 0x0db00db0, 0x0db01000,
	0x0dc00dc0, 0x0dc01000, 0x0dd00dd0, 0x0dd01000,
	0x0de00de0, 0x0de01000, 0x0df00df0, 0x0df01000,
	0x0e000e00, 0x0e001000, 0x0e100e10, 0x0e101000,
	0x0e200e20, 0x0e201000, 0x0e300e30, 0x0e301000,
	0x0e400e40, 0x0e401000, 0x0e500e50, 0x0e501000,
	0x0e600e60, 0x0e601000, 0x0e700e70, 0x0e701000,
	0x0e800e80, 0x0e801000, 0x0e900e90, 0x0e901000,
	0x0ea00ea0, 0x0ea01000, 0x0eb00eb0, 0x0eb01000,
	0x0ec00ec0, 0x0ec01000, 0x0ed00ed0, 0x0ed01000,
	0x0ee00ee0, 0x0ee01000, 0x0ef00ef0, 0x0ef01000,
	0x0f000f00, 0x0f001000, 0x0f100f10, 0x0f101000,
	0x0f200f20, 0x0f201000, 0x0f300f30, 0x0f301000,
	0x0f400f40, 0x0f401000, 0x0f500f50, 0x0f501000,
	0x0f600f60, 0x0f601000, 0x0f700f70, 0x0f701000,
	0x0f800f80, 0x0f801000, 0x0f900f90, 0x0f901000,
	0x0fa00fa0, 0x0fa01000, 0x0fb00fb0, 0x0fb01000,
	0x0fc00fc0, 0x0fc01000, 0x0fd00fd0, 0x0fd01000,
	0x0fe00fe0, 0x0fe01000, 0x0ff00ff0, 0x0ff01000,
	0x10001000, 0x10001000
};

/* *********************************************************** */

#pragma align 8(mlib_table_blend_ARGB_s32)
const mlib_s32 mlib_table_blend_ARGB_s32[] = {
	0x10000000, 0x00000000, 0x10000010, 0x00100010,
	0x10000020, 0x00200020, 0x10000030, 0x00300030,
	0x10000040, 0x00400040, 0x10000050, 0x00500050,
	0x10000060, 0x00600060, 0x10000070, 0x00700070,
	0x10000080, 0x00800080, 0x10000090, 0x00900090,
	0x100000a0, 0x00a000a0, 0x100000b0, 0x00b000b0,
	0x100000c0, 0x00c000c0, 0x100000d0, 0x00d000d0,
	0x100000e0, 0x00e000e0, 0x100000f0, 0x00f000f0,
	0x10000100, 0x01000100, 0x10000110, 0x01100110,
	0x10000120, 0x01200120, 0x10000130, 0x01300130,
	0x10000140, 0x01400140, 0x10000150, 0x01500150,
	0x10000160, 0x01600160, 0x10000170, 0x01700170,
	0x10000180, 0x01800180, 0x10000190, 0x01900190,
	0x100001a0, 0x01a001a0, 0x100001b0, 0x01b001b0,
	0x100001c0, 0x01c001c0, 0x100001d0, 0x01d001d0,
	0x100001e0, 0x01e001e0, 0x100001f0, 0x01f001f0,
	0x10000200, 0x02000200, 0x10000210, 0x02100210,
	0x10000220, 0x02200220, 0x10000230, 0x02300230,
	0x10000240, 0x02400240, 0x10000250, 0x02500250,
	0x10000260, 0x02600260, 0x10000270, 0x02700270,
	0x10000280, 0x02800280, 0x10000290, 0x02900290,
	0x100002a0, 0x02a002a0, 0x100002b0, 0x02b002b0,
	0x100002c0, 0x02c002c0, 0x100002d0, 0x02d002d0,
	0x100002e0, 0x02e002e0, 0x100002f0, 0x02f002f0,
	0x10000300, 0x03000300, 0x10000310, 0x03100310,
	0x10000320, 0x03200320, 0x10000330, 0x03300330,
	0x10000340, 0x03400340, 0x10000350, 0x03500350,
	0x10000360, 0x03600360, 0x10000370, 0x03700370,
	0x10000380, 0x03800380, 0x10000390, 0x03900390,
	0x100003a0, 0x03a003a0, 0x100003b0, 0x03b003b0,
	0x100003c0, 0x03c003c0, 0x100003d0, 0x03d003d0,
	0x100003e0, 0x03e003e0, 0x100003f0, 0x03f003f0,
	0x10000400, 0x04000400, 0x10000410, 0x04100410,
	0x10000420, 0x04200420, 0x10000430, 0x04300430,
	0x10000440, 0x04400440, 0x10000450, 0x04500450,
	0x10000460, 0x04600460, 0x10000470, 0x04700470,
	0x10000480, 0x04800480, 0x10000490, 0x04900490,
	0x100004a0, 0x04a004a0, 0x100004b0, 0x04b004b0,
	0x100004c0, 0x04c004c0, 0x100004d0, 0x04d004d0,
	0x100004e0, 0x04e004e0, 0x100004f0, 0x04f004f0,
	0x10000500, 0x05000500, 0x10000510, 0x05100510,
	0x10000520, 0x05200520, 0x10000530, 0x05300530,
	0x10000540, 0x05400540, 0x10000550, 0x05500550,
	0x10000560, 0x05600560, 0x10000570, 0x05700570,
	0x10000580, 0x05800580, 0x10000590, 0x05900590,
	0x100005a0, 0x05a005a0, 0x100005b0, 0x05b005b0,
	0x100005c0, 0x05c005c0, 0x100005d0, 0x05d005d0,
	0x100005e0, 0x05e005e0, 0x100005f0, 0x05f005f0,
	0x10000600, 0x06000600, 0x10000610, 0x06100610,
	0x10000620, 0x06200620, 0x10000630, 0x06300630,
	0x10000640, 0x06400640, 0x10000650, 0x06500650,
	0x10000660, 0x06600660, 0x10000670, 0x06700670,
	0x10000680, 0x06800680, 0x10000690, 0x06900690,
	0x100006a0, 0x06a006a0, 0x100006b0, 0x06b006b0,
	0x100006c0, 0x06c006c0, 0x100006d0, 0x06d006d0,
	0x100006e0, 0x06e006e0, 0x100006f0, 0x06f006f0,
	0x10000700, 0x07000700, 0x10000710, 0x07100710,
	0x10000720, 0x07200720, 0x10000730, 0x07300730,
	0x10000740, 0x07400740, 0x10000750, 0x07500750,
	0x10000760, 0x07600760, 0x10000770, 0x07700770,
	0x10000780, 0x07800780, 0x10000790, 0x07900790,
	0x100007a0, 0x07a007a0, 0x100007b0, 0x07b007b0,
	0x100007c0, 0x07c007c0, 0x100007d0, 0x07d007d0,
	0x100007e0, 0x07e007e0, 0x100007f0, 0x07f007f0,
	0x10000800, 0x08000800, 0x10000810, 0x08100810,
	0x10000820, 0x08200820, 0x10000830, 0x08300830,
	0x10000840, 0x08400840, 0x10000850, 0x08500850,
	0x10000860, 0x08600860, 0x10000870, 0x08700870,
	0x10000880, 0x08800880, 0x10000890, 0x08900890,
	0x100008a0, 0x08a008a0, 0x100008b0, 0x08b008b0,
	0x100008c0, 0x08c008c0, 0x100008d0, 0x08d008d0,
	0x100008e0, 0x08e008e0, 0x100008f0, 0x08f008f0,
	0x10000900, 0x09000900, 0x10000910, 0x09100910,
	0x10000920, 0x09200920, 0x10000930, 0x09300930,
	0x10000940, 0x09400940, 0x10000950, 0x09500950,
	0x10000960, 0x09600960, 0x10000970, 0x09700970,
	0x10000980, 0x09800980, 0x10000990, 0x09900990,
	0x100009a0, 0x09a009a0, 0x100009b0, 0x09b009b0,
	0x100009c0, 0x09c009c0, 0x100009d0, 0x09d009d0,
	0x100009e0, 0x09e009e0, 0x100009f0, 0x09f009f0,
	0x10000a00, 0x0a000a00, 0x10000a10, 0x0a100a10,
	0x10000a20, 0x0a200a20, 0x10000a30, 0x0a300a30,
	0x10000a40, 0x0a400a40, 0x10000a50, 0x0a500a50,
	0x10000a60, 0x0a600a60, 0x10000a70, 0x0a700a70,
	0x10000a80, 0x0a800a80, 0x10000a90, 0x0a900a90,
	0x10000aa0, 0x0aa00aa0, 0x10000ab0, 0x0ab00ab0,
	0x10000ac0, 0x0ac00ac0, 0x10000ad0, 0x0ad00ad0,
	0x10000ae0, 0x0ae00ae0, 0x10000af0, 0x0af00af0,
	0x10000b00, 0x0b000b00, 0x10000b10, 0x0b100b10,
	0x10000b20, 0x0b200b20, 0x10000b30, 0x0b300b30,
	0x10000b40, 0x0b400b40, 0x10000b50, 0x0b500b50,
	0x10000b60, 0x0b600b60, 0x10000b70, 0x0b700b70,
	0x10000b80, 0x0b800b80, 0x10000b90, 0x0b900b90,
	0x10000ba0, 0x0ba00ba0, 0x10000bb0, 0x0bb00bb0,
	0x10000bc0, 0x0bc00bc0, 0x10000bd0, 0x0bd00bd0,
	0x10000be0, 0x0be00be0, 0x10000bf0, 0x0bf00bf0,
	0x10000c00, 0x0c000c00, 0x10000c10, 0x0c100c10,
	0x10000c20, 0x0c200c20, 0x10000c30, 0x0c300c30,
	0x10000c40, 0x0c400c40, 0x10000c50, 0x0c500c50,
	0x10000c60, 0x0c600c60, 0x10000c70, 0x0c700c70,
	0x10000c80, 0x0c800c80, 0x10000c90, 0x0c900c90,
	0x10000ca0, 0x0ca00ca0, 0x10000cb0, 0x0cb00cb0,
	0x10000cc0, 0x0cc00cc0, 0x10000cd0, 0x0cd00cd0,
	0x10000ce0, 0x0ce00ce0, 0x10000cf0, 0x0cf00cf0,
	0x10000d00, 0x0d000d00, 0x10000d10, 0x0d100d10,
	0x10000d20, 0x0d200d20, 0x10000d30, 0x0d300d30,
	0x10000d40, 0x0d400d40, 0x10000d50, 0x0d500d50,
	0x10000d60, 0x0d600d60, 0x10000d70, 0x0d700d70,
	0x10000d80, 0x0d800d80, 0x10000d90, 0x0d900d90,
	0x10000da0, 0x0da00da0, 0x10000db0, 0x0db00db0,
	0x10000dc0, 0x0dc00dc0, 0x10000dd0, 0x0dd00dd0,
	0x10000de0, 0x0de00de0, 0x10000df0, 0x0df00df0,
	0x10000e00, 0x0e000e00, 0x10000e10, 0x0e100e10,
	0x10000e20, 0x0e200e20, 0x10000e30, 0x0e300e30,
	0x10000e40, 0x0e400e40, 0x10000e50, 0x0e500e50,
	0x10000e60, 0x0e600e60, 0x10000e70, 0x0e700e70,
	0x10000e80, 0x0e800e80, 0x10000e90, 0x0e900e90,
	0x10000ea0, 0x0ea00ea0, 0x10000eb0, 0x0eb00eb0,
	0x10000ec0, 0x0ec00ec0, 0x10000ed0, 0x0ed00ed0,
	0x10000ee0, 0x0ee00ee0, 0x10000ef0, 0x0ef00ef0,
	0x10000f00, 0x0f000f00, 0x10000f10, 0x0f100f10,
	0x10000f20, 0x0f200f20, 0x10000f30, 0x0f300f30,
	0x10000f40, 0x0f400f40, 0x10000f50, 0x0f500f50,
	0x10000f60, 0x0f600f60, 0x10000f70, 0x0f700f70,
	0x10000f80, 0x0f800f80, 0x10000f90, 0x0f900f90,
	0x10000fa0, 0x0fa00fa0, 0x10000fb0, 0x0fb00fb0,
	0x10000fc0, 0x0fc00fc0, 0x10000fd0, 0x0fd00fd0,
	0x10000fe0, 0x0fe00fe0, 0x10000ff0, 0x0ff00ff0,
	0x10001000, 0x10001000
};

/* *********************************************************** */

#pragma align 8(mlib_table_blend_alpha_u32)
const mlib_u32 mlib_table_blend_alpha_u32[] = {
	0x00000000, 0x01010101, 0x02020202, 0x03030303,
	0x04040404, 0x05050505, 0x06060606, 0x07070707,
	0x08080808, 0x09090909, 0x0a0a0a0a, 0x0b0b0b0b,
	0x0c0c0c0c, 0x0d0d0d0d, 0x0e0e0e0e, 0x0f0f0f0f,
	0x10101010, 0x11111111, 0x12121212, 0x13131313,
	0x14141414, 0x15151515, 0x16161616, 0x17171717,
	0x18181818, 0x19191919, 0x1a1a1a1a, 0x1b1b1b1b,
	0x1c1c1c1c, 0x1d1d1d1d, 0x1e1e1e1e, 0x1f1f1f1f,
	0x20202020, 0x21212121, 0x22222222, 0x23232323,
	0x24242424, 0x25252525, 0x26262626, 0x27272727,
	0x28282828, 0x29292929, 0x2a2a2a2a, 0x2b2b2b2b,
	0x2c2c2c2c, 0x2d2d2d2d, 0x2e2e2e2e, 0x2f2f2f2f,
	0x30303030, 0x31313131, 0x32323232, 0x33333333,
	0x34343434, 0x35353535, 0x36363636, 0x37373737,
	0x38383838, 0x39393939, 0x3a3a3a3a, 0x3b3b3b3b,
	0x3c3c3c3c, 0x3d3d3d3d, 0x3e3e3e3e, 0x3f3f3f3f,
	0x40404040, 0x41414141, 0x42424242, 0x43434343,
	0x44444444, 0x45454545, 0x46464646, 0x47474747,
	0x48484848, 0x49494949, 0x4a4a4a4a, 0x4b4b4b4b,
	0x4c4c4c4c, 0x4d4d4d4d, 0x4e4e4e4e, 0x4f4f4f4f,
	0x50505050, 0x51515151, 0x52525252, 0x53535353,
	0x54545454, 0x55555555, 0x56565656, 0x57575757,
	0x58585858, 0x59595959, 0x5a5a5a5a, 0x5b5b5b5b,
	0x5c5c5c5c, 0x5d5d5d5d, 0x5e5e5e5e, 0x5f5f5f5f,
	0x60606060, 0x61616161, 0x62626262, 0x63636363,
	0x64646464, 0x65656565, 0x66666666, 0x67676767,
	0x68686868, 0x69696969, 0x6a6a6a6a, 0x6b6b6b6b,
	0x6c6c6c6c, 0x6d6d6d6d, 0x6e6e6e6e, 0x6f6f6f6f,
	0x70707070, 0x71717171, 0x72727272, 0x73737373,
	0x74747474, 0x75757575, 0x76767676, 0x77777777,
	0x78787878, 0x79797979, 0x7a7a7a7a, 0x7b7b7b7b,
	0x7c7c7c7c, 0x7d7d7d7d, 0x7e7e7e7e, 0x7f7f7f7f,
	0x80808080, 0x81818181, 0x82828282, 0x83838383,
	0x84848484, 0x85858585, 0x86868686, 0x87878787,
	0x88888888, 0x89898989, 0x8a8a8a8a, 0x8b8b8b8b,
	0x8c8c8c8c, 0x8d8d8d8d, 0x8e8e8e8e, 0x8f8f8f8f,
	0x90909090, 0x91919191, 0x92929292, 0x93939393,
	0x94949494, 0x95959595, 0x96969696, 0x97979797,
	0x98989898, 0x99999999, 0x9a9a9a9a, 0x9b9b9b9b,
	0x9c9c9c9c, 0x9d9d9d9d, 0x9e9e9e9e, 0x9f9f9f9f,
	0xa0a0a0a0, 0xa1a1a1a1, 0xa2a2a2a2, 0xa3a3a3a3,
	0xa4a4a4a4, 0xa5a5a5a5, 0xa6a6a6a6, 0xa7a7a7a7,
	0xa8a8a8a8, 0xa9a9a9a9, 0xaaaaaaaa, 0xabababab,
	0xacacacac, 0xadadadad, 0xaeaeaeae, 0xafafafaf,
	0xb0b0b0b0, 0xb1b1b1b1, 0xb2b2b2b2, 0xb3b3b3b3,
	0xb4b4b4b4, 0xb5b5b5b5, 0xb6b6b6b6, 0xb7b7b7b7,
	0xb8b8b8b8, 0xb9b9b9b9, 0xbabababa, 0xbbbbbbbb,
	0xbcbcbcbc, 0xbdbdbdbd, 0xbebebebe, 0xbfbfbfbf,
	0xc0c0c0c0, 0xc1c1c1c1, 0xc2c2c2c2, 0xc3c3c3c3,
	0xc4c4c4c4, 0xc5c5c5c5, 0xc6c6c6c6, 0xc7c7c7c7,
	0xc8c8c8c8, 0xc9c9c9c9, 0xcacacaca, 0xcbcbcbcb,
	0xcccccccc, 0xcdcdcdcd, 0xcececece, 0xcfcfcfcf,
	0xd0d0d0d0, 0xd1d1d1d1, 0xd2d2d2d2, 0xd3d3d3d3,
	0xd4d4d4d4, 0xd5d5d5d5, 0xd6d6d6d6, 0xd7d7d7d7,
	0xd8d8d8d8, 0xd9d9d9d9, 0xdadadada, 0xdbdbdbdb,
	0xdcdcdcdc, 0xdddddddd, 0xdededede, 0xdfdfdfdf,
	0xe0e0e0e0, 0xe1e1e1e1, 0xe2e2e2e2, 0xe3e3e3e3,
	0xe4e4e4e4, 0xe5e5e5e5, 0xe6e6e6e6, 0xe7e7e7e7,
	0xe8e8e8e8, 0xe9e9e9e9, 0xeaeaeaea, 0xebebebeb,
	0xecececec, 0xedededed, 0xeeeeeeee, 0xefefefef,
	0xf0f0f0f0, 0xf1f1f1f1, 0xf2f2f2f2, 0xf3f3f3f3,
	0xf4f4f4f4, 0xf5f5f5f5, 0xf6f6f6f6, 0xf7f7f7f7,
	0xf8f8f8f8, 0xf9f9f9f9, 0xfafafafa, 0xfbfbfbfb,
	0xfcfcfcfc, 0xfdfdfdfd, 0xfefefefe, 0xffffffff
};

/* *********************************************************** */
