/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"@(#)mlib_SignalCodecTable.c	9.2	07/10/09 SMI"

#include <mlib_signal.h>

/* *********************************************************** */

/*
 * Maps G.723_24 code word to reconstructed scale factor normalized log
 * magnitude values.
 */

const mlib_s16 mlib_ADPCM2Bits_rsf[] = {
	116, 365, 365, 116
};

const mlib_s16 mlib_ADPCM3Bits_rsf[] = {
	-2048, 135, 273, 373, 373, 273, 135, -2048
};

const mlib_s16 mlib_ADPCM4Bits_rsf[] = {
	-2048, 4, 135, 213, 273, 323, 373, 425,
	425, 373, 323, 273, 213, 135, 4, -2048
};

const mlib_s16 mlib_ADPCM5Bits_rsf[] = {
	-2048, -66, 28, 104, 169, 224, 274, 318,
	358, 395, 429, 459, 488, 514, 539, 566,
	566, 539, 514, 488, 459, 429, 395, 358,
	318, 274, 224, 169, 104, 28, -66, -2048
};

/* *********************************************************** */

/*
 * Maps G.723_24 code word to log of scale factor multiplier.
 */

const mlib_s16 mlib_ADPCM2Bits_sfm[] = {
	-704, 14048, 14048, -704
};

const mlib_s16 mlib_ADPCM3Bits_sfm[] = {
	-128, 960, 4384, 18624, 18624, 4384, 960, -128
};

const mlib_s16 mlib_ADPCM4Bits_sfm[] = {
	-12, 18, 41, 64, 112, 198, 355, 1122,
	1122, 355, 198, 112, 64, 41, 18, -12
};

const mlib_s16 mlib_ADPCM5Bits_sfm[] = {
	448, 448, 768, 1248, 1280, 1312, 1856,
	3200, 4512, 5728, 7008, 8960, 11456, 14080,
	16928, 22272, 22272, 16928, 14080, 11456,
	8960, 7008, 5728, 4512, 3200, 1856, 1312,
	1280, 1248, 768, 448, 448
};

/* *********************************************************** */

/*
 * Maps G.723_24 code words to a set of values whose mlib_s32 and mlib_s16
 * term averages are computed and then compared to give an indication
 * how stationary (steady state) the signal is.
 */

const mlib_s16 mlib_ADPCM2Bits_st[] = {
	0x000, 0xE00, 0xE00, 0x000
};

const mlib_s16 mlib_ADPCM3Bits_st[] = {
	0x000, 0x200, 0x400, 0xE00,
	0xE00, 0x400, 0x200, 0x000
};

const mlib_s16 mlib_ADPCM4Bits_st[] = {
	0x000, 0x000, 0x000, 0x200,
	0x200, 0x200, 0x600, 0xE00,
	0xE00, 0x600, 0x200, 0x200,
	0x200, 0x000, 0x000, 0x000
};

const mlib_s16 mlib_ADPCM5Bits_st[] = {
	0x000, 0x000, 0x000, 0x000, 0x000,
	0x200, 0x200, 0x200, 0x200, 0x200,
	0x400, 0x600, 0x800, 0xA00, 0xC00,
	0xC00, 0xC00, 0xC00, 0xA00, 0x800,
	0x600, 0x400, 0x200, 0x200, 0x200,
	0x200, 0x200, 0x000, 0x000, 0x000,
	0x000, 0x000
};

const mlib_s16 mlib_ADPCM3Bits_quant[] = {
	8, 218, 331
};

const mlib_s16 mlib_ADPCM4Bits_quant[] = {
	-124, 80, 178, 246, 300, 349, 400
};

const mlib_s16 mlib_ADPCM5Bits_quant[] = {
	-122, -16, 68, 139, 198, 250, 298, 339,
	378, 413, 445, 475, 502, 528, 553
};

const mlib_u8 mlib_ADPCM3Bits_qs3[] = {
	3, 0, 1, 0, 2, 0, 1, 0
};

/* *********************************************************** */

/*
 * u- to A-Law conversion
 */

const mlib_u8 mlib_u2a[] = {
	42, 43, 40, 41, 46, 47, 44, 45,
	34, 35, 32, 33, 38, 39, 36, 37,
	58, 59, 56, 57, 62, 63, 60, 61,
	50, 51, 48, 49, 54, 55, 52, 53,
	10, 11, 8, 9, 14, 15, 12, 13,
	2, 3, 0, 1, 6, 7, 4, 26,
	27, 24, 25, 30, 31, 28, 29, 18,
	19, 16, 17, 22, 23, 20, 21, 106,
	104, 105, 110, 111, 108, 109, 98, 99,
	96, 97, 102, 103, 100, 101, 122, 120,
	126, 127, 124, 125, 114, 115, 112, 113,
	118, 119, 116, 117, 75, 73, 79, 77,
	66, 67, 64, 65, 70, 71, 68, 69,
	90, 91, 88, 89, 94, 95, 92, 93,
	82, 82, 83, 83, 80, 80, 81, 81,
	86, 86, 87, 87, 84, 84, 85, 85,
	170, 171, 168, 169, 174, 175, 172, 173,
	162, 163, 160, 161, 166, 167, 164, 165,
	186, 187, 184, 185, 190, 191, 188, 189,
	178, 179, 176, 177, 182, 183, 180, 181,
	138, 139, 136, 137, 142, 143, 140, 141,
	130, 131, 128, 129, 134, 135, 132, 154,
	155, 152, 153, 158, 159, 156, 157, 146,
	147, 144, 145, 150, 151, 148, 149, 234,
	232, 233, 238, 239, 236, 237, 226, 227,
	224, 225, 230, 231, 228, 229, 250, 248,
	254, 255, 252, 253, 242, 243, 240, 241,
	246, 247, 244, 245, 203, 201, 207, 205,
	194, 195, 192, 193, 198, 199, 196, 197,
	218, 219, 216, 217, 222, 223, 220, 221,
	210, 210, 211, 211, 208, 208, 209, 209,
	214, 214, 215, 215, 212, 212, 213, 213
};

/* *********************************************************** */

/*
 * A- to u-Law conversion
 */

const mlib_u8 mlib_a2u[] = {
	42, 43, 40, 41, 46, 47, 44, 45,
	34, 35, 32, 33, 38, 39, 36, 37,
	57, 58, 55, 56, 61, 62, 59, 60,
	49, 50, 47, 48, 53, 54, 51, 52,
	10, 11, 8, 9, 14, 15, 12, 13,
	2, 3, 0, 1, 6, 7, 4, 5,
	26, 27, 24, 25, 30, 31, 28, 29,
	18, 19, 16, 17, 22, 23, 20, 21,
	98, 99, 96, 97, 102, 103, 100, 101,
	93, 93, 92, 92, 95, 95, 94, 94,
	116, 118, 112, 114, 124, 126, 120, 122,
	106, 107, 104, 105, 110, 111, 108, 109,
	72, 73, 70, 71, 76, 77, 74, 75,
	64, 65, 63, 63, 68, 69, 66, 67,
	86, 87, 84, 85, 90, 91, 88, 89,
	79, 79, 78, 78, 82, 83, 80, 81,
	170, 171, 168, 169, 174, 175, 172, 173,
	162, 163, 160, 161, 166, 167, 164, 165,
	185, 186, 183, 184, 189, 190, 187, 188,
	177, 178, 175, 176, 181, 182, 179, 180,
	138, 139, 136, 137, 142, 143, 140, 141,
	130, 131, 128, 129, 134, 135, 132, 133,
	154, 155, 152, 153, 158, 159, 156, 157,
	146, 147, 144, 145, 150, 151, 148, 149,
	226, 227, 224, 225, 230, 231, 228, 229,
	221, 221, 220, 220, 223, 223, 222, 222,
	244, 246, 240, 242, 252, 254, 248, 250,
	234, 235, 232, 233, 238, 239, 236, 237,
	200, 201, 198, 199, 204, 205, 202, 203,
	192, 193, 191, 191, 196, 197, 194, 195,
	214, 215, 212, 213, 218, 219, 216, 217,
	207, 207, 206, 206, 210, 211, 208, 209
};

/* *********************************************************** */

/*
 * u-Law to Linear conversion
 */

const mlib_u16 mlib_u2l[] = {
	0x8284, 0x8684, 0x8a84, 0x8e84, 0x9284, 0x9684, 0x9a84, 0x9e84,
	0xa284, 0xa684, 0xaa84, 0xae84, 0xb284, 0xb684, 0xba84, 0xbe84,
	0xc184, 0xc384, 0xc584, 0xc784, 0xc984, 0xcb84, 0xcd84, 0xcf84,
	0xd184, 0xd384, 0xd584, 0xd784, 0xd984, 0xdb84, 0xdd84, 0xdf84,
	0xe104, 0xe204, 0xe304, 0xe404, 0xe504, 0xe604, 0xe704, 0xe804,
	0xe904, 0xea04, 0xeb04, 0xec04, 0xed04, 0xee04, 0xef04, 0xf004,
	0xf0c4, 0xf144, 0xf1c4, 0xf244, 0xf2c4, 0xf344, 0xf3c4, 0xf444,
	0xf4c4, 0xf544, 0xf5c4, 0xf644, 0xf6c4, 0xf744, 0xf7c4, 0xf844,
	0xf8a4, 0xf8e4, 0xf924, 0xf964, 0xf9a4, 0xf9e4, 0xfa24, 0xfa64,
	0xfaa4, 0xfae4, 0xfb24, 0xfb64, 0xfba4, 0xfbe4, 0xfc24, 0xfc64,
	0xfc94, 0xfcb4, 0xfcd4, 0xfcf4, 0xfd14, 0xfd34, 0xfd54, 0xfd74,
	0xfd94, 0xfdb4, 0xfdd4, 0xfdf4, 0xfe14, 0xfe34, 0xfe54, 0xfe74,
	0xfe8c, 0xfe9c, 0xfeac, 0xfebc, 0xfecc, 0xfedc, 0xfeec, 0xfefc,
	0xff0c, 0xff1c, 0xff2c, 0xff3c, 0xff4c, 0xff5c, 0xff6c, 0xff7c,
	0xff88, 0xff90, 0xff98, 0xffa0, 0xffa8, 0xffb0, 0xffb8, 0xffc0,
	0xffc8, 0xffd0, 0xffd8, 0xffe0, 0xffe8, 0xfff0, 0xfff8, 0x0000,
	0x7d7c, 0x797c, 0x757c, 0x717c, 0x6d7c, 0x697c, 0x657c, 0x617c,
	0x5d7c, 0x597c, 0x557c, 0x517c, 0x4d7c, 0x497c, 0x457c, 0x417c,
	0x3e7c, 0x3c7c, 0x3a7c, 0x387c, 0x367c, 0x347c, 0x327c, 0x307c,
	0x2e7c, 0x2c7c, 0x2a7c, 0x287c, 0x267c, 0x247c, 0x227c, 0x207c,
	0x1efc, 0x1dfc, 0x1cfc, 0x1bfc, 0x1afc, 0x19fc, 0x18fc, 0x17fc,
	0x16fc, 0x15fc, 0x14fc, 0x13fc, 0x12fc, 0x11fc, 0x10fc, 0x0ffc,
	0x0f3c, 0x0ebc, 0x0e3c, 0x0dbc, 0x0d3c, 0x0cbc, 0x0c3c, 0x0bbc,
	0x0b3c, 0x0abc, 0x0a3c, 0x09bc, 0x093c, 0x08bc, 0x083c, 0x07bc,
	0x075c, 0x071c, 0x06dc, 0x069c, 0x065c, 0x061c, 0x05dc, 0x059c,
	0x055c, 0x051c, 0x04dc, 0x049c, 0x045c, 0x041c, 0x03dc, 0x039c,
	0x036c, 0x034c, 0x032c, 0x030c, 0x02ec, 0x02cc, 0x02ac, 0x028c,
	0x026c, 0x024c, 0x022c, 0x020c, 0x01ec, 0x01cc, 0x01ac, 0x018c,
	0x0174, 0x0164, 0x0154, 0x0144, 0x0134, 0x0124, 0x0114, 0x0104,
	0x00f4, 0x00e4, 0x00d4, 0x00c4, 0x00b4, 0x00a4, 0x0094, 0x0084,
	0x0078, 0x0070, 0x0068, 0x0060, 0x0058, 0x0050, 0x0048, 0x0040,
	0x0038, 0x0030, 0x0028, 0x0020, 0x0018, 0x0010, 0x0008, 0x0000
};

/* *********************************************************** */

/*
 * A-Law to Linear conversion
 */

const mlib_u16 mlib_A2l[] = {
	0xea80, 0xeb80, 0xe880, 0xe980, 0xee80, 0xef80, 0xec80, 0xed80,
	0xe280, 0xe380, 0xe080, 0xe180, 0xe680, 0xe780, 0xe480, 0xe580,
	0xf540, 0xf5c0, 0xf440, 0xf4c0, 0xf740, 0xf7c0, 0xf640, 0xf6c0,
	0xf140, 0xf1c0, 0xf040, 0xf0c0, 0xf340, 0xf3c0, 0xf240, 0xf2c0,
	0xaa00, 0xae00, 0xa200, 0xa600, 0xba00, 0xbe00, 0xb200, 0xb600,
	0x8a00, 0x8e00, 0x8200, 0x8600, 0x9a00, 0x9e00, 0x9200, 0x9600,
	0xd500, 0xd700, 0xd100, 0xd300, 0xdd00, 0xdf00, 0xd900, 0xdb00,
	0xc500, 0xc700, 0xc100, 0xc300, 0xcd00, 0xcf00, 0xc900, 0xcb00,
	0xfea8, 0xfeb8, 0xfe88, 0xfe98, 0xfee8, 0xfef8, 0xfec8, 0xfed8,
	0xfe28, 0xfe38, 0xfe08, 0xfe18, 0xfe68, 0xfe78, 0xfe48, 0xfe58,
	0xffa8, 0xffb8, 0xff88, 0xff98, 0xffe8, 0xfff8, 0xffc8, 0xffd8,
	0xff28, 0xff38, 0xff08, 0xff18, 0xff68, 0xff78, 0xff48, 0xff58,
	0xfaa0, 0xfae0, 0xfa20, 0xfa60, 0xfba0, 0xfbe0, 0xfb20, 0xfb60,
	0xf8a0, 0xf8e0, 0xf820, 0xf860, 0xf9a0, 0xf9e0, 0xf920, 0xf960,
	0xfd50, 0xfd70, 0xfd10, 0xfd30, 0xfdd0, 0xfdf0, 0xfd90, 0xfdb0,
	0xfc50, 0xfc70, 0xfc10, 0xfc30, 0xfcd0, 0xfcf0, 0xfc90, 0xfcb0,
	0x1580, 0x1480, 0x1780, 0x1680, 0x1180, 0x1080, 0x1380, 0x1280,
	0x1d80, 0x1c80, 0x1f80, 0x1e80, 0x1980, 0x1880, 0x1b80, 0x1a80,
	0x0ac0, 0x0a40, 0x0bc0, 0x0b40, 0x08c0, 0x0840, 0x09c0, 0x0940,
	0x0ec0, 0x0e40, 0x0fc0, 0x0f40, 0x0cc0, 0x0c40, 0x0dc0, 0x0d40,
	0x5600, 0x5200, 0x5e00, 0x5a00, 0x4600, 0x4200, 0x4e00, 0x4a00,
	0x7600, 0x7200, 0x7e00, 0x7a00, 0x6600, 0x6200, 0x6e00, 0x6a00,
	0x2b00, 0x2900, 0x2f00, 0x2d00, 0x2300, 0x2100, 0x2700, 0x2500,
	0x3b00, 0x3900, 0x3f00, 0x3d00, 0x3300, 0x3100, 0x3700, 0x3500,
	0x0158, 0x0148, 0x0178, 0x0168, 0x0118, 0x0108, 0x0138, 0x0128,
	0x01d8, 0x01c8, 0x01f8, 0x01e8, 0x0198, 0x0188, 0x01b8, 0x01a8,
	0x0058, 0x0048, 0x0078, 0x0068, 0x0018, 0x0008, 0x0038, 0x0028,
	0x00d8, 0x00c8, 0x00f8, 0x00e8, 0x0098, 0x0088, 0x00b8, 0x00a8,
	0x0560, 0x0520, 0x05e0, 0x05a0, 0x0460, 0x0420, 0x04e0, 0x04a0,
	0x0760, 0x0720, 0x07e0, 0x07a0, 0x0660, 0x0620, 0x06e0, 0x06a0,
	0x02b0, 0x0290, 0x02f0, 0x02d0, 0x0230, 0x0210, 0x0270, 0x0250,
	0x03b0, 0x0390, 0x03f0, 0x03d0, 0x0330, 0x0310, 0x0370, 0x0350
};

/* *********************************************************** */

/*
 * Linear to u-Law conversion
 */

const mlib_u8 mlib_l2u[] = {
	255, 254, 253, 252, 251, 250, 249, 248,
	247, 246, 245, 244, 243, 242, 241, 240,
	239, 239, 238, 238, 237, 237, 236, 236,
	235, 235, 234, 234, 233, 233, 232, 232,
	231, 231, 230, 230, 229, 229, 228, 228,
	227, 227, 226, 226, 225, 225, 224, 224,
	223, 223, 223, 223, 222, 222, 222, 222,
	221, 221, 221, 221, 220, 220, 220, 220,
	219, 219, 219, 219, 218, 218, 218, 218,
	217, 217, 217, 217, 216, 216, 216, 216,
	215, 215, 215, 215, 214, 214, 214, 214,
	213, 213, 213, 213, 212, 212, 212, 212,
	211, 211, 211, 211, 210, 210, 210, 210,
	209, 209, 209, 209, 208, 208, 208, 208,
	207, 207, 207, 207, 207, 207, 207, 207,
	206, 206, 206, 206, 206, 206, 206, 206,
	205, 205, 205, 205, 205, 205, 205, 205,
	204, 204, 204, 204, 204, 204, 204, 204,
	203, 203, 203, 203, 203, 203, 203, 203,
	202, 202, 202, 202, 202, 202, 202, 202,
	201, 201, 201, 201, 201, 201, 201, 201,
	200, 200, 200, 200, 200, 200, 200, 200,
	199, 199, 199, 199, 199, 199, 199, 199,
	198, 198, 198, 198, 198, 198, 198, 198,
	197, 197, 197, 197, 197, 197, 197, 197,
	196, 196, 196, 196, 196, 196, 196, 196,
	195, 195, 195, 195, 195, 195, 195, 195,
	194, 194, 194, 194, 194, 194, 194, 194,
	193, 193, 193, 193, 193, 193, 193, 193,
	192, 192, 192, 192, 192, 192, 192, 192,
	191, 191, 191, 191, 191, 191, 191, 191,
	191, 191, 191, 191, 191, 191, 191, 191,
	190, 190, 190, 190, 190, 190, 190, 190,
	190, 190, 190, 190, 190, 190, 190, 190,
	189, 189, 189, 189, 189, 189, 189, 189,
	189, 189, 189, 189, 189, 189, 189, 189,
	188, 188, 188, 188, 188, 188, 188, 188,
	188, 188, 188, 188, 188, 188, 188, 188,
	187, 187, 187, 187, 187, 187, 187, 187,
	187, 187, 187, 187, 187, 187, 187, 187,
	186, 186, 186, 186, 186, 186, 186, 186,
	186, 186, 186, 186, 186, 186, 186, 186,
	185, 185, 185, 185, 185, 185, 185, 185,
	185, 185, 185, 185, 185, 185, 185, 185,
	184, 184, 184, 184, 184, 184, 184, 184,
	184, 184, 184, 184, 184, 184, 184, 184,
	183, 183, 183, 183, 183, 183, 183, 183,
	183, 183, 183, 183, 183, 183, 183, 183,
	182, 182, 182, 182, 182, 182, 182, 182,
	182, 182, 182, 182, 182, 182, 182, 182,
	181, 181, 181, 181, 181, 181, 181, 181,
	181, 181, 181, 181, 181, 181, 181, 181,
	180, 180, 180, 180, 180, 180, 180, 180,
	180, 180, 180, 180, 180, 180, 180, 180,
	179, 179, 179, 179, 179, 179, 179, 179,
	179, 179, 179, 179, 179, 179, 179, 179,
	178, 178, 178, 178, 178, 178, 178, 178,
	178, 178, 178, 178, 178, 178, 178, 178,
	177, 177, 177, 177, 177, 177, 177, 177,
	177, 177, 177, 177, 177, 177, 177, 177,
	176, 176, 176, 176, 176, 176, 176, 176,
	176, 176, 176, 176, 176, 176, 176, 176,
	175, 175, 175, 175, 175, 175, 175, 175,
	175, 175, 175, 175, 175, 175, 175, 175,
	175, 175, 175, 175, 175, 175, 175, 175,
	175, 175, 175, 175, 175, 175, 175, 175,
	174, 174, 174, 174, 174, 174, 174, 174,
	174, 174, 174, 174, 174, 174, 174, 174,
	174, 174, 174, 174, 174, 174, 174, 174,
	174, 174, 174, 174, 174, 174, 174, 174,
	173, 173, 173, 173, 173, 173, 173, 173,
	173, 173, 173, 173, 173, 173, 173, 173,
	173, 173, 173, 173, 173, 173, 173, 173,
	173, 173, 173, 173, 173, 173, 173, 173,
	172, 172, 172, 172, 172, 172, 172, 172,
	172, 172, 172, 172, 172, 172, 172, 172,
	172, 172, 172, 172, 172, 172, 172, 172,
	172, 172, 172, 172, 172, 172, 172, 172,
	171, 171, 171, 171, 171, 171, 171, 171,
	171, 171, 171, 171, 171, 171, 171, 171,
	171, 171, 171, 171, 171, 171, 171, 171,
	171, 171, 171, 171, 171, 171, 171, 171,
	170, 170, 170, 170, 170, 170, 170, 170,
	170, 170, 170, 170, 170, 170, 170, 170,
	170, 170, 170, 170, 170, 170, 170, 170,
	170, 170, 170, 170, 170, 170, 170, 170,
	169, 169, 169, 169, 169, 169, 169, 169,
	169, 169, 169, 169, 169, 169, 169, 169,
	169, 169, 169, 169, 169, 169, 169, 169,
	169, 169, 169, 169, 169, 169, 169, 169,
	168, 168, 168, 168, 168, 168, 168, 168,
	168, 168, 168, 168, 168, 168, 168, 168,
	168, 168, 168, 168, 168, 168, 168, 168,
	168, 168, 168, 168, 168, 168, 168, 168,
	167, 167, 167, 167, 167, 167, 167, 167,
	167, 167, 167, 167, 167, 167, 167, 167,
	167, 167, 167, 167, 167, 167, 167, 167,
	167, 167, 167, 167, 167, 167, 167, 167,
	166, 166, 166, 166, 166, 166, 166, 166,
	166, 166, 166, 166, 166, 166, 166, 166,
	166, 166, 166, 166, 166, 166, 166, 166,
	166, 166, 166, 166, 166, 166, 166, 166,
	165, 165, 165, 165, 165, 165, 165, 165,
	165, 165, 165, 165, 165, 165, 165, 165,
	165, 165, 165, 165, 165, 165, 165, 165,
	165, 165, 165, 165, 165, 165, 165, 165,
	164, 164, 164, 164, 164, 164, 164, 164,
	164, 164, 164, 164, 164, 164, 164, 164,
	164, 164, 164, 164, 164, 164, 164, 164,
	164, 164, 164, 164, 164, 164, 164, 164,
	163, 163, 163, 163, 163, 163, 163, 163,
	163, 163, 163, 163, 163, 163, 163, 163,
	163, 163, 163, 163, 163, 163, 163, 163,
	163, 163, 163, 163, 163, 163, 163, 163,
	162, 162, 162, 162, 162, 162, 162, 162,
	162, 162, 162, 162, 162, 162, 162, 162,
	162, 162, 162, 162, 162, 162, 162, 162,
	162, 162, 162, 162, 162, 162, 162, 162,
	161, 161, 161, 161, 161, 161, 161, 161,
	161, 161, 161, 161, 161, 161, 161, 161,
	161, 161, 161, 161, 161, 161, 161, 161,
	161, 161, 161, 161, 161, 161, 161, 161,
	160, 160, 160, 160, 160, 160, 160, 160,
	160, 160, 160, 160, 160, 160, 160, 160,
	160, 160, 160, 160, 160, 160, 160, 160,
	160, 160, 160, 160, 160, 160, 160, 160,
	159, 159, 159, 159, 159, 159, 159, 159,
	159, 159, 159, 159, 159, 159, 159, 159,
	159, 159, 159, 159, 159, 159, 159, 159,
	159, 159, 159, 159, 159, 159, 159, 159,
	159, 159, 159, 159, 159, 159, 159, 159,
	159, 159, 159, 159, 159, 159, 159, 159,
	159, 159, 159, 159, 159, 159, 159, 159,
	159, 159, 159, 159, 159, 159, 159, 159,
	158, 158, 158, 158, 158, 158, 158, 158,
	158, 158, 158, 158, 158, 158, 158, 158,
	158, 158, 158, 158, 158, 158, 158, 158,
	158, 158, 158, 158, 158, 158, 158, 158,
	158, 158, 158, 158, 158, 158, 158, 158,
	158, 158, 158, 158, 158, 158, 158, 158,
	158, 158, 158, 158, 158, 158, 158, 158,
	158, 158, 158, 158, 158, 158, 158, 158,
	157, 157, 157, 157, 157, 157, 157, 157,
	157, 157, 157, 157, 157, 157, 157, 157,
	157, 157, 157, 157, 157, 157, 157, 157,
	157, 157, 157, 157, 157, 157, 157, 157,
	157, 157, 157, 157, 157, 157, 157, 157,
	157, 157, 157, 157, 157, 157, 157, 157,
	157, 157, 157, 157, 157, 157, 157, 157,
	157, 157, 157, 157, 157, 157, 157, 157,
	156, 156, 156, 156, 156, 156, 156, 156,
	156, 156, 156, 156, 156, 156, 156, 156,
	156, 156, 156, 156, 156, 156, 156, 156,
	156, 156, 156, 156, 156, 156, 156, 156,
	156, 156, 156, 156, 156, 156, 156, 156,
	156, 156, 156, 156, 156, 156, 156, 156,
	156, 156, 156, 156, 156, 156, 156, 156,
	156, 156, 156, 156, 156, 156, 156, 156,
	155, 155, 155, 155, 155, 155, 155, 155,
	155, 155, 155, 155, 155, 155, 155, 155,
	155, 155, 155, 155, 155, 155, 155, 155,
	155, 155, 155, 155, 155, 155, 155, 155,
	155, 155, 155, 155, 155, 155, 155, 155,
	155, 155, 155, 155, 155, 155, 155, 155,
	155, 155, 155, 155, 155, 155, 155, 155,
	155, 155, 155, 155, 155, 155, 155, 155,
	154, 154, 154, 154, 154, 154, 154, 154,
	154, 154, 154, 154, 154, 154, 154, 154,
	154, 154, 154, 154, 154, 154, 154, 154,
	154, 154, 154, 154, 154, 154, 154, 154,
	154, 154, 154, 154, 154, 154, 154, 154,
	154, 154, 154, 154, 154, 154, 154, 154,
	154, 154, 154, 154, 154, 154, 154, 154,
	154, 154, 154, 154, 154, 154, 154, 154,
	153, 153, 153, 153, 153, 153, 153, 153,
	153, 153, 153, 153, 153, 153, 153, 153,
	153, 153, 153, 153, 153, 153, 153, 153,
	153, 153, 153, 153, 153, 153, 153, 153,
	153, 153, 153, 153, 153, 153, 153, 153,
	153, 153, 153, 153, 153, 153, 153, 153,
	153, 153, 153, 153, 153, 153, 153, 153,
	153, 153, 153, 153, 153, 153, 153, 153,
	152, 152, 152, 152, 152, 152, 152, 152,
	152, 152, 152, 152, 152, 152, 152, 152,
	152, 152, 152, 152, 152, 152, 152, 152,
	152, 152, 152, 152, 152, 152, 152, 152,
	152, 152, 152, 152, 152, 152, 152, 152,
	152, 152, 152, 152, 152, 152, 152, 152,
	152, 152, 152, 152, 152, 152, 152, 152,
	152, 152, 152, 152, 152, 152, 152, 152,
	151, 151, 151, 151, 151, 151, 151, 151,
	151, 151, 151, 151, 151, 151, 151, 151,
	151, 151, 151, 151, 151, 151, 151, 151,
	151, 151, 151, 151, 151, 151, 151, 151,
	151, 151, 151, 151, 151, 151, 151, 151,
	151, 151, 151, 151, 151, 151, 151, 151,
	151, 151, 151, 151, 151, 151, 151, 151,
	151, 151, 151, 151, 151, 151, 151, 151,
	150, 150, 150, 150, 150, 150, 150, 150,
	150, 150, 150, 150, 150, 150, 150, 150,
	150, 150, 150, 150, 150, 150, 150, 150,
	150, 150, 150, 150, 150, 150, 150, 150,
	150, 150, 150, 150, 150, 150, 150, 150,
	150, 150, 150, 150, 150, 150, 150, 150,
	150, 150, 150, 150, 150, 150, 150, 150,
	150, 150, 150, 150, 150, 150, 150, 150,
	149, 149, 149, 149, 149, 149, 149, 149,
	149, 149, 149, 149, 149, 149, 149, 149,
	149, 149, 149, 149, 149, 149, 149, 149,
	149, 149, 149, 149, 149, 149, 149, 149,
	149, 149, 149, 149, 149, 149, 149, 149,
	149, 149, 149, 149, 149, 149, 149, 149,
	149, 149, 149, 149, 149, 149, 149, 149,
	149, 149, 149, 149, 149, 149, 149, 149,
	148, 148, 148, 148, 148, 148, 148, 148,
	148, 148, 148, 148, 148, 148, 148, 148,
	148, 148, 148, 148, 148, 148, 148, 148,
	148, 148, 148, 148, 148, 148, 148, 148,
	148, 148, 148, 148, 148, 148, 148, 148,
	148, 148, 148, 148, 148, 148, 148, 148,
	148, 148, 148, 148, 148, 148, 148, 148,
	148, 148, 148, 148, 148, 148, 148, 148,
	147, 147, 147, 147, 147, 147, 147, 147,
	147, 147, 147, 147, 147, 147, 147, 147,
	147, 147, 147, 147, 147, 147, 147, 147,
	147, 147, 147, 147, 147, 147, 147, 147,
	147, 147, 147, 147, 147, 147, 147, 147,
	147, 147, 147, 147, 147, 147, 147, 147,
	147, 147, 147, 147, 147, 147, 147, 147,
	147, 147, 147, 147, 147, 147, 147, 147,
	146, 146, 146, 146, 146, 146, 146, 146,
	146, 146, 146, 146, 146, 146, 146, 146,
	146, 146, 146, 146, 146, 146, 146, 146,
	146, 146, 146, 146, 146, 146, 146, 146,
	146, 146, 146, 146, 146, 146, 146, 146,
	146, 146, 146, 146, 146, 146, 146, 146,
	146, 146, 146, 146, 146, 146, 146, 146,
	146, 146, 146, 146, 146, 146, 146, 146,
	145, 145, 145, 145, 145, 145, 145, 145,
	145, 145, 145, 145, 145, 145, 145, 145,
	145, 145, 145, 145, 145, 145, 145, 145,
	145, 145, 145, 145, 145, 145, 145, 145,
	145, 145, 145, 145, 145, 145, 145, 145,
	145, 145, 145, 145, 145, 145, 145, 145,
	145, 145, 145, 145, 145, 145, 145, 145,
	145, 145, 145, 145, 145, 145, 145, 145,
	144, 144, 144, 144, 144, 144, 144, 144,
	144, 144, 144, 144, 144, 144, 144, 144,
	144, 144, 144, 144, 144, 144, 144, 144,
	144, 144, 144, 144, 144, 144, 144, 144,
	144, 144, 144, 144, 144, 144, 144, 144,
	144, 144, 144, 144, 144, 144, 144, 144,
	144, 144, 144, 144, 144, 144, 144, 144,
	144, 144, 144, 144, 144, 144, 144, 144,
	143, 143, 143, 143, 143, 143, 143, 143,
	143, 143, 143, 143, 143, 143, 143, 143,
	143, 143, 143, 143, 143, 143, 143, 143,
	143, 143, 143, 143, 143, 143, 143, 143,
	143, 143, 143, 143, 143, 143, 143, 143,
	143, 143, 143, 143, 143, 143, 143, 143,
	143, 143, 143, 143, 143, 143, 143, 143,
	143, 143, 143, 143, 143, 143, 143, 143,
	143, 143, 143, 143, 143, 143, 143, 143,
	143, 143, 143, 143, 143, 143, 143, 143,
	143, 143, 143, 143, 143, 143, 143, 143,
	143, 143, 143, 143, 143, 143, 143, 143,
	143, 143, 143, 143, 143, 143, 143, 143,
	143, 143, 143, 143, 143, 143, 143, 143,
	143, 143, 143, 143, 143, 143, 143, 143,
	143, 143, 143, 143, 143, 143, 143, 143,
	142, 142, 142, 142, 142, 142, 142, 142,
	142, 142, 142, 142, 142, 142, 142, 142,
	142, 142, 142, 142, 142, 142, 142, 142,
	142, 142, 142, 142, 142, 142, 142, 142,
	142, 142, 142, 142, 142, 142, 142, 142,
	142, 142, 142, 142, 142, 142, 142, 142,
	142, 142, 142, 142, 142, 142, 142, 142,
	142, 142, 142, 142, 142, 142, 142, 142,
	142, 142, 142, 142, 142, 142, 142, 142,
	142, 142, 142, 142, 142, 142, 142, 142,
	142, 142, 142, 142, 142, 142, 142, 142,
	142, 142, 142, 142, 142, 142, 142, 142,
	142, 142, 142, 142, 142, 142, 142, 142,
	142, 142, 142, 142, 142, 142, 142, 142,
	142, 142, 142, 142, 142, 142, 142, 142,
	142, 142, 142, 142, 142, 142, 142, 142,
	141, 141, 141, 141, 141, 141, 141, 141,
	141, 141, 141, 141, 141, 141, 141, 141,
	141, 141, 141, 141, 141, 141, 141, 141,
	141, 141, 141, 141, 141, 141, 141, 141,
	141, 141, 141, 141, 141, 141, 141, 141,
	141, 141, 141, 141, 141, 141, 141, 141,
	141, 141, 141, 141, 141, 141, 141, 141,
	141, 141, 141, 141, 141, 141, 141, 141,
	141, 141, 141, 141, 141, 141, 141, 141,
	141, 141, 141, 141, 141, 141, 141, 141,
	141, 141, 141, 141, 141, 141, 141, 141,
	141, 141, 141, 141, 141, 141, 141, 141,
	141, 141, 141, 141, 141, 141, 141, 141,
	141, 141, 141, 141, 141, 141, 141, 141,
	141, 141, 141, 141, 141, 141, 141, 141,
	141, 141, 141, 141, 141, 141, 141, 141,
	140, 140, 140, 140, 140, 140, 140, 140,
	140, 140, 140, 140, 140, 140, 140, 140,
	140, 140, 140, 140, 140, 140, 140, 140,
	140, 140, 140, 140, 140, 140, 140, 140,
	140, 140, 140, 140, 140, 140, 140, 140,
	140, 140, 140, 140, 140, 140, 140, 140,
	140, 140, 140, 140, 140, 140, 140, 140,
	140, 140, 140, 140, 140, 140, 140, 140,
	140, 140, 140, 140, 140, 140, 140, 140,
	140, 140, 140, 140, 140, 140, 140, 140,
	140, 140, 140, 140, 140, 140, 140, 140,
	140, 140, 140, 140, 140, 140, 140, 140,
	140, 140, 140, 140, 140, 140, 140, 140,
	140, 140, 140, 140, 140, 140, 140, 140,
	140, 140, 140, 140, 140, 140, 140, 140,
	140, 140, 140, 140, 140, 140, 140, 140,
	139, 139, 139, 139, 139, 139, 139, 139,
	139, 139, 139, 139, 139, 139, 139, 139,
	139, 139, 139, 139, 139, 139, 139, 139,
	139, 139, 139, 139, 139, 139, 139, 139,
	139, 139, 139, 139, 139, 139, 139, 139,
	139, 139, 139, 139, 139, 139, 139, 139,
	139, 139, 139, 139, 139, 139, 139, 139,
	139, 139, 139, 139, 139, 139, 139, 139,
	139, 139, 139, 139, 139, 139, 139, 139,
	139, 139, 139, 139, 139, 139, 139, 139,
	139, 139, 139, 139, 139, 139, 139, 139,
	139, 139, 139, 139, 139, 139, 139, 139,
	139, 139, 139, 139, 139, 139, 139, 139,
	139, 139, 139, 139, 139, 139, 139, 139,
	139, 139, 139, 139, 139, 139, 139, 139,
	139, 139, 139, 139, 139, 139, 139, 139,
	138, 138, 138, 138, 138, 138, 138, 138,
	138, 138, 138, 138, 138, 138, 138, 138,
	138, 138, 138, 138, 138, 138, 138, 138,
	138, 138, 138, 138, 138, 138, 138, 138,
	138, 138, 138, 138, 138, 138, 138, 138,
	138, 138, 138, 138, 138, 138, 138, 138,
	138, 138, 138, 138, 138, 138, 138, 138,
	138, 138, 138, 138, 138, 138, 138, 138,
	138, 138, 138, 138, 138, 138, 138, 138,
	138, 138, 138, 138, 138, 138, 138, 138,
	138, 138, 138, 138, 138, 138, 138, 138,
	138, 138, 138, 138, 138, 138, 138, 138,
	138, 138, 138, 138, 138, 138, 138, 138,
	138, 138, 138, 138, 138, 138, 138, 138,
	138, 138, 138, 138, 138, 138, 138, 138,
	138, 138, 138, 138, 138, 138, 138, 138,
	137, 137, 137, 137, 137, 137, 137, 137,
	137, 137, 137, 137, 137, 137, 137, 137,
	137, 137, 137, 137, 137, 137, 137, 137,
	137, 137, 137, 137, 137, 137, 137, 137,
	137, 137, 137, 137, 137, 137, 137, 137,
	137, 137, 137, 137, 137, 137, 137, 137,
	137, 137, 137, 137, 137, 137, 137, 137,
	137, 137, 137, 137, 137, 137, 137, 137,
	137, 137, 137, 137, 137, 137, 137, 137,
	137, 137, 137, 137, 137, 137, 137, 137,
	137, 137, 137, 137, 137, 137, 137, 137,
	137, 137, 137, 137, 137, 137, 137, 137,
	137, 137, 137, 137, 137, 137, 137, 137,
	137, 137, 137, 137, 137, 137, 137, 137,
	137, 137, 137, 137, 137, 137, 137, 137,
	137, 137, 137, 137, 137, 137, 137, 137,
	136, 136, 136, 136, 136, 136, 136, 136,
	136, 136, 136, 136, 136, 136, 136, 136,
	136, 136, 136, 136, 136, 136, 136, 136,
	136, 136, 136, 136, 136, 136, 136, 136,
	136, 136, 136, 136, 136, 136, 136, 136,
	136, 136, 136, 136, 136, 136, 136, 136,
	136, 136, 136, 136, 136, 136, 136, 136,
	136, 136, 136, 136, 136, 136, 136, 136,
	136, 136, 136, 136, 136, 136, 136, 136,
	136, 136, 136, 136, 136, 136, 136, 136,
	136, 136, 136, 136, 136, 136, 136, 136,
	136, 136, 136, 136, 136, 136, 136, 136,
	136, 136, 136, 136, 136, 136, 136, 136,
	136, 136, 136, 136, 136, 136, 136, 136,
	136, 136, 136, 136, 136, 136, 136, 136,
	136, 136, 136, 136, 136, 136, 136, 136,
	135, 135, 135, 135, 135, 135, 135, 135,
	135, 135, 135, 135, 135, 135, 135, 135,
	135, 135, 135, 135, 135, 135, 135, 135,
	135, 135, 135, 135, 135, 135, 135, 135,
	135, 135, 135, 135, 135, 135, 135, 135,
	135, 135, 135, 135, 135, 135, 135, 135,
	135, 135, 135, 135, 135, 135, 135, 135,
	135, 135, 135, 135, 135, 135, 135, 135,
	135, 135, 135, 135, 135, 135, 135, 135,
	135, 135, 135, 135, 135, 135, 135, 135,
	135, 135, 135, 135, 135, 135, 135, 135,
	135, 135, 135, 135, 135, 135, 135, 135,
	135, 135, 135, 135, 135, 135, 135, 135,
	135, 135, 135, 135, 135, 135, 135, 135,
	135, 135, 135, 135, 135, 135, 135, 135,
	135, 135, 135, 135, 135, 135, 135, 135,
	134, 134, 134, 134, 134, 134, 134, 134,
	134, 134, 134, 134, 134, 134, 134, 134,
	134, 134, 134, 134, 134, 134, 134, 134,
	134, 134, 134, 134, 134, 134, 134, 134,
	134, 134, 134, 134, 134, 134, 134, 134,
	134, 134, 134, 134, 134, 134, 134, 134,
	134, 134, 134, 134, 134, 134, 134, 134,
	134, 134, 134, 134, 134, 134, 134, 134,
	134, 134, 134, 134, 134, 134, 134, 134,
	134, 134, 134, 134, 134, 134, 134, 134,
	134, 134, 134, 134, 134, 134, 134, 134,
	134, 134, 134, 134, 134, 134, 134, 134,
	134, 134, 134, 134, 134, 134, 134, 134,
	134, 134, 134, 134, 134, 134, 134, 134,
	134, 134, 134, 134, 134, 134, 134, 134,
	134, 134, 134, 134, 134, 134, 134, 134,
	133, 133, 133, 133, 133, 133, 133, 133,
	133, 133, 133, 133, 133, 133, 133, 133,
	133, 133, 133, 133, 133, 133, 133, 133,
	133, 133, 133, 133, 133, 133, 133, 133,
	133, 133, 133, 133, 133, 133, 133, 133,
	133, 133, 133, 133, 133, 133, 133, 133,
	133, 133, 133, 133, 133, 133, 133, 133,
	133, 133, 133, 133, 133, 133, 133, 133,
	133, 133, 133, 133, 133, 133, 133, 133,
	133, 133, 133, 133, 133, 133, 133, 133,
	133, 133, 133, 133, 133, 133, 133, 133,
	133, 133, 133, 133, 133, 133, 133, 133,
	133, 133, 133, 133, 133, 133, 133, 133,
	133, 133, 133, 133, 133, 133, 133, 133,
	133, 133, 133, 133, 133, 133, 133, 133,
	133, 133, 133, 133, 133, 133, 133, 133,
	132, 132, 132, 132, 132, 132, 132, 132,
	132, 132, 132, 132, 132, 132, 132, 132,
	132, 132, 132, 132, 132, 132, 132, 132,
	132, 132, 132, 132, 132, 132, 132, 132,
	132, 132, 132, 132, 132, 132, 132, 132,
	132, 132, 132, 132, 132, 132, 132, 132,
	132, 132, 132, 132, 132, 132, 132, 132,
	132, 132, 132, 132, 132, 132, 132, 132,
	132, 132, 132, 132, 132, 132, 132, 132,
	132, 132, 132, 132, 132, 132, 132, 132,
	132, 132, 132, 132, 132, 132, 132, 132,
	132, 132, 132, 132, 132, 132, 132, 132,
	132, 132, 132, 132, 132, 132, 132, 132,
	132, 132, 132, 132, 132, 132, 132, 132,
	132, 132, 132, 132, 132, 132, 132, 132,
	132, 132, 132, 132, 132, 132, 132, 132,
	131, 131, 131, 131, 131, 131, 131, 131,
	131, 131, 131, 131, 131, 131, 131, 131,
	131, 131, 131, 131, 131, 131, 131, 131,
	131, 131, 131, 131, 131, 131, 131, 131,
	131, 131, 131, 131, 131, 131, 131, 131,
	131, 131, 131, 131, 131, 131, 131, 131,
	131, 131, 131, 131, 131, 131, 131, 131,
	131, 131, 131, 131, 131, 131, 131, 131,
	131, 131, 131, 131, 131, 131, 131, 131,
	131, 131, 131, 131, 131, 131, 131, 131,
	131, 131, 131, 131, 131, 131, 131, 131,
	131, 131, 131, 131, 131, 131, 131, 131,
	131, 131, 131, 131, 131, 131, 131, 131,
	131, 131, 131, 131, 131, 131, 131, 131,
	131, 131, 131, 131, 131, 131, 131, 131,
	131, 131, 131, 131, 131, 131, 131, 131,
	130, 130, 130, 130, 130, 130, 130, 130,
	130, 130, 130, 130, 130, 130, 130, 130,
	130, 130, 130, 130, 130, 130, 130, 130,
	130, 130, 130, 130, 130, 130, 130, 130,
	130, 130, 130, 130, 130, 130, 130, 130,
	130, 130, 130, 130, 130, 130, 130, 130,
	130, 130, 130, 130, 130, 130, 130, 130,
	130, 130, 130, 130, 130, 130, 130, 130,
	130, 130, 130, 130, 130, 130, 130, 130,
	130, 130, 130, 130, 130, 130, 130, 130,
	130, 130, 130, 130, 130, 130, 130, 130,
	130, 130, 130, 130, 130, 130, 130, 130,
	130, 130, 130, 130, 130, 130, 130, 130,
	130, 130, 130, 130, 130, 130, 130, 130,
	130, 130, 130, 130, 130, 130, 130, 130,
	130, 130, 130, 130, 130, 130, 130, 130,
	129, 129, 129, 129, 129, 129, 129, 129,
	129, 129, 129, 129, 129, 129, 129, 129,
	129, 129, 129, 129, 129, 129, 129, 129,
	129, 129, 129, 129, 129, 129, 129, 129,
	129, 129, 129, 129, 129, 129, 129, 129,
	129, 129, 129, 129, 129, 129, 129, 129,
	129, 129, 129, 129, 129, 129, 129, 129,
	129, 129, 129, 129, 129, 129, 129, 129,
	129, 129, 129, 129, 129, 129, 129, 129,
	129, 129, 129, 129, 129, 129, 129, 129,
	129, 129, 129, 129, 129, 129, 129, 129,
	129, 129, 129, 129, 129, 129, 129, 129,
	129, 129, 129, 129, 129, 129, 129, 129,
	129, 129, 129, 129, 129, 129, 129, 129,
	129, 129, 129, 129, 129, 129, 129, 129,
	129, 129, 129, 129, 129, 129, 129, 129,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 9, 9, 9, 9, 9, 9,
	9, 9, 9, 9, 9, 9, 9, 9,
	9, 9, 9, 9, 9, 9, 9, 9,
	9, 9, 9, 9, 9, 9, 9, 9,
	9, 9, 9, 9, 9, 9, 9, 9,
	9, 9, 9, 9, 9, 9, 9, 9,
	9, 9, 9, 9, 9, 9, 9, 9,
	9, 9, 9, 9, 9, 9, 9, 9,
	9, 9, 9, 9, 9, 9, 9, 9,
	9, 9, 9, 9, 9, 9, 9, 9,
	9, 9, 9, 9, 9, 9, 9, 9,
	9, 9, 9, 9, 9, 9, 9, 9,
	9, 9, 9, 9, 9, 9, 9, 9,
	9, 9, 9, 9, 9, 9, 9, 9,
	9, 9, 9, 9, 9, 9, 9, 9,
	9, 9, 9, 9, 9, 9, 9, 9,
	9, 9, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 11, 11, 11, 11, 11, 11,
	11, 11, 11, 11, 11, 11, 11, 11,
	11, 11, 11, 11, 11, 11, 11, 11,
	11, 11, 11, 11, 11, 11, 11, 11,
	11, 11, 11, 11, 11, 11, 11, 11,
	11, 11, 11, 11, 11, 11, 11, 11,
	11, 11, 11, 11, 11, 11, 11, 11,
	11, 11, 11, 11, 11, 11, 11, 11,
	11, 11, 11, 11, 11, 11, 11, 11,
	11, 11, 11, 11, 11, 11, 11, 11,
	11, 11, 11, 11, 11, 11, 11, 11,
	11, 11, 11, 11, 11, 11, 11, 11,
	11, 11, 11, 11, 11, 11, 11, 11,
	11, 11, 11, 11, 11, 11, 11, 11,
	11, 11, 11, 11, 11, 11, 11, 11,
	11, 11, 11, 11, 11, 11, 11, 11,
	11, 11, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 14, 14, 14, 14, 14, 14,
	14, 14, 14, 14, 14, 14, 14, 14,
	14, 14, 14, 14, 14, 14, 14, 14,
	14, 14, 14, 14, 14, 14, 14, 14,
	14, 14, 14, 14, 14, 14, 14, 14,
	14, 14, 14, 14, 14, 14, 14, 14,
	14, 14, 14, 14, 14, 14, 14, 14,
	14, 14, 14, 14, 14, 14, 14, 14,
	14, 14, 14, 14, 14, 14, 14, 14,
	14, 14, 14, 14, 14, 14, 14, 14,
	14, 14, 14, 14, 14, 14, 14, 14,
	14, 14, 14, 14, 14, 14, 14, 14,
	14, 14, 14, 14, 14, 14, 14, 14,
	14, 14, 14, 14, 14, 14, 14, 14,
	14, 14, 14, 14, 14, 14, 14, 14,
	14, 14, 14, 14, 14, 14, 14, 14,
	14, 14, 15, 15, 15, 15, 15, 15,
	15, 15, 15, 15, 15, 15, 15, 15,
	15, 15, 15, 15, 15, 15, 15, 15,
	15, 15, 15, 15, 15, 15, 15, 15,
	15, 15, 15, 15, 15, 15, 15, 15,
	15, 15, 15, 15, 15, 15, 15, 15,
	15, 15, 15, 15, 15, 15, 15, 15,
	15, 15, 15, 15, 15, 15, 15, 15,
	15, 15, 15, 15, 15, 15, 15, 15,
	15, 15, 15, 15, 15, 15, 15, 15,
	15, 15, 15, 15, 15, 15, 15, 15,
	15, 15, 15, 15, 15, 15, 15, 15,
	15, 15, 15, 15, 15, 15, 15, 15,
	15, 15, 15, 15, 15, 15, 15, 15,
	15, 15, 15, 15, 15, 15, 15, 15,
	15, 15, 15, 15, 15, 15, 15, 15,
	15, 15, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 17, 17, 17, 17, 17, 17,
	17, 17, 17, 17, 17, 17, 17, 17,
	17, 17, 17, 17, 17, 17, 17, 17,
	17, 17, 17, 17, 17, 17, 17, 17,
	17, 17, 17, 17, 17, 17, 17, 17,
	17, 17, 17, 17, 17, 17, 17, 17,
	17, 17, 17, 17, 17, 17, 17, 17,
	17, 17, 17, 17, 17, 17, 17, 17,
	17, 17, 18, 18, 18, 18, 18, 18,
	18, 18, 18, 18, 18, 18, 18, 18,
	18, 18, 18, 18, 18, 18, 18, 18,
	18, 18, 18, 18, 18, 18, 18, 18,
	18, 18, 18, 18, 18, 18, 18, 18,
	18, 18, 18, 18, 18, 18, 18, 18,
	18, 18, 18, 18, 18, 18, 18, 18,
	18, 18, 18, 18, 18, 18, 18, 18,
	18, 18, 19, 19, 19, 19, 19, 19,
	19, 19, 19, 19, 19, 19, 19, 19,
	19, 19, 19, 19, 19, 19, 19, 19,
	19, 19, 19, 19, 19, 19, 19, 19,
	19, 19, 19, 19, 19, 19, 19, 19,
	19, 19, 19, 19, 19, 19, 19, 19,
	19, 19, 19, 19, 19, 19, 19, 19,
	19, 19, 19, 19, 19, 19, 19, 19,
	19, 19, 20, 20, 20, 20, 20, 20,
	20, 20, 20, 20, 20, 20, 20, 20,
	20, 20, 20, 20, 20, 20, 20, 20,
	20, 20, 20, 20, 20, 20, 20, 20,
	20, 20, 20, 20, 20, 20, 20, 20,
	20, 20, 20, 20, 20, 20, 20, 20,
	20, 20, 20, 20, 20, 20, 20, 20,
	20, 20, 20, 20, 20, 20, 20, 20,
	20, 20, 21, 21, 21, 21, 21, 21,
	21, 21, 21, 21, 21, 21, 21, 21,
	21, 21, 21, 21, 21, 21, 21, 21,
	21, 21, 21, 21, 21, 21, 21, 21,
	21, 21, 21, 21, 21, 21, 21, 21,
	21, 21, 21, 21, 21, 21, 21, 21,
	21, 21, 21, 21, 21, 21, 21, 21,
	21, 21, 21, 21, 21, 21, 21, 21,
	21, 21, 22, 22, 22, 22, 22, 22,
	22, 22, 22, 22, 22, 22, 22, 22,
	22, 22, 22, 22, 22, 22, 22, 22,
	22, 22, 22, 22, 22, 22, 22, 22,
	22, 22, 22, 22, 22, 22, 22, 22,
	22, 22, 22, 22, 22, 22, 22, 22,
	22, 22, 22, 22, 22, 22, 22, 22,
	22, 22, 22, 22, 22, 22, 22, 22,
	22, 22, 23, 23, 23, 23, 23, 23,
	23, 23, 23, 23, 23, 23, 23, 23,
	23, 23, 23, 23, 23, 23, 23, 23,
	23, 23, 23, 23, 23, 23, 23, 23,
	23, 23, 23, 23, 23, 23, 23, 23,
	23, 23, 23, 23, 23, 23, 23, 23,
	23, 23, 23, 23, 23, 23, 23, 23,
	23, 23, 23, 23, 23, 23, 23, 23,
	23, 23, 24, 24, 24, 24, 24, 24,
	24, 24, 24, 24, 24, 24, 24, 24,
	24, 24, 24, 24, 24, 24, 24, 24,
	24, 24, 24, 24, 24, 24, 24, 24,
	24, 24, 24, 24, 24, 24, 24, 24,
	24, 24, 24, 24, 24, 24, 24, 24,
	24, 24, 24, 24, 24, 24, 24, 24,
	24, 24, 24, 24, 24, 24, 24, 24,
	24, 24, 25, 25, 25, 25, 25, 25,
	25, 25, 25, 25, 25, 25, 25, 25,
	25, 25, 25, 25, 25, 25, 25, 25,
	25, 25, 25, 25, 25, 25, 25, 25,
	25, 25, 25, 25, 25, 25, 25, 25,
	25, 25, 25, 25, 25, 25, 25, 25,
	25, 25, 25, 25, 25, 25, 25, 25,
	25, 25, 25, 25, 25, 25, 25, 25,
	25, 25, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 26, 26, 26, 26, 26, 26,
	26, 26, 27, 27, 27, 27, 27, 27,
	27, 27, 27, 27, 27, 27, 27, 27,
	27, 27, 27, 27, 27, 27, 27, 27,
	27, 27, 27, 27, 27, 27, 27, 27,
	27, 27, 27, 27, 27, 27, 27, 27,
	27, 27, 27, 27, 27, 27, 27, 27,
	27, 27, 27, 27, 27, 27, 27, 27,
	27, 27, 27, 27, 27, 27, 27, 27,
	27, 27, 28, 28, 28, 28, 28, 28,
	28, 28, 28, 28, 28, 28, 28, 28,
	28, 28, 28, 28, 28, 28, 28, 28,
	28, 28, 28, 28, 28, 28, 28, 28,
	28, 28, 28, 28, 28, 28, 28, 28,
	28, 28, 28, 28, 28, 28, 28, 28,
	28, 28, 28, 28, 28, 28, 28, 28,
	28, 28, 28, 28, 28, 28, 28, 28,
	28, 28, 29, 29, 29, 29, 29, 29,
	29, 29, 29, 29, 29, 29, 29, 29,
	29, 29, 29, 29, 29, 29, 29, 29,
	29, 29, 29, 29, 29, 29, 29, 29,
	29, 29, 29, 29, 29, 29, 29, 29,
	29, 29, 29, 29, 29, 29, 29, 29,
	29, 29, 29, 29, 29, 29, 29, 29,
	29, 29, 29, 29, 29, 29, 29, 29,
	29, 29, 30, 30, 30, 30, 30, 30,
	30, 30, 30, 30, 30, 30, 30, 30,
	30, 30, 30, 30, 30, 30, 30, 30,
	30, 30, 30, 30, 30, 30, 30, 30,
	30, 30, 30, 30, 30, 30, 30, 30,
	30, 30, 30, 30, 30, 30, 30, 30,
	30, 30, 30, 30, 30, 30, 30, 30,
	30, 30, 30, 30, 30, 30, 30, 30,
	30, 30, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 31, 31, 31, 31, 31, 31,
	31, 31, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 32, 32,
	32, 32, 33, 33, 33, 33, 33, 33,
	33, 33, 33, 33, 33, 33, 33, 33,
	33, 33, 33, 33, 33, 33, 33, 33,
	33, 33, 33, 33, 33, 33, 33, 33,
	33, 33, 34, 34, 34, 34, 34, 34,
	34, 34, 34, 34, 34, 34, 34, 34,
	34, 34, 34, 34, 34, 34, 34, 34,
	34, 34, 34, 34, 34, 34, 34, 34,
	34, 34, 35, 35, 35, 35, 35, 35,
	35, 35, 35, 35, 35, 35, 35, 35,
	35, 35, 35, 35, 35, 35, 35, 35,
	35, 35, 35, 35, 35, 35, 35, 35,
	35, 35, 36, 36, 36, 36, 36, 36,
	36, 36, 36, 36, 36, 36, 36, 36,
	36, 36, 36, 36, 36, 36, 36, 36,
	36, 36, 36, 36, 36, 36, 36, 36,
	36, 36, 37, 37, 37, 37, 37, 37,
	37, 37, 37, 37, 37, 37, 37, 37,
	37, 37, 37, 37, 37, 37, 37, 37,
	37, 37, 37, 37, 37, 37, 37, 37,
	37, 37, 38, 38, 38, 38, 38, 38,
	38, 38, 38, 38, 38, 38, 38, 38,
	38, 38, 38, 38, 38, 38, 38, 38,
	38, 38, 38, 38, 38, 38, 38, 38,
	38, 38, 39, 39, 39, 39, 39, 39,
	39, 39, 39, 39, 39, 39, 39, 39,
	39, 39, 39, 39, 39, 39, 39, 39,
	39, 39, 39, 39, 39, 39, 39, 39,
	39, 39, 40, 40, 40, 40, 40, 40,
	40, 40, 40, 40, 40, 40, 40, 40,
	40, 40, 40, 40, 40, 40, 40, 40,
	40, 40, 40, 40, 40, 40, 40, 40,
	40, 40, 41, 41, 41, 41, 41, 41,
	41, 41, 41, 41, 41, 41, 41, 41,
	41, 41, 41, 41, 41, 41, 41, 41,
	41, 41, 41, 41, 41, 41, 41, 41,
	41, 41, 42, 42, 42, 42, 42, 42,
	42, 42, 42, 42, 42, 42, 42, 42,
	42, 42, 42, 42, 42, 42, 42, 42,
	42, 42, 42, 42, 42, 42, 42, 42,
	42, 42, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 43, 43,
	43, 43, 44, 44, 44, 44, 44, 44,
	44, 44, 44, 44, 44, 44, 44, 44,
	44, 44, 44, 44, 44, 44, 44, 44,
	44, 44, 44, 44, 44, 44, 44, 44,
	44, 44, 45, 45, 45, 45, 45, 45,
	45, 45, 45, 45, 45, 45, 45, 45,
	45, 45, 45, 45, 45, 45, 45, 45,
	45, 45, 45, 45, 45, 45, 45, 45,
	45, 45, 46, 46, 46, 46, 46, 46,
	46, 46, 46, 46, 46, 46, 46, 46,
	46, 46, 46, 46, 46, 46, 46, 46,
	46, 46, 46, 46, 46, 46, 46, 46,
	46, 46, 47, 47, 47, 47, 47, 47,
	47, 47, 47, 47, 47, 47, 47, 47,
	47, 47, 47, 47, 47, 47, 47, 47,
	47, 47, 47, 47, 47, 47, 47, 47,
	47, 47, 48, 48, 48, 48, 48, 48,
	48, 48, 48, 48, 48, 48, 48, 48,
	48, 48, 49, 49, 49, 49, 49, 49,
	49, 49, 49, 49, 49, 49, 49, 49,
	49, 49, 50, 50, 50, 50, 50, 50,
	50, 50, 50, 50, 50, 50, 50, 50,
	50, 50, 51, 51, 51, 51, 51, 51,
	51, 51, 51, 51, 51, 51, 51, 51,
	51, 51, 52, 52, 52, 52, 52, 52,
	52, 52, 52, 52, 52, 52, 52, 52,
	52, 52, 53, 53, 53, 53, 53, 53,
	53, 53, 53, 53, 53, 53, 53, 53,
	53, 53, 54, 54, 54, 54, 54, 54,
	54, 54, 54, 54, 54, 54, 54, 54,
	54, 54, 55, 55, 55, 55, 55, 55,
	55, 55, 55, 55, 55, 55, 55, 55,
	55, 55, 56, 56, 56, 56, 56, 56,
	56, 56, 56, 56, 56, 56, 56, 56,
	56, 56, 57, 57, 57, 57, 57, 57,
	57, 57, 57, 57, 57, 57, 57, 57,
	57, 57, 58, 58, 58, 58, 58, 58,
	58, 58, 58, 58, 58, 58, 58, 58,
	58, 58, 59, 59, 59, 59, 59, 59,
	59, 59, 59, 59, 59, 59, 59, 59,
	59, 59, 60, 60, 60, 60, 60, 60,
	60, 60, 60, 60, 60, 60, 60, 60,
	60, 60, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 62, 62, 62, 62, 62, 62,
	62, 62, 62, 62, 62, 62, 62, 62,
	62, 62, 63, 63, 63, 63, 63, 63,
	63, 63, 63, 63, 63, 63, 63, 63,
	63, 63, 64, 64, 64, 64, 64, 64,
	64, 64, 65, 65, 65, 65, 65, 65,
	65, 65, 66, 66, 66, 66, 66, 66,
	66, 66, 67, 67, 67, 67, 67, 67,
	67, 67, 68, 68, 68, 68, 68, 68,
	68, 68, 69, 69, 69, 69, 69, 69,
	69, 69, 70, 70, 70, 70, 70, 70,
	70, 70, 71, 71, 71, 71, 71, 71,
	71, 71, 72, 72, 72, 72, 72, 72,
	72, 72, 73, 73, 73, 73, 73, 73,
	73, 73, 74, 74, 74, 74, 74, 74,
	74, 74, 75, 75, 75, 75, 75, 75,
	75, 75, 76, 76, 76, 76, 76, 76,
	76, 76, 77, 77, 77, 77, 77, 77,
	77, 77, 78, 78, 78, 78, 78, 78,
	78, 78, 79, 79, 79, 79, 79, 79,
	79, 79, 80, 80, 80, 80, 81, 81,
	81, 81, 82, 82, 82, 82, 83, 83,
	83, 83, 84, 84, 84, 84, 85, 85,
	85, 85, 86, 86, 86, 86, 87, 87,
	87, 87, 88, 88, 88, 88, 89, 89,
	89, 89, 90, 90, 90, 90, 91, 91,
	91, 91, 92, 92, 92, 92, 93, 93,
	93, 93, 94, 94, 94, 94, 95, 95,
	95, 95, 96, 96, 97, 97, 98, 98,
	99, 99, 100, 100, 101, 101, 102, 102,
	103, 103, 104, 104, 105, 105, 106, 106,
	107, 107, 108, 108, 109, 109, 110, 110,
	111, 111, 112, 113, 114, 115, 116, 117,
	118, 119, 120, 121, 122, 123, 124, 125,
	126, 127
};

/* *********************************************************** */

/*
 * Linear to A-Law conversion
 */

const mlib_u8 mlib_l2A[] = {
	213, 212, 215, 214, 209, 208, 211, 210,
	221, 220, 223, 222, 217, 216, 219, 218,
	197, 196, 199, 198, 193, 192, 195, 194,
	205, 204, 207, 206, 201, 200, 203, 202,
	245, 245, 244, 244, 247, 247, 246, 246,
	241, 241, 240, 240, 243, 243, 242, 242,
	253, 253, 252, 252, 255, 255, 254, 254,
	249, 249, 248, 248, 251, 251, 250, 250,
	229, 229, 229, 229, 228, 228, 228, 228,
	231, 231, 231, 231, 230, 230, 230, 230,
	225, 225, 225, 225, 224, 224, 224, 224,
	227, 227, 227, 227, 226, 226, 226, 226,
	237, 237, 237, 237, 236, 236, 236, 236,
	239, 239, 239, 239, 238, 238, 238, 238,
	233, 233, 233, 233, 232, 232, 232, 232,
	235, 235, 235, 235, 234, 234, 234, 234,
	149, 149, 149, 149, 149, 149, 149, 149,
	148, 148, 148, 148, 148, 148, 148, 148,
	151, 151, 151, 151, 151, 151, 151, 151,
	150, 150, 150, 150, 150, 150, 150, 150,
	145, 145, 145, 145, 145, 145, 145, 145,
	144, 144, 144, 144, 144, 144, 144, 144,
	147, 147, 147, 147, 147, 147, 147, 147,
	146, 146, 146, 146, 146, 146, 146, 146,
	157, 157, 157, 157, 157, 157, 157, 157,
	156, 156, 156, 156, 156, 156, 156, 156,
	159, 159, 159, 159, 159, 159, 159, 159,
	158, 158, 158, 158, 158, 158, 158, 158,
	153, 153, 153, 153, 153, 153, 153, 153,
	152, 152, 152, 152, 152, 152, 152, 152,
	155, 155, 155, 155, 155, 155, 155, 155,
	154, 154, 154, 154, 154, 154, 154, 154,
	133, 133, 133, 133, 133, 133, 133, 133,
	133, 133, 133, 133, 133, 133, 133, 133,
	132, 132, 132, 132, 132, 132, 132, 132,
	132, 132, 132, 132, 132, 132, 132, 132,
	135, 135, 135, 135, 135, 135, 135, 135,
	135, 135, 135, 135, 135, 135, 135, 135,
	134, 134, 134, 134, 134, 134, 134, 134,
	134, 134, 134, 134, 134, 134, 134, 134,
	129, 129, 129, 129, 129, 129, 129, 129,
	129, 129, 129, 129, 129, 129, 129, 129,
	128, 128, 128, 128, 128, 128, 128, 128,
	128, 128, 128, 128, 128, 128, 128, 128,
	131, 131, 131, 131, 131, 131, 131, 131,
	131, 131, 131, 131, 131, 131, 131, 131,
	130, 130, 130, 130, 130, 130, 130, 130,
	130, 130, 130, 130, 130, 130, 130, 130,
	141, 141, 141, 141, 141, 141, 141, 141,
	141, 141, 141, 141, 141, 141, 141, 141,
	140, 140, 140, 140, 140, 140, 140, 140,
	140, 140, 140, 140, 140, 140, 140, 140,
	143, 143, 143, 143, 143, 143, 143, 143,
	143, 143, 143, 143, 143, 143, 143, 143,
	142, 142, 142, 142, 142, 142, 142, 142,
	142, 142, 142, 142, 142, 142, 142, 142,
	137, 137, 137, 137, 137, 137, 137, 137,
	137, 137, 137, 137, 137, 137, 137, 137,
	136, 136, 136, 136, 136, 136, 136, 136,
	136, 136, 136, 136, 136, 136, 136, 136,
	139, 139, 139, 139, 139, 139, 139, 139,
	139, 139, 139, 139, 139, 139, 139, 139,
	138, 138, 138, 138, 138, 138, 138, 138,
	138, 138, 138, 138, 138, 138, 138, 138,
	181, 181, 181, 181, 181, 181, 181, 181,
	181, 181, 181, 181, 181, 181, 181, 181,
	181, 181, 181, 181, 181, 181, 181, 181,
	181, 181, 181, 181, 181, 181, 181, 181,
	180, 180, 180, 180, 180, 180, 180, 180,
	180, 180, 180, 180, 180, 180, 180, 180,
	180, 180, 180, 180, 180, 180, 180, 180,
	180, 180, 180, 180, 180, 180, 180, 180,
	183, 183, 183, 183, 183, 183, 183, 183,
	183, 183, 183, 183, 183, 183, 183, 183,
	183, 183, 183, 183, 183, 183, 183, 183,
	183, 183, 183, 183, 183, 183, 183, 183,
	182, 182, 182, 182, 182, 182, 182, 182,
	182, 182, 182, 182, 182, 182, 182, 182,
	182, 182, 182, 182, 182, 182, 182, 182,
	182, 182, 182, 182, 182, 182, 182, 182,
	177, 177, 177, 177, 177, 177, 177, 177,
	177, 177, 177, 177, 177, 177, 177, 177,
	177, 177, 177, 177, 177, 177, 177, 177,
	177, 177, 177, 177, 177, 177, 177, 177,
	176, 176, 176, 176, 176, 176, 176, 176,
	176, 176, 176, 176, 176, 176, 176, 176,
	176, 176, 176, 176, 176, 176, 176, 176,
	176, 176, 176, 176, 176, 176, 176, 176,
	179, 179, 179, 179, 179, 179, 179, 179,
	179, 179, 179, 179, 179, 179, 179, 179,
	179, 179, 179, 179, 179, 179, 179, 179,
	179, 179, 179, 179, 179, 179, 179, 179,
	178, 178, 178, 178, 178, 178, 178, 178,
	178, 178, 178, 178, 178, 178, 178, 178,
	178, 178, 178, 178, 178, 178, 178, 178,
	178, 178, 178, 178, 178, 178, 178, 178,
	189, 189, 189, 189, 189, 189, 189, 189,
	189, 189, 189, 189, 189, 189, 189, 189,
	189, 189, 189, 189, 189, 189, 189, 189,
	189, 189, 189, 189, 189, 189, 189, 189,
	188, 188, 188, 188, 188, 188, 188, 188,
	188, 188, 188, 188, 188, 188, 188, 188,
	188, 188, 188, 188, 188, 188, 188, 188,
	188, 188, 188, 188, 188, 188, 188, 188,
	191, 191, 191, 191, 191, 191, 191, 191,
	191, 191, 191, 191, 191, 191, 191, 191,
	191, 191, 191, 191, 191, 191, 191, 191,
	191, 191, 191, 191, 191, 191, 191, 191,
	190, 190, 190, 190, 190, 190, 190, 190,
	190, 190, 190, 190, 190, 190, 190, 190,
	190, 190, 190, 190, 190, 190, 190, 190,
	190, 190, 190, 190, 190, 190, 190, 190,
	185, 185, 185, 185, 185, 185, 185, 185,
	185, 185, 185, 185, 185, 185, 185, 185,
	185, 185, 185, 185, 185, 185, 185, 185,
	185, 185, 185, 185, 185, 185, 185, 185,
	184, 184, 184, 184, 184, 184, 184, 184,
	184, 184, 184, 184, 184, 184, 184, 184,
	184, 184, 184, 184, 184, 184, 184, 184,
	184, 184, 184, 184, 184, 184, 184, 184,
	187, 187, 187, 187, 187, 187, 187, 187,
	187, 187, 187, 187, 187, 187, 187, 187,
	187, 187, 187, 187, 187, 187, 187, 187,
	187, 187, 187, 187, 187, 187, 187, 187,
	186, 186, 186, 186, 186, 186, 186, 186,
	186, 186, 186, 186, 186, 186, 186, 186,
	186, 186, 186, 186, 186, 186, 186, 186,
	186, 186, 186, 186, 186, 186, 186, 186,
	165, 165, 165, 165, 165, 165, 165, 165,
	165, 165, 165, 165, 165, 165, 165, 165,
	165, 165, 165, 165, 165, 165, 165, 165,
	165, 165, 165, 165, 165, 165, 165, 165,
	165, 165, 165, 165, 165, 165, 165, 165,
	165, 165, 165, 165, 165, 165, 165, 165,
	165, 165, 165, 165, 165, 165, 165, 165,
	165, 165, 165, 165, 165, 165, 165, 165,
	164, 164, 164, 164, 164, 164, 164, 164,
	164, 164, 164, 164, 164, 164, 164, 164,
	164, 164, 164, 164, 164, 164, 164, 164,
	164, 164, 164, 164, 164, 164, 164, 164,
	164, 164, 164, 164, 164, 164, 164, 164,
	164, 164, 164, 164, 164, 164, 164, 164,
	164, 164, 164, 164, 164, 164, 164, 164,
	164, 164, 164, 164, 164, 164, 164, 164,
	167, 167, 167, 167, 167, 167, 167, 167,
	167, 167, 167, 167, 167, 167, 167, 167,
	167, 167, 167, 167, 167, 167, 167, 167,
	167, 167, 167, 167, 167, 167, 167, 167,
	167, 167, 167, 167, 167, 167, 167, 167,
	167, 167, 167, 167, 167, 167, 167, 167,
	167, 167, 167, 167, 167, 167, 167, 167,
	167, 167, 167, 167, 167, 167, 167, 167,
	166, 166, 166, 166, 166, 166, 166, 166,
	166, 166, 166, 166, 166, 166, 166, 166,
	166, 166, 166, 166, 166, 166, 166, 166,
	166, 166, 166, 166, 166, 166, 166, 166,
	166, 166, 166, 166, 166, 166, 166, 166,
	166, 166, 166, 166, 166, 166, 166, 166,
	166, 166, 166, 166, 166, 166, 166, 166,
	166, 166, 166, 166, 166, 166, 166, 166,
	161, 161, 161, 161, 161, 161, 161, 161,
	161, 161, 161, 161, 161, 161, 161, 161,
	161, 161, 161, 161, 161, 161, 161, 161,
	161, 161, 161, 161, 161, 161, 161, 161,
	161, 161, 161, 161, 161, 161, 161, 161,
	161, 161, 161, 161, 161, 161, 161, 161,
	161, 161, 161, 161, 161, 161, 161, 161,
	161, 161, 161, 161, 161, 161, 161, 161,
	160, 160, 160, 160, 160, 160, 160, 160,
	160, 160, 160, 160, 160, 160, 160, 160,
	160, 160, 160, 160, 160, 160, 160, 160,
	160, 160, 160, 160, 160, 160, 160, 160,
	160, 160, 160, 160, 160, 160, 160, 160,
	160, 160, 160, 160, 160, 160, 160, 160,
	160, 160, 160, 160, 160, 160, 160, 160,
	160, 160, 160, 160, 160, 160, 160, 160,
	163, 163, 163, 163, 163, 163, 163, 163,
	163, 163, 163, 163, 163, 163, 163, 163,
	163, 163, 163, 163, 163, 163, 163, 163,
	163, 163, 163, 163, 163, 163, 163, 163,
	163, 163, 163, 163, 163, 163, 163, 163,
	163, 163, 163, 163, 163, 163, 163, 163,
	163, 163, 163, 163, 163, 163, 163, 163,
	163, 163, 163, 163, 163, 163, 163, 163,
	162, 162, 162, 162, 162, 162, 162, 162,
	162, 162, 162, 162, 162, 162, 162, 162,
	162, 162, 162, 162, 162, 162, 162, 162,
	162, 162, 162, 162, 162, 162, 162, 162,
	162, 162, 162, 162, 162, 162, 162, 162,
	162, 162, 162, 162, 162, 162, 162, 162,
	162, 162, 162, 162, 162, 162, 162, 162,
	162, 162, 162, 162, 162, 162, 162, 162,
	173, 173, 173, 173, 173, 173, 173, 173,
	173, 173, 173, 173, 173, 173, 173, 173,
	173, 173, 173, 173, 173, 173, 173, 173,
	173, 173, 173, 173, 173, 173, 173, 173,
	173, 173, 173, 173, 173, 173, 173, 173,
	173, 173, 173, 173, 173, 173, 173, 173,
	173, 173, 173, 173, 173, 173, 173, 173,
	173, 173, 173, 173, 173, 173, 173, 173,
	172, 172, 172, 172, 172, 172, 172, 172,
	172, 172, 172, 172, 172, 172, 172, 172,
	172, 172, 172, 172, 172, 172, 172, 172,
	172, 172, 172, 172, 172, 172, 172, 172,
	172, 172, 172, 172, 172, 172, 172, 172,
	172, 172, 172, 172, 172, 172, 172, 172,
	172, 172, 172, 172, 172, 172, 172, 172,
	172, 172, 172, 172, 172, 172, 172, 172,
	175, 175, 175, 175, 175, 175, 175, 175,
	175, 175, 175, 175, 175, 175, 175, 175,
	175, 175, 175, 175, 175, 175, 175, 175,
	175, 175, 175, 175, 175, 175, 175, 175,
	175, 175, 175, 175, 175, 175, 175, 175,
	175, 175, 175, 175, 175, 175, 175, 175,
	175, 175, 175, 175, 175, 175, 175, 175,
	175, 175, 175, 175, 175, 175, 175, 175,
	174, 174, 174, 174, 174, 174, 174, 174,
	174, 174, 174, 174, 174, 174, 174, 174,
	174, 174, 174, 174, 174, 174, 174, 174,
	174, 174, 174, 174, 174, 174, 174, 174,
	174, 174, 174, 174, 174, 174, 174, 174,
	174, 174, 174, 174, 174, 174, 174, 174,
	174, 174, 174, 174, 174, 174, 174, 174,
	174, 174, 174, 174, 174, 174, 174, 174,
	169, 169, 169, 169, 169, 169, 169, 169,
	169, 169, 169, 169, 169, 169, 169, 169,
	169, 169, 169, 169, 169, 169, 169, 169,
	169, 169, 169, 169, 169, 169, 169, 169,
	169, 169, 169, 169, 169, 169, 169, 169,
	169, 169, 169, 169, 169, 169, 169, 169,
	169, 169, 169, 169, 169, 169, 169, 169,
	169, 169, 169, 169, 169, 169, 169, 169,
	168, 168, 168, 168, 168, 168, 168, 168,
	168, 168, 168, 168, 168, 168, 168, 168,
	168, 168, 168, 168, 168, 168, 168, 168,
	168, 168, 168, 168, 168, 168, 168, 168,
	168, 168, 168, 168, 168, 168, 168, 168,
	168, 168, 168, 168, 168, 168, 168, 168,
	168, 168, 168, 168, 168, 168, 168, 168,
	168, 168, 168, 168, 168, 168, 168, 168,
	171, 171, 171, 171, 171, 171, 171, 171,
	171, 171, 171, 171, 171, 171, 171, 171,
	171, 171, 171, 171, 171, 171, 171, 171,
	171, 171, 171, 171, 171, 171, 171, 171,
	171, 171, 171, 171, 171, 171, 171, 171,
	171, 171, 171, 171, 171, 171, 171, 171,
	171, 171, 171, 171, 171, 171, 171, 171,
	171, 171, 171, 171, 171, 171, 171, 171,
	170, 170, 170, 170, 170, 170, 170, 170,
	170, 170, 170, 170, 170, 170, 170, 170,
	170, 170, 170, 170, 170, 170, 170, 170,
	170, 170, 170, 170, 170, 170, 170, 170,
	170, 170, 170, 170, 170, 170, 170, 170,
	170, 170, 170, 170, 170, 170, 170, 170,
	170, 170, 170, 170, 170, 170, 170, 170,
	170, 170, 170, 170, 170, 170, 170, 170,
	42, 42, 42, 42, 42, 42, 42, 42,
	42, 42, 42, 42, 42, 42, 42, 42,
	42, 42, 42, 42, 42, 42, 42, 42,
	42, 42, 42, 42, 42, 42, 42, 42,
	42, 42, 42, 42, 42, 42, 42, 42,
	42, 42, 42, 42, 42, 42, 42, 42,
	42, 42, 42, 42, 42, 42, 42, 42,
	42, 42, 42, 42, 42, 42, 42, 42,
	43, 43, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 43, 43,
	40, 40, 40, 40, 40, 40, 40, 40,
	40, 40, 40, 40, 40, 40, 40, 40,
	40, 40, 40, 40, 40, 40, 40, 40,
	40, 40, 40, 40, 40, 40, 40, 40,
	40, 40, 40, 40, 40, 40, 40, 40,
	40, 40, 40, 40, 40, 40, 40, 40,
	40, 40, 40, 40, 40, 40, 40, 40,
	40, 40, 40, 40, 40, 40, 40, 40,
	41, 41, 41, 41, 41, 41, 41, 41,
	41, 41, 41, 41, 41, 41, 41, 41,
	41, 41, 41, 41, 41, 41, 41, 41,
	41, 41, 41, 41, 41, 41, 41, 41,
	41, 41, 41, 41, 41, 41, 41, 41,
	41, 41, 41, 41, 41, 41, 41, 41,
	41, 41, 41, 41, 41, 41, 41, 41,
	41, 41, 41, 41, 41, 41, 41, 41,
	46, 46, 46, 46, 46, 46, 46, 46,
	46, 46, 46, 46, 46, 46, 46, 46,
	46, 46, 46, 46, 46, 46, 46, 46,
	46, 46, 46, 46, 46, 46, 46, 46,
	46, 46, 46, 46, 46, 46, 46, 46,
	46, 46, 46, 46, 46, 46, 46, 46,
	46, 46, 46, 46, 46, 46, 46, 46,
	46, 46, 46, 46, 46, 46, 46, 46,
	47, 47, 47, 47, 47, 47, 47, 47,
	47, 47, 47, 47, 47, 47, 47, 47,
	47, 47, 47, 47, 47, 47, 47, 47,
	47, 47, 47, 47, 47, 47, 47, 47,
	47, 47, 47, 47, 47, 47, 47, 47,
	47, 47, 47, 47, 47, 47, 47, 47,
	47, 47, 47, 47, 47, 47, 47, 47,
	47, 47, 47, 47, 47, 47, 47, 47,
	44, 44, 44, 44, 44, 44, 44, 44,
	44, 44, 44, 44, 44, 44, 44, 44,
	44, 44, 44, 44, 44, 44, 44, 44,
	44, 44, 44, 44, 44, 44, 44, 44,
	44, 44, 44, 44, 44, 44, 44, 44,
	44, 44, 44, 44, 44, 44, 44, 44,
	44, 44, 44, 44, 44, 44, 44, 44,
	44, 44, 44, 44, 44, 44, 44, 44,
	45, 45, 45, 45, 45, 45, 45, 45,
	45, 45, 45, 45, 45, 45, 45, 45,
	45, 45, 45, 45, 45, 45, 45, 45,
	45, 45, 45, 45, 45, 45, 45, 45,
	45, 45, 45, 45, 45, 45, 45, 45,
	45, 45, 45, 45, 45, 45, 45, 45,
	45, 45, 45, 45, 45, 45, 45, 45,
	45, 45, 45, 45, 45, 45, 45, 45,
	34, 34, 34, 34, 34, 34, 34, 34,
	34, 34, 34, 34, 34, 34, 34, 34,
	34, 34, 34, 34, 34, 34, 34, 34,
	34, 34, 34, 34, 34, 34, 34, 34,
	34, 34, 34, 34, 34, 34, 34, 34,
	34, 34, 34, 34, 34, 34, 34, 34,
	34, 34, 34, 34, 34, 34, 34, 34,
	34, 34, 34, 34, 34, 34, 34, 34,
	35, 35, 35, 35, 35, 35, 35, 35,
	35, 35, 35, 35, 35, 35, 35, 35,
	35, 35, 35, 35, 35, 35, 35, 35,
	35, 35, 35, 35, 35, 35, 35, 35,
	35, 35, 35, 35, 35, 35, 35, 35,
	35, 35, 35, 35, 35, 35, 35, 35,
	35, 35, 35, 35, 35, 35, 35, 35,
	35, 35, 35, 35, 35, 35, 35, 35,
	32, 32, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 32, 32,
	33, 33, 33, 33, 33, 33, 33, 33,
	33, 33, 33, 33, 33, 33, 33, 33,
	33, 33, 33, 33, 33, 33, 33, 33,
	33, 33, 33, 33, 33, 33, 33, 33,
	33, 33, 33, 33, 33, 33, 33, 33,
	33, 33, 33, 33, 33, 33, 33, 33,
	33, 33, 33, 33, 33, 33, 33, 33,
	33, 33, 33, 33, 33, 33, 33, 33,
	38, 38, 38, 38, 38, 38, 38, 38,
	38, 38, 38, 38, 38, 38, 38, 38,
	38, 38, 38, 38, 38, 38, 38, 38,
	38, 38, 38, 38, 38, 38, 38, 38,
	38, 38, 38, 38, 38, 38, 38, 38,
	38, 38, 38, 38, 38, 38, 38, 38,
	38, 38, 38, 38, 38, 38, 38, 38,
	38, 38, 38, 38, 38, 38, 38, 38,
	39, 39, 39, 39, 39, 39, 39, 39,
	39, 39, 39, 39, 39, 39, 39, 39,
	39, 39, 39, 39, 39, 39, 39, 39,
	39, 39, 39, 39, 39, 39, 39, 39,
	39, 39, 39, 39, 39, 39, 39, 39,
	39, 39, 39, 39, 39, 39, 39, 39,
	39, 39, 39, 39, 39, 39, 39, 39,
	39, 39, 39, 39, 39, 39, 39, 39,
	36, 36, 36, 36, 36, 36, 36, 36,
	36, 36, 36, 36, 36, 36, 36, 36,
	36, 36, 36, 36, 36, 36, 36, 36,
	36, 36, 36, 36, 36, 36, 36, 36,
	36, 36, 36, 36, 36, 36, 36, 36,
	36, 36, 36, 36, 36, 36, 36, 36,
	36, 36, 36, 36, 36, 36, 36, 36,
	36, 36, 36, 36, 36, 36, 36, 36,
	37, 37, 37, 37, 37, 37, 37, 37,
	37, 37, 37, 37, 37, 37, 37, 37,
	37, 37, 37, 37, 37, 37, 37, 37,
	37, 37, 37, 37, 37, 37, 37, 37,
	37, 37, 37, 37, 37, 37, 37, 37,
	37, 37, 37, 37, 37, 37, 37, 37,
	37, 37, 37, 37, 37, 37, 37, 37,
	37, 37, 37, 37, 37, 37, 37, 37,
	58, 58, 58, 58, 58, 58, 58, 58,
	58, 58, 58, 58, 58, 58, 58, 58,
	58, 58, 58, 58, 58, 58, 58, 58,
	58, 58, 58, 58, 58, 58, 58, 58,
	59, 59, 59, 59, 59, 59, 59, 59,
	59, 59, 59, 59, 59, 59, 59, 59,
	59, 59, 59, 59, 59, 59, 59, 59,
	59, 59, 59, 59, 59, 59, 59, 59,
	56, 56, 56, 56, 56, 56, 56, 56,
	56, 56, 56, 56, 56, 56, 56, 56,
	56, 56, 56, 56, 56, 56, 56, 56,
	56, 56, 56, 56, 56, 56, 56, 56,
	57, 57, 57, 57, 57, 57, 57, 57,
	57, 57, 57, 57, 57, 57, 57, 57,
	57, 57, 57, 57, 57, 57, 57, 57,
	57, 57, 57, 57, 57, 57, 57, 57,
	62, 62, 62, 62, 62, 62, 62, 62,
	62, 62, 62, 62, 62, 62, 62, 62,
	62, 62, 62, 62, 62, 62, 62, 62,
	62, 62, 62, 62, 62, 62, 62, 62,
	63, 63, 63, 63, 63, 63, 63, 63,
	63, 63, 63, 63, 63, 63, 63, 63,
	63, 63, 63, 63, 63, 63, 63, 63,
	63, 63, 63, 63, 63, 63, 63, 63,
	60, 60, 60, 60, 60, 60, 60, 60,
	60, 60, 60, 60, 60, 60, 60, 60,
	60, 60, 60, 60, 60, 60, 60, 60,
	60, 60, 60, 60, 60, 60, 60, 60,
	61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61,
	50, 50, 50, 50, 50, 50, 50, 50,
	50, 50, 50, 50, 50, 50, 50, 50,
	50, 50, 50, 50, 50, 50, 50, 50,
	50, 50, 50, 50, 50, 50, 50, 50,
	51, 51, 51, 51, 51, 51, 51, 51,
	51, 51, 51, 51, 51, 51, 51, 51,
	51, 51, 51, 51, 51, 51, 51, 51,
	51, 51, 51, 51, 51, 51, 51, 51,
	48, 48, 48, 48, 48, 48, 48, 48,
	48, 48, 48, 48, 48, 48, 48, 48,
	48, 48, 48, 48, 48, 48, 48, 48,
	48, 48, 48, 48, 48, 48, 48, 48,
	49, 49, 49, 49, 49, 49, 49, 49,
	49, 49, 49, 49, 49, 49, 49, 49,
	49, 49, 49, 49, 49, 49, 49, 49,
	49, 49, 49, 49, 49, 49, 49, 49,
	54, 54, 54, 54, 54, 54, 54, 54,
	54, 54, 54, 54, 54, 54, 54, 54,
	54, 54, 54, 54, 54, 54, 54, 54,
	54, 54, 54, 54, 54, 54, 54, 54,
	55, 55, 55, 55, 55, 55, 55, 55,
	55, 55, 55, 55, 55, 55, 55, 55,
	55, 55, 55, 55, 55, 55, 55, 55,
	55, 55, 55, 55, 55, 55, 55, 55,
	52, 52, 52, 52, 52, 52, 52, 52,
	52, 52, 52, 52, 52, 52, 52, 52,
	52, 52, 52, 52, 52, 52, 52, 52,
	52, 52, 52, 52, 52, 52, 52, 52,
	53, 53, 53, 53, 53, 53, 53, 53,
	53, 53, 53, 53, 53, 53, 53, 53,
	53, 53, 53, 53, 53, 53, 53, 53,
	53, 53, 53, 53, 53, 53, 53, 53,
	10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10,
	11, 11, 11, 11, 11, 11, 11, 11,
	11, 11, 11, 11, 11, 11, 11, 11,
	8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8,
	9, 9, 9, 9, 9, 9, 9, 9,
	9, 9, 9, 9, 9, 9, 9, 9,
	14, 14, 14, 14, 14, 14, 14, 14,
	14, 14, 14, 14, 14, 14, 14, 14,
	15, 15, 15, 15, 15, 15, 15, 15,
	15, 15, 15, 15, 15, 15, 15, 15,
	12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 12, 12, 12, 12, 12,
	13, 13, 13, 13, 13, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13,
	2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2,
	3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7,
	4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4,
	5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5,
	26, 26, 26, 26, 26, 26, 26, 26,
	27, 27, 27, 27, 27, 27, 27, 27,
	24, 24, 24, 24, 24, 24, 24, 24,
	25, 25, 25, 25, 25, 25, 25, 25,
	30, 30, 30, 30, 30, 30, 30, 30,
	31, 31, 31, 31, 31, 31, 31, 31,
	28, 28, 28, 28, 28, 28, 28, 28,
	29, 29, 29, 29, 29, 29, 29, 29,
	18, 18, 18, 18, 18, 18, 18, 18,
	19, 19, 19, 19, 19, 19, 19, 19,
	16, 16, 16, 16, 16, 16, 16, 16,
	17, 17, 17, 17, 17, 17, 17, 17,
	22, 22, 22, 22, 22, 22, 22, 22,
	23, 23, 23, 23, 23, 23, 23, 23,
	20, 20, 20, 20, 20, 20, 20, 20,
	21, 21, 21, 21, 21, 21, 21, 21,
	106, 106, 106, 106, 107, 107, 107, 107,
	104, 104, 104, 104, 105, 105, 105, 105,
	110, 110, 110, 110, 111, 111, 111, 111,
	108, 108, 108, 108, 109, 109, 109, 109,
	98, 98, 98, 98, 99, 99, 99, 99,
	96, 96, 96, 96, 97, 97, 97, 97,
	102, 102, 102, 102, 103, 103, 103, 103,
	100, 100, 100, 100, 101, 101, 101, 101,
	122, 122, 123, 123, 120, 120, 121, 121,
	126, 126, 127, 127, 124, 124, 125, 125,
	114, 114, 115, 115, 112, 112, 113, 113,
	118, 118, 119, 119, 116, 116, 117, 117,
	74, 75, 72, 73, 78, 79, 76, 77,
	66, 67, 64, 65, 70, 71, 68, 69,
	90, 91, 88, 89, 94, 95, 92, 93,
	82, 83, 80, 81, 86, 87, 84, 85
};

/* *********************************************************** */

const mlib_s8 mlib_sgn[] = {
	0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4,
	5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
	7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8
};

/* *********************************************************** */

const mlib_u8 mlib_ADPCM_mul[] = {
	67, 69, 71, 73, 75, 77, 79, 81,
	83, 85, 87, 89, 91, 93, 95, 97,
	99, 101, 103, 105, 107, 109, 111, 113,
	115, 117, 119, 121, 123, 125, 127, 129,
	69, 71, 73, 75, 77, 79, 81, 83,
	85, 87, 89, 91, 93, 95, 97, 99,
	102, 104, 106, 108, 110, 112, 114, 116,
	118, 120, 122, 124, 126, 128, 130, 132,
	71, 73, 75, 77, 79, 81, 83, 85,
	88, 90, 92, 94, 96, 98, 100, 102,
	105, 107, 109, 111, 113, 115, 117, 119,
	122, 124, 126, 128, 130, 132, 134, 136,
	73, 75, 77, 79, 81, 83, 86, 88,
	90, 92, 94, 97, 99, 101, 103, 105,
	108, 110, 112, 114, 116, 118, 121, 123,
	125, 127, 129, 132, 134, 136, 138, 140,
	75, 77, 79, 81, 84, 86, 88, 90,
	93, 95, 97, 99, 102, 104, 106, 108,
	111, 113, 115, 117, 120, 122, 124, 126,
	129, 131, 133, 135, 138, 140, 142, 144,
	77, 79, 81, 83, 86, 88, 90, 93,
	95, 97, 100, 102, 104, 107, 109, 111,
	114, 116, 118, 120, 123, 125, 127, 130,
	132, 134, 137, 139, 141, 144, 146, 148,
	79, 81, 83, 86, 88, 90, 93, 95,
	98, 100, 102, 105, 107, 109, 112, 114,
	117, 119, 121, 124, 126, 128, 131, 133,
	136, 138, 140, 143, 145, 147, 150, 152,
	81, 83, 85, 88, 90, 93, 95, 98,
	100, 102, 105, 107, 110, 112, 115, 117,
	120, 122, 124, 127, 129, 132, 134, 137,
	139, 141, 144, 146, 149, 151, 154, 156,
	83, 85, 88, 90, 93, 95, 98, 100,
	103, 105, 108, 110, 113, 115, 118, 120,
	123, 125, 128, 130, 133, 135, 138, 140,
	143, 145, 148, 150, 153, 155, 158, 160,
	85, 87, 90, 92, 95, 97, 100, 102,
	105, 108, 110, 113, 115, 118, 120, 123,
	126, 128, 131, 133, 136, 138, 141, 143,
	146, 149, 151, 154, 156, 159, 161, 164,
	87, 89, 92, 94, 97, 100, 102, 105,
	108, 110, 113, 115, 118, 121, 123, 126,
	129, 131, 134, 136, 139, 142, 144, 147,
	150, 152, 155, 157, 160, 163, 165, 168,
	89, 91, 94, 97, 99, 102, 105, 107,
	110, 113, 115, 118, 121, 123, 126, 129,
	132, 134, 137, 140, 142, 145, 148, 150,
	153, 156, 158, 161, 164, 166, 169, 172,
	91, 93, 96, 99, 102, 104, 107, 110,
	113, 115, 118, 121, 124, 126, 129, 132,
	135, 137, 140, 143, 146, 148, 151, 154,
	157, 159, 162, 165, 168, 170, 173, 176,
	93, 95, 98, 101, 104, 107, 109, 112,
	115, 118, 121, 123, 126, 129, 132, 135,
	138, 140, 143, 146, 149, 152, 154, 157,
	160, 163, 166, 168, 171, 174, 177, 180,
	95, 97, 100, 103, 106, 109, 112, 115,
	118, 120, 123, 126, 129, 132, 135, 138,
	141, 143, 146, 149, 152, 155, 158, 161,
	164, 166, 169, 172, 175, 178, 181, 184,
	97, 99, 102, 105, 108, 111, 114, 117,
	120, 123, 126, 129, 132, 135, 138, 141,
	144, 146, 149, 152, 155, 158, 161, 164,
	167, 170, 173, 176, 179, 182, 185, 188,
	99, 102, 105, 108, 111, 114, 117, 120,
	123, 126, 129, 132, 135, 138, 141, 144,
	147, 150, 153, 156, 159, 162, 165, 168,
	171, 174, 177, 180, 183, 186, 189, 192,
	101, 104, 107, 110, 113, 116, 119, 122,
	125, 128, 131, 134, 137, 140, 143, 146,
	150, 153, 156, 159, 162, 165, 168, 171,
	174, 177, 180, 183, 186, 189, 192, 195,
	103, 106, 109, 112, 115, 118, 121, 124,
	128, 131, 134, 137, 140, 143, 146, 149,
	153, 156, 159, 162, 165, 168, 171, 174,
	178, 181, 184, 187, 190, 193, 196, 199,
	105, 108, 111, 114, 117, 120, 124, 127,
	130, 133, 136, 140, 143, 146, 149, 152,
	156, 159, 162, 165, 168, 171, 175, 178,
	181, 184, 187, 191, 194, 197, 200, 203,
	107, 110, 113, 116, 120, 123, 126, 129,
	133, 136, 139, 142, 146, 149, 152, 155,
	159, 162, 165, 168, 172, 175, 178, 181,
	185, 188, 191, 194, 198, 201, 204, 207,
	109, 112, 115, 118, 122, 125, 128, 132,
	135, 138, 142, 145, 148, 152, 155, 158,
	162, 165, 168, 171, 175, 178, 181, 185,
	188, 191, 195, 198, 201, 205, 208, 211,
	111, 114, 117, 121, 124, 127, 131, 134,
	138, 141, 144, 148, 151, 154, 158, 161,
	165, 168, 171, 175, 178, 181, 185, 188,
	192, 195, 198, 202, 205, 208, 212, 215,
	113, 116, 119, 123, 126, 130, 133, 137,
	140, 143, 147, 150, 154, 157, 161, 164,
	168, 171, 174, 178, 181, 185, 188, 192,
	195, 198, 202, 205, 209, 212, 216, 219,
	115, 118, 122, 125, 129, 132, 136, 139,
	143, 146, 150, 153, 157, 160, 164, 167,
	171, 174, 178, 181, 185, 188, 192, 195,
	199, 202, 206, 209, 213, 216, 220, 223,
	117, 120, 124, 127, 131, 134, 138, 141,
	145, 149, 152, 156, 159, 163, 166, 170,
	174, 177, 181, 184, 188, 191, 195, 198,
	202, 206, 209, 213, 216, 220, 223, 227,
	119, 122, 126, 129, 133, 137, 140, 144,
	148, 151, 155, 158, 162, 166, 169, 173,
	177, 180, 184, 187, 191, 195, 198, 202,
	206, 209, 213, 216, 220, 224, 227, 231,
	121, 124, 128, 132, 135, 139, 143, 146,
	150, 154, 157, 161, 165, 168, 172, 176,
	180, 183, 187, 191, 194, 198, 202, 205,
	209, 213, 216, 220, 224, 227, 231, 235,
	123, 126, 130, 134, 138, 141, 145, 149,
	153, 156, 160, 164, 168, 171, 175, 179,
	183, 186, 190, 194, 198, 201, 205, 209,
	213, 216, 220, 224, 228, 231, 235, 239,
	125, 128, 132, 136, 140, 144, 147, 151,
	155, 159, 163, 166, 170, 174, 178, 182,
	186, 189, 193, 197, 201, 205, 208, 212,
	216, 220, 224, 227, 231, 235, 239, 243,
	127, 130, 134, 138, 142, 146, 150, 154,
	158, 161, 165, 169, 173, 177, 181, 185,
	189, 192, 196, 200, 204, 208, 212, 216,
	220, 223, 227, 231, 235, 239, 243, 247,
	129, 132, 136, 140, 144, 148, 152, 156,
	160, 164, 168, 172, 176, 180, 184, 188,
	192, 195, 199, 203, 207, 211, 215, 219,
	223, 227, 231, 235, 239, 243, 247, 251
};

/* *********************************************************** */
