/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mail.internet;

import jakarta.mail.internet.HeaderTokenizer;
import jakarta.mail.internet.ParameterList;
import jakarta.mail.internet.ParseException;

public class ContentDisposition {
    private String _disposition;
    private ParameterList _list;

    public ContentDisposition() {
        this.setDisposition(null);
        this.setParameterList(null);
    }

    public ContentDisposition(String disposition) throws ParseException {
        HeaderTokenizer tokenizer = new HeaderTokenizer(disposition, "()<>@,;:\\\"\t []/?=");
        HeaderTokenizer.Token token = tokenizer.next();
        if (token.getType() != -1) {
            throw new ParseException("Invalid content disposition");
        }
        this._disposition = token.getValue();
        String remainder = tokenizer.getRemainder();
        if (remainder != null) {
            this._list = new ParameterList(remainder);
        }
    }

    public ContentDisposition(String disposition, ParameterList list) {
        this.setDisposition(disposition);
        this.setParameterList(list);
    }

    public String getDisposition() {
        return this._disposition;
    }

    public String getParameter(String name) {
        if (this._list == null) {
            return null;
        }
        return this._list.get(name);
    }

    public ParameterList getParameterList() {
        return this._list;
    }

    public void setDisposition(String string) {
        this._disposition = string;
    }

    public void setParameter(String name, String value) {
        if (this._list == null) {
            this._list = new ParameterList();
        }
        this._list.set(name, value);
    }

    public void setParameterList(ParameterList list) {
        this._list = list == null ? new ParameterList() : list;
    }

    public String toString() {
        if (this._disposition == null) {
            return "";
        }
        if (this._list == null) {
            return this._disposition;
        }
        return this._disposition + this._list.toString("Content-Disposition".length() + this._disposition.length());
    }
}

