/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.io;

import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import relocated_for_contentpackage.javax.jcr.Node;
import relocated_for_contentpackage.javax.jcr.NodeIterator;
import relocated_for_contentpackage.javax.jcr.Property;
import relocated_for_contentpackage.javax.jcr.PropertyIterator;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.javax.jcr.Session;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.ImportInfo;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.ImportMode;

public class NodeStash {
    static final Logger log = LoggerFactory.getLogger(NodeStash.class);
    private final Session session;
    private final String path;
    private final ImportMode importMode;
    private Node tmpNode;
    private final Set<String> excludedNodeName = new HashSet<String>();
    private static final String[] ROOTS = new String[]{"/", "/tmp", "/var", "/etc", "/content"};

    public NodeStash(Session session, String path, ImportMode importMode) {
        this.session = session;
        this.path = path;
        this.importMode = importMode;
    }

    private Node getOrCreateTemporaryNode() throws RepositoryException {
        if (this.tmpNode != null) {
            return this.tmpNode;
        }
        for (String rootPath : ROOTS) {
            try {
                Node root = this.session.getNode(rootPath);
                this.tmpNode = root.addNode("tmp" + System.currentTimeMillis(), "nt:unstructured");
                return this.tmpNode;
            }
            catch (RepositoryException e) {
                log.debug("unable to create temporary stash location below {}.", (Object)rootPath);
            }
        }
        throw new RepositoryException("Unable to create temporary root below.");
    }

    public NodeStash excludeName(String name) {
        this.excludedNodeName.add(name);
        return this;
    }

    public void stash() {
        if (this.importMode == ImportMode.REPLACE) {
            return;
        }
        try {
            Node parent = this.session.getNode(this.path);
            Node tmp = this.getOrCreateTemporaryNode();
            NodeIterator nodeIterator = parent.getNodes();
            while (nodeIterator.hasNext()) {
                Node child = nodeIterator.nextNode();
                String name = child.getName();
                if (this.excludedNodeName.contains(name)) {
                    log.debug("skipping excluded child node from stash: {}", (Object)child.getPath());
                    continue;
                }
                try {
                    this.session.move(child.getPath(), tmp.getPath() + "/" + name);
                }
                catch (RepositoryException e) {
                    log.error("Error while moving child node to temporary location. Child will be removed.", (Throwable)e);
                }
            }
            PropertyIterator propIterator = parent.getProperties();
            while (propIterator.hasNext()) {
                Property property = propIterator.nextProperty();
                if (property.getDefinition().isProtected()) continue;
                if (property.isMultiple()) {
                    tmp.setProperty(property.getName(), property.getValues(), property.getType());
                    continue;
                }
                tmp.setProperty(property.getName(), property.getValue(), property.getType());
            }
        }
        catch (RepositoryException e) {
            log.warn("error while moving child nodes (ignored)", (Throwable)e);
        }
    }

    public void recover(@Nullable ImportInfo importInfo) throws RepositoryException {
        if (this.tmpNode != null) {
            boolean hasErrors;
            block8: {
                Node parent = this.session.getNode(this.path);
                NodeIterator iter = this.tmpNode.getNodes();
                hasErrors = false;
                while (iter.hasNext()) {
                    Node child = iter.nextNode();
                    String newPath = parent.getPath() + "/" + child.getName();
                    try {
                        if (this.session.nodeExists(newPath)) {
                            log.debug("Skipping restore from temporary location {} as node already exists at {}", (Object)child.getPath(), (Object)newPath);
                            continue;
                        }
                        this.session.move(child.getPath(), newPath);
                    }
                    catch (RepositoryException e) {
                        log.warn("Unable to move child back to new location at {} due to: {}. Node will remain in temporary location: {}", new Object[]{newPath, e.getMessage(), child.getPath()});
                        if (importInfo == null) continue;
                        importInfo.onError(newPath, e);
                        hasErrors = true;
                    }
                }
                try {
                    this.recoverProperties(this.importMode == ImportMode.MERGE || this.importMode == ImportMode.MERGE_PROPERTIES);
                }
                catch (RepositoryException e) {
                    log.warn("Unable to restore properties at {} due to: {}. Properties will remain in temporary location: {}", new Object[]{this.path, e.getMessage(), this.tmpNode.getPath()});
                    if (importInfo == null) break block8;
                    importInfo.onError(this.path, e);
                    hasErrors = true;
                }
            }
            if (!hasErrors) {
                this.tmpNode.remove();
            }
        }
    }

    private void recoverProperties(boolean overwriteNewOnes) throws RepositoryException {
        PropertyIterator propIterator = this.tmpNode.getProperties();
        Node destNode = this.session.getNode(this.path);
        while (propIterator.hasNext()) {
            Property property = propIterator.nextProperty();
            if (property.getDefinition().isProtected()) continue;
            if (!overwriteNewOnes && destNode.hasProperty(property.getName())) {
                log.debug("Skipping restore property {} as it has been updated", (Object)property.getPath());
                continue;
            }
            if (property.isMultiple()) {
                destNode.setProperty(property.getName(), property.getValues(), property.getType());
                continue;
            }
            destNode.setProperty(property.getName(), property.getValue(), property.getType());
        }
    }
}

