/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc.impl;

import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.InvocationException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamFactory;
import com.google.gwt.user.client.rpc.SerializationStreamReader;
import com.google.gwt.user.client.rpc.StatusCodeException;
import com.google.gwt.user.client.rpc.impl.RemoteServiceProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestCallbackAdapter<T>
implements RequestCallback {
    private final AsyncCallback<T> callback;
    private final String methodName;
    private final int requestId;
    private final ResponseReader responseReader;
    private final SerializationStreamFactory streamFactory;

    public RequestCallbackAdapter(SerializationStreamFactory streamFactory, String methodName, int requestId, AsyncCallback<T> callback, ResponseReader responseReader) {
        assert (streamFactory != null);
        assert (callback != null);
        assert (responseReader != null);
        this.streamFactory = streamFactory;
        this.callback = callback;
        this.methodName = methodName;
        this.requestId = requestId;
        this.responseReader = responseReader;
    }

    public void onError(Request request, Throwable exception) {
        this.callback.onFailure(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void onResponseReceived(Request request, Response response) {
        boolean toss;
        block13: {
            Throwable caught;
            Object result;
            block12: {
                result = null;
                caught = null;
                try {
                    boolean toss2;
                    String encodedResponse = response.getText();
                    int statusCode = response.getStatusCode();
                    boolean bl = toss2 = RemoteServiceProxy.isStatsAvailable() && RemoteServiceProxy.stats(RemoteServiceProxy.bytesStat(this.methodName, this.requestId, encodedResponse.length(), "responseReceived"));
                    if (statusCode != 200) {
                        caught = new StatusCodeException(statusCode, encodedResponse);
                        break block12;
                    }
                    if (encodedResponse == null) {
                        caught = new InvocationException("No response payload");
                        break block12;
                    }
                    if (RemoteServiceProxy.isReturnValue(encodedResponse)) {
                        result = this.responseReader.read(this.streamFactory.createStreamReader(encodedResponse));
                        break block12;
                    }
                    caught = RemoteServiceProxy.isThrownException(encodedResponse) ? (Throwable)this.streamFactory.createStreamReader(encodedResponse).readObject() : new InvocationException(encodedResponse);
                }
                catch (SerializationException e) {
                    caught = new IncompatibleRemoteServiceException("The response could not be deserialized", e);
                    toss = RemoteServiceProxy.isStatsAvailable() && RemoteServiceProxy.stats(RemoteServiceProxy.timeStat(this.methodName, this.requestId, "responseDeserialized"));
                }
                catch (Throwable e2) {
                    caught = e2;
                    {
                        catch (Throwable throwable) {
                            boolean toss3 = RemoteServiceProxy.isStatsAvailable() && RemoteServiceProxy.stats(RemoteServiceProxy.timeStat(this.methodName, this.requestId, "responseDeserialized"));
                            throw throwable;
                        }
                    }
                    toss = RemoteServiceProxy.isStatsAvailable() && RemoteServiceProxy.stats(RemoteServiceProxy.timeStat(this.methodName, this.requestId, "responseDeserialized"));
                }
            }
            toss = RemoteServiceProxy.isStatsAvailable() && RemoteServiceProxy.stats(RemoteServiceProxy.timeStat(this.methodName, this.requestId, "responseDeserialized"));
            try {
                if (caught == null) {
                    this.callback.onSuccess(result);
                    break block13;
                }
                this.callback.onFailure(caught);
            }
            catch (Throwable throwable) {
                boolean toss4 = RemoteServiceProxy.isStatsAvailable() && RemoteServiceProxy.stats(RemoteServiceProxy.timeStat(this.methodName, this.requestId, "end"));
                throw throwable;
            }
        }
        toss = RemoteServiceProxy.isStatsAvailable() && RemoteServiceProxy.stats(RemoteServiceProxy.timeStat(this.methodName, this.requestId, "end"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResponseReader {
        BOOLEAN{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readBoolean();
            }
        }
        ,
        BYTE{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readByte();
            }
        }
        ,
        CHAR{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return Character.valueOf(streamReader.readChar());
            }
        }
        ,
        DOUBLE{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readDouble();
            }
        }
        ,
        FLOAT{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return Float.valueOf(streamReader.readFloat());
            }
        }
        ,
        INT{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readInt();
            }
        }
        ,
        LONG{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readLong();
            }
        }
        ,
        OBJECT{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readObject();
            }
        }
        ,
        SHORT{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readShort();
            }
        }
        ,
        STRING{

            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readString();
            }
        }
        ,
        VOID{

            public Object read(SerializationStreamReader streamReader) {
                return null;
            }
        };


        public abstract Object read(SerializationStreamReader var1) throws SerializationException;
    }
}

