/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.message;

import apache.rocketmq.v2.Resource;
import apache.rocketmq.v2.SystemProperties;
import com.google.protobuf.ByteString;
import com.google.protobuf.util.Timestamps;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.message.MessageId;
import org.apache.rocketmq.client.java.impl.producer.PublishingSettings;
import org.apache.rocketmq.client.java.message.MessageIdCodec;
import org.apache.rocketmq.client.java.message.MessageImpl;
import org.apache.rocketmq.client.java.message.MessageType;
import org.apache.rocketmq.client.java.message.protocol.Encoding;
import org.apache.rocketmq.client.java.misc.Utilities;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;

public class PublishingMessageImpl
extends MessageImpl {
    private final MessageId messageId;
    private final MessageType messageType;

    public PublishingMessageImpl(Message message, PublishingSettings publishingSettings, boolean txEnabled) throws IOException {
        super(message);
        int length = message.getBody().remaining();
        int maxBodySizeBytes = publishingSettings.getMaxBodySizeBytes();
        if (length > maxBodySizeBytes) {
            throw new IOException("Message body size exceeds the threshold, max size=" + maxBodySizeBytes + " bytes");
        }
        this.messageId = MessageIdCodec.getInstance().nextMessageId();
        if (!(message.getMessageGroup().isPresent() || message.getDeliveryTimestamp().isPresent() || txEnabled)) {
            this.messageType = MessageType.NORMAL;
            return;
        }
        if (message.getMessageGroup().isPresent() && !txEnabled) {
            this.messageType = MessageType.FIFO;
            return;
        }
        if (message.getDeliveryTimestamp().isPresent() && !txEnabled) {
            this.messageType = MessageType.DELAY;
            return;
        }
        if (!message.getMessageGroup().isPresent() && !message.getDeliveryTimestamp().isPresent() && txEnabled) {
            this.messageType = MessageType.TRANSACTION;
            return;
        }
        throw new IllegalArgumentException("Transactional message should not set messageGroup or deliveryTimestamp");
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public apache.rocketmq.v2.Message toProtobuf(MessageQueueImpl mq) {
        SystemProperties.Builder systemPropertiesBuilder = SystemProperties.newBuilder().addAllKeys((Iterable)this.keys).setMessageId(this.messageId.toString()).setBornTimestamp(Timestamps.fromMillis((long)System.currentTimeMillis())).setBornHost(Utilities.hostName()).setBodyEncoding(Encoding.toProtobuf(Encoding.IDENTITY)).setQueueId(mq.getQueueId()).setMessageType(MessageType.toProtobuf(this.messageType));
        this.getTag().ifPresent(arg_0 -> ((SystemProperties.Builder)systemPropertiesBuilder).setTag(arg_0));
        this.getDeliveryTimestamp().ifPresent(millis -> systemPropertiesBuilder.setDeliveryTimestamp(Timestamps.fromMillis((long)millis)));
        this.getMessageGroup().ifPresent(arg_0 -> ((SystemProperties.Builder)systemPropertiesBuilder).setMessageGroup(arg_0));
        SystemProperties systemProperties = systemPropertiesBuilder.build();
        Resource topicResource = Resource.newBuilder().setName(this.getTopic()).build();
        return apache.rocketmq.v2.Message.newBuilder().setTopic(topicResource).setBody(ByteString.copyFrom((ByteBuffer)this.getBody())).setSystemProperties(systemProperties).putAllUserProperties(this.getProperties()).build();
    }
}

