/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.ProtocolDetectionResult;
import io.netty.handler.codec.ProtocolDetectionState;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionalProxyProtocolDecoder
extends ChannelInboundHandlerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OptionalProxyProtocolDecoder.class);
    public static final String NAME = "optional-proxy-protocol-decoder";
    public static final int MIN_BYTES_SIZE_TO_DETECT_PROTOCOL = 12;
    private CompositeByteBuf cumulatedByteBuf;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            ProtocolDetectionResult result;
            ByteBuf buf = (ByteBuf)msg;
            if (this.cumulatedByteBuf != null) {
                buf = this.cumulatedByteBuf.addComponent(true, buf);
            }
            if ((result = HAProxyMessageDecoder.detectProtocol((ByteBuf)buf)).state() == ProtocolDetectionState.NEEDS_MORE_DATA) {
                if (this.cumulatedByteBuf == null) {
                    this.cumulatedByteBuf = new CompositeByteBuf(ctx.alloc(), false, 12, new ByteBuf[]{buf});
                }
                return;
            }
            this.cumulatedByteBuf = null;
            if (result.state() == ProtocolDetectionState.DETECTED) {
                ctx.pipeline().addAfter(NAME, null, (ChannelHandler)new HAProxyMessageDecoder());
            }
            ctx.pipeline().remove((ChannelHandler)this);
            super.channelRead(ctx, (Object)buf);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (this.cumulatedByteBuf != null) {
            log.info("Release cumulated byte buffer when channel inactive.");
            this.cumulatedByteBuf = null;
        }
    }
}

