/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Code generated by code-generation. DO NOT EDIT.
using org.apache.plc4net.types;

namespace org.apache.plc4net.drivers.knxnetip.readwrite.model
{

    public enum KnxInterfaceObjectProperty
    {
        PID_UNKNOWN = 0,
        PID_GENERAL_OBJECT_TYPE = 1,
        PID_GENERAL_OBJECT_NAME = 2,
        PID_GENERAL_SEMAPHOR = 3,
        PID_GENERAL_GROUP_OBJECT_REFERENCE = 4,
        PID_GENERAL_LOAD_STATE_CONTROL = 5,
        PID_GENERAL_RUN_STATE_CONTROL = 6,
        PID_GENERAL_TABLE_REFERENCE = 7,
        PID_GENERAL_SERVICE_CONTROL = 8,
        PID_GENERAL_FIRMWARE_REVISION = 9,
        PID_GENERAL_SERVICES_SUPPORTED = 10,
        PID_GENERAL_SERIAL_NUMBER = 11,
        PID_GENERAL_MANUFACTURER_ID = 12,
        PID_GENERAL_PROGRAM_VERSION = 13,
        PID_GENERAL_DEVICE_CONTROL = 14,
        PID_GENERAL_ORDER_INFO = 15,
        PID_GENERAL_PEI_TYPE = 16,
        PID_GENERAL_PORT_CONFIGURATION = 17,
        PID_GENERAL_POLL_GROUP_SETTINGS = 18,
        PID_GENERAL_MANUFACTURER_DATA = 19,
        PID_GENERAL_ENABLE = 20,
        PID_GENERAL_DESCRIPTION = 21,
        PID_GENERAL_FILE = 22,
        PID_GENERAL_TABLE = 23,
        PID_GENERAL_ENROL = 24,
        PID_GENERAL_VERSION = 25,
        PID_GENERAL_GROUP_OBJECT_LINK = 26,
        PID_GENERAL_MCB_TABLE = 27,
        PID_GENERAL_ERROR_CODE = 28,
        PID_GENERAL_OBJECT_INDEX = 29,
        PID_GENERAL_DOWNLOAD_COUNTER = 30,
        PID_DEVICE_ROUTING_COUNT = 31,
        PID_DEVICE_MAX_RETRY_COUNT = 32,
        PID_DEVICE_ERROR_FLAGS = 33,
        PID_DEVICE_PROGMODE = 34,
        PID_DEVICE_PRODUCT_ID = 35,
        PID_DEVICE_MAX_APDULENGTH = 36,
        PID_DEVICE_SUBNET_ADDR = 37,
        PID_DEVICE_DEVICE_ADDR = 38,
        PID_DEVICE_PB_CONFIG = 39,
        PID_DEVICE_ADDR_REPORT = 40,
        PID_DEVICE_ADDR_CHECK = 41,
        PID_DEVICE_OBJECT_VALUE = 42,
        PID_DEVICE_OBJECTLINK = 43,
        PID_DEVICE_APPLICATION = 44,
        PID_DEVICE_PARAMETER = 45,
        PID_DEVICE_OBJECTADDRESS = 46,
        PID_DEVICE_PSU_TYPE = 47,
        PID_DEVICE_PSU_STATUS = 48,
        PID_DEVICE_PSU_ENABLE = 49,
        PID_DEVICE_DOMAIN_ADDRESS = 50,
        PID_DEVICE_IO_LIST = 51,
        PID_DEVICE_MGT_DESCRIPTOR_01 = 52,
        PID_DEVICE_PL110_PARAM = 53,
        PID_DEVICE_RF_REPEAT_COUNTER = 54,
        PID_DEVICE_RECEIVE_BLOCK_TABLE = 55,
        PID_DEVICE_RANDOM_PAUSE_TABLE = 56,
        PID_DEVICE_RECEIVE_BLOCK_NR = 57,
        PID_DEVICE_HARDWARE_TYPE = 58,
        PID_DEVICE_RETRANSMITTER_NUMBER = 59,
        PID_DEVICE_SERIAL_NR_TABLE = 60,
        PID_DEVICE_BIBATMASTER_ADDRESS = 61,
        PID_DEVICE_RF_DOMAIN_ADDRESS = 62,
        PID_DEVICE_DEVICE_DESCRIPTOR = 63,
        PID_DEVICE_METERING_FILTER_TABLE = 64,
        PID_DEVICE_GROUP_TELEGR_RATE_LIMIT_TIME_BASE = 65,
        PID_DEVICE_GROUP_TELEGR_RATE_LIMIT_NO_OF_TELEGR = 66,
        PID_GROUP_OBJECT_TABLE_GRPOBJTABLE = 67,
        PID_GROUP_OBJECT_TABLE_EXT_GRPOBJREFERENCE = 68,
        PID_ROUTER_LINE_STATUS = 69,
        PID_ROUTER_MAIN_LCCONFIG = 70,
        PID_ROUTER_SUB_LCCONFIG = 71,
        PID_ROUTER_MAIN_LCGRPCONFIG = 72,
        PID_ROUTER_SUB_LCGRPCONFIG = 73,
        PID_ROUTER_ROUTETABLE_CONTROL = 74,
        PID_ROUTER_COUPL_SERV_CONTROL = 75,
        PID_ROUTER_MAX_ROUTER_APDU_LENGTH = 76,
        PID_ROUTER_MEDIUM = 77,
        PID_ROUTER_FILTER_TABLE_USE = 78,
        PID_ROUTER_RF_ENABLE_SBC = 79,
        PID_KNXIP_PARAMETER_PROJECT_INSTALLATION_ID = 80,
        PID_KNXIP_PARAMETER_KNX_INDIVIDUAL_ADDRESS = 81,
        PID_KNXIP_PARAMETER_ADDITIONAL_INDIVIDUAL_ADDRESSES = 82,
        PID_KNXIP_PARAMETER_CURRENT_IP_ASSIGNMENT_METHOD = 83,
        PID_KNXIP_PARAMETER_IP_ASSIGNMENT_METHOD = 84,
        PID_KNXIP_PARAMETER_IP_CAPABILITIES = 85,
        PID_KNXIP_PARAMETER_CURRENT_IP_ADDRESS = 86,
        PID_KNXIP_PARAMETER_CURRENT_SUBNET_MASK = 87,
        PID_KNXIP_PARAMETER_CURRENT_DEFAULT_GATEWAY = 88,
        PID_KNXIP_PARAMETER_IP_ADDRESS = 89,
        PID_KNXIP_PARAMETER_SUBNET_MASK = 90,
        PID_KNXIP_PARAMETER_DEFAULT_GATEWAY = 91,
        PID_KNXIP_PARAMETER_DHCP_BOOTP_SERVER = 92,
        PID_KNXIP_PARAMETER_MAC_ADDRESS = 93,
        PID_KNXIP_PARAMETER_SYSTEM_SETUP_MULTICAST_ADDRESS = 94,
        PID_KNXIP_PARAMETER_ROUTING_MULTICAST_ADDRESS = 95,
        PID_KNXIP_PARAMETER_TTL = 96,
        PID_KNXIP_PARAMETER_KNXNETIP_DEVICE_CAPABILITIES = 97,
        PID_KNXIP_PARAMETER_KNXNETIP_DEVICE_STATE = 98,
        PID_KNXIP_PARAMETER_KNXNETIP_ROUTING_CAPABILITIES = 99,
        PID_KNXIP_PARAMETER_PRIORITY_FIFO_ENABLED = 100,
        PID_KNXIP_PARAMETER_QUEUE_OVERFLOW_TO_IP = 101,
        PID_KNXIP_PARAMETER_QUEUE_OVERFLOW_TO_KNX = 102,
        PID_KNXIP_PARAMETER_MSG_TRANSMIT_TO_IP = 103,
        PID_KNXIP_PARAMETER_MSG_TRANSMIT_TO_KNX = 104,
        PID_KNXIP_PARAMETER_FRIENDLY_NAME = 105,
        PID_KNXIP_PARAMETER_BACKBONE_KEY = 106,
        PID_KNXIP_PARAMETER_DEVICE_AUTHENTICATION_CODE = 107,
        PID_KNXIP_PARAMETER_PASSWORD_HASHES = 108,
        PID_KNXIP_PARAMETER_SECURED_SERVICE_FAMILIES = 109,
        PID_KNXIP_PARAMETER_MULTICAST_LATENCY_TOLERANCE = 110,
        PID_KNXIP_PARAMETER_SYNC_LATENCY_FRACTION = 111,
        PID_KNXIP_PARAMETER_TUNNELLING_USERS = 112,
        PID_SECURITY_SECURITY_MODE = 113,
        PID_SECURITY_P2P_KEY_TABLE = 114,
        PID_SECURITY_GRP_KEY_TABLE = 115,
        PID_SECURITY_SECURITY_INDIVIDUAL_ADDRESS_TABLE = 116,
        PID_SECURITY_SECURITY_FAILURES_LOG = 117,
        PID_SECURITY_SKI_TOOL = 118,
        PID_SECURITY_SECURITY_REPORT = 119,
        PID_SECURITY_SECURITY_REPORT_CONTROL = 120,
        PID_SECURITY_SEQUENCE_NUMBER_SENDING = 121,
        PID_SECURITY_ZONE_KEYS_TABLE = 122,
        PID_SECURITY_GO_SECURITY_FLAGS = 123,
        PID_RF_MEDIUM_RF_MULTI_TYPE = 124,
        PID_RF_MEDIUM_RF_DOMAIN_ADDRESS = 125,
        PID_RF_MEDIUM_RF_RETRANSMITTER = 126,
        PID_RF_MEDIUM_SECURITY_REPORT_CONTROL = 127,
        PID_RF_MEDIUM_RF_FILTERING_MODE_SELECT = 128,
        PID_RF_MEDIUM_RF_BIDIR_TIMEOUT = 129,
        PID_RF_MEDIUM_RF_DIAG_SA_FILTER_TABLE = 130,
        PID_RF_MEDIUM_RF_DIAG_QUALITY_TABLE = 131,
        PID_RF_MEDIUM_RF_DIAG_PROBE = 132,
        PID_INDOOR_BRIGHTNESS_SENSOR_CHANGE_OF_VALUE = 133,
        PID_INDOOR_BRIGHTNESS_SENSOR_REPETITION_TIME = 134,
        PID_INDOOR_LUMINANCE_SENSOR_CHANGE_OF_VALUE = 135,
        PID_INDOOR_LUMINANCE_SENSOR_REPETITION_TIME = 136,
        PID_LIGHT_SWITCHING_ACTUATOR_BASIC_ON_DELAY = 137,
        PID_LIGHT_SWITCHING_ACTUATOR_BASIC_OFF_DELAY = 138,
        PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TIMED_ON_DURATION = 139,
        PID_LIGHT_SWITCHING_ACTUATOR_BASIC_PREWARNING_DURATION = 140,
        PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TRANSMISSION_CYCLE_TIME = 141,
        PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BUS_POWER_UP_MESSAGE_DELAY = 142,
        PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_AT_LOCKING = 143,
        PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_AT_UNLOCKING = 144,
        PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP = 145,
        PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_DOWN = 146,
        PID_LIGHT_SWITCHING_ACTUATOR_BASIC_INVERT_OUTPUT_STATE = 147,
        PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TIMED_ON_RETRIGGER_FUNCTION = 148,
        PID_LIGHT_SWITCHING_ACTUATOR_BASIC_MANUAL_OFF_ENABLE = 149,
        PID_LIGHT_SWITCHING_ACTUATOR_BASIC_INVERT_LOCK_DEVICE = 150,
        PID_LIGHT_SWITCHING_ACTUATOR_BASIC_LOCK_STATE = 151,
        PID_LIGHT_SWITCHING_ACTUATOR_BASIC_UNLOCK_STATE = 152,
        PID_LIGHT_SWITCHING_ACTUATOR_BASIC_STATE_FOR_SCENE_NUMBER = 153,
        PID_LIGHT_SWITCHING_ACTUATOR_BASIC_STORAGE_FUNCTION_FOR_SCENE = 154,
        PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BUS_POWER_UP_STATE = 155,
        PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP_2 = 156,
        PID_DIMMING_ACTUATOR_BASIC_ON_DELAY = 157,
        PID_DIMMING_ACTUATOR_BASIC_OFF_DELAY = 158,
        PID_DIMMING_ACTUATOR_BASIC_SWITCH_OFF_BRIGHTNESS_DELAY_TIME = 159,
        PID_DIMMING_ACTUATOR_BASIC_TIMED_ON_DURATION = 160,
        PID_DIMMING_ACTUATOR_BASIC_PREWARNING_DURATION = 161,
        PID_DIMMING_ACTUATOR_BASIC_TRANSMISSION_CYCLE_TIME = 162,
        PID_DIMMING_ACTUATOR_BASIC_BUS_POWER_UP_MESSAGE_DELAY = 163,
        PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED = 164,
        PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME = 165,
        PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED_FOR_SWITCH_ON_SET_VALUE = 166,
        PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED_FOR_SWITCH_OFF = 167,
        PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME_FOR_SWITCH_ON_SET_VALUE = 168,
        PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME_FOR_SWITCH_OFF = 169,
        PID_DIMMING_ACTUATOR_BASIC_SWITCFH_OFF_BRIGHTNESS = 170,
        PID_DIMMING_ACTUATOR_BASIC_MINIMUM_SET_VALUE = 171,
        PID_DIMMING_ACTUATOR_BASIC_MAXIMUM_SET_VALUE = 172,
        PID_DIMMING_ACTUATOR_BASIC_SWITCH_ON_SET_VALUE = 173,
        PID_DIMMING_ACTUATOR_BASIC_DIMM_MODE_SELECTION = 174,
        PID_DIMMING_ACTUATOR_BASIC_RELATIV_OFF_ENABLE = 175,
        PID_DIMMING_ACTUATOR_BASIC_MEMORY_FUNCTION = 176,
        PID_DIMMING_ACTUATOR_BASIC_TIMED_ON_RETRIGGER_FUNCTION = 177,
        PID_DIMMING_ACTUATOR_BASIC_MANUAL_OFF_ENABLE = 178,
        PID_DIMMING_ACTUATOR_BASIC_INVERT_LOCK_DEVICE = 179,
        PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_AT_LOCKING = 180,
        PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_AT_UNLOCKING = 181,
        PID_DIMMING_ACTUATOR_BASIC_LOCK_SETVALUE = 182,
        PID_DIMMING_ACTUATOR_BASIC_UNLOCK_SETVALUE = 183,
        PID_DIMMING_ACTUATOR_BASIC_BIGHTNESS_FOR_SCENE = 184,
        PID_DIMMING_ACTUATOR_BASIC_STORAGE_FUNCTION_FOR_SCENE = 185,
        PID_DIMMING_ACTUATOR_BASIC_DELTA_DIMMING_VALUE = 186,
        PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP = 187,
        PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP_SET_VALUE = 188,
        PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_DOWN = 189,
        PID_DIMMING_ACTUATOR_BASIC_BUS_POWER_DOWN_SET_VALUE = 190,
        PID_DIMMING_SENSOR_BASIC_ON_OFF_ACTION = 191,
        PID_DIMMING_SENSOR_BASIC_ENABLE_TOGGLE_MODE = 192,
        PID_DIMMING_SENSOR_BASIC_ABSOLUTE_SETVALUE = 193,
        PID_SWITCHING_SENSOR_BASIC_ON_OFF_ACTION = 194,
        PID_SWITCHING_SENSOR_BASIC_ENABLE_TOGGLE_MODE = 195,
        PID_SUNBLIND_ACTUATOR_BASIC_REVERSION_PAUSE_TIME = 196,
        PID_SUNBLIND_ACTUATOR_BASIC_MOVE_UP_DOWN_TIME = 197,
        PID_SUNBLIND_ACTUATOR_BASIC_SLAT_STEP_TIME = 198,
        PID_SUNBLIND_ACTUATOR_BASIC_MOVE_PRESET_POSITION_TIME = 199,
        PID_SUNBLIND_ACTUATOR_BASIC_MOVE_TO_PRESET_POSITION_IN_PERCENT = 200,
        PID_SUNBLIND_ACTUATOR_BASIC_MOVE_TO_PRESET_POSITION_LENGTH = 201,
        PID_SUNBLIND_ACTUATOR_BASIC_PRESET_SLAT_POSITION_PERCENT = 202,
        PID_SUNBLIND_ACTUATOR_BASIC_PRESET_SLAT_POSITION_ANGLE = 203,
        PID_SUNBLIND_ACTUATOR_BASIC_REACTION_WIND_ALARM = 204,
        PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_WIND_ALARM = 205,
        PID_SUNBLIND_ACTUATOR_BASIC_REACTION_ON_RAIN_ALARM = 206,
        PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_RAIN_ALARM = 207,
        PID_SUNBLIND_ACTUATOR_BASIC_REACTION_FROST_ALARM = 208,
        PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_FROST_ALARM = 209,
        PID_SUNBLIND_ACTUATOR_BASIC_MAX_SLAT_MOVE_TIME = 210,
        PID_SUNBLIND_ACTUATOR_BASIC_ENABLE_BLINDS_MODE = 211,
        PID_SUNBLIND_ACTUATOR_BASIC_STORAGE_FUNCTIONS_FOR_SCENE = 212,
        PID_SUNBLIND_SENSOR_BASIC_ENABLE_BLINDS_MODE = 213,
        PID_SUNBLIND_SENSOR_BASIC_UP_DOWN_ACTION = 214,
        PID_SUNBLIND_SENSOR_BASIC_ENABLE_TOGGLE_MODE = 215,
    }

    public static class KnxInterfaceObjectPropertyInfo
    {

        public static KnxPropertyDataType? PropertyDataType(this KnxInterfaceObjectProperty value)
        {
            switch (value)
            {
                case KnxInterfaceObjectProperty.PID_UNKNOWN: { /* '0' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_OBJECT_TYPE: { /* '1' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_INT;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_SERVICES_SUPPORTED: { /* '10' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_PRIORITY_FIFO_ENABLED: { /* '100' */
                    return model.KnxPropertyDataType.PDT_BINARY_INFORMATION;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_QUEUE_OVERFLOW_TO_IP: { /* '101' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_INT;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_QUEUE_OVERFLOW_TO_KNX: { /* '102' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_INT;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_MSG_TRANSMIT_TO_IP: { /* '103' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_LONG;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_MSG_TRANSMIT_TO_KNX: { /* '104' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_LONG;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_FRIENDLY_NAME: { /* '105' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_BACKBONE_KEY: { /* '106' */
                    return model.KnxPropertyDataType.PDT_GENERIC_16;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_DEVICE_AUTHENTICATION_CODE: { /* '107' */
                    return model.KnxPropertyDataType.PDT_GENERIC_16;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_PASSWORD_HASHES: { /* '108' */
                    return model.KnxPropertyDataType.PDT_GENERIC_16;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_SECURED_SERVICE_FAMILIES: { /* '109' */
                    return model.KnxPropertyDataType.PDT_FUNCTION;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_SERIAL_NUMBER: { /* '11' */
                    return model.KnxPropertyDataType.PDT_GENERIC_06;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_MULTICAST_LATENCY_TOLERANCE: { /* '110' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_INT;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_SYNC_LATENCY_FRACTION: { /* '111' */
                    return model.KnxPropertyDataType.PDT_SCALING;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_TUNNELLING_USERS: { /* '112' */
                    return model.KnxPropertyDataType.PDT_GENERIC_02;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SECURITY_MODE: { /* '113' */
                    return model.KnxPropertyDataType.PDT_FUNCTION;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_P2P_KEY_TABLE: { /* '114' */
                    return model.KnxPropertyDataType.PDT_GENERIC_18;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_GRP_KEY_TABLE: { /* '115' */
                    return model.KnxPropertyDataType.PDT_GENERIC_18;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SECURITY_INDIVIDUAL_ADDRESS_TABLE: { /* '116' */
                    return model.KnxPropertyDataType.PDT_GENERIC_08;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SECURITY_FAILURES_LOG: { /* '117' */
                    return model.KnxPropertyDataType.PDT_FUNCTION;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SKI_TOOL: { /* '118' */
                    return model.KnxPropertyDataType.PDT_GENERIC_16;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SECURITY_REPORT: { /* '119' */
                    return model.KnxPropertyDataType.PDT_BITSET8;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_MANUFACTURER_ID: { /* '12' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_INT;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SECURITY_REPORT_CONTROL: { /* '120' */
                    return model.KnxPropertyDataType.PDT_BINARY_INFORMATION;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SEQUENCE_NUMBER_SENDING: { /* '121' */
                    return model.KnxPropertyDataType.PDT_GENERIC_06;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_ZONE_KEYS_TABLE: { /* '122' */
                    return model.KnxPropertyDataType.PDT_GENERIC_19;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_GO_SECURITY_FLAGS: { /* '123' */
                    return model.KnxPropertyDataType.PDT_GENERIC_01;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_MULTI_TYPE: { /* '124' */
                    return model.KnxPropertyDataType.PDT_GENERIC_01;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_DOMAIN_ADDRESS: { /* '125' */
                    return model.KnxPropertyDataType.PDT_GENERIC_06;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_RETRANSMITTER: { /* '126' */
                    return model.KnxPropertyDataType.PDT_BINARY_INFORMATION;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_SECURITY_REPORT_CONTROL: { /* '127' */
                    return model.KnxPropertyDataType.PDT_BINARY_INFORMATION;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_FILTERING_MODE_SELECT: { /* '128' */
                    return model.KnxPropertyDataType.PDT_BITSET8;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_BIDIR_TIMEOUT: { /* '129' */
                    return model.KnxPropertyDataType.PDT_FUNCTION;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_PROGRAM_VERSION: { /* '13' */
                    return model.KnxPropertyDataType.PDT_GENERIC_05;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_DIAG_SA_FILTER_TABLE: { /* '130' */
                    return model.KnxPropertyDataType.PDT_GENERIC_03;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_DIAG_QUALITY_TABLE: { /* '131' */
                    return model.KnxPropertyDataType.PDT_GENERIC_04;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_DIAG_PROBE: { /* '132' */
                    return model.KnxPropertyDataType.PDT_FUNCTION;
                }
                case KnxInterfaceObjectProperty.PID_INDOOR_BRIGHTNESS_SENSOR_CHANGE_OF_VALUE: { /* '133' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_INDOOR_BRIGHTNESS_SENSOR_REPETITION_TIME: { /* '134' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_INDOOR_LUMINANCE_SENSOR_CHANGE_OF_VALUE: { /* '135' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_INDOOR_LUMINANCE_SENSOR_REPETITION_TIME: { /* '136' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_ON_DELAY: { /* '137' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_OFF_DELAY: { /* '138' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TIMED_ON_DURATION: { /* '139' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_DEVICE_CONTROL: { /* '14' */
                    return model.KnxPropertyDataType.PDT_BITSET8;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_PREWARNING_DURATION: { /* '140' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TRANSMISSION_CYCLE_TIME: { /* '141' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BUS_POWER_UP_MESSAGE_DELAY: { /* '142' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_AT_LOCKING: { /* '143' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_AT_UNLOCKING: { /* '144' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP: { /* '145' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_DOWN: { /* '146' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_INVERT_OUTPUT_STATE: { /* '147' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TIMED_ON_RETRIGGER_FUNCTION: { /* '148' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_MANUAL_OFF_ENABLE: { /* '149' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_ORDER_INFO: { /* '15' */
                    return model.KnxPropertyDataType.PDT_GENERIC_10;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_INVERT_LOCK_DEVICE: { /* '150' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_LOCK_STATE: { /* '151' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_UNLOCK_STATE: { /* '152' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_STATE_FOR_SCENE_NUMBER: { /* '153' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_STORAGE_FUNCTION_FOR_SCENE: { /* '154' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BUS_POWER_UP_STATE: { /* '155' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP_2: { /* '156' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_ON_DELAY: { /* '157' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_OFF_DELAY: { /* '158' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_SWITCH_OFF_BRIGHTNESS_DELAY_TIME: { /* '159' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_PEI_TYPE: { /* '16' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_TIMED_ON_DURATION: { /* '160' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_PREWARNING_DURATION: { /* '161' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_TRANSMISSION_CYCLE_TIME: { /* '162' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BUS_POWER_UP_MESSAGE_DELAY: { /* '163' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED: { /* '164' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME: { /* '165' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED_FOR_SWITCH_ON_SET_VALUE: { /* '166' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED_FOR_SWITCH_OFF: { /* '167' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME_FOR_SWITCH_ON_SET_VALUE: { /* '168' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME_FOR_SWITCH_OFF: { /* '169' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_PORT_CONFIGURATION: { /* '17' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_SWITCFH_OFF_BRIGHTNESS: { /* '170' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_MINIMUM_SET_VALUE: { /* '171' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_MAXIMUM_SET_VALUE: { /* '172' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_SWITCH_ON_SET_VALUE: { /* '173' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMM_MODE_SELECTION: { /* '174' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_RELATIV_OFF_ENABLE: { /* '175' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_MEMORY_FUNCTION: { /* '176' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_TIMED_ON_RETRIGGER_FUNCTION: { /* '177' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_MANUAL_OFF_ENABLE: { /* '178' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_INVERT_LOCK_DEVICE: { /* '179' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_POLL_GROUP_SETTINGS: { /* '18' */
                    return model.KnxPropertyDataType.PDT_POLL_GROUP_SETTINGS;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_AT_LOCKING: { /* '180' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_AT_UNLOCKING: { /* '181' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_LOCK_SETVALUE: { /* '182' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_UNLOCK_SETVALUE: { /* '183' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BIGHTNESS_FOR_SCENE: { /* '184' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_STORAGE_FUNCTION_FOR_SCENE: { /* '185' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DELTA_DIMMING_VALUE: { /* '186' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP: { /* '187' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP_SET_VALUE: { /* '188' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_DOWN: { /* '189' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_MANUFACTURER_DATA: { /* '19' */
                    return model.KnxPropertyDataType.PDT_GENERIC_04;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BUS_POWER_DOWN_SET_VALUE: { /* '190' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_SENSOR_BASIC_ON_OFF_ACTION: { /* '191' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_SENSOR_BASIC_ENABLE_TOGGLE_MODE: { /* '192' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_SENSOR_BASIC_ABSOLUTE_SETVALUE: { /* '193' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_SWITCHING_SENSOR_BASIC_ON_OFF_ACTION: { /* '194' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_SWITCHING_SENSOR_BASIC_ENABLE_TOGGLE_MODE: { /* '195' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_REVERSION_PAUSE_TIME: { /* '196' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_MOVE_UP_DOWN_TIME: { /* '197' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_SLAT_STEP_TIME: { /* '198' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_MOVE_PRESET_POSITION_TIME: { /* '199' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_OBJECT_NAME: { /* '2' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_ENABLE: { /* '20' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_MOVE_TO_PRESET_POSITION_IN_PERCENT: { /* '200' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_MOVE_TO_PRESET_POSITION_LENGTH: { /* '201' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_PRESET_SLAT_POSITION_PERCENT: { /* '202' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_PRESET_SLAT_POSITION_ANGLE: { /* '203' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_REACTION_WIND_ALARM: { /* '204' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_WIND_ALARM: { /* '205' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_REACTION_ON_RAIN_ALARM: { /* '206' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_RAIN_ALARM: { /* '207' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_REACTION_FROST_ALARM: { /* '208' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_FROST_ALARM: { /* '209' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_DESCRIPTION: { /* '21' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_MAX_SLAT_MOVE_TIME: { /* '210' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_ENABLE_BLINDS_MODE: { /* '211' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_STORAGE_FUNCTIONS_FOR_SCENE: { /* '212' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_SENSOR_BASIC_ENABLE_BLINDS_MODE: { /* '213' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_SENSOR_BASIC_UP_DOWN_ACTION: { /* '214' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_SENSOR_BASIC_ENABLE_TOGGLE_MODE: { /* '215' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_FILE: { /* '22' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_TABLE: { /* '23' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_INT;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_ENROL: { /* '24' */
                    return model.KnxPropertyDataType.PDT_FUNCTION;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_VERSION: { /* '25' */
                    return model.KnxPropertyDataType.PDT_VERSION;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_GROUP_OBJECT_LINK: { /* '26' */
                    return model.KnxPropertyDataType.PDT_FUNCTION;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_MCB_TABLE: { /* '27' */
                    return model.KnxPropertyDataType.PDT_GENERIC_08;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_ERROR_CODE: { /* '28' */
                    return model.KnxPropertyDataType.PDT_GENERIC_01;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_OBJECT_INDEX: { /* '29' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_SEMAPHOR: { /* '3' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_DOWNLOAD_COUNTER: { /* '30' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_ROUTING_COUNT: { /* '31' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_MAX_RETRY_COUNT: { /* '32' */
                    return model.KnxPropertyDataType.PDT_GENERIC_01;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_ERROR_FLAGS: { /* '33' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PROGMODE: { /* '34' */
                    return model.KnxPropertyDataType.PDT_BITSET8;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PRODUCT_ID: { /* '35' */
                    return model.KnxPropertyDataType.PDT_GENERIC_10;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_MAX_APDULENGTH: { /* '36' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_INT;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_SUBNET_ADDR: { /* '37' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_DEVICE_ADDR: { /* '38' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PB_CONFIG: { /* '39' */
                    return model.KnxPropertyDataType.PDT_GENERIC_04;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_GROUP_OBJECT_REFERENCE: { /* '4' */
                    return model.KnxPropertyDataType.PDT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_ADDR_REPORT: { /* '40' */
                    return model.KnxPropertyDataType.PDT_GENERIC_06;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_ADDR_CHECK: { /* '41' */
                    return model.KnxPropertyDataType.PDT_GENERIC_01;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_OBJECT_VALUE: { /* '42' */
                    return model.KnxPropertyDataType.PDT_FUNCTION;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_OBJECTLINK: { /* '43' */
                    return model.KnxPropertyDataType.PDT_FUNCTION;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_APPLICATION: { /* '44' */
                    return model.KnxPropertyDataType.PDT_FUNCTION;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PARAMETER: { /* '45' */
                    return model.KnxPropertyDataType.PDT_FUNCTION;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_OBJECTADDRESS: { /* '46' */
                    return model.KnxPropertyDataType.PDT_FUNCTION;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PSU_TYPE: { /* '47' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_INT;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PSU_STATUS: { /* '48' */
                    return model.KnxPropertyDataType.PDT_BINARY_INFORMATION;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PSU_ENABLE: { /* '49' */
                    return model.KnxPropertyDataType.PDT_ENUM8;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_LOAD_STATE_CONTROL: { /* '5' */
                    return model.KnxPropertyDataType.PDT_CONTROL;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_DOMAIN_ADDRESS: { /* '50' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_INT;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_IO_LIST: { /* '51' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_INT;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_MGT_DESCRIPTOR_01: { /* '52' */
                    return model.KnxPropertyDataType.PDT_GENERIC_10;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PL110_PARAM: { /* '53' */
                    return model.KnxPropertyDataType.PDT_GENERIC_01;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RF_REPEAT_COUNTER: { /* '54' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RECEIVE_BLOCK_TABLE: { /* '55' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RANDOM_PAUSE_TABLE: { /* '56' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RECEIVE_BLOCK_NR: { /* '57' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_HARDWARE_TYPE: { /* '58' */
                    return model.KnxPropertyDataType.PDT_GENERIC_06;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RETRANSMITTER_NUMBER: { /* '59' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_RUN_STATE_CONTROL: { /* '6' */
                    return model.KnxPropertyDataType.PDT_CONTROL;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_SERIAL_NR_TABLE: { /* '60' */
                    return model.KnxPropertyDataType.PDT_GENERIC_06;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_BIBATMASTER_ADDRESS: { /* '61' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_INT;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RF_DOMAIN_ADDRESS: { /* '62' */
                    return model.KnxPropertyDataType.PDT_GENERIC_06;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_DEVICE_DESCRIPTOR: { /* '63' */
                    return model.KnxPropertyDataType.PDT_GENERIC_02;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_METERING_FILTER_TABLE: { /* '64' */
                    return model.KnxPropertyDataType.PDT_GENERIC_08;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_GROUP_TELEGR_RATE_LIMIT_TIME_BASE: { /* '65' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_INT;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_GROUP_TELEGR_RATE_LIMIT_NO_OF_TELEGR: { /* '66' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_INT;
                }
                case KnxInterfaceObjectProperty.PID_GROUP_OBJECT_TABLE_GRPOBJTABLE: { /* '67' */
                    return model.KnxPropertyDataType.PDT_GENERIC_06;
                }
                case KnxInterfaceObjectProperty.PID_GROUP_OBJECT_TABLE_EXT_GRPOBJREFERENCE: { /* '68' */
                    return model.KnxPropertyDataType.PDT_GENERIC_08;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_LINE_STATUS: { /* '69' */
                    return model.KnxPropertyDataType.PDT_GENERIC_01;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_TABLE_REFERENCE: { /* '7' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_INT;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_MAIN_LCCONFIG: { /* '70' */
                    return model.KnxPropertyDataType.PDT_GENERIC_01;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_SUB_LCCONFIG: { /* '71' */
                    return model.KnxPropertyDataType.PDT_GENERIC_01;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_MAIN_LCGRPCONFIG: { /* '72' */
                    return model.KnxPropertyDataType.PDT_GENERIC_01;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_SUB_LCGRPCONFIG: { /* '73' */
                    return model.KnxPropertyDataType.PDT_GENERIC_01;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_ROUTETABLE_CONTROL: { /* '74' */
                    return model.KnxPropertyDataType.PDT_FUNCTION;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_COUPL_SERV_CONTROL: { /* '75' */
                    return model.KnxPropertyDataType.PDT_GENERIC_01;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_MAX_ROUTER_APDU_LENGTH: { /* '76' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_INT;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_MEDIUM: { /* '77' */
                    return model.KnxPropertyDataType.PDT_ENUM8;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_FILTER_TABLE_USE: { /* '78' */
                    return model.KnxPropertyDataType.PDT_BINARY_INFORMATION;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_RF_ENABLE_SBC: { /* '79' */
                    return model.KnxPropertyDataType.PDT_FUNCTION;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_SERVICE_CONTROL: { /* '8' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_INT;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_PROJECT_INSTALLATION_ID: { /* '80' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_INT;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_KNX_INDIVIDUAL_ADDRESS: { /* '81' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_INT;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_ADDITIONAL_INDIVIDUAL_ADDRESSES: { /* '82' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_INT;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_CURRENT_IP_ASSIGNMENT_METHOD: { /* '83' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_IP_ASSIGNMENT_METHOD: { /* '84' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_IP_CAPABILITIES: { /* '85' */
                    return model.KnxPropertyDataType.PDT_BITSET8;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_CURRENT_IP_ADDRESS: { /* '86' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_LONG;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_CURRENT_SUBNET_MASK: { /* '87' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_LONG;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_CURRENT_DEFAULT_GATEWAY: { /* '88' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_LONG;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_IP_ADDRESS: { /* '89' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_LONG;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_FIRMWARE_REVISION: { /* '9' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_SUBNET_MASK: { /* '90' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_LONG;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_DEFAULT_GATEWAY: { /* '91' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_LONG;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_DHCP_BOOTP_SERVER: { /* '92' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_LONG;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_MAC_ADDRESS: { /* '93' */
                    return model.KnxPropertyDataType.PDT_GENERIC_06;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_SYSTEM_SETUP_MULTICAST_ADDRESS: { /* '94' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_LONG;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_ROUTING_MULTICAST_ADDRESS: { /* '95' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_LONG;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_TTL: { /* '96' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_KNXNETIP_DEVICE_CAPABILITIES: { /* '97' */
                    return model.KnxPropertyDataType.PDT_BITSET16;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_KNXNETIP_DEVICE_STATE: { /* '98' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_KNXNETIP_ROUTING_CAPABILITIES: { /* '99' */
                    return model.KnxPropertyDataType.PDT_UNSIGNED_CHAR;
                }
                default: {
                    return null;
                }
            }
        }

        public static string Name(this KnxInterfaceObjectProperty value)
        {
            switch (value)
            {
                case KnxInterfaceObjectProperty.PID_UNKNOWN: { /* '0' */
                    return "Unknown Interface Object Property";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_OBJECT_TYPE: { /* '1' */
                    return "Interface Object Type";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_SERVICES_SUPPORTED: { /* '10' */
                    return "Services Supported";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_PRIORITY_FIFO_ENABLED: { /* '100' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_QUEUE_OVERFLOW_TO_IP: { /* '101' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_QUEUE_OVERFLOW_TO_KNX: { /* '102' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_MSG_TRANSMIT_TO_IP: { /* '103' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_MSG_TRANSMIT_TO_KNX: { /* '104' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_FRIENDLY_NAME: { /* '105' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_BACKBONE_KEY: { /* '106' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_DEVICE_AUTHENTICATION_CODE: { /* '107' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_PASSWORD_HASHES: { /* '108' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_SECURED_SERVICE_FAMILIES: { /* '109' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_SERIAL_NUMBER: { /* '11' */
                    return "KNX Serial Number";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_MULTICAST_LATENCY_TOLERANCE: { /* '110' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_SYNC_LATENCY_FRACTION: { /* '111' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_TUNNELLING_USERS: { /* '112' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SECURITY_MODE: { /* '113' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_P2P_KEY_TABLE: { /* '114' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_GRP_KEY_TABLE: { /* '115' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SECURITY_INDIVIDUAL_ADDRESS_TABLE: { /* '116' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SECURITY_FAILURES_LOG: { /* '117' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SKI_TOOL: { /* '118' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SECURITY_REPORT: { /* '119' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_MANUFACTURER_ID: { /* '12' */
                    return "Manufacturer Identifier";
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SECURITY_REPORT_CONTROL: { /* '120' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SEQUENCE_NUMBER_SENDING: { /* '121' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_ZONE_KEYS_TABLE: { /* '122' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_GO_SECURITY_FLAGS: { /* '123' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_MULTI_TYPE: { /* '124' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_DOMAIN_ADDRESS: { /* '125' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_RETRANSMITTER: { /* '126' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_SECURITY_REPORT_CONTROL: { /* '127' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_FILTERING_MODE_SELECT: { /* '128' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_BIDIR_TIMEOUT: { /* '129' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_PROGRAM_VERSION: { /* '13' */
                    return "Application Version";
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_DIAG_SA_FILTER_TABLE: { /* '130' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_DIAG_QUALITY_TABLE: { /* '131' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_DIAG_PROBE: { /* '132' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_INDOOR_BRIGHTNESS_SENSOR_CHANGE_OF_VALUE: { /* '133' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_INDOOR_BRIGHTNESS_SENSOR_REPETITION_TIME: { /* '134' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_INDOOR_LUMINANCE_SENSOR_CHANGE_OF_VALUE: { /* '135' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_INDOOR_LUMINANCE_SENSOR_REPETITION_TIME: { /* '136' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_ON_DELAY: { /* '137' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_OFF_DELAY: { /* '138' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TIMED_ON_DURATION: { /* '139' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_DEVICE_CONTROL: { /* '14' */
                    return "Device Control";
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_PREWARNING_DURATION: { /* '140' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TRANSMISSION_CYCLE_TIME: { /* '141' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BUS_POWER_UP_MESSAGE_DELAY: { /* '142' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_AT_LOCKING: { /* '143' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_AT_UNLOCKING: { /* '144' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP: { /* '145' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_DOWN: { /* '146' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_INVERT_OUTPUT_STATE: { /* '147' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TIMED_ON_RETRIGGER_FUNCTION: { /* '148' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_MANUAL_OFF_ENABLE: { /* '149' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_ORDER_INFO: { /* '15' */
                    return "Order Info";
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_INVERT_LOCK_DEVICE: { /* '150' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_LOCK_STATE: { /* '151' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_UNLOCK_STATE: { /* '152' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_STATE_FOR_SCENE_NUMBER: { /* '153' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_STORAGE_FUNCTION_FOR_SCENE: { /* '154' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BUS_POWER_UP_STATE: { /* '155' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP_2: { /* '156' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_ON_DELAY: { /* '157' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_OFF_DELAY: { /* '158' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_SWITCH_OFF_BRIGHTNESS_DELAY_TIME: { /* '159' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_PEI_TYPE: { /* '16' */
                    return "PEI Type";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_TIMED_ON_DURATION: { /* '160' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_PREWARNING_DURATION: { /* '161' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_TRANSMISSION_CYCLE_TIME: { /* '162' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BUS_POWER_UP_MESSAGE_DELAY: { /* '163' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED: { /* '164' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME: { /* '165' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED_FOR_SWITCH_ON_SET_VALUE: { /* '166' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED_FOR_SWITCH_OFF: { /* '167' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME_FOR_SWITCH_ON_SET_VALUE: { /* '168' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME_FOR_SWITCH_OFF: { /* '169' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_PORT_CONFIGURATION: { /* '17' */
                    return "PortADDR";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_SWITCFH_OFF_BRIGHTNESS: { /* '170' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_MINIMUM_SET_VALUE: { /* '171' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_MAXIMUM_SET_VALUE: { /* '172' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_SWITCH_ON_SET_VALUE: { /* '173' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMM_MODE_SELECTION: { /* '174' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_RELATIV_OFF_ENABLE: { /* '175' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_MEMORY_FUNCTION: { /* '176' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_TIMED_ON_RETRIGGER_FUNCTION: { /* '177' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_MANUAL_OFF_ENABLE: { /* '178' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_INVERT_LOCK_DEVICE: { /* '179' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_POLL_GROUP_SETTINGS: { /* '18' */
                    return "Polling Group Settings";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_AT_LOCKING: { /* '180' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_AT_UNLOCKING: { /* '181' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_LOCK_SETVALUE: { /* '182' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_UNLOCK_SETVALUE: { /* '183' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BIGHTNESS_FOR_SCENE: { /* '184' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_STORAGE_FUNCTION_FOR_SCENE: { /* '185' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DELTA_DIMMING_VALUE: { /* '186' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP: { /* '187' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP_SET_VALUE: { /* '188' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_DOWN: { /* '189' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_MANUFACTURER_DATA: { /* '19' */
                    return "Manufacturer Data";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BUS_POWER_DOWN_SET_VALUE: { /* '190' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_SENSOR_BASIC_ON_OFF_ACTION: { /* '191' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_SENSOR_BASIC_ENABLE_TOGGLE_MODE: { /* '192' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_SENSOR_BASIC_ABSOLUTE_SETVALUE: { /* '193' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SWITCHING_SENSOR_BASIC_ON_OFF_ACTION: { /* '194' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SWITCHING_SENSOR_BASIC_ENABLE_TOGGLE_MODE: { /* '195' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_REVERSION_PAUSE_TIME: { /* '196' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_MOVE_UP_DOWN_TIME: { /* '197' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_SLAT_STEP_TIME: { /* '198' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_MOVE_PRESET_POSITION_TIME: { /* '199' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_OBJECT_NAME: { /* '2' */
                    return "Interface Object Name";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_ENABLE: { /* '20' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_MOVE_TO_PRESET_POSITION_IN_PERCENT: { /* '200' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_MOVE_TO_PRESET_POSITION_LENGTH: { /* '201' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_PRESET_SLAT_POSITION_PERCENT: { /* '202' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_PRESET_SLAT_POSITION_ANGLE: { /* '203' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_REACTION_WIND_ALARM: { /* '204' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_WIND_ALARM: { /* '205' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_REACTION_ON_RAIN_ALARM: { /* '206' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_RAIN_ALARM: { /* '207' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_REACTION_FROST_ALARM: { /* '208' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_FROST_ALARM: { /* '209' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_DESCRIPTION: { /* '21' */
                    return "Description";
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_MAX_SLAT_MOVE_TIME: { /* '210' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_ENABLE_BLINDS_MODE: { /* '211' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_STORAGE_FUNCTIONS_FOR_SCENE: { /* '212' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_SENSOR_BASIC_ENABLE_BLINDS_MODE: { /* '213' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_SENSOR_BASIC_UP_DOWN_ACTION: { /* '214' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_SENSOR_BASIC_ENABLE_TOGGLE_MODE: { /* '215' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_FILE: { /* '22' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_TABLE: { /* '23' */
                    return "Table";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_ENROL: { /* '24' */
                    return "Interface Object Link";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_VERSION: { /* '25' */
                    return "Version";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_GROUP_OBJECT_LINK: { /* '26' */
                    return "Group Address Assignment";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_MCB_TABLE: { /* '27' */
                    return "Memory Control Table";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_ERROR_CODE: { /* '28' */
                    return "Error Code";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_OBJECT_INDEX: { /* '29' */
                    return "Object Index";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_SEMAPHOR: { /* '3' */
                    return "Semaphor";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_DOWNLOAD_COUNTER: { /* '30' */
                    return "Download Counter";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_ROUTING_COUNT: { /* '31' */
                    return "Routing Count";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_MAX_RETRY_COUNT: { /* '32' */
                    return "Maximum Retry Count";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_ERROR_FLAGS: { /* '33' */
                    return "Error Flags";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PROGMODE: { /* '34' */
                    return "Programming Mode";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PRODUCT_ID: { /* '35' */
                    return "Product Identification";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_MAX_APDULENGTH: { /* '36' */
                    return "Max. APDU-Length";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_SUBNET_ADDR: { /* '37' */
                    return "Subnetwork Address";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_DEVICE_ADDR: { /* '38' */
                    return "Device Address";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PB_CONFIG: { /* '39' */
                    return "Config Link";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_GROUP_OBJECT_REFERENCE: { /* '4' */
                    return "Group Object Reference";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_ADDR_REPORT: { /* '40' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_ADDR_CHECK: { /* '41' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_OBJECT_VALUE: { /* '42' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_OBJECTLINK: { /* '43' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_APPLICATION: { /* '44' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PARAMETER: { /* '45' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_OBJECTADDRESS: { /* '46' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PSU_TYPE: { /* '47' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PSU_STATUS: { /* '48' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PSU_ENABLE: { /* '49' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_LOAD_STATE_CONTROL: { /* '5' */
                    return "Load Control";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_DOMAIN_ADDRESS: { /* '50' */
                    return "Domain Address";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_IO_LIST: { /* '51' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_MGT_DESCRIPTOR_01: { /* '52' */
                    return "Management Descriptor 1";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PL110_PARAM: { /* '53' */
                    return "PL110 Parameters";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RF_REPEAT_COUNTER: { /* '54' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RECEIVE_BLOCK_TABLE: { /* '55' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RANDOM_PAUSE_TABLE: { /* '56' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RECEIVE_BLOCK_NR: { /* '57' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_HARDWARE_TYPE: { /* '58' */
                    return "Hardware Type";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RETRANSMITTER_NUMBER: { /* '59' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_RUN_STATE_CONTROL: { /* '6' */
                    return "Run Control";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_SERIAL_NR_TABLE: { /* '60' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_BIBATMASTER_ADDRESS: { /* '61' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RF_DOMAIN_ADDRESS: { /* '62' */
                    return "RF Domain Address";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_DEVICE_DESCRIPTOR: { /* '63' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_METERING_FILTER_TABLE: { /* '64' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_GROUP_TELEGR_RATE_LIMIT_TIME_BASE: { /* '65' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_GROUP_TELEGR_RATE_LIMIT_NO_OF_TELEGR: { /* '66' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_GROUP_OBJECT_TABLE_GRPOBJTABLE: { /* '67' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_GROUP_OBJECT_TABLE_EXT_GRPOBJREFERENCE: { /* '68' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_LINE_STATUS: { /* '69' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_TABLE_REFERENCE: { /* '7' */
                    return "Table Reference";
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_MAIN_LCCONFIG: { /* '70' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_SUB_LCCONFIG: { /* '71' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_MAIN_LCGRPCONFIG: { /* '72' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_SUB_LCGRPCONFIG: { /* '73' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_ROUTETABLE_CONTROL: { /* '74' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_COUPL_SERV_CONTROL: { /* '75' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_MAX_ROUTER_APDU_LENGTH: { /* '76' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_MEDIUM: { /* '77' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_FILTER_TABLE_USE: { /* '78' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_RF_ENABLE_SBC: { /* '79' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_SERVICE_CONTROL: { /* '8' */
                    return "Service Control";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_PROJECT_INSTALLATION_ID: { /* '80' */
                    return "Project Installation Identification";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_KNX_INDIVIDUAL_ADDRESS: { /* '81' */
                    return "KNX Individual Address";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_ADDITIONAL_INDIVIDUAL_ADDRESSES: { /* '82' */
                    return "Additional Individual Addresses";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_CURRENT_IP_ASSIGNMENT_METHOD: { /* '83' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_IP_ASSIGNMENT_METHOD: { /* '84' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_IP_CAPABILITIES: { /* '85' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_CURRENT_IP_ADDRESS: { /* '86' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_CURRENT_SUBNET_MASK: { /* '87' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_CURRENT_DEFAULT_GATEWAY: { /* '88' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_IP_ADDRESS: { /* '89' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_FIRMWARE_REVISION: { /* '9' */
                    return "Firmware Revision";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_SUBNET_MASK: { /* '90' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_DEFAULT_GATEWAY: { /* '91' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_DHCP_BOOTP_SERVER: { /* '92' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_MAC_ADDRESS: { /* '93' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_SYSTEM_SETUP_MULTICAST_ADDRESS: { /* '94' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_ROUTING_MULTICAST_ADDRESS: { /* '95' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_TTL: { /* '96' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_KNXNETIP_DEVICE_CAPABILITIES: { /* '97' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_KNXNETIP_DEVICE_STATE: { /* '98' */
                    return "";
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_KNXNETIP_ROUTING_CAPABILITIES: { /* '99' */
                    return "";
                }
                default: {
                    return null;
                }
            }
        }

        public static byte? PropertyId(this KnxInterfaceObjectProperty value)
        {
            switch (value)
            {
                case KnxInterfaceObjectProperty.PID_UNKNOWN: { /* '0' */
                    return 0;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_OBJECT_TYPE: { /* '1' */
                    return 1;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_SERVICES_SUPPORTED: { /* '10' */
                    return 10;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_PRIORITY_FIFO_ENABLED: { /* '100' */
                    return 71;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_QUEUE_OVERFLOW_TO_IP: { /* '101' */
                    return 72;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_QUEUE_OVERFLOW_TO_KNX: { /* '102' */
                    return 73;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_MSG_TRANSMIT_TO_IP: { /* '103' */
                    return 74;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_MSG_TRANSMIT_TO_KNX: { /* '104' */
                    return 75;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_FRIENDLY_NAME: { /* '105' */
                    return 76;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_BACKBONE_KEY: { /* '106' */
                    return 91;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_DEVICE_AUTHENTICATION_CODE: { /* '107' */
                    return 92;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_PASSWORD_HASHES: { /* '108' */
                    return 93;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_SECURED_SERVICE_FAMILIES: { /* '109' */
                    return 94;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_SERIAL_NUMBER: { /* '11' */
                    return 11;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_MULTICAST_LATENCY_TOLERANCE: { /* '110' */
                    return 95;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_SYNC_LATENCY_FRACTION: { /* '111' */
                    return 96;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_TUNNELLING_USERS: { /* '112' */
                    return 97;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SECURITY_MODE: { /* '113' */
                    return 51;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_P2P_KEY_TABLE: { /* '114' */
                    return 52;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_GRP_KEY_TABLE: { /* '115' */
                    return 53;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SECURITY_INDIVIDUAL_ADDRESS_TABLE: { /* '116' */
                    return 54;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SECURITY_FAILURES_LOG: { /* '117' */
                    return 55;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SKI_TOOL: { /* '118' */
                    return 56;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SECURITY_REPORT: { /* '119' */
                    return 57;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_MANUFACTURER_ID: { /* '12' */
                    return 12;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SECURITY_REPORT_CONTROL: { /* '120' */
                    return 58;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SEQUENCE_NUMBER_SENDING: { /* '121' */
                    return 59;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_ZONE_KEYS_TABLE: { /* '122' */
                    return 60;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_GO_SECURITY_FLAGS: { /* '123' */
                    return 61;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_MULTI_TYPE: { /* '124' */
                    return 51;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_DOMAIN_ADDRESS: { /* '125' */
                    return 56;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_RETRANSMITTER: { /* '126' */
                    return 57;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_SECURITY_REPORT_CONTROL: { /* '127' */
                    return 58;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_FILTERING_MODE_SELECT: { /* '128' */
                    return 59;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_BIDIR_TIMEOUT: { /* '129' */
                    return 60;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_PROGRAM_VERSION: { /* '13' */
                    return 13;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_DIAG_SA_FILTER_TABLE: { /* '130' */
                    return 61;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_DIAG_QUALITY_TABLE: { /* '131' */
                    return 62;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_DIAG_PROBE: { /* '132' */
                    return 63;
                }
                case KnxInterfaceObjectProperty.PID_INDOOR_BRIGHTNESS_SENSOR_CHANGE_OF_VALUE: { /* '133' */
                    return 110;
                }
                case KnxInterfaceObjectProperty.PID_INDOOR_BRIGHTNESS_SENSOR_REPETITION_TIME: { /* '134' */
                    return 111;
                }
                case KnxInterfaceObjectProperty.PID_INDOOR_LUMINANCE_SENSOR_CHANGE_OF_VALUE: { /* '135' */
                    return 110;
                }
                case KnxInterfaceObjectProperty.PID_INDOOR_LUMINANCE_SENSOR_REPETITION_TIME: { /* '136' */
                    return 111;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_ON_DELAY: { /* '137' */
                    return 101;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_OFF_DELAY: { /* '138' */
                    return 102;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TIMED_ON_DURATION: { /* '139' */
                    return 103;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_DEVICE_CONTROL: { /* '14' */
                    return 14;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_PREWARNING_DURATION: { /* '140' */
                    return 104;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TRANSMISSION_CYCLE_TIME: { /* '141' */
                    return 105;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BUS_POWER_UP_MESSAGE_DELAY: { /* '142' */
                    return 106;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_AT_LOCKING: { /* '143' */
                    return 107;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_AT_UNLOCKING: { /* '144' */
                    return 108;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP: { /* '145' */
                    return 109;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_DOWN: { /* '146' */
                    return 110;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_INVERT_OUTPUT_STATE: { /* '147' */
                    return 111;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TIMED_ON_RETRIGGER_FUNCTION: { /* '148' */
                    return 112;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_MANUAL_OFF_ENABLE: { /* '149' */
                    return 113;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_ORDER_INFO: { /* '15' */
                    return 15;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_INVERT_LOCK_DEVICE: { /* '150' */
                    return 114;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_LOCK_STATE: { /* '151' */
                    return 115;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_UNLOCK_STATE: { /* '152' */
                    return 116;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_STATE_FOR_SCENE_NUMBER: { /* '153' */
                    return 117;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_STORAGE_FUNCTION_FOR_SCENE: { /* '154' */
                    return 118;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BUS_POWER_UP_STATE: { /* '155' */
                    return 119;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP_2: { /* '156' */
                    return 120;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_ON_DELAY: { /* '157' */
                    return 101;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_OFF_DELAY: { /* '158' */
                    return 102;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_SWITCH_OFF_BRIGHTNESS_DELAY_TIME: { /* '159' */
                    return 103;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_PEI_TYPE: { /* '16' */
                    return 16;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_TIMED_ON_DURATION: { /* '160' */
                    return 104;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_PREWARNING_DURATION: { /* '161' */
                    return 105;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_TRANSMISSION_CYCLE_TIME: { /* '162' */
                    return 106;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BUS_POWER_UP_MESSAGE_DELAY: { /* '163' */
                    return 107;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED: { /* '164' */
                    return 108;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME: { /* '165' */
                    return 109;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED_FOR_SWITCH_ON_SET_VALUE: { /* '166' */
                    return 110;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED_FOR_SWITCH_OFF: { /* '167' */
                    return 111;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME_FOR_SWITCH_ON_SET_VALUE: { /* '168' */
                    return 112;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME_FOR_SWITCH_OFF: { /* '169' */
                    return 113;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_PORT_CONFIGURATION: { /* '17' */
                    return 17;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_SWITCFH_OFF_BRIGHTNESS: { /* '170' */
                    return 114;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_MINIMUM_SET_VALUE: { /* '171' */
                    return 115;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_MAXIMUM_SET_VALUE: { /* '172' */
                    return 116;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_SWITCH_ON_SET_VALUE: { /* '173' */
                    return 117;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMM_MODE_SELECTION: { /* '174' */
                    return 118;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_RELATIV_OFF_ENABLE: { /* '175' */
                    return 119;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_MEMORY_FUNCTION: { /* '176' */
                    return 120;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_TIMED_ON_RETRIGGER_FUNCTION: { /* '177' */
                    return 121;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_MANUAL_OFF_ENABLE: { /* '178' */
                    return 122;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_INVERT_LOCK_DEVICE: { /* '179' */
                    return 123;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_POLL_GROUP_SETTINGS: { /* '18' */
                    return 18;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_AT_LOCKING: { /* '180' */
                    return 124;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_AT_UNLOCKING: { /* '181' */
                    return 125;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_LOCK_SETVALUE: { /* '182' */
                    return 126;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_UNLOCK_SETVALUE: { /* '183' */
                    return 127;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BIGHTNESS_FOR_SCENE: { /* '184' */
                    return 128;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_STORAGE_FUNCTION_FOR_SCENE: { /* '185' */
                    return 129;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DELTA_DIMMING_VALUE: { /* '186' */
                    return 130;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP: { /* '187' */
                    return 131;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP_SET_VALUE: { /* '188' */
                    return 132;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_DOWN: { /* '189' */
                    return 133;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_MANUFACTURER_DATA: { /* '19' */
                    return 19;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BUS_POWER_DOWN_SET_VALUE: { /* '190' */
                    return 134;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_SENSOR_BASIC_ON_OFF_ACTION: { /* '191' */
                    return 51;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_SENSOR_BASIC_ENABLE_TOGGLE_MODE: { /* '192' */
                    return 52;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_SENSOR_BASIC_ABSOLUTE_SETVALUE: { /* '193' */
                    return 53;
                }
                case KnxInterfaceObjectProperty.PID_SWITCHING_SENSOR_BASIC_ON_OFF_ACTION: { /* '194' */
                    return 51;
                }
                case KnxInterfaceObjectProperty.PID_SWITCHING_SENSOR_BASIC_ENABLE_TOGGLE_MODE: { /* '195' */
                    return 52;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_REVERSION_PAUSE_TIME: { /* '196' */
                    return 51;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_MOVE_UP_DOWN_TIME: { /* '197' */
                    return 52;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_SLAT_STEP_TIME: { /* '198' */
                    return 53;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_MOVE_PRESET_POSITION_TIME: { /* '199' */
                    return 54;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_OBJECT_NAME: { /* '2' */
                    return 2;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_ENABLE: { /* '20' */
                    return 20;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_MOVE_TO_PRESET_POSITION_IN_PERCENT: { /* '200' */
                    return 55;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_MOVE_TO_PRESET_POSITION_LENGTH: { /* '201' */
                    return 57;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_PRESET_SLAT_POSITION_PERCENT: { /* '202' */
                    return 58;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_PRESET_SLAT_POSITION_ANGLE: { /* '203' */
                    return 60;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_REACTION_WIND_ALARM: { /* '204' */
                    return 61;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_WIND_ALARM: { /* '205' */
                    return 62;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_REACTION_ON_RAIN_ALARM: { /* '206' */
                    return 63;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_RAIN_ALARM: { /* '207' */
                    return 64;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_REACTION_FROST_ALARM: { /* '208' */
                    return 65;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_FROST_ALARM: { /* '209' */
                    return 66;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_DESCRIPTION: { /* '21' */
                    return 21;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_MAX_SLAT_MOVE_TIME: { /* '210' */
                    return 67;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_ENABLE_BLINDS_MODE: { /* '211' */
                    return 68;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_STORAGE_FUNCTIONS_FOR_SCENE: { /* '212' */
                    return 69;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_SENSOR_BASIC_ENABLE_BLINDS_MODE: { /* '213' */
                    return 51;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_SENSOR_BASIC_UP_DOWN_ACTION: { /* '214' */
                    return 52;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_SENSOR_BASIC_ENABLE_TOGGLE_MODE: { /* '215' */
                    return 53;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_FILE: { /* '22' */
                    return 22;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_TABLE: { /* '23' */
                    return 23;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_ENROL: { /* '24' */
                    return 24;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_VERSION: { /* '25' */
                    return 25;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_GROUP_OBJECT_LINK: { /* '26' */
                    return 26;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_MCB_TABLE: { /* '27' */
                    return 27;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_ERROR_CODE: { /* '28' */
                    return 28;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_OBJECT_INDEX: { /* '29' */
                    return 29;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_SEMAPHOR: { /* '3' */
                    return 3;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_DOWNLOAD_COUNTER: { /* '30' */
                    return 30;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_ROUTING_COUNT: { /* '31' */
                    return 51;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_MAX_RETRY_COUNT: { /* '32' */
                    return 52;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_ERROR_FLAGS: { /* '33' */
                    return 53;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PROGMODE: { /* '34' */
                    return 54;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PRODUCT_ID: { /* '35' */
                    return 55;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_MAX_APDULENGTH: { /* '36' */
                    return 56;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_SUBNET_ADDR: { /* '37' */
                    return 57;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_DEVICE_ADDR: { /* '38' */
                    return 58;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PB_CONFIG: { /* '39' */
                    return 59;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_GROUP_OBJECT_REFERENCE: { /* '4' */
                    return 4;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_ADDR_REPORT: { /* '40' */
                    return 60;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_ADDR_CHECK: { /* '41' */
                    return 61;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_OBJECT_VALUE: { /* '42' */
                    return 62;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_OBJECTLINK: { /* '43' */
                    return 63;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_APPLICATION: { /* '44' */
                    return 64;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PARAMETER: { /* '45' */
                    return 65;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_OBJECTADDRESS: { /* '46' */
                    return 66;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PSU_TYPE: { /* '47' */
                    return 67;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PSU_STATUS: { /* '48' */
                    return 68;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PSU_ENABLE: { /* '49' */
                    return 69;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_LOAD_STATE_CONTROL: { /* '5' */
                    return 5;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_DOMAIN_ADDRESS: { /* '50' */
                    return 70;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_IO_LIST: { /* '51' */
                    return 71;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_MGT_DESCRIPTOR_01: { /* '52' */
                    return 72;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PL110_PARAM: { /* '53' */
                    return 73;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RF_REPEAT_COUNTER: { /* '54' */
                    return 74;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RECEIVE_BLOCK_TABLE: { /* '55' */
                    return 75;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RANDOM_PAUSE_TABLE: { /* '56' */
                    return 76;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RECEIVE_BLOCK_NR: { /* '57' */
                    return 77;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_HARDWARE_TYPE: { /* '58' */
                    return 78;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RETRANSMITTER_NUMBER: { /* '59' */
                    return 79;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_RUN_STATE_CONTROL: { /* '6' */
                    return 6;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_SERIAL_NR_TABLE: { /* '60' */
                    return 80;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_BIBATMASTER_ADDRESS: { /* '61' */
                    return 81;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RF_DOMAIN_ADDRESS: { /* '62' */
                    return 82;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_DEVICE_DESCRIPTOR: { /* '63' */
                    return 83;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_METERING_FILTER_TABLE: { /* '64' */
                    return 84;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_GROUP_TELEGR_RATE_LIMIT_TIME_BASE: { /* '65' */
                    return 85;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_GROUP_TELEGR_RATE_LIMIT_NO_OF_TELEGR: { /* '66' */
                    return 86;
                }
                case KnxInterfaceObjectProperty.PID_GROUP_OBJECT_TABLE_GRPOBJTABLE: { /* '67' */
                    return 51;
                }
                case KnxInterfaceObjectProperty.PID_GROUP_OBJECT_TABLE_EXT_GRPOBJREFERENCE: { /* '68' */
                    return 52;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_LINE_STATUS: { /* '69' */
                    return 51;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_TABLE_REFERENCE: { /* '7' */
                    return 7;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_MAIN_LCCONFIG: { /* '70' */
                    return 52;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_SUB_LCCONFIG: { /* '71' */
                    return 53;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_MAIN_LCGRPCONFIG: { /* '72' */
                    return 54;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_SUB_LCGRPCONFIG: { /* '73' */
                    return 55;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_ROUTETABLE_CONTROL: { /* '74' */
                    return 56;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_COUPL_SERV_CONTROL: { /* '75' */
                    return 57;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_MAX_ROUTER_APDU_LENGTH: { /* '76' */
                    return 58;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_MEDIUM: { /* '77' */
                    return 63;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_FILTER_TABLE_USE: { /* '78' */
                    return 67;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_RF_ENABLE_SBC: { /* '79' */
                    return 112;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_SERVICE_CONTROL: { /* '8' */
                    return 8;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_PROJECT_INSTALLATION_ID: { /* '80' */
                    return 51;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_KNX_INDIVIDUAL_ADDRESS: { /* '81' */
                    return 52;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_ADDITIONAL_INDIVIDUAL_ADDRESSES: { /* '82' */
                    return 53;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_CURRENT_IP_ASSIGNMENT_METHOD: { /* '83' */
                    return 54;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_IP_ASSIGNMENT_METHOD: { /* '84' */
                    return 55;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_IP_CAPABILITIES: { /* '85' */
                    return 56;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_CURRENT_IP_ADDRESS: { /* '86' */
                    return 57;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_CURRENT_SUBNET_MASK: { /* '87' */
                    return 58;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_CURRENT_DEFAULT_GATEWAY: { /* '88' */
                    return 59;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_IP_ADDRESS: { /* '89' */
                    return 60;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_FIRMWARE_REVISION: { /* '9' */
                    return 9;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_SUBNET_MASK: { /* '90' */
                    return 61;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_DEFAULT_GATEWAY: { /* '91' */
                    return 62;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_DHCP_BOOTP_SERVER: { /* '92' */
                    return 63;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_MAC_ADDRESS: { /* '93' */
                    return 64;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_SYSTEM_SETUP_MULTICAST_ADDRESS: { /* '94' */
                    return 65;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_ROUTING_MULTICAST_ADDRESS: { /* '95' */
                    return 66;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_TTL: { /* '96' */
                    return 67;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_KNXNETIP_DEVICE_CAPABILITIES: { /* '97' */
                    return 68;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_KNXNETIP_DEVICE_STATE: { /* '98' */
                    return 69;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_KNXNETIP_ROUTING_CAPABILITIES: { /* '99' */
                    return 70;
                }
                default: {
                    return 0;
                }
            }
        }

        public static KnxInterfaceObjectType? ObjectType(this KnxInterfaceObjectProperty value)
        {
            switch (value)
            {
                case KnxInterfaceObjectProperty.PID_UNKNOWN: { /* '0' */
                    return model.KnxInterfaceObjectType.OT_UNKNOWN;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_OBJECT_TYPE: { /* '1' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_SERVICES_SUPPORTED: { /* '10' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_PRIORITY_FIFO_ENABLED: { /* '100' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_QUEUE_OVERFLOW_TO_IP: { /* '101' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_QUEUE_OVERFLOW_TO_KNX: { /* '102' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_MSG_TRANSMIT_TO_IP: { /* '103' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_MSG_TRANSMIT_TO_KNX: { /* '104' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_FRIENDLY_NAME: { /* '105' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_BACKBONE_KEY: { /* '106' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_DEVICE_AUTHENTICATION_CODE: { /* '107' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_PASSWORD_HASHES: { /* '108' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_SECURED_SERVICE_FAMILIES: { /* '109' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_SERIAL_NUMBER: { /* '11' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_MULTICAST_LATENCY_TOLERANCE: { /* '110' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_SYNC_LATENCY_FRACTION: { /* '111' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_TUNNELLING_USERS: { /* '112' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SECURITY_MODE: { /* '113' */
                    return model.KnxInterfaceObjectType.OT_SECURITY;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_P2P_KEY_TABLE: { /* '114' */
                    return model.KnxInterfaceObjectType.OT_SECURITY;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_GRP_KEY_TABLE: { /* '115' */
                    return model.KnxInterfaceObjectType.OT_SECURITY;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SECURITY_INDIVIDUAL_ADDRESS_TABLE: { /* '116' */
                    return model.KnxInterfaceObjectType.OT_SECURITY;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SECURITY_FAILURES_LOG: { /* '117' */
                    return model.KnxInterfaceObjectType.OT_SECURITY;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SKI_TOOL: { /* '118' */
                    return model.KnxInterfaceObjectType.OT_SECURITY;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SECURITY_REPORT: { /* '119' */
                    return model.KnxInterfaceObjectType.OT_SECURITY;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_MANUFACTURER_ID: { /* '12' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SECURITY_REPORT_CONTROL: { /* '120' */
                    return model.KnxInterfaceObjectType.OT_SECURITY;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_SEQUENCE_NUMBER_SENDING: { /* '121' */
                    return model.KnxInterfaceObjectType.OT_SECURITY;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_ZONE_KEYS_TABLE: { /* '122' */
                    return model.KnxInterfaceObjectType.OT_SECURITY;
                }
                case KnxInterfaceObjectProperty.PID_SECURITY_GO_SECURITY_FLAGS: { /* '123' */
                    return model.KnxInterfaceObjectType.OT_SECURITY;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_MULTI_TYPE: { /* '124' */
                    return model.KnxInterfaceObjectType.OT_RF_MEDIUM;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_DOMAIN_ADDRESS: { /* '125' */
                    return model.KnxInterfaceObjectType.OT_RF_MEDIUM;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_RETRANSMITTER: { /* '126' */
                    return model.KnxInterfaceObjectType.OT_RF_MEDIUM;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_SECURITY_REPORT_CONTROL: { /* '127' */
                    return model.KnxInterfaceObjectType.OT_RF_MEDIUM;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_FILTERING_MODE_SELECT: { /* '128' */
                    return model.KnxInterfaceObjectType.OT_RF_MEDIUM;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_BIDIR_TIMEOUT: { /* '129' */
                    return model.KnxInterfaceObjectType.OT_RF_MEDIUM;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_PROGRAM_VERSION: { /* '13' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_DIAG_SA_FILTER_TABLE: { /* '130' */
                    return model.KnxInterfaceObjectType.OT_RF_MEDIUM;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_DIAG_QUALITY_TABLE: { /* '131' */
                    return model.KnxInterfaceObjectType.OT_RF_MEDIUM;
                }
                case KnxInterfaceObjectProperty.PID_RF_MEDIUM_RF_DIAG_PROBE: { /* '132' */
                    return model.KnxInterfaceObjectType.OT_RF_MEDIUM;
                }
                case KnxInterfaceObjectProperty.PID_INDOOR_BRIGHTNESS_SENSOR_CHANGE_OF_VALUE: { /* '133' */
                    return model.KnxInterfaceObjectType.OT_INDOOR_BRIGHTNESS_SENSOR;
                }
                case KnxInterfaceObjectProperty.PID_INDOOR_BRIGHTNESS_SENSOR_REPETITION_TIME: { /* '134' */
                    return model.KnxInterfaceObjectType.OT_INDOOR_BRIGHTNESS_SENSOR;
                }
                case KnxInterfaceObjectProperty.PID_INDOOR_LUMINANCE_SENSOR_CHANGE_OF_VALUE: { /* '135' */
                    return model.KnxInterfaceObjectType.OT_INDOOR_LUMINANCE_SENSOR;
                }
                case KnxInterfaceObjectProperty.PID_INDOOR_LUMINANCE_SENSOR_REPETITION_TIME: { /* '136' */
                    return model.KnxInterfaceObjectType.OT_INDOOR_LUMINANCE_SENSOR;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_ON_DELAY: { /* '137' */
                    return model.KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_OFF_DELAY: { /* '138' */
                    return model.KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TIMED_ON_DURATION: { /* '139' */
                    return model.KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_DEVICE_CONTROL: { /* '14' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_PREWARNING_DURATION: { /* '140' */
                    return model.KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TRANSMISSION_CYCLE_TIME: { /* '141' */
                    return model.KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BUS_POWER_UP_MESSAGE_DELAY: { /* '142' */
                    return model.KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_AT_LOCKING: { /* '143' */
                    return model.KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_AT_UNLOCKING: { /* '144' */
                    return model.KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP: { /* '145' */
                    return model.KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_DOWN: { /* '146' */
                    return model.KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_INVERT_OUTPUT_STATE: { /* '147' */
                    return model.KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_TIMED_ON_RETRIGGER_FUNCTION: { /* '148' */
                    return model.KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_MANUAL_OFF_ENABLE: { /* '149' */
                    return model.KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_ORDER_INFO: { /* '15' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_INVERT_LOCK_DEVICE: { /* '150' */
                    return model.KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_LOCK_STATE: { /* '151' */
                    return model.KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_UNLOCK_STATE: { /* '152' */
                    return model.KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_STATE_FOR_SCENE_NUMBER: { /* '153' */
                    return model.KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_STORAGE_FUNCTION_FOR_SCENE: { /* '154' */
                    return model.KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BUS_POWER_UP_STATE: { /* '155' */
                    return model.KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_LIGHT_SWITCHING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP_2: { /* '156' */
                    return model.KnxInterfaceObjectType.OT_LIGHT_SWITCHING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_ON_DELAY: { /* '157' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_OFF_DELAY: { /* '158' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_SWITCH_OFF_BRIGHTNESS_DELAY_TIME: { /* '159' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_PEI_TYPE: { /* '16' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_TIMED_ON_DURATION: { /* '160' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_PREWARNING_DURATION: { /* '161' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_TRANSMISSION_CYCLE_TIME: { /* '162' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BUS_POWER_UP_MESSAGE_DELAY: { /* '163' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED: { /* '164' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME: { /* '165' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED_FOR_SWITCH_ON_SET_VALUE: { /* '166' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_SPEED_FOR_SWITCH_OFF: { /* '167' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME_FOR_SWITCH_ON_SET_VALUE: { /* '168' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMMING_STEP_TIME_FOR_SWITCH_OFF: { /* '169' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_PORT_CONFIGURATION: { /* '17' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_SWITCFH_OFF_BRIGHTNESS: { /* '170' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_MINIMUM_SET_VALUE: { /* '171' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_MAXIMUM_SET_VALUE: { /* '172' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_SWITCH_ON_SET_VALUE: { /* '173' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DIMM_MODE_SELECTION: { /* '174' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_RELATIV_OFF_ENABLE: { /* '175' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_MEMORY_FUNCTION: { /* '176' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_TIMED_ON_RETRIGGER_FUNCTION: { /* '177' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_MANUAL_OFF_ENABLE: { /* '178' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_INVERT_LOCK_DEVICE: { /* '179' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_POLL_GROUP_SETTINGS: { /* '18' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_AT_LOCKING: { /* '180' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_AT_UNLOCKING: { /* '181' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_LOCK_SETVALUE: { /* '182' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_UNLOCK_SETVALUE: { /* '183' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BIGHTNESS_FOR_SCENE: { /* '184' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_STORAGE_FUNCTION_FOR_SCENE: { /* '185' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_DELTA_DIMMING_VALUE: { /* '186' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP: { /* '187' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_UP_SET_VALUE: { /* '188' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BEHAVIOUR_BUS_POWER_DOWN: { /* '189' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_MANUFACTURER_DATA: { /* '19' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_ACTUATOR_BASIC_BUS_POWER_DOWN_SET_VALUE: { /* '190' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_SENSOR_BASIC_ON_OFF_ACTION: { /* '191' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_SENSOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_SENSOR_BASIC_ENABLE_TOGGLE_MODE: { /* '192' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_SENSOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_DIMMING_SENSOR_BASIC_ABSOLUTE_SETVALUE: { /* '193' */
                    return model.KnxInterfaceObjectType.OT_DIMMING_SENSOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_SWITCHING_SENSOR_BASIC_ON_OFF_ACTION: { /* '194' */
                    return model.KnxInterfaceObjectType.OT_SWITCHING_SENSOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_SWITCHING_SENSOR_BASIC_ENABLE_TOGGLE_MODE: { /* '195' */
                    return model.KnxInterfaceObjectType.OT_SWITCHING_SENSOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_REVERSION_PAUSE_TIME: { /* '196' */
                    return model.KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_MOVE_UP_DOWN_TIME: { /* '197' */
                    return model.KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_SLAT_STEP_TIME: { /* '198' */
                    return model.KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_MOVE_PRESET_POSITION_TIME: { /* '199' */
                    return model.KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_OBJECT_NAME: { /* '2' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_ENABLE: { /* '20' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_MOVE_TO_PRESET_POSITION_IN_PERCENT: { /* '200' */
                    return model.KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_MOVE_TO_PRESET_POSITION_LENGTH: { /* '201' */
                    return model.KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_PRESET_SLAT_POSITION_PERCENT: { /* '202' */
                    return model.KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_PRESET_SLAT_POSITION_ANGLE: { /* '203' */
                    return model.KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_REACTION_WIND_ALARM: { /* '204' */
                    return model.KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_WIND_ALARM: { /* '205' */
                    return model.KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_REACTION_ON_RAIN_ALARM: { /* '206' */
                    return model.KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_RAIN_ALARM: { /* '207' */
                    return model.KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_REACTION_FROST_ALARM: { /* '208' */
                    return model.KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_HEARTBEAT_FROST_ALARM: { /* '209' */
                    return model.KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_DESCRIPTION: { /* '21' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_MAX_SLAT_MOVE_TIME: { /* '210' */
                    return model.KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_ENABLE_BLINDS_MODE: { /* '211' */
                    return model.KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_ACTUATOR_BASIC_STORAGE_FUNCTIONS_FOR_SCENE: { /* '212' */
                    return model.KnxInterfaceObjectType.OT_SUNBLIND_ACTUATOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_SENSOR_BASIC_ENABLE_BLINDS_MODE: { /* '213' */
                    return model.KnxInterfaceObjectType.OT_SUNBLIND_SENSOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_SENSOR_BASIC_UP_DOWN_ACTION: { /* '214' */
                    return model.KnxInterfaceObjectType.OT_SUNBLIND_SENSOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_SUNBLIND_SENSOR_BASIC_ENABLE_TOGGLE_MODE: { /* '215' */
                    return model.KnxInterfaceObjectType.OT_SUNBLIND_SENSOR_BASIC;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_FILE: { /* '22' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_TABLE: { /* '23' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_ENROL: { /* '24' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_VERSION: { /* '25' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_GROUP_OBJECT_LINK: { /* '26' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_MCB_TABLE: { /* '27' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_ERROR_CODE: { /* '28' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_OBJECT_INDEX: { /* '29' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_SEMAPHOR: { /* '3' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_DOWNLOAD_COUNTER: { /* '30' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_ROUTING_COUNT: { /* '31' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_MAX_RETRY_COUNT: { /* '32' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_ERROR_FLAGS: { /* '33' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PROGMODE: { /* '34' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PRODUCT_ID: { /* '35' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_MAX_APDULENGTH: { /* '36' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_SUBNET_ADDR: { /* '37' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_DEVICE_ADDR: { /* '38' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PB_CONFIG: { /* '39' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_GROUP_OBJECT_REFERENCE: { /* '4' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_ADDR_REPORT: { /* '40' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_ADDR_CHECK: { /* '41' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_OBJECT_VALUE: { /* '42' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_OBJECTLINK: { /* '43' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_APPLICATION: { /* '44' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PARAMETER: { /* '45' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_OBJECTADDRESS: { /* '46' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PSU_TYPE: { /* '47' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PSU_STATUS: { /* '48' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PSU_ENABLE: { /* '49' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_LOAD_STATE_CONTROL: { /* '5' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_DOMAIN_ADDRESS: { /* '50' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_IO_LIST: { /* '51' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_MGT_DESCRIPTOR_01: { /* '52' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_PL110_PARAM: { /* '53' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RF_REPEAT_COUNTER: { /* '54' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RECEIVE_BLOCK_TABLE: { /* '55' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RANDOM_PAUSE_TABLE: { /* '56' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RECEIVE_BLOCK_NR: { /* '57' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_HARDWARE_TYPE: { /* '58' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RETRANSMITTER_NUMBER: { /* '59' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_RUN_STATE_CONTROL: { /* '6' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_SERIAL_NR_TABLE: { /* '60' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_BIBATMASTER_ADDRESS: { /* '61' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_RF_DOMAIN_ADDRESS: { /* '62' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_DEVICE_DESCRIPTOR: { /* '63' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_METERING_FILTER_TABLE: { /* '64' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_GROUP_TELEGR_RATE_LIMIT_TIME_BASE: { /* '65' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_DEVICE_GROUP_TELEGR_RATE_LIMIT_NO_OF_TELEGR: { /* '66' */
                    return model.KnxInterfaceObjectType.OT_DEVICE;
                }
                case KnxInterfaceObjectProperty.PID_GROUP_OBJECT_TABLE_GRPOBJTABLE: { /* '67' */
                    return model.KnxInterfaceObjectType.OT_GROUP_OBJECT_TABLE;
                }
                case KnxInterfaceObjectProperty.PID_GROUP_OBJECT_TABLE_EXT_GRPOBJREFERENCE: { /* '68' */
                    return model.KnxInterfaceObjectType.OT_GROUP_OBJECT_TABLE;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_LINE_STATUS: { /* '69' */
                    return model.KnxInterfaceObjectType.OT_ROUTER;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_TABLE_REFERENCE: { /* '7' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_MAIN_LCCONFIG: { /* '70' */
                    return model.KnxInterfaceObjectType.OT_ROUTER;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_SUB_LCCONFIG: { /* '71' */
                    return model.KnxInterfaceObjectType.OT_ROUTER;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_MAIN_LCGRPCONFIG: { /* '72' */
                    return model.KnxInterfaceObjectType.OT_ROUTER;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_SUB_LCGRPCONFIG: { /* '73' */
                    return model.KnxInterfaceObjectType.OT_ROUTER;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_ROUTETABLE_CONTROL: { /* '74' */
                    return model.KnxInterfaceObjectType.OT_ROUTER;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_COUPL_SERV_CONTROL: { /* '75' */
                    return model.KnxInterfaceObjectType.OT_ROUTER;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_MAX_ROUTER_APDU_LENGTH: { /* '76' */
                    return model.KnxInterfaceObjectType.OT_ROUTER;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_MEDIUM: { /* '77' */
                    return model.KnxInterfaceObjectType.OT_ROUTER;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_FILTER_TABLE_USE: { /* '78' */
                    return model.KnxInterfaceObjectType.OT_ROUTER;
                }
                case KnxInterfaceObjectProperty.PID_ROUTER_RF_ENABLE_SBC: { /* '79' */
                    return model.KnxInterfaceObjectType.OT_ROUTER;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_SERVICE_CONTROL: { /* '8' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_PROJECT_INSTALLATION_ID: { /* '80' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_KNX_INDIVIDUAL_ADDRESS: { /* '81' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_ADDITIONAL_INDIVIDUAL_ADDRESSES: { /* '82' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_CURRENT_IP_ASSIGNMENT_METHOD: { /* '83' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_IP_ASSIGNMENT_METHOD: { /* '84' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_IP_CAPABILITIES: { /* '85' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_CURRENT_IP_ADDRESS: { /* '86' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_CURRENT_SUBNET_MASK: { /* '87' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_CURRENT_DEFAULT_GATEWAY: { /* '88' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_IP_ADDRESS: { /* '89' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_GENERAL_FIRMWARE_REVISION: { /* '9' */
                    return model.KnxInterfaceObjectType.OT_GENERAL;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_SUBNET_MASK: { /* '90' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_DEFAULT_GATEWAY: { /* '91' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_DHCP_BOOTP_SERVER: { /* '92' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_MAC_ADDRESS: { /* '93' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_SYSTEM_SETUP_MULTICAST_ADDRESS: { /* '94' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_ROUTING_MULTICAST_ADDRESS: { /* '95' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_TTL: { /* '96' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_KNXNETIP_DEVICE_CAPABILITIES: { /* '97' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_KNXNETIP_DEVICE_STATE: { /* '98' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                case KnxInterfaceObjectProperty.PID_KNXIP_PARAMETER_KNXNETIP_ROUTING_CAPABILITIES: { /* '99' */
                    return model.KnxInterfaceObjectType.OT_KNXIP_PARAMETER;
                }
                default: {
                    return null;
                }
            }
        }
    }

}

