/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SecurityDataZoneOpen extends SecurityData implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final short zoneNumber;

  public SecurityDataZoneOpen(
      SecurityCommandTypeContainer commandTypeContainer, byte argument, short zoneNumber) {
    super(commandTypeContainer, argument);
    this.zoneNumber = zoneNumber;
  }

  public short getZoneNumber() {
    return zoneNumber;
  }

  @Override
  protected void serializeSecurityDataChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SecurityDataZoneOpen");

    // Simple Field (zoneNumber)
    writeSimpleField("zoneNumber", zoneNumber, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("SecurityDataZoneOpen");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    SecurityDataZoneOpen _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (zoneNumber)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static SecurityDataBuilder staticParseSecurityDataBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("SecurityDataZoneOpen");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short zoneNumber = readSimpleField("zoneNumber", readUnsignedShort(readBuffer, 8));

    readBuffer.closeContext("SecurityDataZoneOpen");
    // Create the instance
    return new SecurityDataZoneOpenBuilderImpl(zoneNumber);
  }

  public static class SecurityDataZoneOpenBuilderImpl implements SecurityData.SecurityDataBuilder {
    private final short zoneNumber;

    public SecurityDataZoneOpenBuilderImpl(short zoneNumber) {
      this.zoneNumber = zoneNumber;
    }

    public SecurityDataZoneOpen build(
        SecurityCommandTypeContainer commandTypeContainer, byte argument) {
      SecurityDataZoneOpen securityDataZoneOpen =
          new SecurityDataZoneOpen(commandTypeContainer, argument, zoneNumber);
      return securityDataZoneOpen;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SecurityDataZoneOpen)) {
      return false;
    }
    SecurityDataZoneOpen that = (SecurityDataZoneOpen) o;
    return (getZoneNumber() == that.getZoneNumber()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getZoneNumber());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
