/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.ui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.pdfbox.debugger.PDFDebugger;

public class LogDialog
extends JDialog {
    private static LogDialog instance;
    private final JLabel logLabel;
    private final JTextPane textPane;
    private final JScrollPane scrollPane;
    private int fatalCount = 0;
    private int errorCount = 0;
    private int warnCount = 0;
    private int otherCount = 0;
    private int exceptionCount = 0;

    private LogDialog(Frame owner, JLabel logLabel) {
        super(owner);
        this.logLabel = logLabel;
        this.textPane = new JTextPane();
        String prop = PDFDebugger.configuration.getProperty("textFontHeight");
        if (prop != null) {
            Font font = this.textPane.getFont();
            float textFontHeight = Float.parseFloat(prop);
            this.textPane.setFont(font.deriveFont(textFontHeight));
        }
        this.scrollPane = new JScrollPane(this.textPane);
        this.getContentPane().add(this.scrollPane);
        this.pack();
    }

    public static void init(Frame owner, JLabel logLabel) {
        instance = new LogDialog(owner, logLabel);
    }

    public static LogDialog instance() {
        return instance;
    }

    public void log(String name, String level, Object o, Throwable throwable) {
        String message;
        String levelText;
        StyledDocument doc = this.textPane.getStyledDocument();
        SimpleAttributeSet levelStyle = new SimpleAttributeSet();
        if ("fatal".equals(level)) {
            levelText = "Fatal";
            StyleConstants.setForeground(levelStyle, Color.WHITE);
            StyleConstants.setBackground(levelStyle, Color.BLACK);
            ++this.fatalCount;
        } else if ("error".equals(level)) {
            levelText = "Error";
            StyleConstants.setForeground(levelStyle, new Color(16722207));
            StyleConstants.setBackground(levelStyle, new Color(0xFFF0F0));
            ++this.errorCount;
        } else if ("warn".equals(level)) {
            levelText = "Warning";
            StyleConstants.setForeground(levelStyle, new Color(6373889));
            StyleConstants.setBackground(levelStyle, new Color(16776421));
            ++this.warnCount;
        } else if ("info".equals(level)) {
            levelText = "Info";
            StyleConstants.setForeground(levelStyle, new Color(2110049));
            StyleConstants.setBackground(levelStyle, new Color(14870783));
            ++this.otherCount;
        } else if ("debug".equals(level)) {
            levelText = "Debug";
            StyleConstants.setForeground(levelStyle, new Color(3301678));
            StyleConstants.setBackground(levelStyle, new Color(16056300));
            ++this.otherCount;
        } else if ("trace".equals(level)) {
            levelText = "Trace";
            StyleConstants.setForeground(levelStyle, new Color(6570893));
            StyleConstants.setBackground(levelStyle, new Color(0xFEF3FF));
            ++this.otherCount;
        } else {
            throw new Error(level);
        }
        SimpleAttributeSet nameStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(nameStyle, new Color(0x6A6A6A));
        String shortName = name.substring(name.lastIndexOf(46) + 1);
        String string = message = o == null ? "(null)" : o.toString();
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            throwable.printStackTrace(new PrintWriter(sw));
            message = message + "\n    " + sw.toString();
            ++this.exceptionCount;
        }
        try {
            doc.insertString(doc.getLength(), " " + levelText + " ", levelStyle);
            doc.insertString(doc.getLength(), " [" + shortName + "]", nameStyle);
            doc.insertString(doc.getLength(), " " + message + "\n", null);
        }
        catch (BadLocationException e) {
            throw new Error(e);
        }
        this.textPane.setCaretPosition(doc.getLength());
        this.updateStatusBar();
    }

    private void updateStatusBar() {
        ArrayList<String> infos = new ArrayList<String>();
        if (this.exceptionCount > 0) {
            infos.add(this.exceptionCount + " exception" + (this.exceptionCount > 1 ? "s" : ""));
        }
        if (this.fatalCount > 0) {
            infos.add(this.fatalCount + " fatal error" + (this.fatalCount > 1 ? "s" : ""));
        }
        if (this.errorCount > 0) {
            infos.add(this.errorCount + " error" + (this.errorCount > 1 ? "s" : ""));
        }
        if (this.warnCount > 0) {
            infos.add(this.warnCount + " warning" + (this.warnCount > 1 ? "s" : ""));
        }
        if (this.otherCount > 0) {
            infos.add(this.otherCount + " message" + (this.otherCount > 1 ? "s" : ""));
        }
        String info = "";
        for (String str : infos) {
            if (info.length() > 0) {
                info = info + ", ";
            }
            info = info + str;
        }
        this.logLabel.setText(info);
    }

    public void clear() {
        this.fatalCount = 0;
        this.errorCount = 0;
        this.warnCount = 0;
        this.otherCount = 0;
        this.exceptionCount = 0;
        this.textPane.setText("");
        this.logLabel.setText("");
    }

    @Override
    public final Container getContentPane() {
        return super.getContentPane();
    }

    @Override
    public final void pack() {
        super.pack();
    }
}

