/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.james.blob.api.BlobId;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.Cid;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;

public class MessageRepresentation {
    private final MessageId messageId;
    private final Date internalDate;
    private final Long size;
    private final Content headerContent;
    private final BlobId bodyBlobId;
    private final List<AttachmentRepresentation> attachments;

    public static Builder builder() {
        return new Builder();
    }

    private MessageRepresentation(MessageId messageId, Date internalDate, Long size, Content headerContent, BlobId bodyBlobId, List<AttachmentRepresentation> attachments) {
        this.messageId = messageId;
        this.internalDate = internalDate;
        this.size = size;
        this.headerContent = headerContent;
        this.bodyBlobId = bodyBlobId;
        this.attachments = attachments;
    }

    public Date getInternalDate() {
        return this.internalDate;
    }

    public Long getSize() {
        return this.size;
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public Content getHeaderContent() {
        return this.headerContent;
    }

    public BlobId getBodyBlobId() {
        return this.bodyBlobId;
    }

    public List<AttachmentRepresentation> getAttachments() {
        return this.attachments;
    }

    public static class Builder {
        private MessageId messageId;
        private Date internalDate;
        private Long size;
        private Content headerContent;
        private BlobId bodyBlobId;
        private List<AttachmentRepresentation> attachments = List.of();

        public Builder messageId(MessageId messageId) {
            this.messageId = messageId;
            return this;
        }

        public Builder internalDate(Date internalDate) {
            this.internalDate = internalDate;
            return this;
        }

        public Builder size(long size) {
            Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"size can not be negative");
            this.size = size;
            return this;
        }

        public Builder headerContent(Content headerContent) {
            this.headerContent = headerContent;
            return this;
        }

        public Builder bodyBlobId(BlobId bodyBlobId) {
            this.bodyBlobId = bodyBlobId;
            return this;
        }

        public Builder attachments(List<AttachmentRepresentation> attachments) {
            this.attachments = attachments;
            return this;
        }

        public MessageRepresentation build() {
            Preconditions.checkNotNull((Object)this.messageId, (Object)"messageId is required");
            Preconditions.checkNotNull((Object)this.internalDate, (Object)"internalDate is required");
            Preconditions.checkNotNull((Object)this.size, (Object)"size is required");
            Preconditions.checkNotNull((Object)this.headerContent, (Object)"headerContent is required");
            Preconditions.checkNotNull((Object)this.bodyBlobId, (Object)"mailboxId is required");
            return new MessageRepresentation(this.messageId, this.internalDate, this.size, this.headerContent, this.bodyBlobId, this.attachments);
        }
    }

    public static class AttachmentRepresentation {
        private final AttachmentId attachmentId;
        private final Optional<String> name;
        private final Optional<Cid> cid;
        private final boolean isInline;

        public static AttachmentRepresentation from(MessageAttachmentMetadata messageAttachmentMetadata) {
            return new AttachmentRepresentation(messageAttachmentMetadata.getAttachment().getAttachmentId(), messageAttachmentMetadata.getName(), messageAttachmentMetadata.getCid(), messageAttachmentMetadata.isInline());
        }

        public static List<AttachmentRepresentation> from(List<MessageAttachmentMetadata> messageAttachmentMetadata) {
            return messageAttachmentMetadata.stream().map(AttachmentRepresentation::from).collect(Collectors.toList());
        }

        public AttachmentRepresentation(AttachmentId attachmentId, Optional<String> name, Optional<Cid> cid, boolean isInline) {
            Preconditions.checkNotNull((Object)attachmentId, (Object)"attachmentId is required");
            this.attachmentId = attachmentId;
            this.name = name;
            this.cid = cid;
            this.isInline = isInline;
        }

        public AttachmentId getAttachmentId() {
            return this.attachmentId;
        }

        public Optional<String> getName() {
            return this.name;
        }

        public Optional<Cid> getCid() {
            return this.cid;
        }

        public boolean isInline() {
            return this.isInline;
        }
    }
}

