/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.postgres.upload;

import java.time.LocalDateTime;
import java.util.UUID;
import org.apache.james.backends.postgres.PostgresCommons;
import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.backends.postgres.PostgresIndex;
import org.apache.james.backends.postgres.PostgresTable;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public interface PostgresUploadDataDefinition {
    public static final PostgresDataDefinition MODULE = PostgresDataDefinition.builder().addTable(new PostgresTable[]{PostgresUploadTable.TABLE}).addIndex(new PostgresIndex[]{PostgresUploadTable.USER_NAME_INDEX, PostgresUploadTable.ID_USERNAME_INDEX, PostgresUploadTable.UPLOAD_DATE_INDEX}).build();

    public static interface PostgresUploadTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"uploads");
        public static final Field<UUID> ID = DSL.field((String)"id", (DataType)SQLDataType.UUID.notNull());
        public static final Field<String> CONTENT_TYPE = DSL.field((String)"content_type", (DataType)SQLDataType.VARCHAR);
        public static final Field<Long> SIZE = DSL.field((String)"size", (DataType)SQLDataType.BIGINT.notNull());
        public static final Field<String> BLOB_ID = DSL.field((String)"blob_id", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<String> USER_NAME = DSL.field((String)"user_name", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<LocalDateTime> UPLOAD_DATE = DSL.field((String)"upload_date", (DataType)PostgresCommons.DataTypes.TIMESTAMP.notNull());
        public static final PostgresTable TABLE = PostgresTable.name((String)TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(ID).column(CONTENT_TYPE).column(SIZE).column(BLOB_ID).column(USER_NAME).column(UPLOAD_DATE).primaryKey(new Field[]{ID})).supportsRowLevelSecurity().build();
        public static final PostgresIndex USER_NAME_INDEX = PostgresIndex.name((String)"uploads_user_name_index").createIndexStep((dslContext, indexName) -> dslContext.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{USER_NAME}));
        public static final PostgresIndex ID_USERNAME_INDEX = PostgresIndex.name((String)"uploads_id_user_name_index").createIndexStep((dslContext, indexName) -> dslContext.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{ID, USER_NAME}));
        public static final PostgresIndex UPLOAD_DATE_INDEX = PostgresIndex.name((String)"uploads_upload_date_index").createIndexStep((dslContext, indexName) -> dslContext.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{UPLOAD_DATE}));
    }
}

