/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.util.Optional;
import org.apache.james.events.Event;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.Group;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple3;

public interface EventRetriever {
    public static EventRetriever allEvents() {
        return new AllEventsRetriever();
    }

    public static EventRetriever groupEvents(Group group) {
        return new GroupEventsRetriever(group);
    }

    public static EventRetriever singleEvent(Group group, EventDeadLetters.InsertionId insertionId) {
        return new SingleEventRetriever(group, insertionId);
    }

    public Optional<Group> forGroup();

    public Optional<EventDeadLetters.InsertionId> forEvent();

    public Flux<Tuple3<Group, Event, EventDeadLetters.InsertionId>> retrieveEvents(EventDeadLetters var1);

    default public Flux<Tuple3<Group, Event, EventDeadLetters.InsertionId>> listGroupEvents(EventDeadLetters deadLetters, Group group) {
        return deadLetters.failedIds(group).flatMap(insertionId -> Flux.zip((Publisher)Mono.just((Object)group), (Publisher)deadLetters.failedEvent(group, insertionId), (Publisher)Mono.just((Object)insertionId)), 16);
    }

    public static class AllEventsRetriever
    implements EventRetriever {
        @Override
        public Optional<Group> forGroup() {
            return Optional.empty();
        }

        @Override
        public Optional<EventDeadLetters.InsertionId> forEvent() {
            return Optional.empty();
        }

        @Override
        public Flux<Tuple3<Group, Event, EventDeadLetters.InsertionId>> retrieveEvents(EventDeadLetters deadLetters) {
            return deadLetters.groupsWithFailedEvents().flatMap(group -> this.listGroupEvents(deadLetters, (Group)group), 16);
        }
    }

    public static class GroupEventsRetriever
    implements EventRetriever {
        private final Group group;

        GroupEventsRetriever(Group group) {
            this.group = group;
        }

        @Override
        public Optional<Group> forGroup() {
            return Optional.of(this.group);
        }

        @Override
        public Optional<EventDeadLetters.InsertionId> forEvent() {
            return Optional.empty();
        }

        @Override
        public Flux<Tuple3<Group, Event, EventDeadLetters.InsertionId>> retrieveEvents(EventDeadLetters deadLetters) {
            return this.listGroupEvents(deadLetters, this.group);
        }
    }

    public static class SingleEventRetriever
    implements EventRetriever {
        private final Group group;
        private final EventDeadLetters.InsertionId insertionId;

        SingleEventRetriever(Group group, EventDeadLetters.InsertionId insertionId) {
            this.group = group;
            this.insertionId = insertionId;
        }

        @Override
        public Optional<Group> forGroup() {
            return Optional.of(this.group);
        }

        @Override
        public Optional<EventDeadLetters.InsertionId> forEvent() {
            return Optional.of(this.insertionId);
        }

        @Override
        public Flux<Tuple3<Group, Event, EventDeadLetters.InsertionId>> retrieveEvents(EventDeadLetters deadLetters) {
            return Flux.zip((Publisher)Mono.just((Object)this.group), (Publisher)deadLetters.failedEvent(this.group, this.insertionId), (Publisher)Mono.just((Object)this.insertionId));
        }
    }
}

