/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.UUID;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.change.CanNotCalculateChangesException;
import org.apache.james.jmap.api.change.EmailChangeRepository;
import org.apache.james.jmap.api.change.EmailChanges;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.exception.ChangeNotFoundException;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.ErrorCode$CannotCalculateChanges$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.Invocation$;
import org.apache.james.jmap.core.SessionTranslator;
import org.apache.james.jmap.core.UuidState$;
import org.apache.james.jmap.json.EmailGetSerializer$;
import org.apache.james.jmap.mail.EmailChangesRequest;
import org.apache.james.jmap.mail.EmailChangesResponse;
import org.apache.james.jmap.mail.HasMoreChanges$;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.MethodRequiringAccountId;
import org.apache.james.jmap.method.package$;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.metrics.api.MetricFactory;
import org.reactivestreams.Publisher;
import play.api.libs.json.JsValue;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005=e\u0001B\t\u0013\u0001uA\u0001B\f\u0001\u0003\u0006\u0004%\ta\f\u0005\tq\u0001\u0011\t\u0011)A\u0005a!A\u0011\b\u0001BC\u0002\u0013\u0005!\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003<\u0011!\u0019\u0005A!b\u0001\n\u0003!\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u00111\u0003!Q1A\u0005\u00025C\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\u0006+\u0002!\tA\u0016\u0005\bK\u0002\u0011\r\u0011\"\u0011g\u0011\u0019Y\b\u0001)A\u0005O\"9A\u0010\u0001b\u0001\n\u0003j\bbBA\u000e\u0001\u0001\u0006IA \u0005\b\u0003;\u0001A\u0011IA\u0010\u0011\u001d\t9\u0006\u0001C\u0005\u00033Bq!!\u001b\u0001\t\u0003\nYG\u0001\nF[\u0006LGn\u00115b]\u001e,7/T3uQ>$'BA\n\u0015\u0003\u0019iW\r\u001e5pI*\u0011QCF\u0001\u0005U6\f\u0007O\u0003\u0002\u00181\u0005)!.Y7fg*\u0011\u0011DG\u0001\u0007CB\f7\r[3\u000b\u0003m\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0010%!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fMB\u0019QE\n\u0015\u000e\u0003II!a\n\n\u000315+G\u000f[8e%\u0016\fX/\u001b:j]\u001e\f5mY8v]RLE\r\u0005\u0002*Y5\t!F\u0003\u0002,)\u0005!Q.Y5m\u0013\ti#FA\nF[\u0006LGn\u00115b]\u001e,7OU3rk\u0016\u001cH/A\u0007nKR\u0014\u0018n\u0019$bGR|'/_\u000b\u0002aA\u0011\u0011GN\u0007\u0002e)\u00111\u0007N\u0001\u0004CBL'BA\u001b\u0017\u0003\u001diW\r\u001e:jGNL!a\u000e\u001a\u0003\u001b5+GO]5d\r\u0006\u001cGo\u001c:z\u00039iW\r\u001e:jG\u001a\u000b7\r^8ss\u0002\nQ#Z7bS2\u001c\u0005.\u00198hKJ+\u0007o\\:ji>\u0014\u00180F\u0001<!\ta\u0004)D\u0001>\u0015\tqt(\u0001\u0004dQ\u0006tw-\u001a\u0006\u0003gQI!!Q\u001f\u0003+\u0015k\u0017-\u001b7DQ\u0006tw-\u001a*fa>\u001c\u0018\u000e^8ss\u00061R-\\1jY\u000eC\u0017M\\4f%\u0016\u0004xn]5u_JL\b%A\btKN\u001c\u0018n\u001c8TkB\u0004H.[3s+\u0005)\u0005C\u0001$J\u001b\u00059%B\u0001%\u0015\u0003\u0019\u0011x.\u001e;fg&\u0011!j\u0012\u0002\u0010'\u0016\u001c8/[8o'V\u0004\b\u000f\\5fe\u0006\u00012/Z:tS>t7+\u001e9qY&,'\u000fI\u0001\u0012g\u0016\u001c8/[8o)J\fgn\u001d7bi>\u0014X#\u0001(\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E#\u0012\u0001B2pe\u0016L!a\u0015)\u0003#M+7o]5p]R\u0013\u0018M\\:mCR|'/\u0001\ntKN\u001c\u0018n\u001c8Ue\u0006t7\u000f\\1u_J\u0004\u0013A\u0002\u001fj]&$h\bF\u0003X1fS6\f\u0005\u0002&\u0001!)a&\u0003a\u0001a!)\u0011(\u0003a\u0001w!)1)\u0003a\u0001\u000b\")A*\u0003a\u0001\u001d\"\u0012\u0011\"\u0018\t\u0003=\u000el\u0011a\u0018\u0006\u0003A\u0006\fa!\u001b8kK\u000e$(\"\u00012\u0002\u000f)\f7.\u0019:uC&\u0011Am\u0018\u0002\u0007\u0013:TWm\u0019;\u0002\u00155,G\u000f[8e\u001d\u0006lW-F\u0001h!\tA\u0007P\u0004\u0002jm:\u0011!.\u001e\b\u0003WRt!\u0001\\:\u000f\u00055\u0014hB\u00018r\u001b\u0005y'B\u00019\u001d\u0003\u0019a$o\\8u}%\t1$\u0003\u0002\u001a5%\u0011q\u0003G\u0005\u0003+YI!!\u0015\u000b\n\u0005]\u0004\u0016AC%om>\u001c\u0017\r^5p]&\u0011\u0011P\u001f\u0002\u000b\u001b\u0016$\bn\u001c3OC6,'BA<Q\u0003-iW\r\u001e5pI:\u000bW.\u001a\u0011\u0002)I,\u0017/^5sK\u0012\u001c\u0015\r]1cS2LG/[3t+\u0005q\b#B@\u0002\b\u00055a\u0002BA\u0001\u0003\u0007\u0001\"A\u001c\u0011\n\u0007\u0005\u0015\u0001%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0013\tYAA\u0002TKRT1!!\u0002!!\u0011\ty!!\u0006\u000f\u0007%\f\t\"C\u0002\u0002\u0014A\u000bAcQ1qC\nLG.\u001b;z\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018\u0002BA\f\u00033\u0011AcQ1qC\nLG.\u001b;z\u0013\u0012,g\u000e^5gS\u0016\u0014(bAA\n!\u0006)\"/Z9vSJ,GmQ1qC\nLG.\u001b;jKN\u0004\u0013!\u00033p!J|7-Z:t))\t\t#a\u000f\u0002@\u0005\r\u00131\u000b\t\u0007\u0003G\t\t$!\u000e\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\t\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u0007\u0005\nYCC\u0002R\u0003[Q!!a\f\u0002\u000fI,\u0017m\u0019;pe&!\u00111GA\u0013\u0005\u0015\u0019Vj\u001c8p!\r)\u0013qG\u0005\u0004\u0003s\u0011\"!F%om>\u001c\u0017\r^5p]^KG\u000f[\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003{q\u0001\u0019\u0001@\u0002\u0019\r\f\u0007/\u00192jY&$\u0018.Z:\t\u000f\u0005\u0005c\u00021\u0001\u00026\u0005Q\u0011N\u001c<pG\u0006$\u0018n\u001c8\t\u000f\u0005\u0015c\u00021\u0001\u0002H\u0005qQ.Y5mE>D8+Z:tS>t\u0007\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u00055c#A\u0004nC&d'm\u001c=\n\t\u0005E\u00131\n\u0002\u000f\u001b\u0006LGNY8y'\u0016\u001c8/[8o\u0011\u0019\t)F\u0004a\u0001Q\u00059!/Z9vKN$\u0018a\u0004:fiJLWM^3DQ\u0006tw-Z:\u0015\u0011\u0005m\u00131MA3\u0003O\u0002b!a\t\u00022\u0005u\u0003c\u0001\u001f\u0002`%\u0019\u0011\u0011M\u001f\u0003\u0019\u0015k\u0017-\u001b7DQ\u0006tw-Z:\t\r\u0005ur\u00021\u0001\u007f\u0011\u001d\t)e\u0004a\u0001\u0003\u000fBa!!\u0016\u0010\u0001\u0004A\u0013AC4fiJ+\u0017/^3tiR1\u0011QNAC\u0003\u000f\u0003r!a\u001c\u0002z\u0005}\u0004F\u0004\u0003\u0002r\u0005Udb\u00018\u0002t%\t\u0011%C\u0002\u0002x\u0001\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002|\u0005u$AB#ji\",'OC\u0002\u0002x\u0001\u0002B!a\u001c\u0002\u0002&!\u00111QA?\u0005aIE\u000e\\3hC2\f%oZ;nK:$X\t_2faRLwN\u001c\u0005\b\u0003\u000b\u0002\u0002\u0019AA$\u0011\u001d\t\t\u0005\u0005a\u0001\u0003\u0013\u00032aTAF\u0013\r\ti\t\u0015\u0002\u000b\u0013:4xnY1uS>t\u0007")
public class EmailChangesMethod
implements MethodRequiringAccountId<EmailChangesRequest> {
    private final MetricFactory metricFactory;
    private final EmailChangeRepository emailChangeRepository;
    private final SessionSupplier sessionSupplier;
    private final SessionTranslator sessionTranslator;
    private final Invocation.MethodName methodName;
    private final Set<Refined<String, string.Uri>> requiredCapabilities;
    private String JMAP_RFC8621_PREFIX;

    @Override
    public Publisher<InvocationWithContext> process(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return MethodRequiringAccountId.process$(this, capabilities, invocation, mailboxSession);
    }

    @Override
    public String JMAP_RFC8621_PREFIX() {
        return this.JMAP_RFC8621_PREFIX;
    }

    @Override
    public void org$apache$james$jmap$method$Method$_setter_$JMAP_RFC8621_PREFIX_$eq(String x$1) {
        this.JMAP_RFC8621_PREFIX = x$1;
    }

    @Override
    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    public EmailChangeRepository emailChangeRepository() {
        return this.emailChangeRepository;
    }

    @Override
    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    @Override
    public SessionTranslator sessionTranslator() {
        return this.sessionTranslator;
    }

    @Override
    public Invocation.MethodName methodName() {
        return this.methodName;
    }

    @Override
    public Set<Refined<String, string.Uri>> requiredCapabilities() {
        return this.requiredCapabilities;
    }

    public SMono<InvocationWithContext> doProcess(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession, EmailChangesRequest request) {
        return this.retrieveChanges(capabilities, mailboxSession, request).map((Function1 & Serializable)emailChanges -> new EmailChangesResponse(request.accountId(), request.sinceState(), UuidState$.MODULE$.fromEmailChanges((EmailChanges)emailChanges), HasMoreChanges$.MODULE$.fromEmailChanges((EmailChanges)emailChanges), (Set<MessageId>)CollectionConverters$.MODULE$.SetHasAsScala(emailChanges.getCreated()).asScala().toSet(), (Set<MessageId>)CollectionConverters$.MODULE$.SetHasAsScala(emailChanges.getUpdated()).asScala().toSet(), (Set<MessageId>)CollectionConverters$.MODULE$.SetHasAsScala(emailChanges.getDestroyed()).asScala().toSet())).map((Function1 & Serializable)response -> new InvocationWithContext(new Invocation(this.methodName(), EmailGetSerializer$.MODULE$.serializeChanges((EmailChangesResponse)response), invocation.invocation().methodCallId()), invocation.processingContext())).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof CanNotCalculateChangesException) {
                CanNotCalculateChangesException canNotCalculateChangesException = (CanNotCalculateChangesException)throwable;
                return SMono$.MODULE$.just((Object)new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$CannotCalculateChanges$.MODULE$, canNotCalculateChangesException.getMessage(), invocation.invocation().methodCallId()), invocation.processingContext()));
            }
            if (throwable instanceof ChangeNotFoundException) {
                ChangeNotFoundException changeNotFoundException = (ChangeNotFoundException)throwable;
                return SMono$.MODULE$.just((Object)new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$CannotCalculateChanges$.MODULE$, changeNotFoundException.getMessage(), invocation.invocation().methodCallId()), invocation.processingContext()));
            }
            return SMono$.MODULE$.error(throwable);
        });
    }

    private SMono<EmailChanges> retrieveChanges(Set<Refined<String, string.Uri>> capabilities, MailboxSession mailboxSession, EmailChangesRequest request) {
        AccountId accountId = AccountId.fromUsername((Username)mailboxSession.getUser());
        if (capabilities.contains((Object)new Refined((Object)CapabilityIdentifier$.MODULE$.JAMES_SHARES()))) {
            return SMono$.MODULE$.apply((Publisher)this.emailChangeRepository().getSinceStateWithDelegation(accountId, State.of((UUID)request.sinceState().value()), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(request.maxChanges()))));
        }
        return SMono$.MODULE$.apply((Publisher)this.emailChangeRepository().getSinceState(accountId, State.of((UUID)request.sinceState().value()), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(request.maxChanges()))));
    }

    @Override
    public Either<IllegalArgumentException, EmailChangesRequest> getRequest(MailboxSession mailboxSession, Invocation invocation) {
        return package$.MODULE$.AsEitherRequest(EmailGetSerializer$.MODULE$.deserializeEmailChangesRequest((JsValue)invocation.arguments())).asEitherRequest();
    }

    @Inject
    public EmailChangesMethod(MetricFactory metricFactory, EmailChangeRepository emailChangeRepository, SessionSupplier sessionSupplier, SessionTranslator sessionTranslator) {
        this.metricFactory = metricFactory;
        this.emailChangeRepository = emailChangeRepository;
        this.sessionSupplier = sessionSupplier;
        this.sessionTranslator = sessionTranslator;
        Method.$init$(this);
        MethodRequiringAccountId.$init$(this);
        this.methodName = new Invocation.MethodName((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"Email/changes")).value());
        this.requiredCapabilities = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_MAIL())}));
        Statics.releaseFence();
    }
}

