/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionIoDataType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.tsfile.exception.StopReadTsFileByInterruptException;
import org.apache.tsfile.read.reader.TsFileInput;

public class CompactionTsFileInput
implements TsFileInput {
    private final TsFileInput tsFileInput;
    private long metadataOffset = -1L;
    private final CompactionType compactionType;
    private volatile boolean readingAlignedSeries = false;

    public CompactionTsFileInput(CompactionType compactionType, TsFileInput tsFileInput) {
        this.compactionType = compactionType;
        this.tsFileInput = tsFileInput;
    }

    public void setMetadataOffset(long metadataOffset) {
        this.metadataOffset = metadataOffset;
    }

    public void markStartOfAlignedSeries() {
        this.readingAlignedSeries = true;
    }

    public void markEndOfAlignedSeries() {
        this.readingAlignedSeries = false;
    }

    public long size() throws IOException {
        try {
            return this.tsFileInput.size();
        }
        catch (Exception e) {
            if (Thread.currentThread().isInterrupted()) {
                throw new StopReadTsFileByInterruptException();
            }
            throw e;
        }
    }

    public long position() throws IOException {
        try {
            return this.tsFileInput.position();
        }
        catch (Exception e) {
            if (Thread.currentThread().isInterrupted()) {
                throw new StopReadTsFileByInterruptException();
            }
            throw e;
        }
    }

    public TsFileInput position(long newPosition) throws IOException {
        try {
            return this.tsFileInput.position(newPosition);
        }
        catch (Exception e) {
            if (Thread.currentThread().isInterrupted()) {
                throw new StopReadTsFileByInterruptException();
            }
            throw e;
        }
    }

    public int read(ByteBuffer dst) throws IOException {
        this.acquireReadDataSizeWithCompactionReadRateLimiter(dst.remaining());
        int readSize = this.tsFileInput.read(dst);
        this.updateMetrics(this.position(), readSize);
        if (Thread.currentThread().isInterrupted()) {
            throw new StopReadTsFileByInterruptException();
        }
        return readSize;
    }

    public int read(ByteBuffer dst, long position) throws IOException {
        this.acquireReadDataSizeWithCompactionReadRateLimiter(dst.remaining());
        int readSize = this.tsFileInput.read(dst, position);
        this.updateMetrics(position, readSize);
        if (Thread.currentThread().isInterrupted()) {
            throw new StopReadTsFileByInterruptException();
        }
        return readSize;
    }

    public InputStream wrapAsInputStream() throws IOException {
        return new CompactionTsFileInputStreamWrapper(this.tsFileInput.wrapAsInputStream());
    }

    public void close() throws IOException {
        this.tsFileInput.close();
    }

    public String getFilePath() {
        return this.tsFileInput.getFilePath();
    }

    private void acquireReadDataSizeWithCompactionReadRateLimiter(int readDataSize) {
        CompactionTaskManager.getInstance().getCompactionReadOperationRateLimiter().acquire(1);
        CompactionTaskManager.getInstance().getCompactionReadRateLimiter().acquire(readDataSize);
    }

    private void updateMetrics(long position, long totalSize) {
        if (position >= this.metadataOffset) {
            CompactionMetrics.getInstance().recordReadInfo(this.compactionType, CompactionIoDataType.METADATA, totalSize);
        } else {
            CompactionMetrics.getInstance().recordReadInfo(this.compactionType, this.readingAlignedSeries ? CompactionIoDataType.ALIGNED : CompactionIoDataType.NOT_ALIGNED, totalSize);
        }
    }

    private class CompactionTsFileInputStreamWrapper
    extends InputStream {
        private final InputStream inputStream;

        public CompactionTsFileInputStreamWrapper(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public int read() throws IOException {
            CompactionTsFileInput.this.acquireReadDataSizeWithCompactionReadRateLimiter(1);
            long position = CompactionTsFileInput.this.position();
            int readSize = this.inputStream.read();
            CompactionTsFileInput.this.updateMetrics(position, readSize);
            return readSize;
        }

        @Override
        public int read(byte[] b) throws IOException {
            CompactionTsFileInput.this.acquireReadDataSizeWithCompactionReadRateLimiter(b.length);
            long position = CompactionTsFileInput.this.position();
            int readSize = this.inputStream.read(b);
            CompactionTsFileInput.this.updateMetrics(position, readSize);
            return readSize;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            CompactionTsFileInput.this.acquireReadDataSizeWithCompactionReadRateLimiter(len);
            long position = CompactionTsFileInput.this.position();
            int readSize = this.inputStream.read(b, off, len);
            CompactionTsFileInput.this.updateMetrics(position, readSize);
            return readSize;
        }

        @Override
        public long skip(long n) throws IOException {
            return this.inputStream.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.inputStream.available();
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.inputStream.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.inputStream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.inputStream.markSupported();
        }
    }
}

