/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.Accountable;

public interface Operator
extends AutoCloseable,
Accountable {
    public static final ListenableFuture<?> NOT_BLOCKED = Futures.immediateVoidFuture();

    public OperatorContext getOperatorContext();

    default public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public TsBlock nextWithTimer() throws Exception {
        OperatorContext context = this.getOperatorContext();
        long startTime = System.nanoTime();
        TsBlock output = null;
        try {
            output = this.next();
        }
        finally {
            context.recordExecutionTime(System.nanoTime() - startTime);
            if (output != null) {
                context.addOutputRows(output.getPositionCount());
            }
            context.recordNextCalled();
        }
        return output;
    }

    public TsBlock next() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean hasNextWithTimer() throws Exception {
        OperatorContext context = this.getOperatorContext();
        long startTime = System.nanoTime();
        try {
            boolean bl = this.hasNext();
            return bl;
        }
        finally {
            context.recordExecutionTime(System.nanoTime() - startTime);
            context.recordHasNextCalled();
        }
    }

    default public long calculateMaxPeekMemoryWithCounter() {
        long maxPeekMemory = this.calculateMaxPeekMemory();
        this.getOperatorContext().setEstimatedMemorySize(maxPeekMemory);
        return maxPeekMemory;
    }

    public boolean hasNext() throws Exception;

    @Override
    public void close() throws Exception;

    public boolean isFinished() throws Exception;

    public long calculateMaxPeekMemory();

    public long calculateMaxReturnSize();

    public long calculateRetainedSizeAfterCallingNext();
}

