/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class QualifiedNameConversions {
    private QualifiedNameConversions() {
    }

    @Nullable
    static String qualifiedNameToString(@NotNull QualifiedName name) {
        return name.getName();
    }

    @NotNull
    static LocalizedText qualifiedNameToLocalizedText(@NotNull QualifiedName name) {
        return new LocalizedText("", name.getName());
    }

    @Nullable
    static Object convert(@NotNull Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof QualifiedName) {
            QualifiedName name = (QualifiedName)o;
            return implicit ? QualifiedNameConversions.implicitConversion(name, targetType) : QualifiedNameConversions.explicitConversion(name, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@NotNull QualifiedName name, BuiltinDataType targetType) {
        return QualifiedNameConversions.implicitConversion(name, targetType);
    }

    @Nullable
    static Object implicitConversion(@NotNull QualifiedName name, BuiltinDataType targetType) {
        switch (targetType) {
            case String: {
                return QualifiedNameConversions.qualifiedNameToString(name);
            }
            case LocalizedText: {
                return QualifiedNameConversions.qualifiedNameToLocalizedText(name);
            }
        }
        return null;
    }
}

