/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.role;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.auth.entity.DatabasePrivilege;
import org.apache.iotdb.commons.auth.entity.IEntityAccessor;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.utils.IOUtils;
import org.apache.thrift.TException;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileRoleAccessor
implements IEntityAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalFileRoleAccessor.class);
    protected static final String TEMP_SUFFIX = ".temp";
    protected static final String STRING_ENCODING = "utf-8";
    protected final String entityDirPath;
    protected static final int VERSION = 2;
    protected final ThreadLocal<ByteBuffer> encodingBufferLocal = new ThreadLocal();
    protected final ThreadLocal<byte[]> strBufferLocal = new ThreadLocal();

    public LocalFileRoleAccessor(String roleDirPath) {
        this.entityDirPath = roleDirPath;
    }

    protected String getEntitySnapshotFileName() {
        return "system" + File.separator + "roles";
    }

    protected void saveEntityVersion(BufferedOutputStream outputStream) throws IOException {
        IOUtils.writeInt(outputStream, 2, this.encodingBufferLocal);
    }

    protected void saveEntityName(BufferedOutputStream outputStream, Role role) throws IOException {
        IOUtils.writeString(outputStream, role.getName(), STRING_ENCODING, this.encodingBufferLocal);
    }

    protected void savePrivileges(BufferedOutputStream outputStream, Role role) throws IOException {
        IOUtils.writeInt(outputStream, role.getAllSysPrivileges(), this.encodingBufferLocal);
        int privilegeNum = role.getPathPrivilegeList().size();
        IOUtils.writeInt(outputStream, privilegeNum, this.encodingBufferLocal);
        for (int i = 0; i < privilegeNum; ++i) {
            PathPrivilege pathPrivilege = role.getPathPrivilegeList().get(i);
            IOUtils.writePathPrivilege(outputStream, pathPrivilege, STRING_ENCODING, this.encodingBufferLocal);
        }
        IOUtils.writeInt(outputStream, role.getAnyScopePrivileges(), this.encodingBufferLocal);
        privilegeNum = role.getDBScopePrivilegeMap().size();
        IOUtils.writeInt(outputStream, privilegeNum, this.encodingBufferLocal);
        for (Map.Entry<String, DatabasePrivilege> objectPrivilegeMap : role.getDBScopePrivilegeMap().entrySet()) {
            IOUtils.writeObjectPrivilege(outputStream, objectPrivilegeMap.getValue(), STRING_ENCODING, this.encodingBufferLocal);
        }
    }

    protected void loadPrivileges(DataInputStream dataInputStream, Role role) throws IOException, IllegalPathException {
        role.setSysPrivilegesWithMask(dataInputStream.readInt());
        int num = ReadWriteIOUtils.readInt((InputStream)dataInputStream);
        ArrayList<PathPrivilege> pathPrivilegeList = new ArrayList<PathPrivilege>();
        for (int i = 0; i < num; ++i) {
            pathPrivilegeList.add(IOUtils.readPathPrivilege(dataInputStream, STRING_ENCODING, this.strBufferLocal));
        }
        role.setPrivilegeList(pathPrivilegeList);
        role.setAnyScopePrivilegeSetWithMask(ReadWriteIOUtils.readInt((InputStream)dataInputStream));
        HashMap<String, DatabasePrivilege> objectPrivilegeMap = new HashMap<String, DatabasePrivilege>();
        num = ReadWriteIOUtils.readInt((InputStream)dataInputStream);
        for (int i = 0; i < num; ++i) {
            DatabasePrivilege databasePrivilege = IOUtils.readRelationalPrivilege(dataInputStream, STRING_ENCODING, this.strBufferLocal);
            objectPrivilegeMap.put(databasePrivilege.getDatabaseName(), databasePrivilege);
        }
        role.setObjectPrivilegeMap(objectPrivilegeMap);
    }

    protected void saveSessionPerUser(BufferedOutputStream outputStream, Role role) throws IOException {
    }

    protected void saveRoles(Role role) throws IOException {
    }

    protected File checkFileAvailable(String entityName, String suffix) {
        File userProfile = SystemFileFactory.INSTANCE.getFile(this.entityDirPath + File.separator + entityName + suffix + ".profile");
        if (!userProfile.exists() || !userProfile.isFile()) {
            File newProfile = SystemFileFactory.INSTANCE.getFile(this.entityDirPath + File.separator + entityName + suffix + ".profile" + TEMP_SUFFIX);
            if (newProfile.exists() && newProfile.isFile()) {
                if (!newProfile.renameTo(userProfile)) {
                    LOGGER.error("New profile renaming not succeed.");
                }
                userProfile = newProfile;
            } else {
                return null;
            }
        }
        return userProfile;
    }

    @Override
    public Role loadEntity(String entityName) throws IOException {
        File entityFile = this.checkFileAvailable(entityName, "");
        if (entityFile == null) {
            return null;
        }
        FileInputStream inputStream = new FileInputStream(entityFile);
        try {
            int tag;
            DataInputStream dataInputStream;
            block18: {
                block17: {
                    Role role;
                    dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
                    try {
                        tag = dataInputStream.readInt();
                        if (tag >= 0) break block17;
                        String name = IOUtils.readString(dataInputStream, STRING_ENCODING, this.strBufferLocal, -1 * tag);
                        Role role2 = new Role(name);
                        role2.setSysPrivilegesWithMask(dataInputStream.readInt());
                        ArrayList<PathPrivilege> pathPrivilegeList = new ArrayList<PathPrivilege>();
                        int i = 0;
                        while (dataInputStream.available() != 0) {
                            pathPrivilegeList.add(IOUtils.readPathPrivilege(dataInputStream, STRING_ENCODING, this.strBufferLocal));
                            ++i;
                        }
                        role2.setPrivilegeList(pathPrivilegeList);
                        role = role2;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                dataInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            throw new IOException(e);
                        }
                    }
                    dataInputStream.close();
                    return role;
                }
                if (tag != 1) break block18;
                entityName = IOUtils.readString(dataInputStream, STRING_ENCODING, this.strBufferLocal);
                Role role = new Role(entityName);
                this.loadPrivileges(dataInputStream, role);
                Role role3 = role;
                dataInputStream.close();
                return role3;
            }
            assert (tag == 2);
            entityName = IOUtils.readString(dataInputStream, STRING_ENCODING, this.strBufferLocal);
            Role role = new Role(entityName);
            this.loadPrivileges(dataInputStream, role);
            Role role4 = role;
            dataInputStream.close();
            return role4;
        }
        finally {
            this.strBufferLocal.remove();
        }
    }

    @Override
    public long loadUserId() throws IOException {
        File userIdFile = this.checkFileAvailable("user_id", "");
        if (userIdFile == null) {
            return -1L;
        }
        FileInputStream inputStream = new FileInputStream(userIdFile);
        try {
            long l;
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            try {
                dataInputStream.readInt();
                l = dataInputStream.readLong();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        dataInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            dataInputStream.close();
            return l;
        }
        finally {
            this.strBufferLocal.remove();
        }
    }

    @Override
    public void saveEntity(Role entity) throws IOException {
        String prefixName = "";
        prefixName = entity instanceof User ? String.valueOf(((User)entity).getUserId()) : entity.getName();
        File roleProfile = SystemFileFactory.INSTANCE.getFile(this.entityDirPath + File.separator + prefixName + ".profile" + TEMP_SUFFIX);
        File roleDir = new File(this.entityDirPath);
        if (!roleDir.exists() && !roleDir.mkdirs()) {
            LOGGER.error("Failed to create role dir {}", (Object)this.entityDirPath);
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(roleProfile);
             BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);){
            this.saveEntityVersion(outputStream);
            this.saveEntityName(outputStream, entity);
            this.saveSessionPerUser(outputStream, entity);
            this.savePrivileges(outputStream, entity);
            outputStream.flush();
            fileOutputStream.getFD().sync();
        }
        catch (Exception e) {
            LOGGER.warn("meet error when save role: {}", (Object)entity.getName());
            throw new IOException(e);
        }
        finally {
            this.encodingBufferLocal.remove();
        }
        File oldFile = SystemFileFactory.INSTANCE.getFile(this.entityDirPath + File.separator + prefixName + ".profile");
        IOUtils.replaceFile(roleProfile, oldFile);
        this.saveRoles(entity);
    }

    @Override
    public boolean deleteEntity(String entityName) throws IOException {
        File roleProfile = SystemFileFactory.INSTANCE.getFile(this.entityDirPath + File.separator + entityName + ".profile");
        File backFile = SystemFileFactory.INSTANCE.getFile(this.entityDirPath + File.separator + entityName + ".profile" + TEMP_SUFFIX);
        if (!roleProfile.exists() && !backFile.exists()) {
            return false;
        }
        if (roleProfile.exists() && !roleProfile.delete() || backFile.exists() && !backFile.delete()) {
            throw new IOException(String.format("Cannot delete role file of %s", entityName));
        }
        return true;
    }

    @Override
    public List<String> listAllEntities() {
        File roleDir = SystemFileFactory.INSTANCE.getFile(this.entityDirPath);
        String[] names = roleDir.list((dir, name) -> name.endsWith(".profile") || name.endsWith(TEMP_SUFFIX));
        return LocalFileRoleAccessor.getEntityStrings(names);
    }

    public static List<String> getEntityStrings(String[] names) {
        ArrayList<String> retList = new ArrayList<String>();
        if (names != null) {
            HashSet<String> set = new HashSet<String>();
            for (String fileName : names) {
                set.add(fileName.replace(".profile", "").replace(TEMP_SUFFIX, ""));
            }
            retList.addAll(set);
        }
        retList.remove("user_id");
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        SystemFileFactory systemFileFactory = SystemFileFactory.INSTANCE;
        File roleFolder = systemFileFactory.getFile(this.entityDirPath);
        File roleSnapshotDir = systemFileFactory.getFile(snapshotDir, this.getEntitySnapshotFileName());
        File roleTmpSnapshotDir = systemFileFactory.getFile(roleSnapshotDir.getAbsolutePath() + "-" + UUID.randomUUID());
        try {
            boolean result = org.apache.iotdb.commons.utils.FileUtils.copyDir(roleFolder, roleTmpSnapshotDir);
        }
        finally {
            if (roleTmpSnapshotDir.exists() && !roleTmpSnapshotDir.delete()) {
                org.apache.iotdb.commons.utils.FileUtils.deleteFileOrDirectory(roleTmpSnapshotDir);
            }
        }
        return result &= roleTmpSnapshotDir.renameTo(roleSnapshotDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        SystemFileFactory systemFileFactory = SystemFileFactory.INSTANCE;
        File roleFolder = systemFileFactory.getFile(this.entityDirPath);
        File roleTmpFolder = systemFileFactory.getFile(roleFolder.getAbsolutePath() + "-" + UUID.randomUUID());
        File roleSnapshotDir = systemFileFactory.getFile(snapshotDir, this.getEntitySnapshotFileName());
        if (roleSnapshotDir.exists()) {
            try {
                FileUtils.moveDirectory((File)roleFolder, (File)roleTmpFolder);
                if (org.apache.iotdb.commons.utils.FileUtils.copyDir(roleSnapshotDir, roleFolder)) return;
                LOGGER.error("Failed to load role folder snapshot and rollback.");
                org.apache.iotdb.commons.utils.FileUtils.deleteFileOrDirectory(roleFolder);
                FileUtils.moveDirectory((File)roleTmpFolder, (File)roleFolder);
                return;
            }
            finally {
                org.apache.iotdb.commons.utils.FileUtils.deleteFileOrDirectory(roleTmpFolder);
            }
        } else {
            LOGGER.info("There are no roles to load.");
        }
    }

    @Override
    public void reset() {
        this.checkOldEntityDir(SystemFileFactory.INSTANCE.getFile(this.entityDirPath));
        if (SystemFileFactory.INSTANCE.getFile(this.entityDirPath).mkdirs()) {
            LOGGER.info("role info dir {} is created", (Object)this.entityDirPath);
        } else if (!SystemFileFactory.INSTANCE.getFile(this.entityDirPath).exists()) {
            LOGGER.error("role info dir {} can not be created", (Object)this.entityDirPath);
        }
    }

    private void checkOldEntityDir(File newDir) {
        File oldDir = new File(CommonDescriptor.getInstance().getConfig().getOldRoleFolder());
        if (oldDir.exists() && !org.apache.iotdb.commons.utils.FileUtils.moveFileSafe(oldDir, newDir)) {
            LOGGER.error("move old role dir fail: {}", (Object)oldDir.getAbsolutePath());
        }
    }

    @Override
    public void cleanEntityFolder() {
        File[] files = SystemFileFactory.INSTANCE.getFile(this.entityDirPath).listFiles();
        if (files != null) {
            for (File file : files) {
                org.apache.iotdb.commons.utils.FileUtils.deleteFileIfExist(file);
            }
        } else {
            LOGGER.warn("Role folder not exists");
        }
    }

    @Override
    public void saveUserId(long nextUserId) throws IOException {
        File userInfoProfile = SystemFileFactory.INSTANCE.getFile(this.entityDirPath + File.separator + "user_id" + ".profile" + TEMP_SUFFIX);
        File userDir = new File(this.entityDirPath);
        if (!userDir.exists() && !userDir.mkdirs()) {
            LOGGER.error("Failed to create user dir {}", (Object)this.entityDirPath);
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(userInfoProfile);
             BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);){
            IOUtils.writeInt(outputStream, 2, this.encodingBufferLocal);
            IOUtils.writeLong(outputStream, nextUserId, this.encodingBufferLocal);
            outputStream.flush();
            fileOutputStream.getFD().sync();
        }
        catch (Exception e) {
            LOGGER.warn("meet error when save userId: {}", (Object)nextUserId);
            throw new IOException(e);
        }
        finally {
            this.encodingBufferLocal.remove();
        }
        File oldFile = SystemFileFactory.INSTANCE.getFile(this.entityDirPath + File.separator + "user_id" + ".profile");
        IOUtils.replaceFile(userInfoProfile, oldFile);
    }
}

