/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational;

import java.util.List;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.AbstractTableScanOperator;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.DeviceEntry;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;

public class MeasurementToTableViewAdaptorUtils {
    private MeasurementToTableViewAdaptorUtils() {
    }

    public static TsBlock toTableBlock(TsBlock measurementDataBlock, int[] columnsIndexArray, List<ColumnSchema> columnSchemas, DeviceEntry deviceEntry, GetNthIdColumnValueFunc func) {
        if (measurementDataBlock == null) {
            return null;
        }
        int positionCount = measurementDataBlock.getPositionCount();
        Column[] valueColumns = new Column[columnsIndexArray.length];
        block6: for (int i = 0; i < columnsIndexArray.length; ++i) {
            switch (columnSchemas.get(i).getColumnCategory()) {
                case TAG: {
                    String idColumnValue = func.getNthIdColumnValue(columnsIndexArray[i]);
                    valueColumns[i] = MeasurementToTableViewAdaptorUtils.getIdOrAttributeValueColumn(idColumnValue == null ? null : new Binary(idColumnValue, TSFileConfig.STRING_CHARSET), positionCount);
                    continue block6;
                }
                case ATTRIBUTE: {
                    Binary attributeColumnValue = deviceEntry.getAttributeColumnValues()[columnsIndexArray[i]];
                    valueColumns[i] = MeasurementToTableViewAdaptorUtils.getIdOrAttributeValueColumn(attributeColumnValue, positionCount);
                    continue block6;
                }
                case FIELD: {
                    valueColumns[i] = measurementDataBlock.getColumn(columnsIndexArray[i]);
                    continue block6;
                }
                case TIME: {
                    valueColumns[i] = measurementDataBlock.getTimeColumn();
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected column category: " + columnSchemas.get(i).getColumnCategory());
                }
            }
        }
        return new TsBlock(positionCount, (Column)new RunLengthEncodedColumn((Column)AbstractTableScanOperator.TIME_COLUMN_TEMPLATE, positionCount), valueColumns);
    }

    private static RunLengthEncodedColumn getIdOrAttributeValueColumn(Binary value, int positionCount) {
        if (value == null) {
            return new RunLengthEncodedColumn((Column)new BinaryColumn(1, Optional.of(new boolean[]{true}), new Binary[]{null}), positionCount);
        }
        return new RunLengthEncodedColumn((Column)new BinaryColumn(1, Optional.empty(), new Binary[]{value}), positionCount);
    }

    @FunctionalInterface
    public static interface GetNthIdColumnValueFunc {
        public String getNthIdColumnValue(int var1);
    }
}

