/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.config.constant;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;

public class SystemConstant {
    public static final String SYSTEM_PREFIX_KEY = "__system";
    public static final String RESTART_KEY = "__system.restart";
    public static final boolean RESTART_DEFAULT_VALUE = false;
    public static final String SQL_DIALECT_KEY = "__system.sql-dialect";
    public static final String SQL_DIALECT_TREE_VALUE = "tree";
    public static final String SQL_DIALECT_TABLE_VALUE = "table";
    public static final Set<String> SYSTEM_KEYS = new HashSet<String>();

    public static PipeParameters addSystemKeysIfNecessary(PipeParameters givenPipeParameters) {
        HashMap<String, String> attributes = new HashMap<String, String>(givenPipeParameters.getAttribute());
        attributes.putIfAbsent(SQL_DIALECT_KEY, SQL_DIALECT_TREE_VALUE);
        return new PipeParameters(attributes);
    }

    private SystemConstant() {
        throw new IllegalStateException("Utility class");
    }

    static {
        SYSTEM_KEYS.add(RESTART_KEY);
        SYSTEM_KEYS.add(SQL_DIALECT_KEY);
    }
}

