/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.analyze.AnalyzeUtils;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ITableDeviceSchemaValidation;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableSchema;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WrappedInsertStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;

public class InsertRows
extends WrappedInsertStatement {
    private boolean allowCreateTable = false;

    public InsertRows(InsertRowsStatement insertRowsStatement, MPPQueryContext context) {
        super(insertRowsStatement, context);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitInsertRows(this, context);
    }

    @Override
    public InsertRowsStatement getInnerTreeStatement() {
        return (InsertRowsStatement)super.getInnerTreeStatement();
    }

    @Override
    public void updateAfterSchemaValidation(MPPQueryContext context) throws QueryProcessException {
        this.getInnerTreeStatement().updateAfterSchemaValidation(context);
    }

    @Override
    public String getTableName() {
        return this.getInnerTreeStatement().getInsertRowStatementList().get(0).getDevicePath().getFullPath();
    }

    @Override
    public List<Object[]> getDeviceIdList() {
        InsertRowsStatement insertRowStatement = this.getInnerTreeStatement();
        return insertRowStatement.getDeviceIdListNoTableName();
    }

    @Override
    public List<String> getAttributeColumnNameList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Object[]> getAttributeValueList() {
        throw new UnsupportedOperationException();
    }

    public void setAllowCreateTable(boolean allowCreateTable) {
        this.allowCreateTable = allowCreateTable;
    }

    @Override
    public void validateTableSchema(Metadata metadata, MPPQueryContext context) {
        for (InsertRowStatement insertRowStatement : this.getInnerTreeStatement().getInsertRowStatementList()) {
            TableSchema incomingTableSchema = this.toTableSchema(insertRowStatement);
            TableSchema realSchema = metadata.validateTableHeaderSchema(AnalyzeUtils.getDatabaseName(insertRowStatement, context), incomingTableSchema, context, this.allowCreateTable, false).orElse(null);
            if (realSchema == null) {
                throw new SemanticException("Schema validation failed, table cannot be created: " + incomingTableSchema);
            }
            this.validateTableSchema(realSchema, incomingTableSchema, insertRowStatement);
        }
    }

    @Override
    public void validateDeviceSchema(Metadata metadata, MPPQueryContext context) {
        for (InsertRowStatement insertRowStatement : this.getInnerTreeStatement().getInsertRowStatementList()) {
            metadata.validateDeviceSchema(this.createTableSchemaValidation(insertRowStatement), context);
        }
    }

    protected ITableDeviceSchemaValidation createTableSchemaValidation(final InsertRowStatement insertRowStatement) {
        return new ITableDeviceSchemaValidation(){

            @Override
            public String getDatabase() {
                return AnalyzeUtils.getDatabaseName(insertRowStatement, InsertRows.this.context);
            }

            @Override
            public String getTableName() {
                return insertRowStatement.getTableDeviceID().getTableName();
            }

            @Override
            public List<Object[]> getDeviceIdList() {
                Object[] idSegments = insertRowStatement.getTableDeviceID().getSegments();
                return Collections.singletonList(Arrays.copyOfRange(idSegments, 1, idSegments.length));
            }

            @Override
            public List<String> getAttributeColumnNameList() {
                return insertRowStatement.getAttributeColumnNameList();
            }

            @Override
            public List<Object[]> getAttributeValueList() {
                ArrayList<Object> attributeValueList = new ArrayList<Object>();
                for (int i = 0; i < insertRowStatement.getColumnCategories().length; ++i) {
                    if (insertRowStatement.getColumnCategories()[i] != TsTableColumnCategory.ATTRIBUTE) continue;
                    attributeValueList.add(insertRowStatement.getValues()[i]);
                }
                return Collections.singletonList(attributeValueList.toArray());
            }
        };
    }
}

