/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.task.subtask.sink;

import java.util.Objects;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.agent.task.subtask.PipeAbstractSinkSubtask;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.sink.protocol.IoTDBSink;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.event.UserDefinedEnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionWritePlanEvent;
import org.apache.iotdb.db.pipe.metric.schema.PipeSchemaRegionSinkMetrics;
import org.apache.iotdb.db.pipe.metric.sink.PipeDataRegionSinkMetrics;
import org.apache.iotdb.db.pipe.sink.protocol.thrift.async.IoTDBDataRegionAsyncSink;
import org.apache.iotdb.db.pipe.sink.protocol.thrift.sync.IoTDBDataRegionSyncSink;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeSinkSubtask
extends PipeAbstractSinkSubtask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeSinkSubtask.class);
    protected final UnboundedBlockingPendingQueue<Event> inputPendingQueue;
    private final String attributeSortedString;
    private final int connectorIndex;
    public static final PipeHeartbeatEvent CRON_HEARTBEAT_EVENT = new PipeHeartbeatEvent("cron", false);

    public PipeSinkSubtask(String taskID, long creationTime, String attributeSortedString, int connectorIndex, UnboundedBlockingPendingQueue<Event> inputPendingQueue, PipeConnector outputPipeConnector) {
        super(taskID, creationTime, outputPipeConnector);
        this.attributeSortedString = attributeSortedString;
        this.connectorIndex = connectorIndex;
        this.inputPendingQueue = inputPendingQueue;
        if (!attributeSortedString.startsWith("schema_")) {
            PipeDataRegionSinkMetrics.getInstance().register(this);
        } else {
            PipeSchemaRegionSinkMetrics.getInstance().register(this);
        }
    }

    protected boolean executeOnce() {
        if (this.isClosed.get()) {
            return false;
        }
        Event event = this.lastEvent != null ? this.lastEvent : UserDefinedEnrichedEvent.maybeOf(this.inputPendingQueue.waitedPoll());
        this.setLastEvent(event);
        if (event instanceof EnrichedEvent && ((EnrichedEvent)event).isReleased()) {
            this.lastEvent = null;
            return true;
        }
        try {
            if (Objects.isNull(event)) {
                this.transferHeartbeatEvent(CRON_HEARTBEAT_EVENT);
                return false;
            }
            if (event instanceof TabletInsertionEvent) {
                this.outputPipeConnector.transfer((TabletInsertionEvent)event);
                PipeDataRegionSinkMetrics.getInstance().markTabletEvent(this.taskID);
            } else if (event instanceof TsFileInsertionEvent) {
                this.outputPipeConnector.transfer((TsFileInsertionEvent)event);
                PipeDataRegionSinkMetrics.getInstance().markTsFileEvent(this.taskID);
            } else if (event instanceof PipeSchemaRegionWritePlanEvent) {
                this.outputPipeConnector.transfer(event);
                if (((PipeSchemaRegionWritePlanEvent)event).getPlanNode().getType() != PlanNodeType.DELETE_DATA) {
                    PipeSchemaRegionSinkMetrics.getInstance().markSchemaEvent(this.taskID);
                }
            } else if (event instanceof PipeHeartbeatEvent) {
                this.transferHeartbeatEvent((PipeHeartbeatEvent)event);
            } else {
                this.outputPipeConnector.transfer((Event)(event instanceof UserDefinedEnrichedEvent ? ((UserDefinedEnrichedEvent)event).getUserDefinedEvent() : event));
            }
            this.decreaseReferenceCountAndReleaseLastEvent(event, true);
        }
        catch (PipeException e) {
            if (!this.isClosed.get()) {
                this.setLastExceptionEvent(event);
                throw e;
            }
            LOGGER.info("{} in pipe transfer, ignored because the connector subtask is dropped.", (Object)((Object)((Object)e)).getClass().getSimpleName(), (Object)e);
            this.clearReferenceCountAndReleaseLastEvent(event);
        }
        catch (Exception e) {
            if (!this.isClosed.get()) {
                this.setLastExceptionEvent(event);
                throw new PipeException(String.format("Exception in pipe transfer, subtask: %s, last event: %s, root cause: %s", this.taskID, event instanceof EnrichedEvent ? ((EnrichedEvent)event).coreReportMessage() : event, ErrorHandlingUtils.getRootCause(e).getMessage()), (Throwable)e);
            }
            LOGGER.info("Exception in pipe transfer, ignored because the connector subtask is dropped.", (Throwable)e);
            this.clearReferenceCountAndReleaseLastEvent(event);
        }
        return true;
    }

    private void transferHeartbeatEvent(PipeHeartbeatEvent event) {
        if (this.isClosed.get()) {
            return;
        }
        try {
            this.outputPipeConnector.heartbeat();
            this.outputPipeConnector.transfer((Event)event);
        }
        catch (Exception e) {
            throw new PipeConnectionException("PipeConnector: " + this.outputPipeConnector.getClass().getName() + "(id: " + this.taskID + ") heartbeat failed, or encountered failure when transferring generic event. Failure: " + e.getMessage(), (Throwable)e);
        }
        event.onTransferred();
        PipeDataRegionSinkMetrics.getInstance().markPipeHeartbeatEvent(this.taskID);
    }

    public void close() {
        if (!this.attributeSortedString.startsWith("schema_")) {
            PipeDataRegionSinkMetrics.getInstance().deregister(this.taskID);
        } else {
            PipeSchemaRegionSinkMetrics.getInstance().deregister(this.taskID);
        }
        this.isClosed.set(true);
        try {
            long startTime = System.currentTimeMillis();
            this.outputPipeConnector.close();
            LOGGER.info("Pipe: connector subtask {} ({}) was closed within {} ms", new Object[]{this.taskID, this.outputPipeConnector, System.currentTimeMillis() - startTime});
        }
        catch (Exception e) {
            LOGGER.info("Exception occurred when closing pipe connector subtask {}, root cause: {}", new Object[]{this.taskID, ErrorHandlingUtils.getRootCause(e).getMessage(), e});
        }
        finally {
            this.inputPendingQueue.discardAllEvents();
            super.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardEventsOfPipe(String pipeNameToDrop, int regionId) {
        this.inputPendingQueue.discardEventsOfPipe(pipeNameToDrop, regionId);
        try {
            this.increaseHighPriorityTaskCount();
            PipeSinkSubtask pipeSinkSubtask = this;
            synchronized (pipeSinkSubtask) {
                if (this.lastEvent instanceof EnrichedEvent && pipeNameToDrop.equals(((EnrichedEvent)this.lastEvent).getPipeName()) && regionId == ((EnrichedEvent)this.lastEvent).getRegionId()) {
                    this.lastEvent = null;
                    this.submitSelf();
                }
                if (this.lastExceptionEvent instanceof EnrichedEvent && pipeNameToDrop.equals(((EnrichedEvent)this.lastExceptionEvent).getPipeName()) && regionId == ((EnrichedEvent)this.lastExceptionEvent).getRegionId()) {
                    this.clearReferenceCountAndReleaseLastExceptionEvent();
                }
            }
        }
        finally {
            this.decreaseHighPriorityTaskCount();
        }
        if (this.outputPipeConnector instanceof IoTDBSink) {
            ((IoTDBSink)this.outputPipeConnector).discardEventsOfPipe(pipeNameToDrop, regionId);
        }
    }

    public String getAttributeSortedString() {
        return this.attributeSortedString;
    }

    public int getConnectorIndex() {
        return this.connectorIndex;
    }

    public int getTsFileInsertionEventCount() {
        return this.inputPendingQueue.getTsFileInsertionEventCount() + (this.lastEvent instanceof TsFileInsertionEvent ? 1 : 0);
    }

    public int getTabletInsertionEventCount() {
        return this.inputPendingQueue.getTabletInsertionEventCount() + (this.lastEvent instanceof TabletInsertionEvent ? 1 : 0);
    }

    public int getPipeHeartbeatEventCount() {
        return this.inputPendingQueue.getPipeHeartbeatEventCount() + (this.lastEvent instanceof PipeHeartbeatEvent ? 1 : 0);
    }

    public int getAsyncConnectorRetryEventQueueSize() {
        return this.outputPipeConnector instanceof IoTDBDataRegionAsyncSink ? ((IoTDBDataRegionAsyncSink)this.outputPipeConnector).getRetryEventQueueSize() : 0;
    }

    public int getPendingHandlersSize() {
        return this.outputPipeConnector instanceof IoTDBDataRegionAsyncSink ? ((IoTDBDataRegionAsyncSink)this.outputPipeConnector).getPendingHandlersSize() : 0;
    }

    public int getBatchSize() {
        if (this.outputPipeConnector instanceof IoTDBDataRegionAsyncSink) {
            return ((IoTDBDataRegionAsyncSink)this.outputPipeConnector).getBatchSize();
        }
        if (this.outputPipeConnector instanceof IoTDBDataRegionSyncSink) {
            return ((IoTDBDataRegionSyncSink)this.outputPipeConnector).getBatchSize();
        }
        return 0;
    }

    public double getTotalUncompressedSize() {
        return this.outputPipeConnector instanceof IoTDBSink ? (double)((IoTDBSink)this.outputPipeConnector).getTotalUncompressedSize() : 0.0;
    }

    public double getTotalCompressedSize() {
        return this.outputPipeConnector instanceof IoTDBSink ? (double)((IoTDBSink)this.outputPipeConnector).getTotalCompressedSize() : 0.0;
    }

    public void setTabletBatchSizeHistogram(Histogram tabletBatchSizeHistogram) {
        if (this.outputPipeConnector instanceof IoTDBSink) {
            ((IoTDBSink)this.outputPipeConnector).setTabletBatchSizeHistogram(tabletBatchSizeHistogram);
        }
    }

    public void setTsFileBatchSizeHistogram(Histogram tsFileBatchSizeHistogram) {
        if (this.outputPipeConnector instanceof IoTDBSink) {
            ((IoTDBSink)this.outputPipeConnector).setTsFileBatchSizeHistogram(tsFileBatchSizeHistogram);
        }
    }

    public void setTabletBatchTimeIntervalHistogram(Histogram tabletBatchTimeIntervalHistogram) {
        if (this.outputPipeConnector instanceof IoTDBSink) {
            ((IoTDBSink)this.outputPipeConnector).setTabletBatchTimeIntervalHistogram(tabletBatchTimeIntervalHistogram);
        }
    }

    public void setTsFileBatchTimeIntervalHistogram(Histogram tsFileBatchTimeIntervalHistogram) {
        if (this.outputPipeConnector instanceof IoTDBSink) {
            ((IoTDBSink)this.outputPipeConnector).setTsFileBatchTimeIntervalHistogram(tsFileBatchTimeIntervalHistogram);
        }
    }

    public void setEventSizeHistogram(Histogram eventSizeHistogram) {
        if (this.outputPipeConnector instanceof IoTDBSink) {
            ((IoTDBSink)this.outputPipeConnector).setBatchEventSizeHistogram(eventSizeHistogram);
        }
    }

    protected String getRootCause(Throwable throwable) {
        return ErrorHandlingUtils.getRootCause(throwable).getMessage();
    }

    protected void report(EnrichedEvent event, PipeRuntimeException exception) {
        PipeDataNodeAgent.runtime().report(event, exception);
    }
}

